# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DataAccessorArgs', 'DataAccessor']

@pulumi.input_type
class DataAccessorArgs:
    def __init__(__self__, *,
                 action_configurations: pulumi.Input[Sequence[pulumi.Input['DataAccessorActionConfigurationArgs']]],
                 application_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 principal: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataAccessor resource.
        :param pulumi.Input[Sequence[pulumi.Input['DataAccessorActionConfigurationArgs']]] action_configurations: A list of action configurations specifying the allowed actions and any associated filters.
        :param pulumi.Input[builtins.str] application_id: The unique identifier of the Amazon Q Business application.
        :param pulumi.Input[builtins.str] display_name: The friendly name of the data accessor.
        :param pulumi.Input[builtins.str] principal: The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to associate with the data accessor.
        """
        pulumi.set(__self__, "action_configurations", action_configurations)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "principal", principal)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="actionConfigurations")
    def action_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['DataAccessorActionConfigurationArgs']]]:
        """
        A list of action configurations specifying the allowed actions and any associated filters.
        """
        return pulumi.get(self, "action_configurations")

    @action_configurations.setter
    def action_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['DataAccessorActionConfigurationArgs']]]):
        pulumi.set(self, "action_configurations", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The friendly name of the data accessor.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to associate with the data accessor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:qbusiness:DataAccessor")
class DataAccessor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessorActionConfigurationArgs', 'DataAccessorActionConfigurationArgsDict']]]]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::DataAccessor Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataAccessorActionConfigurationArgs', 'DataAccessorActionConfigurationArgsDict']]]] action_configurations: A list of action configurations specifying the allowed actions and any associated filters.
        :param pulumi.Input[builtins.str] application_id: The unique identifier of the Amazon Q Business application.
        :param pulumi.Input[builtins.str] display_name: The friendly name of the data accessor.
        :param pulumi.Input[builtins.str] principal: The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to associate with the data accessor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataAccessorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::DataAccessor Resource Type

        :param str resource_name: The name of the resource.
        :param DataAccessorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAccessorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessorActionConfigurationArgs', 'DataAccessorActionConfigurationArgsDict']]]]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAccessorArgs.__new__(DataAccessorArgs)

            if action_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'action_configurations'")
            __props__.__dict__["action_configurations"] = action_configurations
            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_accessor_arn"] = None
            __props__.__dict__["data_accessor_id"] = None
            __props__.__dict__["idc_application_arn"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "principal"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataAccessor, __self__).__init__(
            'aws-native:qbusiness:DataAccessor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataAccessor':
        """
        Get an existing DataAccessor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataAccessorArgs.__new__(DataAccessorArgs)

        __props__.__dict__["action_configurations"] = None
        __props__.__dict__["application_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["data_accessor_arn"] = None
        __props__.__dict__["data_accessor_id"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["idc_application_arn"] = None
        __props__.__dict__["principal"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return DataAccessor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionConfigurations")
    def action_configurations(self) -> pulumi.Output[Sequence['outputs.DataAccessorActionConfiguration']]:
        """
        A list of action configurations specifying the allowed actions and any associated filters.
        """
        return pulumi.get(self, "action_configurations")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the data accessor was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataAccessorArn")
    def data_accessor_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the data accessor.
        """
        return pulumi.get(self, "data_accessor_arn")

    @property
    @pulumi.getter(name="dataAccessorId")
    def data_accessor_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the data accessor.
        """
        return pulumi.get(self, "data_accessor_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The friendly name of the data accessor.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="idcApplicationArn")
    def idc_application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the associated IAM Identity Center application.
        """
        return pulumi.get(self, "idc_application_arn")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role for the ISV associated with this data accessor.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to associate with the data accessor.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp when the data accessor was last updated.
        """
        return pulumi.get(self, "updated_at")

