# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 attachments_configuration: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']] = None,
                 auto_subscription_configuration: Optional[pulumi.Input['ApplicationAutoSubscriptionConfigurationArgs']] = None,
                 client_ids_for_oidc: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']] = None,
                 iam_identity_provider_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input['ApplicationIdentityType']] = None,
                 personalization_configuration: Optional[pulumi.Input['ApplicationPersonalizationConfigurationArgs']] = None,
                 q_apps_configuration: Optional[pulumi.Input['ApplicationQAppsConfigurationArgs']] = None,
                 quick_sight_configuration: Optional[pulumi.Input['ApplicationQuickSightConfigurationArgs']] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] display_name: The name of the Amazon Q Business application.
        :param pulumi.Input['ApplicationAttachmentsConfigurationArgs'] attachments_configuration: Configuration information for the file upload during chat feature.
        :param pulumi.Input['ApplicationAutoSubscriptionConfigurationArgs'] auto_subscription_configuration: Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_ids_for_oidc: The OIDC client ID for a Amazon Q Business application.
        :param pulumi.Input[builtins.str] description: A description for the Amazon Q Business application.
        :param pulumi.Input['ApplicationEncryptionConfigurationArgs'] encryption_configuration: Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. Amazon Q Business doesn't support asymmetric keys.
        :param pulumi.Input[builtins.str] iam_identity_provider_arn: The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
               
               *Required* : `Yes`
        :param pulumi.Input['ApplicationIdentityType'] identity_type: The authentication type being used by a Amazon Q Business application.
        :param pulumi.Input['ApplicationPersonalizationConfigurationArgs'] personalization_configuration: Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html) .
        :param pulumi.Input['ApplicationQAppsConfigurationArgs'] q_apps_configuration: Configuration information about Amazon Q Apps.
        :param pulumi.Input['ApplicationQuickSightConfigurationArgs'] quick_sight_configuration: The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. If this property is not specified, Amazon Q Business will create a [service linked role (SLR)](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions) and use it as the application's role.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        pulumi.set(__self__, "display_name", display_name)
        if attachments_configuration is not None:
            pulumi.set(__self__, "attachments_configuration", attachments_configuration)
        if auto_subscription_configuration is not None:
            pulumi.set(__self__, "auto_subscription_configuration", auto_subscription_configuration)
        if client_ids_for_oidc is not None:
            pulumi.set(__self__, "client_ids_for_oidc", client_ids_for_oidc)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if iam_identity_provider_arn is not None:
            pulumi.set(__self__, "iam_identity_provider_arn", iam_identity_provider_arn)
        if identity_center_instance_arn is not None:
            pulumi.set(__self__, "identity_center_instance_arn", identity_center_instance_arn)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if personalization_configuration is not None:
            pulumi.set(__self__, "personalization_configuration", personalization_configuration)
        if q_apps_configuration is not None:
            pulumi.set(__self__, "q_apps_configuration", q_apps_configuration)
        if quick_sight_configuration is not None:
            pulumi.set(__self__, "quick_sight_configuration", quick_sight_configuration)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Amazon Q Business application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]:
        """
        Configuration information for the file upload during chat feature.
        """
        return pulumi.get(self, "attachments_configuration")

    @attachments_configuration.setter
    def attachments_configuration(self, value: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]):
        pulumi.set(self, "attachments_configuration", value)

    @property
    @pulumi.getter(name="autoSubscriptionConfiguration")
    def auto_subscription_configuration(self) -> Optional[pulumi.Input['ApplicationAutoSubscriptionConfigurationArgs']]:
        """
        Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
        """
        return pulumi.get(self, "auto_subscription_configuration")

    @auto_subscription_configuration.setter
    def auto_subscription_configuration(self, value: Optional[pulumi.Input['ApplicationAutoSubscriptionConfigurationArgs']]):
        pulumi.set(self, "auto_subscription_configuration", value)

    @property
    @pulumi.getter(name="clientIdsForOidc")
    def client_ids_for_oidc(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The OIDC client ID for a Amazon Q Business application.
        """
        return pulumi.get(self, "client_ids_for_oidc")

    @client_ids_for_oidc.setter
    def client_ids_for_oidc(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "client_ids_for_oidc", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Amazon Q Business application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]:
        """
        Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. Amazon Q Business doesn't support asymmetric keys.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="iamIdentityProviderArn")
    def iam_identity_provider_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
        """
        return pulumi.get(self, "iam_identity_provider_arn")

    @iam_identity_provider_arn.setter
    def iam_identity_provider_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_identity_provider_arn", value)

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.

        *Required* : `Yes`
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @identity_center_instance_arn.setter
    def identity_center_instance_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_center_instance_arn", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input['ApplicationIdentityType']]:
        """
        The authentication type being used by a Amazon Q Business application.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input['ApplicationIdentityType']]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="personalizationConfiguration")
    def personalization_configuration(self) -> Optional[pulumi.Input['ApplicationPersonalizationConfigurationArgs']]:
        """
        Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html) .
        """
        return pulumi.get(self, "personalization_configuration")

    @personalization_configuration.setter
    def personalization_configuration(self, value: Optional[pulumi.Input['ApplicationPersonalizationConfigurationArgs']]):
        pulumi.set(self, "personalization_configuration", value)

    @property
    @pulumi.getter(name="qAppsConfiguration")
    def q_apps_configuration(self) -> Optional[pulumi.Input['ApplicationQAppsConfigurationArgs']]:
        """
        Configuration information about Amazon Q Apps.
        """
        return pulumi.get(self, "q_apps_configuration")

    @q_apps_configuration.setter
    def q_apps_configuration(self, value: Optional[pulumi.Input['ApplicationQAppsConfigurationArgs']]):
        pulumi.set(self, "q_apps_configuration", value)

    @property
    @pulumi.getter(name="quickSightConfiguration")
    def quick_sight_configuration(self) -> Optional[pulumi.Input['ApplicationQuickSightConfigurationArgs']]:
        """
        The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
        """
        return pulumi.get(self, "quick_sight_configuration")

    @quick_sight_configuration.setter
    def quick_sight_configuration(self, value: Optional[pulumi.Input['ApplicationQuickSightConfigurationArgs']]):
        pulumi.set(self, "quick_sight_configuration", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. If this property is not specified, Amazon Q Business will create a [service linked role (SLR)](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions) and use it as the application's role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:qbusiness:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_configuration: Optional[pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']]] = None,
                 auto_subscription_configuration: Optional[pulumi.Input[Union['ApplicationAutoSubscriptionConfigurationArgs', 'ApplicationAutoSubscriptionConfigurationArgsDict']]] = None,
                 client_ids_for_oidc: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']]] = None,
                 iam_identity_provider_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input['ApplicationIdentityType']] = None,
                 personalization_configuration: Optional[pulumi.Input[Union['ApplicationPersonalizationConfigurationArgs', 'ApplicationPersonalizationConfigurationArgsDict']]] = None,
                 q_apps_configuration: Optional[pulumi.Input[Union['ApplicationQAppsConfigurationArgs', 'ApplicationQAppsConfigurationArgsDict']]] = None,
                 quick_sight_configuration: Optional[pulumi.Input[Union['ApplicationQuickSightConfigurationArgs', 'ApplicationQuickSightConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::Application Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']] attachments_configuration: Configuration information for the file upload during chat feature.
        :param pulumi.Input[Union['ApplicationAutoSubscriptionConfigurationArgs', 'ApplicationAutoSubscriptionConfigurationArgsDict']] auto_subscription_configuration: Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_ids_for_oidc: The OIDC client ID for a Amazon Q Business application.
        :param pulumi.Input[builtins.str] description: A description for the Amazon Q Business application.
        :param pulumi.Input[builtins.str] display_name: The name of the Amazon Q Business application.
        :param pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']] encryption_configuration: Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. Amazon Q Business doesn't support asymmetric keys.
        :param pulumi.Input[builtins.str] iam_identity_provider_arn: The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.
               
               *Required* : `Yes`
        :param pulumi.Input['ApplicationIdentityType'] identity_type: The authentication type being used by a Amazon Q Business application.
        :param pulumi.Input[Union['ApplicationPersonalizationConfigurationArgs', 'ApplicationPersonalizationConfigurationArgsDict']] personalization_configuration: Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html) .
        :param pulumi.Input[Union['ApplicationQAppsConfigurationArgs', 'ApplicationQAppsConfigurationArgsDict']] q_apps_configuration: Configuration information about Amazon Q Apps.
        :param pulumi.Input[Union['ApplicationQuickSightConfigurationArgs', 'ApplicationQuickSightConfigurationArgsDict']] quick_sight_configuration: The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. If this property is not specified, Amazon Q Business will create a [service linked role (SLR)](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions) and use it as the application's role.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::Application Resource Type

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_configuration: Optional[pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']]] = None,
                 auto_subscription_configuration: Optional[pulumi.Input[Union['ApplicationAutoSubscriptionConfigurationArgs', 'ApplicationAutoSubscriptionConfigurationArgsDict']]] = None,
                 client_ids_for_oidc: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']]] = None,
                 iam_identity_provider_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input['ApplicationIdentityType']] = None,
                 personalization_configuration: Optional[pulumi.Input[Union['ApplicationPersonalizationConfigurationArgs', 'ApplicationPersonalizationConfigurationArgsDict']]] = None,
                 q_apps_configuration: Optional[pulumi.Input[Union['ApplicationQAppsConfigurationArgs', 'ApplicationQAppsConfigurationArgsDict']]] = None,
                 quick_sight_configuration: Optional[pulumi.Input[Union['ApplicationQuickSightConfigurationArgs', 'ApplicationQuickSightConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["attachments_configuration"] = attachments_configuration
            __props__.__dict__["auto_subscription_configuration"] = auto_subscription_configuration
            __props__.__dict__["client_ids_for_oidc"] = client_ids_for_oidc
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["iam_identity_provider_arn"] = iam_identity_provider_arn
            __props__.__dict__["identity_center_instance_arn"] = identity_center_instance_arn
            __props__.__dict__["identity_type"] = identity_type
            __props__.__dict__["personalization_configuration"] = personalization_configuration
            __props__.__dict__["q_apps_configuration"] = q_apps_configuration
            __props__.__dict__["quick_sight_configuration"] = quick_sight_configuration
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["application_arn"] = None
            __props__.__dict__["application_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["identity_center_application_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clientIdsForOidc[*]", "encryptionConfiguration", "iamIdentityProviderArn", "identityType", "quickSightConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Application, __self__).__init__(
            'aws-native:qbusiness:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["application_arn"] = None
        __props__.__dict__["application_id"] = None
        __props__.__dict__["attachments_configuration"] = None
        __props__.__dict__["auto_subscription_configuration"] = None
        __props__.__dict__["client_ids_for_oidc"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["encryption_configuration"] = None
        __props__.__dict__["iam_identity_provider_arn"] = None
        __props__.__dict__["identity_center_application_arn"] = None
        __props__.__dict__["identity_center_instance_arn"] = None
        __props__.__dict__["identity_type"] = None
        __props__.__dict__["personalization_configuration"] = None
        __props__.__dict__["q_apps_configuration"] = None
        __props__.__dict__["quick_sight_configuration"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier for the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationAttachmentsConfiguration']]:
        """
        Configuration information for the file upload during chat feature.
        """
        return pulumi.get(self, "attachments_configuration")

    @property
    @pulumi.getter(name="autoSubscriptionConfiguration")
    def auto_subscription_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationAutoSubscriptionConfiguration']]:
        """
        Subscription configuration information for an Amazon Q Business application using IAM identity federation for user management.
        """
        return pulumi.get(self, "auto_subscription_configuration")

    @property
    @pulumi.getter(name="clientIdsForOidc")
    def client_ids_for_oidc(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The OIDC client ID for a Amazon Q Business application.
        """
        return pulumi.get(self, "client_ids_for_oidc")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the Amazon Q Business application was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the Amazon Q Business application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Amazon Q Business application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationEncryptionConfiguration']]:
        """
        Provides the identifier of the AWS KMS key used to encrypt data indexed by Amazon Q Business. Amazon Q Business doesn't support asymmetric keys.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="iamIdentityProviderArn")
    def iam_identity_provider_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
        """
        return pulumi.get(self, "iam_identity_provider_arn")

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached to your Amazon Q Business application.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting to—your Amazon Q Business application.

        *Required* : `Yes`
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Output[Optional['ApplicationIdentityType']]:
        """
        The authentication type being used by a Amazon Q Business application.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="personalizationConfiguration")
    def personalization_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationPersonalizationConfiguration']]:
        """
        Configuration information about chat response personalization. For more information, see [Personalizing chat responses](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html) .
        """
        return pulumi.get(self, "personalization_configuration")

    @property
    @pulumi.getter(name="qAppsConfiguration")
    def q_apps_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationQAppsConfiguration']]:
        """
        Configuration information about Amazon Q Apps.
        """
        return pulumi.get(self, "q_apps_configuration")

    @property
    @pulumi.getter(name="quickSightConfiguration")
    def quick_sight_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationQuickSightConfiguration']]:
        """
        The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity provider.
        """
        return pulumi.get(self, "quick_sight_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics. If this property is not specified, Amazon Q Business will create a [service linked role (SLR)](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions) and use it as the application's role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['ApplicationStatus']:
        """
        The status of the Amazon Q Business application. The application is ready to use when the status is `ACTIVE` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the Amazon Q Business application was last updated.
        """
        return pulumi.get(self, "updated_at")

