# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['EnvironmentAccountConnectionArgs', 'EnvironmentAccountConnection']

@pulumi.input_type
class EnvironmentAccountConnectionArgs:
    def __init__(__self__, *,
                 codebuild_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 component_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 environment_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 management_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a EnvironmentAccountConnection resource.
        :param pulumi.Input[builtins.str] codebuild_role_arn: The Amazon Resource Name (ARN) of an IAM service role in the environment account. AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
        :param pulumi.Input[builtins.str] component_role_arn: The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
        :param pulumi.Input[builtins.str] environment_account_id: The environment account that's connected to the environment account connection.
        :param pulumi.Input[builtins.str] environment_name: The name of the AWS Proton environment that's created in the associated management account.
        :param pulumi.Input[builtins.str] management_account_id: The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision infrastructure resources in the associated environment account.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: <p>An optional list of metadata items that you can associate with the Proton environment account connection. A tag is a key-value pair.</p>
                        <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
                       <i>Proton User Guide</i>.</p>
        """
        if codebuild_role_arn is not None:
            pulumi.set(__self__, "codebuild_role_arn", codebuild_role_arn)
        if component_role_arn is not None:
            pulumi.set(__self__, "component_role_arn", component_role_arn)
        if environment_account_id is not None:
            pulumi.set(__self__, "environment_account_id", environment_account_id)
        if environment_name is not None:
            pulumi.set(__self__, "environment_name", environment_name)
        if management_account_id is not None:
            pulumi.set(__self__, "management_account_id", management_account_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="codebuildRoleArn")
    def codebuild_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM service role in the environment account. AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
        """
        return pulumi.get(self, "codebuild_role_arn")

    @codebuild_role_arn.setter
    def codebuild_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "codebuild_role_arn", value)

    @property
    @pulumi.getter(name="componentRoleArn")
    def component_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
        """
        return pulumi.get(self, "component_role_arn")

    @component_role_arn.setter
    def component_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_role_arn", value)

    @property
    @pulumi.getter(name="environmentAccountId")
    def environment_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment account that's connected to the environment account connection.
        """
        return pulumi.get(self, "environment_account_id")

    @environment_account_id.setter
    def environment_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_account_id", value)

    @property
    @pulumi.getter(name="environmentName")
    def environment_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AWS Proton environment that's created in the associated management account.
        """
        return pulumi.get(self, "environment_name")

    @environment_name.setter
    def environment_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_name", value)

    @property
    @pulumi.getter(name="managementAccountId")
    def management_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
        """
        return pulumi.get(self, "management_account_id")

    @management_account_id.setter
    def management_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_account_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision infrastructure resources in the associated environment account.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        <p>An optional list of metadata items that you can associate with the Proton environment account connection. A tag is a key-value pair.</p>
                 <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
                <i>Proton User Guide</i>.</p>
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:proton:EnvironmentAccountConnection")
class EnvironmentAccountConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 codebuild_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 component_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 environment_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 management_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Schema describing various properties for AWS Proton Environment Account Connections resources.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] codebuild_role_arn: The Amazon Resource Name (ARN) of an IAM service role in the environment account. AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
        :param pulumi.Input[builtins.str] component_role_arn: The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
        :param pulumi.Input[builtins.str] environment_account_id: The environment account that's connected to the environment account connection.
        :param pulumi.Input[builtins.str] environment_name: The name of the AWS Proton environment that's created in the associated management account.
        :param pulumi.Input[builtins.str] management_account_id: The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision infrastructure resources in the associated environment account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: <p>An optional list of metadata items that you can associate with the Proton environment account connection. A tag is a key-value pair.</p>
                        <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
                       <i>Proton User Guide</i>.</p>
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EnvironmentAccountConnectionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema describing various properties for AWS Proton Environment Account Connections resources.

        :param str resource_name: The name of the resource.
        :param EnvironmentAccountConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentAccountConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 codebuild_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 component_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 environment_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 management_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentAccountConnectionArgs.__new__(EnvironmentAccountConnectionArgs)

            __props__.__dict__["codebuild_role_arn"] = codebuild_role_arn
            __props__.__dict__["component_role_arn"] = component_role_arn
            __props__.__dict__["environment_account_id"] = environment_account_id
            __props__.__dict__["environment_name"] = environment_name
            __props__.__dict__["management_account_id"] = management_account_id
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["status"] = None
        super(EnvironmentAccountConnection, __self__).__init__(
            'aws-native:proton:EnvironmentAccountConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentAccountConnection':
        """
        Get an existing EnvironmentAccountConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentAccountConnectionArgs.__new__(EnvironmentAccountConnectionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["codebuild_role_arn"] = None
        __props__.__dict__["component_role_arn"] = None
        __props__.__dict__["environment_account_id"] = None
        __props__.__dict__["environment_name"] = None
        __props__.__dict__["management_account_id"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return EnvironmentAccountConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the environment account connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the environment account connection.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="codebuildRoleArn")
    def codebuild_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM service role in the environment account. AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
        """
        return pulumi.get(self, "codebuild_role_arn")

    @property
    @pulumi.getter(name="componentRoleArn")
    def component_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.
        """
        return pulumi.get(self, "component_role_arn")

    @property
    @pulumi.getter(name="environmentAccountId")
    def environment_account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The environment account that's connected to the environment account connection.
        """
        return pulumi.get(self, "environment_account_id")

    @property
    @pulumi.getter(name="environmentName")
    def environment_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the AWS Proton environment that's created in the associated management account.
        """
        return pulumi.get(self, "environment_name")

    @property
    @pulumi.getter(name="managementAccountId")
    def management_account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the management account that accepts or rejects the environment account connection. You create an manage the AWS Proton environment in this account. If the management account accepts the environment account connection, AWS Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.
        """
        return pulumi.get(self, "management_account_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. AWS Proton uses this role to provision infrastructure resources in the associated environment account.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['EnvironmentAccountConnectionStatus']:
        """
        The status of the environment account connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        <p>An optional list of metadata items that you can associate with the Proton environment account connection. A tag is a key-value pair.</p>
                 <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and tagging</a> in the
                <i>Proton User Guide</i>.</p>
        """
        return pulumi.get(self, "tags")

