# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'PipeAwsVpcConfiguration',
    'PipeBatchArrayProperties',
    'PipeBatchContainerOverrides',
    'PipeBatchEnvironmentVariable',
    'PipeBatchJobDependency',
    'PipeBatchResourceRequirement',
    'PipeBatchRetryStrategy',
    'PipeCapacityProviderStrategyItem',
    'PipeCloudwatchLogsLogDestination',
    'PipeDeadLetterConfig',
    'PipeDimensionMapping',
    'PipeEcsContainerOverride',
    'PipeEcsEnvironmentFile',
    'PipeEcsEnvironmentVariable',
    'PipeEcsEphemeralStorage',
    'PipeEcsInferenceAcceleratorOverride',
    'PipeEcsResourceRequirement',
    'PipeEcsTaskOverride',
    'PipeEnrichmentHttpParameters',
    'PipeEnrichmentParameters',
    'PipeFilter',
    'PipeFilterCriteria',
    'PipeFirehoseLogDestination',
    'PipeLogConfiguration',
    'PipeMqBrokerAccessCredentialsProperties',
    'PipeMskAccessCredentials0Properties',
    'PipeMskAccessCredentials1Properties',
    'PipeMultiMeasureAttributeMapping',
    'PipeMultiMeasureMapping',
    'PipeNetworkConfiguration',
    'PipePlacementConstraint',
    'PipePlacementStrategy',
    'PipeS3LogDestination',
    'PipeSageMakerPipelineParameter',
    'PipeSelfManagedKafkaAccessConfigurationCredentials0Properties',
    'PipeSelfManagedKafkaAccessConfigurationCredentials1Properties',
    'PipeSelfManagedKafkaAccessConfigurationCredentials2Properties',
    'PipeSelfManagedKafkaAccessConfigurationCredentials3Properties',
    'PipeSelfManagedKafkaAccessConfigurationVpc',
    'PipeSingleMeasureMapping',
    'PipeSourceActiveMqBrokerParameters',
    'PipeSourceDynamoDbStreamParameters',
    'PipeSourceKinesisStreamParameters',
    'PipeSourceManagedStreamingKafkaParameters',
    'PipeSourceParameters',
    'PipeSourceRabbitMqBrokerParameters',
    'PipeSourceSelfManagedKafkaParameters',
    'PipeSourceSqsQueueParameters',
    'PipeTag',
    'PipeTargetBatchJobParameters',
    'PipeTargetCloudWatchLogsParameters',
    'PipeTargetEcsTaskParameters',
    'PipeTargetEventBridgeEventBusParameters',
    'PipeTargetHttpParameters',
    'PipeTargetKinesisStreamParameters',
    'PipeTargetLambdaFunctionParameters',
    'PipeTargetParameters',
    'PipeTargetRedshiftDataParameters',
    'PipeTargetSageMakerPipelineParameters',
    'PipeTargetSqsQueueParameters',
    'PipeTargetStateMachineParameters',
    'PipeTargetTimestreamParameters',
]

@pulumi.output_type
class PipeAwsVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional['PipeAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        :param 'PipeAssignPublicIp' assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        :param Sequence[builtins.str] security_groups: Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['PipeAssignPublicIp']:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class PipeBatchArrayProperties(dict):
    def __init__(__self__, *,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.int size: The size of the array, if this is an array batch job.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        The size of the array, if this is an array batch job.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class PipeBatchContainerOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeBatchContainerOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeBatchContainerOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeBatchContainerOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[builtins.str]] = None,
                 environment: Optional[Sequence['outputs.PipeBatchEnvironmentVariable']] = None,
                 instance_type: Optional[builtins.str] = None,
                 resource_requirements: Optional[Sequence['outputs.PipeBatchResourceRequirement']] = None):
        """
        :param Sequence[builtins.str] command: The command to send to the container that overrides the default command from the Docker image or the task definition.
        :param Sequence['PipeBatchEnvironmentVariable'] environment: The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.
               
               > Environment variables cannot start with " `AWS Batch` ". This naming convention is reserved for variables that AWS Batch sets.
        :param builtins.str instance_type: The instance type to use for a multi-node parallel job.
               
               > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        :param Sequence['PipeBatchResourceRequirement'] resource_requirements: The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command to send to the container that overrides the default command from the Docker image or the task definition.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.PipeBatchEnvironmentVariable']]:
        """
        The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.

        > Environment variables cannot start with " `AWS Batch` ". This naming convention is reserved for variables that AWS Batch sets.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The instance type to use for a multi-node parallel job.

        > This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.PipeBatchResourceRequirement']]:
        """
        The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "resource_requirements")


@pulumi.output_type
class PipeBatchEnvironmentVariable(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the key-value pair. For environment variables, this is the name of the environment variable.
        :param builtins.str value: The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the key-value pair. For environment variables, this is the name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeBatchJobDependency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeBatchJobDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeBatchJobDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeBatchJobDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: Optional[builtins.str] = None,
                 type: Optional['PipeBatchJobDependencyType'] = None):
        """
        :param builtins.str job_id: The job ID of the AWS Batch job that's associated with this dependency.
        :param 'PipeBatchJobDependencyType' type: The type of the job dependency.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[builtins.str]:
        """
        The job ID of the AWS Batch job that's associated with this dependency.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def type(self) -> Optional['PipeBatchJobDependencyType']:
        """
        The type of the job dependency.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipeBatchResourceRequirement(dict):
    def __init__(__self__, *,
                 type: 'PipeBatchResourceRequirementType',
                 value: builtins.str):
        """
        :param 'PipeBatchResourceRequirementType' type: The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        :param builtins.str value: The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
               
               - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.
               
               > GPUs aren't available for jobs that are running on Fargate resources.
               - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .
               
               > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 
               
               For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.
               
               - **value = 512** - `VCPU` = 0.25
               - **value = 1024** - `VCPU` = 0.25 or 0.5
               - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
               - **value = 3072** - `VCPU` = 0.5, or 1
               - **value = 4096** - `VCPU` = 0.5, 1, or 2
               - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
               - **value = 8192** - `VCPU` = 1, 2, 4, or 8
               - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
               - **value = 16384** - `VCPU` = 2, 4, or 8
               - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
               - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
               - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
               - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
               - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
               - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.
               
               The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .
               
               For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
               
               - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
               - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
               - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
               - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
               - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
               - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
               - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'PipeBatchResourceRequirementType':
        """
        The type of resource to assign to a container. The supported resources include `GPU` , `MEMORY` , and `VCPU` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.

        - **type="GPU"** - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.

        > GPUs aren't available for jobs that are running on Fargate resources.
        - **type="MEMORY"** - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to `Memory` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--memory` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) .

        > If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see [Memory management](https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html) in the *AWS Batch User Guide* . 

        For jobs that are running on Fargate resources, then `value` is the hard limit (in MiB), and must match one of the supported values and the `VCPU` values must be one of the values supported for that memory value.

        - **value = 512** - `VCPU` = 0.25
        - **value = 1024** - `VCPU` = 0.25 or 0.5
        - **value = 2048** - `VCPU` = 0.25, 0.5, or 1
        - **value = 3072** - `VCPU` = 0.5, or 1
        - **value = 4096** - `VCPU` = 0.5, 1, or 2
        - **value = 5120, 6144, or 7168** - `VCPU` = 1 or 2
        - **value = 8192** - `VCPU` = 1, 2, 4, or 8
        - **value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360** - `VCPU` = 2 or 4
        - **value = 16384** - `VCPU` = 2, 4, or 8
        - **value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720** - `VCPU` = 4
        - **value = 20480, 24576, or 28672** - `VCPU` = 4 or 8
        - **value = 36864, 45056, 53248, or 61440** - `VCPU` = 8
        - **value = 32768, 40960, 49152, or 57344** - `VCPU` = 8 or 16
        - **value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880** - `VCPU` = 16
        - **type="VCPU"** - The number of vCPUs reserved for the container. This parameter maps to `CpuShares` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/) and the `--cpu-shares` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/) . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.

        The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see [AWS Fargate quotas](https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate) in the *AWS General Reference* .

        For jobs that are running on Fargate resources, then `value` must match one of the supported values and the `MEMORY` values must be one of the values supported for that `VCPU` value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16

        - **value = 0.25** - `MEMORY` = 512, 1024, or 2048
        - **value = 0.5** - `MEMORY` = 1024, 2048, 3072, or 4096
        - **value = 1** - `MEMORY` = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
        - **value = 2** - `MEMORY` = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384
        - **value = 4** - `MEMORY` = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720
        - **value = 8** - `MEMORY` = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440
        - **value = 16** - `MEMORY` = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeBatchRetryStrategy(dict):
    def __init__(__self__, *,
                 attempts: Optional[builtins.int] = None):
        """
        :param builtins.int attempts: The number of times to move a job to the `RUNNABLE` status. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[builtins.int]:
        """
        The number of times to move a job to the `RUNNABLE` status. If the value of `attempts` is greater than one, the job is retried on failure the same number of attempts as the value.
        """
        return pulumi.get(self, "attempts")


@pulumi.output_type
class PipeCapacityProviderStrategyItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: The short name of the capacity provider.
        :param builtins.int base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        :param builtins.int weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class PipeCloudwatchLogsLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeCloudwatchLogsLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeCloudwatchLogsLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeCloudwatchLogsLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: Optional[builtins.str] = None):
        """
        :param builtins.str log_group_arn: The AWS Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
        """
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[builtins.str]:
        """
        The AWS Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
        """
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class PipeDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        :param builtins.str arn: The ARN of the specified target for the dead-letter queue.
               
               For Amazon Kinesis stream and Amazon DynamoDB stream sources, specify either an Amazon SNS topic or Amazon SQS queue ARN.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the specified target for the dead-letter queue.

        For Amazon Kinesis stream and Amazon DynamoDB stream sources, specify either an Amazon SNS topic or Amazon SQS queue ARN.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class PipeDimensionMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionName":
            suggest = "dimension_name"
        elif key == "dimensionValue":
            suggest = "dimension_value"
        elif key == "dimensionValueType":
            suggest = "dimension_value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeDimensionMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeDimensionMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeDimensionMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_name: builtins.str,
                 dimension_value: builtins.str,
                 dimension_value_type: 'PipeDimensionValueType'):
        """
        :param builtins.str dimension_name: The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
        :param builtins.str dimension_value: Dynamic path to the dimension value in the source event.
        :param 'PipeDimensionValueType' dimension_value_type: The data type of the dimension for the time-series data.
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "dimension_value", dimension_value)
        pulumi.set(__self__, "dimension_value_type", dimension_value_type)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> builtins.str:
        """
        The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> builtins.str:
        """
        Dynamic path to the dimension value in the source event.
        """
        return pulumi.get(self, "dimension_value")

    @property
    @pulumi.getter(name="dimensionValueType")
    def dimension_value_type(self) -> 'PipeDimensionValueType':
        """
        The data type of the dimension for the time-series data.
        """
        return pulumi.get(self, "dimension_value_type")


@pulumi.output_type
class PipeEcsContainerOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentFiles":
            suggest = "environment_files"
        elif key == "memoryReservation":
            suggest = "memory_reservation"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEcsContainerOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEcsContainerOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEcsContainerOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[builtins.str]] = None,
                 cpu: Optional[builtins.int] = None,
                 environment: Optional[Sequence['outputs.PipeEcsEnvironmentVariable']] = None,
                 environment_files: Optional[Sequence['outputs.PipeEcsEnvironmentFile']] = None,
                 memory: Optional[builtins.int] = None,
                 memory_reservation: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 resource_requirements: Optional[Sequence['outputs.PipeEcsResourceRequirement']] = None):
        """
        :param Sequence[builtins.str] command: The command to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        :param builtins.int cpu: The number of `cpu` units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        :param Sequence['PipeEcsEnvironmentVariable'] environment: The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
        :param Sequence['PipeEcsEnvironmentFile'] environment_files: A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
        :param builtins.int memory: The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        :param builtins.int memory_reservation: The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
        :param builtins.str name: The name of the container that receives the override. This parameter is required if any override is specified.
        :param Sequence['PipeEcsResourceRequirement'] resource_requirements: The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.int]:
        """
        The number of `cpu` units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.PipeEcsEnvironmentVariable']]:
        """
        The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[Sequence['outputs.PipeEcsEnvironmentFile']]:
        """
        A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
        """
        return pulumi.get(self, "environment_files")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[builtins.int]:
        """
        The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the container that receives the override. This parameter is required if any override is specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.PipeEcsResourceRequirement']]:
        """
        The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU.
        """
        return pulumi.get(self, "resource_requirements")


@pulumi.output_type
class PipeEcsEnvironmentFile(dict):
    def __init__(__self__, *,
                 type: 'PipeEcsEnvironmentFileType',
                 value: builtins.str):
        """
        :param 'PipeEcsEnvironmentFileType' type: The file type to use. The only supported value is `s3` .
        :param builtins.str value: The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'PipeEcsEnvironmentFileType':
        """
        The file type to use. The only supported value is `s3` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeEcsEnvironmentVariable(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the key-value pair. For environment variables, this is the name of the environment variable.
        :param builtins.str value: The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the key-value pair. For environment variables, this is the name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeEcsEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGiB":
            suggest = "size_in_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEcsEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEcsEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEcsEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gi_b: builtins.int):
        """
        :param builtins.int size_in_gi_b: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> builtins.int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gi_b")


@pulumi.output_type
class PipeEcsInferenceAcceleratorOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deviceType":
            suggest = "device_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEcsInferenceAcceleratorOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEcsInferenceAcceleratorOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEcsInferenceAcceleratorOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[builtins.str] = None,
                 device_type: Optional[builtins.str] = None):
        """
        :param builtins.str device_name: The Elastic Inference accelerator device name to override for the task. This parameter must match a `deviceName` specified in the task definition.
        :param builtins.str device_type: The Elastic Inference accelerator type to use.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator device name to override for the task. This parameter must match a `deviceName` specified in the task definition.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator type to use.
        """
        return pulumi.get(self, "device_type")


@pulumi.output_type
class PipeEcsResourceRequirement(dict):
    def __init__(__self__, *,
                 type: 'PipeEcsResourceRequirementType',
                 value: builtins.str):
        """
        :param 'PipeEcsResourceRequirementType' type: The type of resource to assign to a container. The supported values are `GPU` or `InferenceAccelerator` .
        :param builtins.str value: The value for the specified resource type.
               
               If the `GPU` type is used, the value is the number of physical `GPUs` the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
               
               If the `InferenceAccelerator` type is used, the `value` matches the `deviceName` for an InferenceAccelerator specified in a task definition.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'PipeEcsResourceRequirementType':
        """
        The type of resource to assign to a container. The supported values are `GPU` or `InferenceAccelerator` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the specified resource type.

        If the `GPU` type is used, the value is the number of physical `GPUs` the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.

        If the `InferenceAccelerator` type is used, the `value` matches the `deviceName` for an InferenceAccelerator specified in a task definition.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeEcsTaskOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerOverrides":
            suggest = "container_overrides"
        elif key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "inferenceAcceleratorOverrides":
            suggest = "inference_accelerator_overrides"
        elif key == "taskRoleArn":
            suggest = "task_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEcsTaskOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEcsTaskOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEcsTaskOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_overrides: Optional[Sequence['outputs.PipeEcsContainerOverride']] = None,
                 cpu: Optional[builtins.str] = None,
                 ephemeral_storage: Optional['outputs.PipeEcsEphemeralStorage'] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 inference_accelerator_overrides: Optional[Sequence['outputs.PipeEcsInferenceAcceleratorOverride']] = None,
                 memory: Optional[builtins.str] = None,
                 task_role_arn: Optional[builtins.str] = None):
        """
        :param Sequence['PipeEcsContainerOverride'] container_overrides: One or more container overrides that are sent to a task.
        :param builtins.str cpu: The cpu override for the task.
        :param 'PipeEcsEphemeralStorage' ephemeral_storage: The ephemeral storage setting override for the task.
               
               > This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
               > 
               > - Linux platform version `1.4.0` or later.
               > - Windows platform version `1.0.0` or later.
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param Sequence['PipeEcsInferenceAcceleratorOverride'] inference_accelerator_overrides: The Elastic Inference accelerator override for the task.
        :param builtins.str memory: The memory override for the task.
        :param builtins.str task_role_arn: The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Role for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        if container_overrides is not None:
            pulumi.set(__self__, "container_overrides", container_overrides)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if inference_accelerator_overrides is not None:
            pulumi.set(__self__, "inference_accelerator_overrides", inference_accelerator_overrides)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)

    @property
    @pulumi.getter(name="containerOverrides")
    def container_overrides(self) -> Optional[Sequence['outputs.PipeEcsContainerOverride']]:
        """
        One or more container overrides that are sent to a task.
        """
        return pulumi.get(self, "container_overrides")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        The cpu override for the task.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional['outputs.PipeEcsEphemeralStorage']:
        """
        The ephemeral storage setting override for the task.

        > This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
        > 
        > - Linux platform version `1.4.0` or later.
        > - Windows platform version `1.0.0` or later.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="inferenceAcceleratorOverrides")
    def inference_accelerator_overrides(self) -> Optional[Sequence['outputs.PipeEcsInferenceAcceleratorOverride']]:
        """
        The Elastic Inference accelerator override for the task.
        """
        return pulumi.get(self, "inference_accelerator_overrides")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        The memory override for the task.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Role for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "task_role_arn")


@pulumi.output_type
class PipeEnrichmentHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEnrichmentHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEnrichmentHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEnrichmentHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, builtins.str]] = None,
                 path_parameter_values: Optional[Sequence[builtins.str]] = None,
                 query_string_parameters: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] header_parameters: The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        :param Sequence[builtins.str] path_parameter_values: The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
        :param Mapping[str, builtins.str] query_string_parameters: The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[Sequence[builtins.str]]:
        """
        The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
        """
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class PipeEnrichmentParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputTemplate":
            suggest = "input_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEnrichmentParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEnrichmentParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEnrichmentParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_parameters: Optional['outputs.PipeEnrichmentHttpParameters'] = None,
                 input_template: Optional[builtins.str] = None):
        """
        :param 'PipeEnrichmentHttpParameters' http_parameters: Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
               
               If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        :param builtins.str input_template: Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the enrichment. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
               
               To remove an input template, specify an empty string.
        """
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input_template is not None:
            pulumi.set(__self__, "input_template", input_template)

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.PipeEnrichmentHttpParameters']:
        """
        Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.

        If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        """
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> Optional[builtins.str]:
        """
        Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the enrichment. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .

        To remove an input template, specify an empty string.
        """
        return pulumi.get(self, "input_template")


@pulumi.output_type
class PipeFilter(dict):
    def __init__(__self__, *,
                 pattern: Optional[builtins.str] = None):
        """
        :param builtins.str pattern: The event pattern.
        """
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[builtins.str]:
        """
        The event pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class PipeFilterCriteria(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.PipeFilter']] = None):
        """
        :param Sequence['PipeFilter'] filters: The event patterns.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.PipeFilter']]:
        """
        The event patterns.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class PipeFirehoseLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamArn":
            suggest = "delivery_stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeFirehoseLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeFirehoseLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeFirehoseLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_arn: Optional[builtins.str] = None):
        """
        :param builtins.str delivery_stream_arn: The Amazon Resource Name (ARN) of the Firehose delivery stream to which EventBridge delivers the pipe log records.
        """
        if delivery_stream_arn is not None:
            pulumi.set(__self__, "delivery_stream_arn", delivery_stream_arn)

    @property
    @pulumi.getter(name="deliveryStreamArn")
    def delivery_stream_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Firehose delivery stream to which EventBridge delivers the pipe log records.
        """
        return pulumi.get(self, "delivery_stream_arn")


@pulumi.output_type
class PipeLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsLogDestination":
            suggest = "cloudwatch_logs_log_destination"
        elif key == "firehoseLogDestination":
            suggest = "firehose_log_destination"
        elif key == "includeExecutionData":
            suggest = "include_execution_data"
        elif key == "s3LogDestination":
            suggest = "s3_log_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_log_destination: Optional['outputs.PipeCloudwatchLogsLogDestination'] = None,
                 firehose_log_destination: Optional['outputs.PipeFirehoseLogDestination'] = None,
                 include_execution_data: Optional[Sequence['PipeIncludeExecutionDataOption']] = None,
                 level: Optional['PipeLogLevel'] = None,
                 s3_log_destination: Optional['outputs.PipeS3LogDestination'] = None):
        """
        :param 'PipeCloudwatchLogsLogDestination' cloudwatch_logs_log_destination: The logging configuration settings for the pipe.
        :param 'PipeFirehoseLogDestination' firehose_log_destination: The Amazon Data Firehose logging configuration settings for the pipe.
        :param Sequence['PipeIncludeExecutionDataOption'] include_execution_data: Whether the execution data (specifically, the `payload` , `awsRequest` , and `awsResponse` fields) is included in the log messages for this pipe.
               
               This applies to all log destinations for the pipe.
               
               For more information, see [Including execution data in logs](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data) in the *Amazon EventBridge User Guide* .
               
               *Allowed values:* `ALL`
        :param 'PipeLogLevel' level: The level of logging detail to include. This applies to all log destinations for the pipe.
        :param 'PipeS3LogDestination' s3_log_destination: The Amazon S3 logging configuration settings for the pipe.
        """
        if cloudwatch_logs_log_destination is not None:
            pulumi.set(__self__, "cloudwatch_logs_log_destination", cloudwatch_logs_log_destination)
        if firehose_log_destination is not None:
            pulumi.set(__self__, "firehose_log_destination", firehose_log_destination)
        if include_execution_data is not None:
            pulumi.set(__self__, "include_execution_data", include_execution_data)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if s3_log_destination is not None:
            pulumi.set(__self__, "s3_log_destination", s3_log_destination)

    @property
    @pulumi.getter(name="cloudwatchLogsLogDestination")
    def cloudwatch_logs_log_destination(self) -> Optional['outputs.PipeCloudwatchLogsLogDestination']:
        """
        The logging configuration settings for the pipe.
        """
        return pulumi.get(self, "cloudwatch_logs_log_destination")

    @property
    @pulumi.getter(name="firehoseLogDestination")
    def firehose_log_destination(self) -> Optional['outputs.PipeFirehoseLogDestination']:
        """
        The Amazon Data Firehose logging configuration settings for the pipe.
        """
        return pulumi.get(self, "firehose_log_destination")

    @property
    @pulumi.getter(name="includeExecutionData")
    def include_execution_data(self) -> Optional[Sequence['PipeIncludeExecutionDataOption']]:
        """
        Whether the execution data (specifically, the `payload` , `awsRequest` , and `awsResponse` fields) is included in the log messages for this pipe.

        This applies to all log destinations for the pipe.

        For more information, see [Including execution data in logs](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data) in the *Amazon EventBridge User Guide* .

        *Allowed values:* `ALL`
        """
        return pulumi.get(self, "include_execution_data")

    @property
    @pulumi.getter
    def level(self) -> Optional['PipeLogLevel']:
        """
        The level of logging detail to include. This applies to all log destinations for the pipe.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="s3LogDestination")
    def s3_log_destination(self) -> Optional['outputs.PipeS3LogDestination']:
        """
        The Amazon S3 logging configuration settings for the pipe.
        """
        return pulumi.get(self, "s3_log_destination")


@pulumi.output_type
class PipeMqBrokerAccessCredentialsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeMqBrokerAccessCredentialsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeMqBrokerAccessCredentialsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeMqBrokerAccessCredentialsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: builtins.str):
        """
        :param builtins.str basic_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "basic_auth", basic_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "basic_auth")


@pulumi.output_type
class PipeMskAccessCredentials0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "saslScram512Auth":
            suggest = "sasl_scram512_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeMskAccessCredentials0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeMskAccessCredentials0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeMskAccessCredentials0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sasl_scram512_auth: builtins.str):
        """
        :param builtins.str sasl_scram512_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "sasl_scram512_auth", sasl_scram512_auth)

    @property
    @pulumi.getter(name="saslScram512Auth")
    def sasl_scram512_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "sasl_scram512_auth")


@pulumi.output_type
class PipeMskAccessCredentials1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificateTlsAuth":
            suggest = "client_certificate_tls_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeMskAccessCredentials1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeMskAccessCredentials1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeMskAccessCredentials1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate_tls_auth: builtins.str):
        """
        :param builtins.str client_certificate_tls_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "client_certificate_tls_auth", client_certificate_tls_auth)

    @property
    @pulumi.getter(name="clientCertificateTlsAuth")
    def client_certificate_tls_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "client_certificate_tls_auth")


@pulumi.output_type
class PipeMultiMeasureAttributeMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValue":
            suggest = "measure_value"
        elif key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "multiMeasureAttributeName":
            suggest = "multi_measure_attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeMultiMeasureAttributeMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeMultiMeasureAttributeMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeMultiMeasureAttributeMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value: builtins.str,
                 measure_value_type: 'PipeMeasureValueType',
                 multi_measure_attribute_name: builtins.str):
        """
        :param builtins.str measure_value: Dynamic path to the measurement attribute in the source event.
        :param 'PipeMeasureValueType' measure_value_type: Data type of the measurement attribute in the source event.
        :param builtins.str multi_measure_attribute_name: Target measure name to be used.
        """
        pulumi.set(__self__, "measure_value", measure_value)
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        pulumi.set(__self__, "multi_measure_attribute_name", multi_measure_attribute_name)

    @property
    @pulumi.getter(name="measureValue")
    def measure_value(self) -> builtins.str:
        """
        Dynamic path to the measurement attribute in the source event.
        """
        return pulumi.get(self, "measure_value")

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> 'PipeMeasureValueType':
        """
        Data type of the measurement attribute in the source event.
        """
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="multiMeasureAttributeName")
    def multi_measure_attribute_name(self) -> builtins.str:
        """
        Target measure name to be used.
        """
        return pulumi.get(self, "multi_measure_attribute_name")


@pulumi.output_type
class PipeMultiMeasureMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multiMeasureAttributeMappings":
            suggest = "multi_measure_attribute_mappings"
        elif key == "multiMeasureName":
            suggest = "multi_measure_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeMultiMeasureMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeMultiMeasureMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeMultiMeasureMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multi_measure_attribute_mappings: Sequence['outputs.PipeMultiMeasureAttributeMapping'],
                 multi_measure_name: builtins.str):
        """
        :param Sequence['PipeMultiMeasureAttributeMapping'] multi_measure_attribute_mappings: Mappings that represent multiple source event fields mapped to measures in the same Timestream for LiveAnalytics record.
        :param builtins.str multi_measure_name: The name of the multiple measurements per record (multi-measure).
        """
        pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        pulumi.set(__self__, "multi_measure_name", multi_measure_name)

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Sequence['outputs.PipeMultiMeasureAttributeMapping']:
        """
        Mappings that represent multiple source event fields mapped to measures in the same Timestream for LiveAnalytics record.
        """
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @property
    @pulumi.getter(name="multiMeasureName")
    def multi_measure_name(self) -> builtins.str:
        """
        The name of the multiple measurements per record (multi-measure).
        """
        return pulumi.get(self, "multi_measure_name")


@pulumi.output_type
class PipeNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsvpcConfiguration":
            suggest = "awsvpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 awsvpc_configuration: Optional['outputs.PipeAwsVpcConfiguration'] = None):
        """
        :param 'PipeAwsVpcConfiguration' awsvpc_configuration: Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        if awsvpc_configuration is not None:
            pulumi.set(__self__, "awsvpc_configuration", awsvpc_configuration)

    @property
    @pulumi.getter(name="awsvpcConfiguration")
    def awsvpc_configuration(self) -> Optional['outputs.PipeAwsVpcConfiguration']:
        """
        Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        return pulumi.get(self, "awsvpc_configuration")


@pulumi.output_type
class PipePlacementConstraint(dict):
    def __init__(__self__, *,
                 expression: Optional[builtins.str] = None,
                 type: Optional['PipePlacementConstraintType'] = None):
        """
        :param builtins.str expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        :param 'PipePlacementConstraintType' type: The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> Optional['PipePlacementConstraintType']:
        """
        The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipePlacementStrategy(dict):
    def __init__(__self__, *,
                 field: Optional[builtins.str] = None,
                 type: Optional['PipePlacementStrategyType'] = None):
        """
        :param builtins.str field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        :param 'PipePlacementStrategyType' type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def type(self) -> Optional['PipePlacementStrategyType']:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipeS3LogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketOwner":
            suggest = "bucket_owner"
        elif key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeS3LogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeS3LogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeS3LogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[builtins.str] = None,
                 bucket_owner: Optional[builtins.str] = None,
                 output_format: Optional['PipeS3OutputFormat'] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        :param builtins.str bucket_owner: The AWS account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        :param 'PipeS3OutputFormat' output_format: The format EventBridge uses for the log records.
               
               EventBridge currently only supports `json` formatting.
        :param builtins.str prefix: The prefix text with which to begin Amazon S3 log object names.
               
               For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html) in the *Amazon Simple Storage Service User Guide* .
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_owner is not None:
            pulumi.set(__self__, "bucket_owner", bucket_owner)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[builtins.str]:
        """
        The name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> Optional[builtins.str]:
        """
        The AWS account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        """
        return pulumi.get(self, "bucket_owner")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional['PipeS3OutputFormat']:
        """
        The format EventBridge uses for the log records.

        EventBridge currently only supports `json` formatting.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The prefix text with which to begin Amazon S3 log object names.

        For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html) in the *Amazon Simple Storage Service User Guide* .
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class PipeSageMakerPipelineParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeSelfManagedKafkaAccessConfigurationCredentials0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSelfManagedKafkaAccessConfigurationCredentials0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: builtins.str):
        """
        :param builtins.str basic_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "basic_auth", basic_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "basic_auth")


@pulumi.output_type
class PipeSelfManagedKafkaAccessConfigurationCredentials1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "saslScram512Auth":
            suggest = "sasl_scram512_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSelfManagedKafkaAccessConfigurationCredentials1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sasl_scram512_auth: builtins.str):
        """
        :param builtins.str sasl_scram512_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "sasl_scram512_auth", sasl_scram512_auth)

    @property
    @pulumi.getter(name="saslScram512Auth")
    def sasl_scram512_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "sasl_scram512_auth")


@pulumi.output_type
class PipeSelfManagedKafkaAccessConfigurationCredentials2Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "saslScram256Auth":
            suggest = "sasl_scram256_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSelfManagedKafkaAccessConfigurationCredentials2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sasl_scram256_auth: builtins.str):
        """
        :param builtins.str sasl_scram256_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "sasl_scram256_auth", sasl_scram256_auth)

    @property
    @pulumi.getter(name="saslScram256Auth")
    def sasl_scram256_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "sasl_scram256_auth")


@pulumi.output_type
class PipeSelfManagedKafkaAccessConfigurationCredentials3Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificateTlsAuth":
            suggest = "client_certificate_tls_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSelfManagedKafkaAccessConfigurationCredentials3Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials3Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSelfManagedKafkaAccessConfigurationCredentials3Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate_tls_auth: builtins.str):
        """
        :param builtins.str client_certificate_tls_auth: Optional SecretManager ARN which stores the database credentials
        """
        pulumi.set(__self__, "client_certificate_tls_auth", client_certificate_tls_auth)

    @property
    @pulumi.getter(name="clientCertificateTlsAuth")
    def client_certificate_tls_auth(self) -> builtins.str:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "client_certificate_tls_auth")


@pulumi.output_type
class PipeSelfManagedKafkaAccessConfigurationVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroup":
            suggest = "security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSelfManagedKafkaAccessConfigurationVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSelfManagedKafkaAccessConfigurationVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSelfManagedKafkaAccessConfigurationVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group: Optional[Sequence[builtins.str]] = None,
                 subnets: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] security_group: List of SecurityGroupId.
        :param Sequence[builtins.str] subnets: List of SubnetId.
        """
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[Sequence[builtins.str]]:
        """
        List of SecurityGroupId.
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        List of SubnetId.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class PipeSingleMeasureMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureName":
            suggest = "measure_name"
        elif key == "measureValue":
            suggest = "measure_value"
        elif key == "measureValueType":
            suggest = "measure_value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSingleMeasureMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSingleMeasureMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSingleMeasureMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_name: builtins.str,
                 measure_value: builtins.str,
                 measure_value_type: 'PipeMeasureValueType'):
        """
        :param builtins.str measure_name: Target measure name for the measurement attribute in the Timestream table.
        :param builtins.str measure_value: Dynamic path of the source field to map to the measure in the record.
        :param 'PipeMeasureValueType' measure_value_type: Data type of the source field.
        """
        pulumi.set(__self__, "measure_name", measure_name)
        pulumi.set(__self__, "measure_value", measure_value)
        pulumi.set(__self__, "measure_value_type", measure_value_type)

    @property
    @pulumi.getter(name="measureName")
    def measure_name(self) -> builtins.str:
        """
        Target measure name for the measurement attribute in the Timestream table.
        """
        return pulumi.get(self, "measure_name")

    @property
    @pulumi.getter(name="measureValue")
    def measure_value(self) -> builtins.str:
        """
        Dynamic path of the source field to map to the measure in the record.
        """
        return pulumi.get(self, "measure_value")

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> 'PipeMeasureValueType':
        """
        Data type of the source field.
        """
        return pulumi.get(self, "measure_value_type")


@pulumi.output_type
class PipeSourceActiveMqBrokerParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceActiveMqBrokerParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceActiveMqBrokerParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceActiveMqBrokerParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: 'outputs.PipeMqBrokerAccessCredentialsProperties',
                 queue_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None):
        """
        :param 'PipeMqBrokerAccessCredentialsProperties' credentials: The credentials needed to access the resource.
        :param builtins.str queue_name: The name of the destination queue to consume.
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "queue_name", queue_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)

    @property
    @pulumi.getter
    def credentials(self) -> 'outputs.PipeMqBrokerAccessCredentialsProperties':
        """
        The credentials needed to access the resource.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        The name of the destination queue to consume.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")


@pulumi.output_type
class PipeSourceDynamoDbStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startingPosition":
            suggest = "starting_position"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "maximumRecordAgeInSeconds":
            suggest = "maximum_record_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"
        elif key == "onPartialBatchItemFailure":
            suggest = "on_partial_batch_item_failure"
        elif key == "parallelizationFactor":
            suggest = "parallelization_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceDynamoDbStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceDynamoDbStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceDynamoDbStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 starting_position: 'PipeDynamoDbStreamStartPosition',
                 batch_size: Optional[builtins.int] = None,
                 dead_letter_config: Optional['outputs.PipeDeadLetterConfig'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 maximum_record_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None,
                 on_partial_batch_item_failure: Optional['PipeOnPartialBatchItemFailureStreams'] = None,
                 parallelization_factor: Optional[builtins.int] = None):
        """
        :param 'PipeDynamoDbStreamStartPosition' starting_position: (Streams only) The position in a stream from which to start reading.
               
               *Valid values* : `TRIM_HORIZON | LATEST`
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param 'PipeDeadLetterConfig' dead_letter_config: Define the target queue to send dead-letter queue events to.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        :param builtins.int maximum_record_age_in_seconds: Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
        :param builtins.int maximum_retry_attempts: Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
        :param 'PipeOnPartialBatchItemFailureStreams' on_partial_batch_item_failure: Define how to handle item process failures. `AUTOMATIC_BISECT` halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
        :param builtins.int parallelization_factor: The number of batches to process concurrently from each shard. The default value is 1.
        """
        pulumi.set(__self__, "starting_position", starting_position)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if on_partial_batch_item_failure is not None:
            pulumi.set(__self__, "on_partial_batch_item_failure", on_partial_batch_item_failure)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> 'PipeDynamoDbStreamStartPosition':
        """
        (Streams only) The position in a stream from which to start reading.

        *Valid values* : `TRIM_HORIZON | LATEST`
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.PipeDeadLetterConfig']:
        """
        Define the target queue to send dead-letter queue events to.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[builtins.int]:
        """
        Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="onPartialBatchItemFailure")
    def on_partial_batch_item_failure(self) -> Optional['PipeOnPartialBatchItemFailureStreams']:
        """
        Define how to handle item process failures. `AUTOMATIC_BISECT` halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
        """
        return pulumi.get(self, "on_partial_batch_item_failure")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[builtins.int]:
        """
        The number of batches to process concurrently from each shard. The default value is 1.
        """
        return pulumi.get(self, "parallelization_factor")


@pulumi.output_type
class PipeSourceKinesisStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startingPosition":
            suggest = "starting_position"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "maximumRecordAgeInSeconds":
            suggest = "maximum_record_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"
        elif key == "onPartialBatchItemFailure":
            suggest = "on_partial_batch_item_failure"
        elif key == "parallelizationFactor":
            suggest = "parallelization_factor"
        elif key == "startingPositionTimestamp":
            suggest = "starting_position_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceKinesisStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceKinesisStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceKinesisStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 starting_position: 'PipeKinesisStreamStartPosition',
                 batch_size: Optional[builtins.int] = None,
                 dead_letter_config: Optional['outputs.PipeDeadLetterConfig'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 maximum_record_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None,
                 on_partial_batch_item_failure: Optional['PipeOnPartialBatchItemFailureStreams'] = None,
                 parallelization_factor: Optional[builtins.int] = None,
                 starting_position_timestamp: Optional[builtins.str] = None):
        """
        :param 'PipeKinesisStreamStartPosition' starting_position: The position in a stream from which to start reading.
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param 'PipeDeadLetterConfig' dead_letter_config: Define the target queue to send dead-letter queue events to.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        :param builtins.int maximum_record_age_in_seconds: Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
        :param builtins.int maximum_retry_attempts: Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
        :param 'PipeOnPartialBatchItemFailureStreams' on_partial_batch_item_failure: Define how to handle item process failures. `AUTOMATIC_BISECT` halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
        :param builtins.int parallelization_factor: The number of batches to process concurrently from each shard. The default value is 1.
        :param builtins.str starting_position_timestamp: With `StartingPosition` set to `AT_TIMESTAMP` , the time from which to start reading, in Unix time seconds.
        """
        pulumi.set(__self__, "starting_position", starting_position)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if on_partial_batch_item_failure is not None:
            pulumi.set(__self__, "on_partial_batch_item_failure", on_partial_batch_item_failure)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> 'PipeKinesisStreamStartPosition':
        """
        The position in a stream from which to start reading.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.PipeDeadLetterConfig']:
        """
        Define the target queue to send dead-letter queue events to.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[builtins.int]:
        """
        Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="onPartialBatchItemFailure")
    def on_partial_batch_item_failure(self) -> Optional['PipeOnPartialBatchItemFailureStreams']:
        """
        Define how to handle item process failures. `AUTOMATIC_BISECT` halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
        """
        return pulumi.get(self, "on_partial_batch_item_failure")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[builtins.int]:
        """
        The number of batches to process concurrently from each shard. The default value is 1.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[builtins.str]:
        """
        With `StartingPosition` set to `AT_TIMESTAMP` , the time from which to start reading, in Unix time seconds.
        """
        return pulumi.get(self, "starting_position_timestamp")


@pulumi.output_type
class PipeSourceManagedStreamingKafkaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicName":
            suggest = "topic_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "consumerGroupId":
            suggest = "consumer_group_id"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "startingPosition":
            suggest = "starting_position"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceManagedStreamingKafkaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceManagedStreamingKafkaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceManagedStreamingKafkaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 consumer_group_id: Optional[builtins.str] = None,
                 credentials: Optional[Any] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 starting_position: Optional['PipeMskStartPosition'] = None):
        """
        :param builtins.str topic_name: The name of the topic that the pipe will read from.
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param builtins.str consumer_group_id: The name of the destination queue to consume.
        :param Union['PipeMskAccessCredentials0Properties', 'PipeMskAccessCredentials1Properties'] credentials: The credentials needed to access the resource.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        :param 'PipeMskStartPosition' starting_position: The position in a stream from which to start reading.
        """
        pulumi.set(__self__, "topic_name", topic_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> builtins.str:
        """
        The name of the topic that the pipe will read from.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        The name of the destination queue to consume.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[Any]:
        """
        The credentials needed to access the resource.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional['PipeMskStartPosition']:
        """
        The position in a stream from which to start reading.
        """
        return pulumi.get(self, "starting_position")


@pulumi.output_type
class PipeSourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeMqBrokerParameters":
            suggest = "active_mq_broker_parameters"
        elif key == "dynamoDbStreamParameters":
            suggest = "dynamo_db_stream_parameters"
        elif key == "filterCriteria":
            suggest = "filter_criteria"
        elif key == "kinesisStreamParameters":
            suggest = "kinesis_stream_parameters"
        elif key == "managedStreamingKafkaParameters":
            suggest = "managed_streaming_kafka_parameters"
        elif key == "rabbitMqBrokerParameters":
            suggest = "rabbit_mq_broker_parameters"
        elif key == "selfManagedKafkaParameters":
            suggest = "self_managed_kafka_parameters"
        elif key == "sqsQueueParameters":
            suggest = "sqs_queue_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_mq_broker_parameters: Optional['outputs.PipeSourceActiveMqBrokerParameters'] = None,
                 dynamo_db_stream_parameters: Optional['outputs.PipeSourceDynamoDbStreamParameters'] = None,
                 filter_criteria: Optional['outputs.PipeFilterCriteria'] = None,
                 kinesis_stream_parameters: Optional['outputs.PipeSourceKinesisStreamParameters'] = None,
                 managed_streaming_kafka_parameters: Optional['outputs.PipeSourceManagedStreamingKafkaParameters'] = None,
                 rabbit_mq_broker_parameters: Optional['outputs.PipeSourceRabbitMqBrokerParameters'] = None,
                 self_managed_kafka_parameters: Optional['outputs.PipeSourceSelfManagedKafkaParameters'] = None,
                 sqs_queue_parameters: Optional['outputs.PipeSourceSqsQueueParameters'] = None):
        """
        :param 'PipeSourceActiveMqBrokerParameters' active_mq_broker_parameters: The parameters for using an Active MQ broker as a source.
        :param 'PipeSourceDynamoDbStreamParameters' dynamo_db_stream_parameters: The parameters for using a DynamoDB stream as a source.
        :param 'PipeFilterCriteria' filter_criteria: The collection of event patterns used to filter events.
               
               To remove a filter, specify a `FilterCriteria` object with an empty array of `Filter` objects.
               
               For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the *Amazon EventBridge User Guide* .
        :param 'PipeSourceKinesisStreamParameters' kinesis_stream_parameters: The parameters for using a Kinesis stream as a source.
        :param 'PipeSourceManagedStreamingKafkaParameters' managed_streaming_kafka_parameters: The parameters for using an MSK stream as a source.
        :param 'PipeSourceRabbitMqBrokerParameters' rabbit_mq_broker_parameters: The parameters for using a Rabbit MQ broker as a source.
        :param 'PipeSourceSelfManagedKafkaParameters' self_managed_kafka_parameters: The parameters for using a self-managed Apache Kafka stream as a source.
               
               A *self managed* cluster refers to any Apache Kafka cluster not hosted by AWS . This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as [Confluent Cloud](https://docs.aws.amazon.com/https://www.confluent.io/) , [CloudKarafka](https://docs.aws.amazon.com/https://www.cloudkarafka.com/) , or [Redpanda](https://docs.aws.amazon.com/https://redpanda.com/) . For more information, see [Apache Kafka streams as a source](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html) in the *Amazon EventBridge User Guide* .
        :param 'PipeSourceSqsQueueParameters' sqs_queue_parameters: The parameters for using a Amazon SQS stream as a source.
        """
        if active_mq_broker_parameters is not None:
            pulumi.set(__self__, "active_mq_broker_parameters", active_mq_broker_parameters)
        if dynamo_db_stream_parameters is not None:
            pulumi.set(__self__, "dynamo_db_stream_parameters", dynamo_db_stream_parameters)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if kinesis_stream_parameters is not None:
            pulumi.set(__self__, "kinesis_stream_parameters", kinesis_stream_parameters)
        if managed_streaming_kafka_parameters is not None:
            pulumi.set(__self__, "managed_streaming_kafka_parameters", managed_streaming_kafka_parameters)
        if rabbit_mq_broker_parameters is not None:
            pulumi.set(__self__, "rabbit_mq_broker_parameters", rabbit_mq_broker_parameters)
        if self_managed_kafka_parameters is not None:
            pulumi.set(__self__, "self_managed_kafka_parameters", self_managed_kafka_parameters)
        if sqs_queue_parameters is not None:
            pulumi.set(__self__, "sqs_queue_parameters", sqs_queue_parameters)

    @property
    @pulumi.getter(name="activeMqBrokerParameters")
    def active_mq_broker_parameters(self) -> Optional['outputs.PipeSourceActiveMqBrokerParameters']:
        """
        The parameters for using an Active MQ broker as a source.
        """
        return pulumi.get(self, "active_mq_broker_parameters")

    @property
    @pulumi.getter(name="dynamoDbStreamParameters")
    def dynamo_db_stream_parameters(self) -> Optional['outputs.PipeSourceDynamoDbStreamParameters']:
        """
        The parameters for using a DynamoDB stream as a source.
        """
        return pulumi.get(self, "dynamo_db_stream_parameters")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional['outputs.PipeFilterCriteria']:
        """
        The collection of event patterns used to filter events.

        To remove a filter, specify a `FilterCriteria` object with an empty array of `Filter` objects.

        For more information, see [Events and Event Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html) in the *Amazon EventBridge User Guide* .
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="kinesisStreamParameters")
    def kinesis_stream_parameters(self) -> Optional['outputs.PipeSourceKinesisStreamParameters']:
        """
        The parameters for using a Kinesis stream as a source.
        """
        return pulumi.get(self, "kinesis_stream_parameters")

    @property
    @pulumi.getter(name="managedStreamingKafkaParameters")
    def managed_streaming_kafka_parameters(self) -> Optional['outputs.PipeSourceManagedStreamingKafkaParameters']:
        """
        The parameters for using an MSK stream as a source.
        """
        return pulumi.get(self, "managed_streaming_kafka_parameters")

    @property
    @pulumi.getter(name="rabbitMqBrokerParameters")
    def rabbit_mq_broker_parameters(self) -> Optional['outputs.PipeSourceRabbitMqBrokerParameters']:
        """
        The parameters for using a Rabbit MQ broker as a source.
        """
        return pulumi.get(self, "rabbit_mq_broker_parameters")

    @property
    @pulumi.getter(name="selfManagedKafkaParameters")
    def self_managed_kafka_parameters(self) -> Optional['outputs.PipeSourceSelfManagedKafkaParameters']:
        """
        The parameters for using a self-managed Apache Kafka stream as a source.

        A *self managed* cluster refers to any Apache Kafka cluster not hosted by AWS . This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as [Confluent Cloud](https://docs.aws.amazon.com/https://www.confluent.io/) , [CloudKarafka](https://docs.aws.amazon.com/https://www.cloudkarafka.com/) , or [Redpanda](https://docs.aws.amazon.com/https://redpanda.com/) . For more information, see [Apache Kafka streams as a source](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html) in the *Amazon EventBridge User Guide* .
        """
        return pulumi.get(self, "self_managed_kafka_parameters")

    @property
    @pulumi.getter(name="sqsQueueParameters")
    def sqs_queue_parameters(self) -> Optional['outputs.PipeSourceSqsQueueParameters']:
        """
        The parameters for using a Amazon SQS stream as a source.
        """
        return pulumi.get(self, "sqs_queue_parameters")


@pulumi.output_type
class PipeSourceRabbitMqBrokerParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "virtualHost":
            suggest = "virtual_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceRabbitMqBrokerParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceRabbitMqBrokerParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceRabbitMqBrokerParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: 'outputs.PipeMqBrokerAccessCredentialsProperties',
                 queue_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 virtual_host: Optional[builtins.str] = None):
        """
        :param 'PipeMqBrokerAccessCredentialsProperties' credentials: The credentials needed to access the resource.
        :param builtins.str queue_name: The name of the destination queue to consume.
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        :param builtins.str virtual_host: The name of the virtual host associated with the source broker.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "queue_name", queue_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if virtual_host is not None:
            pulumi.set(__self__, "virtual_host", virtual_host)

    @property
    @pulumi.getter
    def credentials(self) -> 'outputs.PipeMqBrokerAccessCredentialsProperties':
        """
        The credentials needed to access the resource.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        The name of the destination queue to consume.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="virtualHost")
    def virtual_host(self) -> Optional[builtins.str]:
        """
        The name of the virtual host associated with the source broker.
        """
        return pulumi.get(self, "virtual_host")


@pulumi.output_type
class PipeSourceSelfManagedKafkaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicName":
            suggest = "topic_name"
        elif key == "additionalBootstrapServers":
            suggest = "additional_bootstrap_servers"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "consumerGroupId":
            suggest = "consumer_group_id"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "serverRootCaCertificate":
            suggest = "server_root_ca_certificate"
        elif key == "startingPosition":
            suggest = "starting_position"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceSelfManagedKafkaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceSelfManagedKafkaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceSelfManagedKafkaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_name: builtins.str,
                 additional_bootstrap_servers: Optional[Sequence[builtins.str]] = None,
                 batch_size: Optional[builtins.int] = None,
                 consumer_group_id: Optional[builtins.str] = None,
                 credentials: Optional[Any] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 server_root_ca_certificate: Optional[builtins.str] = None,
                 starting_position: Optional['PipeSelfManagedKafkaStartPosition'] = None,
                 vpc: Optional['outputs.PipeSelfManagedKafkaAccessConfigurationVpc'] = None):
        """
        :param builtins.str topic_name: The name of the topic that the pipe will read from.
        :param Sequence[builtins.str] additional_bootstrap_servers: An array of server URLs.
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param builtins.str consumer_group_id: The name of the destination queue to consume.
        :param Union['PipeSelfManagedKafkaAccessConfigurationCredentials0Properties', 'PipeSelfManagedKafkaAccessConfigurationCredentials1Properties', 'PipeSelfManagedKafkaAccessConfigurationCredentials2Properties', 'PipeSelfManagedKafkaAccessConfigurationCredentials3Properties'] credentials: The credentials needed to access the resource.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        :param builtins.str server_root_ca_certificate: Optional SecretManager ARN which stores the database credentials
        :param 'PipeSelfManagedKafkaStartPosition' starting_position: The position in a stream from which to start reading.
        :param 'PipeSelfManagedKafkaAccessConfigurationVpc' vpc: This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
        """
        pulumi.set(__self__, "topic_name", topic_name)
        if additional_bootstrap_servers is not None:
            pulumi.set(__self__, "additional_bootstrap_servers", additional_bootstrap_servers)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if server_root_ca_certificate is not None:
            pulumi.set(__self__, "server_root_ca_certificate", server_root_ca_certificate)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> builtins.str:
        """
        The name of the topic that the pipe will read from.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="additionalBootstrapServers")
    def additional_bootstrap_servers(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of server URLs.
        """
        return pulumi.get(self, "additional_bootstrap_servers")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        The name of the destination queue to consume.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[Any]:
        """
        The credentials needed to access the resource.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="serverRootCaCertificate")
    def server_root_ca_certificate(self) -> Optional[builtins.str]:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "server_root_ca_certificate")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional['PipeSelfManagedKafkaStartPosition']:
        """
        The position in a stream from which to start reading.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter
    def vpc(self) -> Optional['outputs.PipeSelfManagedKafkaAccessConfigurationVpc']:
        """
        This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class PipeSourceSqsQueueParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceSqsQueueParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceSqsQueueParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceSqsQueueParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int batch_size: The maximum number of records to include in each batch.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")


@pulumi.output_type
class PipeTag(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the key-value pair.
        :param builtins.str value: The value of the key-value pair.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetBatchJobParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobDefinition":
            suggest = "job_definition"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "arrayProperties":
            suggest = "array_properties"
        elif key == "containerOverrides":
            suggest = "container_overrides"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "retryStrategy":
            suggest = "retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetBatchJobParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetBatchJobParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetBatchJobParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_definition: builtins.str,
                 job_name: builtins.str,
                 array_properties: Optional['outputs.PipeBatchArrayProperties'] = None,
                 container_overrides: Optional['outputs.PipeBatchContainerOverrides'] = None,
                 depends_on: Optional[Sequence['outputs.PipeBatchJobDependency']] = None,
                 parameters: Optional[Mapping[str, builtins.str]] = None,
                 retry_strategy: Optional['outputs.PipeBatchRetryStrategy'] = None):
        """
        :param builtins.str job_definition: The job definition used by this job. This value can be one of `name` , `name:revision` , or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
        :param builtins.str job_name: The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param 'PipeBatchArrayProperties' array_properties: The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        :param 'PipeBatchContainerOverrides' container_overrides: The overrides that are sent to a container.
        :param Sequence['PipeBatchJobDependency'] depends_on: A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a `SEQUENTIAL` type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an `N_TO_N` type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
        :param Mapping[str, builtins.str] parameters: Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.
        :param 'PipeBatchRetryStrategy' retry_strategy: The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_properties is not None:
            pulumi.set(__self__, "array_properties", array_properties)
        if container_overrides is not None:
            pulumi.set(__self__, "container_overrides", container_overrides)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> builtins.str:
        """
        The job definition used by this job. This value can be one of `name` , `name:revision` , or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
        """
        return pulumi.get(self, "job_definition")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> builtins.str:
        """
        The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="arrayProperties")
    def array_properties(self) -> Optional['outputs.PipeBatchArrayProperties']:
        """
        The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        """
        return pulumi.get(self, "array_properties")

    @property
    @pulumi.getter(name="containerOverrides")
    def container_overrides(self) -> Optional['outputs.PipeBatchContainerOverrides']:
        """
        The overrides that are sent to a container.
        """
        return pulumi.get(self, "container_overrides")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.PipeBatchJobDependency']]:
        """
        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a `SEQUENTIAL` type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an `N_TO_N` type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional['outputs.PipeBatchRetryStrategy']:
        """
        The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
        """
        return pulumi.get(self, "retry_strategy")


@pulumi.output_type
class PipeTargetCloudWatchLogsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreamName":
            suggest = "log_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetCloudWatchLogsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetCloudWatchLogsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetCloudWatchLogsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_stream_name: Optional[builtins.str] = None,
                 timestamp: Optional[builtins.str] = None):
        """
        :param builtins.str log_stream_name: The name of the log stream.
        :param builtins.str timestamp: A [dynamic path parameter](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html) to a field in the payload containing the time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
               
               The value cannot be a static timestamp as the provided timestamp would be applied to all events delivered by the Pipe, regardless of when they are actually delivered.
               
               If no dynamic path parameter is provided, the default value is the time the invocation is processed by the Pipe.
        """
        if log_stream_name is not None:
            pulumi.set(__self__, "log_stream_name", log_stream_name)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> Optional[builtins.str]:
        """
        The name of the log stream.
        """
        return pulumi.get(self, "log_stream_name")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[builtins.str]:
        """
        A [dynamic path parameter](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html) to a field in the payload containing the time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.

        The value cannot be a static timestamp as the provided timestamp would be applied to all events delivered by the Pipe, regardless of when they are actually delivered.

        If no dynamic path parameter is provided, the default value is the time the invocation is processed by the Pipe.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class PipeTargetEcsTaskParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategy":
            suggest = "capacity_provider_strategy"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategy":
            suggest = "placement_strategy"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetEcsTaskParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetEcsTaskParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetEcsTaskParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: builtins.str,
                 capacity_provider_strategy: Optional[Sequence['outputs.PipeCapacityProviderStrategyItem']] = None,
                 enable_ecs_managed_tags: Optional[builtins.bool] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 group: Optional[builtins.str] = None,
                 launch_type: Optional['PipeLaunchType'] = None,
                 network_configuration: Optional['outputs.PipeNetworkConfiguration'] = None,
                 overrides: Optional['outputs.PipeEcsTaskOverride'] = None,
                 placement_constraints: Optional[Sequence['outputs.PipePlacementConstraint']] = None,
                 placement_strategy: Optional[Sequence['outputs.PipePlacementStrategy']] = None,
                 platform_version: Optional[builtins.str] = None,
                 propagate_tags: Optional['PipePropagateTags'] = None,
                 reference_id: Optional[builtins.str] = None,
                 tags: Optional[Sequence['outputs.PipeTag']] = None,
                 task_count: Optional[builtins.int] = None):
        """
        :param builtins.str task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param Sequence['PipeCapacityProviderStrategyItem'] capacity_provider_strategy: The capacity provider strategy to use for the task.
               
               If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        :param builtins.bool enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param builtins.str group: Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
        :param 'PipeLaunchType' launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'PipeNetworkConfiguration' network_configuration: Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.
               
               If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        :param 'PipeEcsTaskOverride' overrides: The overrides that are associated with a task.
        :param Sequence['PipePlacementConstraint'] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        :param Sequence['PipePlacementStrategy'] placement_strategy: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param builtins.str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .
               
               This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'PipePropagateTags' propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the `TagResource` API action.
        :param builtins.str reference_id: The reference ID to use for the task.
        :param Sequence['PipeTag'] tags: The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        :param builtins.int task_count: The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategy is not None:
            pulumi.set(__self__, "placement_strategy", placement_strategy)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> builtins.str:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[Sequence['outputs.PipeCapacityProviderStrategyItem']]:
        """
        The capacity provider strategy to use for the task.

        If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional['PipeLaunchType']:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.PipeNetworkConfiguration']:
        """
        Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.

        If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def overrides(self) -> Optional['outputs.PipeEcsTaskOverride']:
        """
        The overrides that are associated with a task.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.PipePlacementConstraint']]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategy")
    def placement_strategy(self) -> Optional[Sequence['outputs.PipePlacementStrategy']]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "placement_strategy")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .

        This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional['PipePropagateTags']:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the `TagResource` API action.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[builtins.str]:
        """
        The reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.PipeTag']]:
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[builtins.int]:
        """
        The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class PipeTargetEventBridgeEventBusParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetEventBridgeEventBusParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetEventBridgeEventBusParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetEventBridgeEventBusParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_type: Optional[builtins.str] = None,
                 endpoint_id: Optional[builtins.str] = None,
                 resources: Optional[Sequence[builtins.str]] = None,
                 source: Optional[builtins.str] = None,
                 time: Optional[builtins.str] = None):
        """
        :param builtins.str detail_type: A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        :param builtins.str endpoint_id: The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is `abcde.veo` .
        :param Sequence[builtins.str] resources: AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
        :param builtins.str source: The source of the event.
        :param builtins.str time: The time stamp of the event, per [RFC3339](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339.txt) . If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
        """
        if detail_type is not None:
            pulumi.set(__self__, "detail_type", detail_type)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional[builtins.str]:
        """
        A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is `abcde.veo` .
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        The source of the event.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def time(self) -> Optional[builtins.str]:
        """
        The time stamp of the event, per [RFC3339](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339.txt) . If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class PipeTargetHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, builtins.str]] = None,
                 path_parameter_values: Optional[Sequence[builtins.str]] = None,
                 query_string_parameters: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] header_parameters: The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        :param Sequence[builtins.str] path_parameter_values: The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
        :param Mapping[str, builtins.str] query_string_parameters: The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[Sequence[builtins.str]]:
        """
        The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
        """
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class PipeTargetKinesisStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKey":
            suggest = "partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetKinesisStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetKinesisStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetKinesisStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key: builtins.str):
        """
        :param builtins.str partition_key: Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
        """
        pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> builtins.str:
        """
        Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
        """
        return pulumi.get(self, "partition_key")


@pulumi.output_type
class PipeTargetLambdaFunctionParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetLambdaFunctionParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetLambdaFunctionParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetLambdaFunctionParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invocation_type: Optional['PipeTargetInvocationType'] = None):
        """
        :param 'PipeTargetInvocationType' invocation_type: Specify whether to invoke the function synchronously or asynchronously.
               
               - `REQUEST_RESPONSE` (default) - Invoke synchronously. This corresponds to the `RequestResponse` option in the `InvocationType` parameter for the Lambda [Invoke](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) API.
               - `FIRE_AND_FORGET` - Invoke asynchronously. This corresponds to the `Event` option in the `InvocationType` parameter for the Lambda [Invoke](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) API.
               
               For more information, see [Invocation types](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation) in the *Amazon EventBridge User Guide* .
        """
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional['PipeTargetInvocationType']:
        """
        Specify whether to invoke the function synchronously or asynchronously.

        - `REQUEST_RESPONSE` (default) - Invoke synchronously. This corresponds to the `RequestResponse` option in the `InvocationType` parameter for the Lambda [Invoke](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) API.
        - `FIRE_AND_FORGET` - Invoke asynchronously. This corresponds to the `Event` option in the `InvocationType` parameter for the Lambda [Invoke](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) API.

        For more information, see [Invocation types](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation) in the *Amazon EventBridge User Guide* .
        """
        return pulumi.get(self, "invocation_type")


@pulumi.output_type
class PipeTargetParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchJobParameters":
            suggest = "batch_job_parameters"
        elif key == "cloudWatchLogsParameters":
            suggest = "cloud_watch_logs_parameters"
        elif key == "ecsTaskParameters":
            suggest = "ecs_task_parameters"
        elif key == "eventBridgeEventBusParameters":
            suggest = "event_bridge_event_bus_parameters"
        elif key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputTemplate":
            suggest = "input_template"
        elif key == "kinesisStreamParameters":
            suggest = "kinesis_stream_parameters"
        elif key == "lambdaFunctionParameters":
            suggest = "lambda_function_parameters"
        elif key == "redshiftDataParameters":
            suggest = "redshift_data_parameters"
        elif key == "sageMakerPipelineParameters":
            suggest = "sage_maker_pipeline_parameters"
        elif key == "sqsQueueParameters":
            suggest = "sqs_queue_parameters"
        elif key == "stepFunctionStateMachineParameters":
            suggest = "step_function_state_machine_parameters"
        elif key == "timestreamParameters":
            suggest = "timestream_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_job_parameters: Optional['outputs.PipeTargetBatchJobParameters'] = None,
                 cloud_watch_logs_parameters: Optional['outputs.PipeTargetCloudWatchLogsParameters'] = None,
                 ecs_task_parameters: Optional['outputs.PipeTargetEcsTaskParameters'] = None,
                 event_bridge_event_bus_parameters: Optional['outputs.PipeTargetEventBridgeEventBusParameters'] = None,
                 http_parameters: Optional['outputs.PipeTargetHttpParameters'] = None,
                 input_template: Optional[builtins.str] = None,
                 kinesis_stream_parameters: Optional['outputs.PipeTargetKinesisStreamParameters'] = None,
                 lambda_function_parameters: Optional['outputs.PipeTargetLambdaFunctionParameters'] = None,
                 redshift_data_parameters: Optional['outputs.PipeTargetRedshiftDataParameters'] = None,
                 sage_maker_pipeline_parameters: Optional['outputs.PipeTargetSageMakerPipelineParameters'] = None,
                 sqs_queue_parameters: Optional['outputs.PipeTargetSqsQueueParameters'] = None,
                 step_function_state_machine_parameters: Optional['outputs.PipeTargetStateMachineParameters'] = None,
                 timestream_parameters: Optional['outputs.PipeTargetTimestreamParameters'] = None):
        """
        :param 'PipeTargetBatchJobParameters' batch_job_parameters: The parameters for using an AWS Batch job as a target.
        :param 'PipeTargetCloudWatchLogsParameters' cloud_watch_logs_parameters: The parameters for using an CloudWatch Logs log stream as a target.
        :param 'PipeTargetEcsTaskParameters' ecs_task_parameters: The parameters for using an Amazon ECS task as a target.
        :param 'PipeTargetEventBridgeEventBusParameters' event_bridge_event_bus_parameters: The parameters for using an EventBridge event bus as a target.
        :param 'PipeTargetHttpParameters' http_parameters: These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
        :param builtins.str input_template: Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
               
               To remove an input template, specify an empty string.
        :param 'PipeTargetKinesisStreamParameters' kinesis_stream_parameters: The parameters for using a Kinesis stream as a target.
        :param 'PipeTargetLambdaFunctionParameters' lambda_function_parameters: The parameters for using a Lambda function as a target.
        :param 'PipeTargetRedshiftDataParameters' redshift_data_parameters: These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
        :param 'PipeTargetSageMakerPipelineParameters' sage_maker_pipeline_parameters: The parameters for using a SageMaker AI pipeline as a target.
        :param 'PipeTargetSqsQueueParameters' sqs_queue_parameters: The parameters for using a Amazon SQS stream as a target.
        :param 'PipeTargetStateMachineParameters' step_function_state_machine_parameters: The parameters for using a Step Functions state machine as a target.
        :param 'PipeTargetTimestreamParameters' timestream_parameters: The parameters for using a Timestream for LiveAnalytics table as a target.
        """
        if batch_job_parameters is not None:
            pulumi.set(__self__, "batch_job_parameters", batch_job_parameters)
        if cloud_watch_logs_parameters is not None:
            pulumi.set(__self__, "cloud_watch_logs_parameters", cloud_watch_logs_parameters)
        if ecs_task_parameters is not None:
            pulumi.set(__self__, "ecs_task_parameters", ecs_task_parameters)
        if event_bridge_event_bus_parameters is not None:
            pulumi.set(__self__, "event_bridge_event_bus_parameters", event_bridge_event_bus_parameters)
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input_template is not None:
            pulumi.set(__self__, "input_template", input_template)
        if kinesis_stream_parameters is not None:
            pulumi.set(__self__, "kinesis_stream_parameters", kinesis_stream_parameters)
        if lambda_function_parameters is not None:
            pulumi.set(__self__, "lambda_function_parameters", lambda_function_parameters)
        if redshift_data_parameters is not None:
            pulumi.set(__self__, "redshift_data_parameters", redshift_data_parameters)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_queue_parameters is not None:
            pulumi.set(__self__, "sqs_queue_parameters", sqs_queue_parameters)
        if step_function_state_machine_parameters is not None:
            pulumi.set(__self__, "step_function_state_machine_parameters", step_function_state_machine_parameters)
        if timestream_parameters is not None:
            pulumi.set(__self__, "timestream_parameters", timestream_parameters)

    @property
    @pulumi.getter(name="batchJobParameters")
    def batch_job_parameters(self) -> Optional['outputs.PipeTargetBatchJobParameters']:
        """
        The parameters for using an AWS Batch job as a target.
        """
        return pulumi.get(self, "batch_job_parameters")

    @property
    @pulumi.getter(name="cloudWatchLogsParameters")
    def cloud_watch_logs_parameters(self) -> Optional['outputs.PipeTargetCloudWatchLogsParameters']:
        """
        The parameters for using an CloudWatch Logs log stream as a target.
        """
        return pulumi.get(self, "cloud_watch_logs_parameters")

    @property
    @pulumi.getter(name="ecsTaskParameters")
    def ecs_task_parameters(self) -> Optional['outputs.PipeTargetEcsTaskParameters']:
        """
        The parameters for using an Amazon ECS task as a target.
        """
        return pulumi.get(self, "ecs_task_parameters")

    @property
    @pulumi.getter(name="eventBridgeEventBusParameters")
    def event_bridge_event_bus_parameters(self) -> Optional['outputs.PipeTargetEventBridgeEventBusParameters']:
        """
        The parameters for using an EventBridge event bus as a target.
        """
        return pulumi.get(self, "event_bridge_event_bus_parameters")

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.PipeTargetHttpParameters']:
        """
        These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
        """
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> Optional[builtins.str]:
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .

        To remove an input template, specify an empty string.
        """
        return pulumi.get(self, "input_template")

    @property
    @pulumi.getter(name="kinesisStreamParameters")
    def kinesis_stream_parameters(self) -> Optional['outputs.PipeTargetKinesisStreamParameters']:
        """
        The parameters for using a Kinesis stream as a target.
        """
        return pulumi.get(self, "kinesis_stream_parameters")

    @property
    @pulumi.getter(name="lambdaFunctionParameters")
    def lambda_function_parameters(self) -> Optional['outputs.PipeTargetLambdaFunctionParameters']:
        """
        The parameters for using a Lambda function as a target.
        """
        return pulumi.get(self, "lambda_function_parameters")

    @property
    @pulumi.getter(name="redshiftDataParameters")
    def redshift_data_parameters(self) -> Optional['outputs.PipeTargetRedshiftDataParameters']:
        """
        These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
        """
        return pulumi.get(self, "redshift_data_parameters")

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional['outputs.PipeTargetSageMakerPipelineParameters']:
        """
        The parameters for using a SageMaker AI pipeline as a target.
        """
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsQueueParameters")
    def sqs_queue_parameters(self) -> Optional['outputs.PipeTargetSqsQueueParameters']:
        """
        The parameters for using a Amazon SQS stream as a target.
        """
        return pulumi.get(self, "sqs_queue_parameters")

    @property
    @pulumi.getter(name="stepFunctionStateMachineParameters")
    def step_function_state_machine_parameters(self) -> Optional['outputs.PipeTargetStateMachineParameters']:
        """
        The parameters for using a Step Functions state machine as a target.
        """
        return pulumi.get(self, "step_function_state_machine_parameters")

    @property
    @pulumi.getter(name="timestreamParameters")
    def timestream_parameters(self) -> Optional['outputs.PipeTargetTimestreamParameters']:
        """
        The parameters for using a Timestream for LiveAnalytics table as a target.
        """
        return pulumi.get(self, "timestream_parameters")


@pulumi.output_type
class PipeTargetRedshiftDataParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbUser":
            suggest = "db_user"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "statementName":
            suggest = "statement_name"
        elif key == "withEvent":
            suggest = "with_event"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetRedshiftDataParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetRedshiftDataParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetRedshiftDataParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: builtins.str,
                 sqls: Sequence[builtins.str],
                 db_user: Optional[builtins.str] = None,
                 secret_manager_arn: Optional[builtins.str] = None,
                 statement_name: Optional[builtins.str] = None,
                 with_event: Optional[builtins.bool] = None):
        """
        :param builtins.str database: Redshift Database
        :param Sequence[builtins.str] sqls: A list of SQLs.
        :param builtins.str db_user: Database user name
        :param builtins.str secret_manager_arn: Optional SecretManager ARN which stores the database credentials
        :param builtins.str statement_name: A name for Redshift DataAPI statement which can be used as filter of ListStatement.
        :param builtins.bool with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "sqls", sqls)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secret_manager_arn is not None:
            pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> builtins.str:
        """
        Redshift Database
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def sqls(self) -> Sequence[builtins.str]:
        """
        A list of SQLs.
        """
        return pulumi.get(self, "sqls")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[builtins.str]:
        """
        Database user name
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> Optional[builtins.str]:
        """
        Optional SecretManager ARN which stores the database credentials
        """
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[builtins.str]:
        """
        A name for Redshift DataAPI statement which can be used as filter of ListStatement.
        """
        return pulumi.get(self, "statement_name")

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[builtins.bool]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")


@pulumi.output_type
class PipeTargetSageMakerPipelineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameterList":
            suggest = "pipeline_parameter_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetSageMakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetSageMakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetSageMakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[Sequence['outputs.PipeSageMakerPipelineParameter']] = None):
        """
        :param Sequence['PipeSageMakerPipelineParameter'] pipeline_parameter_list: List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[Sequence['outputs.PipeSageMakerPipelineParameter']]:
        """
        List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_list")


@pulumi.output_type
class PipeTargetSqsQueueParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageDeduplicationId":
            suggest = "message_deduplication_id"
        elif key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetSqsQueueParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetSqsQueueParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetSqsQueueParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_deduplication_id: Optional[builtins.str] = None,
                 message_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str message_deduplication_id: This parameter applies only to FIFO (first-in-first-out) queues.
               
               The token used for deduplication of sent messages.
        :param builtins.str message_group_id: The FIFO message group ID to use as the target.
        """
        if message_deduplication_id is not None:
            pulumi.set(__self__, "message_deduplication_id", message_deduplication_id)
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageDeduplicationId")
    def message_deduplication_id(self) -> Optional[builtins.str]:
        """
        This parameter applies only to FIFO (first-in-first-out) queues.

        The token used for deduplication of sent messages.
        """
        return pulumi.get(self, "message_deduplication_id")

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[builtins.str]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class PipeTargetStateMachineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetStateMachineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetStateMachineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetStateMachineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invocation_type: Optional['PipeTargetInvocationType'] = None):
        """
        :param 'PipeTargetInvocationType' invocation_type: Specify whether to invoke the Step Functions state machine synchronously or asynchronously.
               
               - `REQUEST_RESPONSE` (default) - Invoke synchronously. For more information, see [StartSyncExecution](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html) in the *AWS Step Functions API Reference* .
               
               > `REQUEST_RESPONSE` is not supported for `STANDARD` state machine workflows.
               - `FIRE_AND_FORGET` - Invoke asynchronously. For more information, see [StartExecution](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html) in the *AWS Step Functions API Reference* .
               
               For more information, see [Invocation types](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation) in the *Amazon EventBridge User Guide* .
        """
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional['PipeTargetInvocationType']:
        """
        Specify whether to invoke the Step Functions state machine synchronously or asynchronously.

        - `REQUEST_RESPONSE` (default) - Invoke synchronously. For more information, see [StartSyncExecution](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html) in the *AWS Step Functions API Reference* .

        > `REQUEST_RESPONSE` is not supported for `STANDARD` state machine workflows.
        - `FIRE_AND_FORGET` - Invoke asynchronously. For more information, see [StartExecution](https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html) in the *AWS Step Functions API Reference* .

        For more information, see [Invocation types](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation) in the *Amazon EventBridge User Guide* .
        """
        return pulumi.get(self, "invocation_type")


@pulumi.output_type
class PipeTargetTimestreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionMappings":
            suggest = "dimension_mappings"
        elif key == "timeValue":
            suggest = "time_value"
        elif key == "versionValue":
            suggest = "version_value"
        elif key == "epochTimeUnit":
            suggest = "epoch_time_unit"
        elif key == "multiMeasureMappings":
            suggest = "multi_measure_mappings"
        elif key == "singleMeasureMappings":
            suggest = "single_measure_mappings"
        elif key == "timeFieldType":
            suggest = "time_field_type"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetTimestreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetTimestreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetTimestreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_mappings: Sequence['outputs.PipeDimensionMapping'],
                 time_value: builtins.str,
                 version_value: builtins.str,
                 epoch_time_unit: Optional['PipeEpochTimeUnit'] = None,
                 multi_measure_mappings: Optional[Sequence['outputs.PipeMultiMeasureMapping']] = None,
                 single_measure_mappings: Optional[Sequence['outputs.PipeSingleMeasureMapping']] = None,
                 time_field_type: Optional['PipeTimeFieldType'] = None,
                 timestamp_format: Optional[builtins.str] = None):
        """
        :param Sequence['PipeDimensionMapping'] dimension_mappings: Map source data to dimensions in the target Timestream for LiveAnalytics table.
               
               For more information, see [Amazon Timestream for LiveAnalytics concepts](https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
        :param builtins.str time_value: Dynamic path to the source data field that represents the time value for your data.
        :param builtins.str version_value: 64 bit version value or source data field that represents the version value for your data.
               
               Write requests with a higher version number will update the existing measure values of the record and version. In cases where the measure value is the same, the version will still be updated.
               
               Default value is 1.
               
               Timestream for LiveAnalytics does not support updating partial measure values in a record.
               
               Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, `Version` will still be updated. Default value is `1` .
               
               > `Version` must be `1` or greater, or you will receive a `ValidationException` error.
        :param 'PipeEpochTimeUnit' epoch_time_unit: The granularity of the time units used. Default is `MILLISECONDS` .
               
               Required if `TimeFieldType` is specified as `EPOCH` .
        :param Sequence['PipeMultiMeasureMapping'] multi_measure_mappings: Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics table.
        :param Sequence['PipeSingleMeasureMapping'] single_measure_mappings: Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics table.
        :param 'PipeTimeFieldType' time_field_type: The type of time value used.
               
               The default is `EPOCH` .
        :param builtins.str timestamp_format: How to format the timestamps. For example, `yyyy-MM-dd'T'HH:mm:ss'Z'` .
               
               Required if `TimeFieldType` is specified as `TIMESTAMP_FORMAT` .
        """
        pulumi.set(__self__, "dimension_mappings", dimension_mappings)
        pulumi.set(__self__, "time_value", time_value)
        pulumi.set(__self__, "version_value", version_value)
        if epoch_time_unit is not None:
            pulumi.set(__self__, "epoch_time_unit", epoch_time_unit)
        if multi_measure_mappings is not None:
            pulumi.set(__self__, "multi_measure_mappings", multi_measure_mappings)
        if single_measure_mappings is not None:
            pulumi.set(__self__, "single_measure_mappings", single_measure_mappings)
        if time_field_type is not None:
            pulumi.set(__self__, "time_field_type", time_field_type)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="dimensionMappings")
    def dimension_mappings(self) -> Sequence['outputs.PipeDimensionMapping']:
        """
        Map source data to dimensions in the target Timestream for LiveAnalytics table.

        For more information, see [Amazon Timestream for LiveAnalytics concepts](https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
        """
        return pulumi.get(self, "dimension_mappings")

    @property
    @pulumi.getter(name="timeValue")
    def time_value(self) -> builtins.str:
        """
        Dynamic path to the source data field that represents the time value for your data.
        """
        return pulumi.get(self, "time_value")

    @property
    @pulumi.getter(name="versionValue")
    def version_value(self) -> builtins.str:
        """
        64 bit version value or source data field that represents the version value for your data.

        Write requests with a higher version number will update the existing measure values of the record and version. In cases where the measure value is the same, the version will still be updated.

        Default value is 1.

        Timestream for LiveAnalytics does not support updating partial measure values in a record.

        Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, `Version` will still be updated. Default value is `1` .

        > `Version` must be `1` or greater, or you will receive a `ValidationException` error.
        """
        return pulumi.get(self, "version_value")

    @property
    @pulumi.getter(name="epochTimeUnit")
    def epoch_time_unit(self) -> Optional['PipeEpochTimeUnit']:
        """
        The granularity of the time units used. Default is `MILLISECONDS` .

        Required if `TimeFieldType` is specified as `EPOCH` .
        """
        return pulumi.get(self, "epoch_time_unit")

    @property
    @pulumi.getter(name="multiMeasureMappings")
    def multi_measure_mappings(self) -> Optional[Sequence['outputs.PipeMultiMeasureMapping']]:
        """
        Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics table.
        """
        return pulumi.get(self, "multi_measure_mappings")

    @property
    @pulumi.getter(name="singleMeasureMappings")
    def single_measure_mappings(self) -> Optional[Sequence['outputs.PipeSingleMeasureMapping']]:
        """
        Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics table.
        """
        return pulumi.get(self, "single_measure_mappings")

    @property
    @pulumi.getter(name="timeFieldType")
    def time_field_type(self) -> Optional['PipeTimeFieldType']:
        """
        The type of time value used.

        The default is `EPOCH` .
        """
        return pulumi.get(self, "time_field_type")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[builtins.str]:
        """
        How to format the timestamps. For example, `yyyy-MM-dd'T'HH:mm:ss'Z'` .

        Required if `TimeFieldType` is specified as `TIMESTAMP_FORMAT` .
        """
        return pulumi.get(self, "timestamp_format")


