# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetPipeResult',
    'AwaitableGetPipeResult',
    'get_pipe',
    'get_pipe_output',
]

@pulumi.output_type
class GetPipeResult:
    def __init__(__self__, arn=None, creation_time=None, current_state=None, description=None, desired_state=None, enrichment=None, enrichment_parameters=None, kms_key_identifier=None, last_modified_time=None, log_configuration=None, role_arn=None, state_reason=None, tags=None, target=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if current_state and not isinstance(current_state, str):
            raise TypeError("Expected argument 'current_state' to be a str")
        pulumi.set(__self__, "current_state", current_state)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if desired_state and not isinstance(desired_state, str):
            raise TypeError("Expected argument 'desired_state' to be a str")
        pulumi.set(__self__, "desired_state", desired_state)
        if enrichment and not isinstance(enrichment, str):
            raise TypeError("Expected argument 'enrichment' to be a str")
        pulumi.set(__self__, "enrichment", enrichment)
        if enrichment_parameters and not isinstance(enrichment_parameters, dict):
            raise TypeError("Expected argument 'enrichment_parameters' to be a dict")
        pulumi.set(__self__, "enrichment_parameters", enrichment_parameters)
        if kms_key_identifier and not isinstance(kms_key_identifier, str):
            raise TypeError("Expected argument 'kms_key_identifier' to be a str")
        pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if log_configuration and not isinstance(log_configuration, dict):
            raise TypeError("Expected argument 'log_configuration' to be a dict")
        pulumi.set(__self__, "log_configuration", log_configuration)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if state_reason and not isinstance(state_reason, str):
            raise TypeError("Expected argument 'state_reason' to be a str")
        pulumi.set(__self__, "state_reason", state_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the pipe.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        The time the pipe was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional['PipeState']:
        """
        The state the pipe is in.
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the pipe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional['PipeRequestedPipeState']:
        """
        The state the pipe should be in.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def enrichment(self) -> Optional[builtins.str]:
        """
        The ARN of the enrichment resource.
        """
        return pulumi.get(self, "enrichment")

    @property
    @pulumi.getter(name="enrichmentParameters")
    def enrichment_parameters(self) -> Optional['outputs.PipeEnrichmentParameters']:
        """
        The parameters required to set up enrichment on your pipe.
        """
        return pulumi.get(self, "enrichment_parameters")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[builtins.str]:
        """
        The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.

        To update a pipe that is using the default AWS owned key to use a customer managed key instead, or update a pipe that is using a customer managed key to use a different customer managed key, specify a customer managed key identifier.

        To update a pipe that is using a customer managed key to use the default AWS owned key , specify an empty string.

        For more information, see [Managing keys](https://docs.aws.amazon.com/kms/latest/developerguide/getting-started.html) in the *AWS Key Management Service Developer Guide* .
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        When the pipe was last updated, in [ISO-8601 format](https://docs.aws.amazon.com/https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.PipeLogConfiguration']:
        """
        The logging configuration settings for the pipe.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role that allows the pipe to send data to the target.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[builtins.str]:
        """
        The reason the pipe is in its current state.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The list of key-value pairs to associate with the pipe.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The ARN of the target resource.
        """
        return pulumi.get(self, "target")


class AwaitableGetPipeResult(GetPipeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipeResult(
            arn=self.arn,
            creation_time=self.creation_time,
            current_state=self.current_state,
            description=self.description,
            desired_state=self.desired_state,
            enrichment=self.enrichment,
            enrichment_parameters=self.enrichment_parameters,
            kms_key_identifier=self.kms_key_identifier,
            last_modified_time=self.last_modified_time,
            log_configuration=self.log_configuration,
            role_arn=self.role_arn,
            state_reason=self.state_reason,
            tags=self.tags,
            target=self.target)


def get_pipe(name: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipeResult:
    """
    Definition of AWS::Pipes::Pipe Resource Type


    :param builtins.str name: The name of the pipe.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:pipes:getPipe', __args__, opts=opts, typ=GetPipeResult).value

    return AwaitableGetPipeResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        current_state=pulumi.get(__ret__, 'current_state'),
        description=pulumi.get(__ret__, 'description'),
        desired_state=pulumi.get(__ret__, 'desired_state'),
        enrichment=pulumi.get(__ret__, 'enrichment'),
        enrichment_parameters=pulumi.get(__ret__, 'enrichment_parameters'),
        kms_key_identifier=pulumi.get(__ret__, 'kms_key_identifier'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        log_configuration=pulumi.get(__ret__, 'log_configuration'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        state_reason=pulumi.get(__ret__, 'state_reason'),
        tags=pulumi.get(__ret__, 'tags'),
        target=pulumi.get(__ret__, 'target'))
def get_pipe_output(name: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipeResult]:
    """
    Definition of AWS::Pipes::Pipe Resource Type


    :param builtins.str name: The name of the pipe.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:pipes:getPipe', __args__, opts=opts, typ=GetPipeResult)
    return __ret__.apply(lambda __response__: GetPipeResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        current_state=pulumi.get(__response__, 'current_state'),
        description=pulumi.get(__response__, 'description'),
        desired_state=pulumi.get(__response__, 'desired_state'),
        enrichment=pulumi.get(__response__, 'enrichment'),
        enrichment_parameters=pulumi.get(__response__, 'enrichment_parameters'),
        kms_key_identifier=pulumi.get(__response__, 'kms_key_identifier'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        log_configuration=pulumi.get(__response__, 'log_configuration'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        state_reason=pulumi.get(__response__, 'state_reason'),
        tags=pulumi.get(__response__, 'tags'),
        target=pulumi.get(__response__, 'target')))
