# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SolutionArgs', 'Solution']

@pulumi.input_type
class SolutionArgs:
    def __init__(__self__, *,
                 dataset_group_arn: pulumi.Input[builtins.str],
                 event_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perform_auto_ml: Optional[pulumi.Input[builtins.bool]] = None,
                 perform_hpo: Optional[pulumi.Input[builtins.bool]] = None,
                 recipe_arn: Optional[pulumi.Input[builtins.str]] = None,
                 solution_config: Optional[pulumi.Input['SolutionConfigArgs']] = None):
        """
        The set of arguments for constructing a Solution resource.
        :param pulumi.Input[builtins.str] dataset_group_arn: The ARN of the dataset group that provides the training data.
        :param pulumi.Input[builtins.str] event_type: When your have multiple event types (using an EVENT_TYPE schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model. If you do not provide an eventType, Amazon Personalize will use all interactions for training with equal weight regardless of type.
        :param pulumi.Input[builtins.str] name: The name for the solution
        :param pulumi.Input[builtins.bool] perform_auto_ml: Whether to perform automated machine learning (AutoML). The default is false. For this case, you must specify recipeArn.
        :param pulumi.Input[builtins.bool] perform_hpo: Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is false. When performing AutoML, this parameter is always true and you should not set it to false.
        :param pulumi.Input[builtins.str] recipe_arn: The ARN of the recipe to use for model training. Only specified when performAutoML is false.
        :param pulumi.Input['SolutionConfigArgs'] solution_config: Describes the configuration properties for the solution.
        """
        pulumi.set(__self__, "dataset_group_arn", dataset_group_arn)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if perform_auto_ml is not None:
            pulumi.set(__self__, "perform_auto_ml", perform_auto_ml)
        if perform_hpo is not None:
            pulumi.set(__self__, "perform_hpo", perform_hpo)
        if recipe_arn is not None:
            pulumi.set(__self__, "recipe_arn", recipe_arn)
        if solution_config is not None:
            pulumi.set(__self__, "solution_config", solution_config)

    @property
    @pulumi.getter(name="datasetGroupArn")
    def dataset_group_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the dataset group that provides the training data.
        """
        return pulumi.get(self, "dataset_group_arn")

    @dataset_group_arn.setter
    def dataset_group_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_group_arn", value)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When your have multiple event types (using an EVENT_TYPE schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model. If you do not provide an eventType, Amazon Personalize will use all interactions for training with equal weight regardless of type.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the solution
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performAutoMl")
    def perform_auto_ml(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to perform automated machine learning (AutoML). The default is false. For this case, you must specify recipeArn.
        """
        return pulumi.get(self, "perform_auto_ml")

    @perform_auto_ml.setter
    def perform_auto_ml(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "perform_auto_ml", value)

    @property
    @pulumi.getter(name="performHpo")
    def perform_hpo(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is false. When performing AutoML, this parameter is always true and you should not set it to false.
        """
        return pulumi.get(self, "perform_hpo")

    @perform_hpo.setter
    def perform_hpo(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "perform_hpo", value)

    @property
    @pulumi.getter(name="recipeArn")
    def recipe_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the recipe to use for model training. Only specified when performAutoML is false.
        """
        return pulumi.get(self, "recipe_arn")

    @recipe_arn.setter
    def recipe_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recipe_arn", value)

    @property
    @pulumi.getter(name="solutionConfig")
    def solution_config(self) -> Optional[pulumi.Input['SolutionConfigArgs']]:
        """
        Describes the configuration properties for the solution.
        """
        return pulumi.get(self, "solution_config")

    @solution_config.setter
    def solution_config(self, value: Optional[pulumi.Input['SolutionConfigArgs']]):
        pulumi.set(self, "solution_config", value)


@pulumi.type_token("aws-native:personalize:Solution")
class Solution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 event_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perform_auto_ml: Optional[pulumi.Input[builtins.bool]] = None,
                 perform_hpo: Optional[pulumi.Input[builtins.bool]] = None,
                 recipe_arn: Optional[pulumi.Input[builtins.str]] = None,
                 solution_config: Optional[pulumi.Input[Union['SolutionConfigArgs', 'SolutionConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource schema for AWS::Personalize::Solution.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_solution = aws_native.personalize.Solution("mySolution",
            name="my-solution-name",
            dataset_group_arn="arn:aws:personalize:us-west-2:123456789012:dataset-group/my-dataset-group-name",
            recipe_arn="arn:aws:personalize:::recipe/aws-user-personalization",
            solution_config={
                "event_value_threshold": ".05",
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_solution = aws_native.personalize.Solution("mySolution",
            name="my-solution-name",
            dataset_group_arn="arn:aws:personalize:us-west-2:123456789012:dataset-group/my-dataset-group-name",
            recipe_arn="arn:aws:personalize:::recipe/aws-user-personalization",
            solution_config={
                "event_value_threshold": ".05",
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dataset_group_arn: The ARN of the dataset group that provides the training data.
        :param pulumi.Input[builtins.str] event_type: When your have multiple event types (using an EVENT_TYPE schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model. If you do not provide an eventType, Amazon Personalize will use all interactions for training with equal weight regardless of type.
        :param pulumi.Input[builtins.str] name: The name for the solution
        :param pulumi.Input[builtins.bool] perform_auto_ml: Whether to perform automated machine learning (AutoML). The default is false. For this case, you must specify recipeArn.
        :param pulumi.Input[builtins.bool] perform_hpo: Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is false. When performing AutoML, this parameter is always true and you should not set it to false.
        :param pulumi.Input[builtins.str] recipe_arn: The ARN of the recipe to use for model training. Only specified when performAutoML is false.
        :param pulumi.Input[Union['SolutionConfigArgs', 'SolutionConfigArgsDict']] solution_config: Describes the configuration properties for the solution.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SolutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::Personalize::Solution.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_solution = aws_native.personalize.Solution("mySolution",
            name="my-solution-name",
            dataset_group_arn="arn:aws:personalize:us-west-2:123456789012:dataset-group/my-dataset-group-name",
            recipe_arn="arn:aws:personalize:::recipe/aws-user-personalization",
            solution_config={
                "event_value_threshold": ".05",
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_solution = aws_native.personalize.Solution("mySolution",
            name="my-solution-name",
            dataset_group_arn="arn:aws:personalize:us-west-2:123456789012:dataset-group/my-dataset-group-name",
            recipe_arn="arn:aws:personalize:::recipe/aws-user-personalization",
            solution_config={
                "event_value_threshold": ".05",
            })

        ```

        :param str resource_name: The name of the resource.
        :param SolutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SolutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 event_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 perform_auto_ml: Optional[pulumi.Input[builtins.bool]] = None,
                 perform_hpo: Optional[pulumi.Input[builtins.bool]] = None,
                 recipe_arn: Optional[pulumi.Input[builtins.str]] = None,
                 solution_config: Optional[pulumi.Input[Union['SolutionConfigArgs', 'SolutionConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SolutionArgs.__new__(SolutionArgs)

            if dataset_group_arn is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_group_arn'")
            __props__.__dict__["dataset_group_arn"] = dataset_group_arn
            __props__.__dict__["event_type"] = event_type
            __props__.__dict__["name"] = name
            __props__.__dict__["perform_auto_ml"] = perform_auto_ml
            __props__.__dict__["perform_hpo"] = perform_hpo
            __props__.__dict__["recipe_arn"] = recipe_arn
            __props__.__dict__["solution_config"] = solution_config
            __props__.__dict__["solution_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["datasetGroupArn", "eventType", "name", "performAutoMl", "performHpo", "recipeArn", "solutionConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Solution, __self__).__init__(
            'aws-native:personalize:Solution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Solution':
        """
        Get an existing Solution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SolutionArgs.__new__(SolutionArgs)

        __props__.__dict__["dataset_group_arn"] = None
        __props__.__dict__["event_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["perform_auto_ml"] = None
        __props__.__dict__["perform_hpo"] = None
        __props__.__dict__["recipe_arn"] = None
        __props__.__dict__["solution_arn"] = None
        __props__.__dict__["solution_config"] = None
        return Solution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datasetGroupArn")
    def dataset_group_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the dataset group that provides the training data.
        """
        return pulumi.get(self, "dataset_group_arn")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        When your have multiple event types (using an EVENT_TYPE schema field), this parameter specifies which event type (for example, 'click' or 'like') is used for training the model. If you do not provide an eventType, Amazon Personalize will use all interactions for training with equal weight regardless of type.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the solution
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performAutoMl")
    def perform_auto_ml(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to perform automated machine learning (AutoML). The default is false. For this case, you must specify recipeArn.
        """
        return pulumi.get(self, "perform_auto_ml")

    @property
    @pulumi.getter(name="performHpo")
    def perform_hpo(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is false. When performing AutoML, this parameter is always true and you should not set it to false.
        """
        return pulumi.get(self, "perform_hpo")

    @property
    @pulumi.getter(name="recipeArn")
    def recipe_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the recipe to use for model training. Only specified when performAutoML is false.
        """
        return pulumi.get(self, "recipe_arn")

    @property
    @pulumi.getter(name="solutionArn")
    def solution_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the solution.
        """
        return pulumi.get(self, "solution_arn")

    @property
    @pulumi.getter(name="solutionConfig")
    def solution_config(self) -> pulumi.Output[Optional['outputs.SolutionConfig']]:
        """
        Describes the configuration properties for the solution.
        """
        return pulumi.get(self, "solution_config")

