# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['SchemaArgs', 'Schema']

@pulumi.input_type
class SchemaArgs:
    def __init__(__self__, *,
                 schema: pulumi.Input[builtins.str],
                 domain: Optional[pulumi.Input['SchemaDomain']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Schema resource.
        :param pulumi.Input[builtins.str] schema: A schema in Avro JSON format.
        :param pulumi.Input['SchemaDomain'] domain: The domain of a Domain dataset group.
        :param pulumi.Input[builtins.str] name: Name for the schema.
        """
        pulumi.set(__self__, "schema", schema)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input[builtins.str]:
        """
        A schema in Avro JSON format.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input['SchemaDomain']]:
        """
        The domain of a Domain dataset group.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input['SchemaDomain']]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for the schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("aws-native:personalize:Schema")
class Schema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input['SchemaDomain']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::Personalize::Schema.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_schema = aws_native.personalize.Schema("mySchema",
            name="my-schema-name",
            schema="{\\"type\\": \\"record\\",\\"name\\": \\"Interactions\\", \\"namespace\\": \\"com.amazonaws.personalize.schema\\", \\"fields\\": [ { \\"name\\": \\"USER_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"ITEM_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"TIMESTAMP\\", \\"type\\": \\"long\\"}], \\"version\\": \\"1.0\\"}")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_schema = aws_native.personalize.Schema("mySchema",
            name="my-schema-name",
            schema="{\\"type\\": \\"record\\",\\"name\\": \\"Interactions\\", \\"namespace\\": \\"com.amazonaws.personalize.schema\\", \\"fields\\": [ { \\"name\\": \\"USER_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"ITEM_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"TIMESTAMP\\", \\"type\\": \\"long\\"}], \\"version\\": \\"1.0\\"}")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['SchemaDomain'] domain: The domain of a Domain dataset group.
        :param pulumi.Input[builtins.str] name: Name for the schema.
        :param pulumi.Input[builtins.str] schema: A schema in Avro JSON format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::Personalize::Schema.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_schema = aws_native.personalize.Schema("mySchema",
            name="my-schema-name",
            schema="{\\"type\\": \\"record\\",\\"name\\": \\"Interactions\\", \\"namespace\\": \\"com.amazonaws.personalize.schema\\", \\"fields\\": [ { \\"name\\": \\"USER_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"ITEM_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"TIMESTAMP\\", \\"type\\": \\"long\\"}], \\"version\\": \\"1.0\\"}")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_schema = aws_native.personalize.Schema("mySchema",
            name="my-schema-name",
            schema="{\\"type\\": \\"record\\",\\"name\\": \\"Interactions\\", \\"namespace\\": \\"com.amazonaws.personalize.schema\\", \\"fields\\": [ { \\"name\\": \\"USER_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"ITEM_ID\\", \\"type\\": \\"string\\" }, { \\"name\\": \\"TIMESTAMP\\", \\"type\\": \\"long\\"}], \\"version\\": \\"1.0\\"}")

        ```

        :param str resource_name: The name of the resource.
        :param SchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input['SchemaDomain']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaArgs.__new__(SchemaArgs)

            __props__.__dict__["domain"] = domain
            __props__.__dict__["name"] = name
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["schema_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domain", "name", "schema"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Schema, __self__).__init__(
            'aws-native:personalize:Schema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Schema':
        """
        Get an existing Schema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SchemaArgs.__new__(SchemaArgs)

        __props__.__dict__["domain"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["schema_arn"] = None
        return Schema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional['SchemaDomain']]:
        """
        The domain of a Domain dataset group.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for the schema.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[builtins.str]:
        """
        A schema in Avro JSON format.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> pulumi.Output[builtins.str]:
        """
        Arn for the schema.
        """
        return pulumi.get(self, "schema_arn")

