# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[builtins.str],
                 compute_node_group_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['QueueComputeNodeGroupConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the cluster of the queue.
        :param pulumi.Input[Sequence[pulumi.Input['QueueComputeNodeGroupConfigurationArgs']]] compute_node_group_configurations: The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.
        :param pulumi.Input[builtins.str] name: The name that identifies the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compute_node_group_configurations is not None:
            pulumi.set(__self__, "compute_node_group_configurations", compute_node_group_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the cluster of the queue.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="computeNodeGroupConfigurations")
    def compute_node_group_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueComputeNodeGroupConfigurationArgs']]]]:
        """
        The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.
        """
        return pulumi.get(self, "compute_node_group_configurations")

    @compute_node_group_configurations.setter
    def compute_node_group_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueComputeNodeGroupConfigurationArgs']]]]):
        pulumi.set(self, "compute_node_group_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name that identifies the queue.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:pcs:Queue")
class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_node_group_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueComputeNodeGroupConfigurationArgs', 'QueueComputeNodeGroupConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        AWS::PCS::Queue resource creates an AWS PCS queue.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the cluster of the queue.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QueueComputeNodeGroupConfigurationArgs', 'QueueComputeNodeGroupConfigurationArgsDict']]]] compute_node_group_configurations: The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.
        :param pulumi.Input[builtins.str] name: The name that identifies the queue.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::PCS::Queue resource creates an AWS PCS queue.

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_node_group_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueComputeNodeGroupConfigurationArgs', 'QueueComputeNodeGroupConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["compute_node_group_configurations"] = compute_node_group_configurations
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["error_info"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clusterId", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Queue, __self__).__init__(
            'aws-native:pcs:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueueArgs.__new__(QueueArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["cluster_id"] = None
        __props__.__dict__["compute_node_group_configurations"] = None
        __props__.__dict__["error_info"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Queue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The unique Amazon Resource Name (ARN) of the queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The generated unique ID of the queue.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the cluster of the queue.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="computeNodeGroupConfigurations")
    def compute_node_group_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.QueueComputeNodeGroupConfiguration']]]:
        """
        The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.
        """
        return pulumi.get(self, "compute_node_group_configurations")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> pulumi.Output[Sequence['outputs.QueueErrorInfo']]:
        """
        The list of errors that occurred during queue provisioning.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name that identifies the queue.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['QueueStatus']:
        """
        The provisioning status of the queue. The provisioning status doesn't indicate the overall health of the queue.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

