# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterEndpoint',
    'ClusterErrorInfo',
    'ComputeNodeGroupErrorInfo',
    'ComputeNodeGroupInstanceConfig',
    'ComputeNodeGroupSlurmCustomSetting',
    'CustomLaunchTemplateProperties',
    'NetworkingProperties',
    'QueueComputeNodeGroupConfiguration',
    'QueueErrorInfo',
    'ScalingConfigurationProperties',
    'SchedulerProperties',
    'SlurmConfigurationProperties',
    'SpotOptionsProperties',
]

@pulumi.output_type
class ClusterEndpoint(dict):
    """
    An endpoint available for interaction with the scheduler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.str,
                 private_ip_address: builtins.str,
                 type: 'ClusterEndpointType',
                 public_ip_address: Optional[builtins.str] = None):
        """
        An endpoint available for interaction with the scheduler.
        :param builtins.str port: The endpoint's connection port number.
        :param builtins.str private_ip_address: The endpoint's private IP address.
        :param 'ClusterEndpointType' type: Indicates the type of endpoint running at the specific IP address.
        :param builtins.str public_ip_address: The endpoint's public IP address.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "type", type)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The endpoint's connection port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> builtins.str:
        """
        The endpoint's private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def type(self) -> 'ClusterEndpointType':
        """
        Indicates the type of endpoint running at the specific IP address.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[builtins.str]:
        """
        The endpoint's public IP address.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class ClusterErrorInfo(dict):
    """
    An error that occurred during resource provisioning.
    """
    def __init__(__self__, *,
                 code: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None):
        """
        An error that occurred during resource provisioning.
        :param builtins.str code: The short-form error code.
        :param builtins.str message: The detailed error information.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        The short-form error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The detailed error information.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ComputeNodeGroupErrorInfo(dict):
    """
    An error that occurred during resource provisioning.
    """
    def __init__(__self__, *,
                 code: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None):
        """
        An error that occurred during resource provisioning.
        :param builtins.str code: The short-form error code.
        :param builtins.str message: The detailed error information.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        The short-form error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The detailed error information.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ComputeNodeGroupInstanceConfig(dict):
    """
    An EC2 instance configuration AWS PCS uses to launch compute nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeNodeGroupInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeNodeGroupInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeNodeGroupInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[builtins.str] = None):
        """
        An EC2 instance configuration AWS PCS uses to launch compute nodes.
        :param builtins.str instance_type: The EC2 instance type that AWS PCS can provision in the compute node group.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The EC2 instance type that AWS PCS can provision in the compute node group.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class ComputeNodeGroupSlurmCustomSetting(dict):
    """
    Additional settings that directly map to Slurm settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeNodeGroupSlurmCustomSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeNodeGroupSlurmCustomSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeNodeGroupSlurmCustomSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: builtins.str,
                 parameter_value: builtins.str):
        """
        Additional settings that directly map to Slurm settings.
        :param builtins.str parameter_name: AWS PCS supports configuration of the following Slurm parameters for compute node groups: Weight and RealMemory.
        :param builtins.str parameter_value: The value for the configured Slurm setting.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> builtins.str:
        """
        AWS PCS supports configuration of the following Slurm parameters for compute node groups: Weight and RealMemory.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> builtins.str:
        """
        The value for the configured Slurm setting.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class CustomLaunchTemplateProperties(dict):
    """
    An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateId":
            suggest = "template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLaunchTemplateProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLaunchTemplateProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLaunchTemplateProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: builtins.str,
                 template_id: Optional[builtins.str] = None):
        """
        An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        :param builtins.str version: The version of the EC2 launch template to use to provision instances.
        :param builtins.str template_id: The ID of the EC2 launch template to use to provision instances.
        """
        pulumi.set(__self__, "version", version)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the EC2 launch template to use to provision instances.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[builtins.str]:
        """
        The ID of the EC2 launch template to use to provision instances.
        """
        return pulumi.get(self, "template_id")


@pulumi.output_type
class NetworkingProperties(dict):
    """
    The networking configuration for the cluster's control plane.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkingProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkingProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkingProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        The networking configuration for the cluster's control plane.
        :param Sequence[builtins.str] security_group_ids: The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.
        :param Sequence[builtins.str] subnet_ids: The list of subnet IDs where AWS PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and AWS PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone. AWS PCS currently supports only 1 subnet in this list.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of subnet IDs where AWS PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and AWS PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone. AWS PCS currently supports only 1 subnet in this list.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class QueueComputeNodeGroupConfiguration(dict):
    """
    The compute node group configuration for a queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeNodeGroupId":
            suggest = "compute_node_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueComputeNodeGroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueComputeNodeGroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueComputeNodeGroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_node_group_id: Optional[builtins.str] = None):
        """
        The compute node group configuration for a queue.
        :param builtins.str compute_node_group_id: The compute node group ID for the compute node group configuration.
        """
        if compute_node_group_id is not None:
            pulumi.set(__self__, "compute_node_group_id", compute_node_group_id)

    @property
    @pulumi.getter(name="computeNodeGroupId")
    def compute_node_group_id(self) -> Optional[builtins.str]:
        """
        The compute node group ID for the compute node group configuration.
        """
        return pulumi.get(self, "compute_node_group_id")


@pulumi.output_type
class QueueErrorInfo(dict):
    """
    An error that occurred during resource provisioning.
    """
    def __init__(__self__, *,
                 code: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None):
        """
        An error that occurred during resource provisioning.
        :param builtins.str code: The short-form error code.
        :param builtins.str message: The detailed error information.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.str]:
        """
        The short-form error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        The detailed error information.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ScalingConfigurationProperties(dict):
    """
    Specifies the boundaries of the compute node group auto scaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: builtins.int,
                 min_instance_count: builtins.int):
        """
        Specifies the boundaries of the compute node group auto scaling.
        :param builtins.int max_instance_count: The upper bound of the number of instances allowed in the compute fleet.
        :param builtins.int min_instance_count: The lower bound of the number of instances allowed in the compute fleet.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> builtins.int:
        """
        The upper bound of the number of instances allowed in the compute fleet.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> builtins.int:
        """
        The lower bound of the number of instances allowed in the compute fleet.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class SchedulerProperties(dict):
    """
    The cluster management and job scheduling software associated with the cluster.
    """
    def __init__(__self__, *,
                 type: 'ClusterSchedulerPropertiesType',
                 version: builtins.str):
        """
        The cluster management and job scheduling software associated with the cluster.
        :param 'ClusterSchedulerPropertiesType' type: The software AWS PCS uses to manage cluster scaling and job scheduling.
        :param builtins.str version: The version of the specified scheduling software that AWS PCS uses to manage cluster scaling and job scheduling.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> 'ClusterSchedulerPropertiesType':
        """
        The software AWS PCS uses to manage cluster scaling and job scheduling.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the specified scheduling software that AWS PCS uses to manage cluster scaling and job scheduling.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SlurmConfigurationProperties(dict):
    """
    Additional options related to the Slurm scheduler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slurmCustomSettings":
            suggest = "slurm_custom_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlurmConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlurmConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlurmConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 slurm_custom_settings: Optional[Sequence['outputs.ComputeNodeGroupSlurmCustomSetting']] = None):
        """
        Additional options related to the Slurm scheduler.
        :param Sequence['ComputeNodeGroupSlurmCustomSetting'] slurm_custom_settings: Additional Slurm-specific configuration that directly maps to Slurm settings.
        """
        if slurm_custom_settings is not None:
            pulumi.set(__self__, "slurm_custom_settings", slurm_custom_settings)

    @property
    @pulumi.getter(name="slurmCustomSettings")
    def slurm_custom_settings(self) -> Optional[Sequence['outputs.ComputeNodeGroupSlurmCustomSetting']]:
        """
        Additional Slurm-specific configuration that directly maps to Slurm settings.
        """
        return pulumi.get(self, "slurm_custom_settings")


@pulumi.output_type
class SpotOptionsProperties(dict):
    """
    Additional configuration when you specify SPOT as the purchase option.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpotOptionsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpotOptionsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpotOptionsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: Optional['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy'] = None):
        """
        Additional configuration when you specify SPOT as the purchase option.
        :param 'ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy' allocation_strategy: The Amazon EC2 allocation strategy AWS PCS uses to provision EC2 instances. AWS PCS supports lowest price, capacity optimized, and price capacity optimized. If you don't provide this option, it defaults to price capacity optimized.
        """
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy']:
        """
        The Amazon EC2 allocation strategy AWS PCS uses to provision EC2 instances. AWS PCS supports lowest price, capacity optimized, and price capacity optimized. If you don't provide this option, it defaults to price capacity optimized.
        """
        return pulumi.get(self, "allocation_strategy")


