# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    def __init__(__self__, arn=None, compute_node_group_configurations=None, error_info=None, id=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if compute_node_group_configurations and not isinstance(compute_node_group_configurations, list):
            raise TypeError("Expected argument 'compute_node_group_configurations' to be a list")
        pulumi.set(__self__, "compute_node_group_configurations", compute_node_group_configurations)
        if error_info and not isinstance(error_info, list):
            raise TypeError("Expected argument 'error_info' to be a list")
        pulumi.set(__self__, "error_info", error_info)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The unique Amazon Resource Name (ARN) of the queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeNodeGroupConfigurations")
    def compute_node_group_configurations(self) -> Optional[Sequence['outputs.QueueComputeNodeGroupConfiguration']]:
        """
        The list of compute node group configurations associated with the queue. Queues assign jobs to associated compute node groups.
        """
        return pulumi.get(self, "compute_node_group_configurations")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> Optional[Sequence['outputs.QueueErrorInfo']]:
        """
        The list of errors that occurred during queue provisioning.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The generated unique ID of the queue.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> Optional['QueueStatus']:
        """
        The provisioning status of the queue. The provisioning status doesn't indicate the overall health of the queue.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            arn=self.arn,
            compute_node_group_configurations=self.compute_node_group_configurations,
            error_info=self.error_info,
            id=self.id,
            status=self.status,
            tags=self.tags)


def get_queue(arn: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    AWS::PCS::Queue resource creates an AWS PCS queue.


    :param builtins.str arn: The unique Amazon Resource Name (ARN) of the queue.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:pcs:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        arn=pulumi.get(__ret__, 'arn'),
        compute_node_group_configurations=pulumi.get(__ret__, 'compute_node_group_configurations'),
        error_info=pulumi.get(__ret__, 'error_info'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_queue_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    AWS::PCS::Queue resource creates an AWS PCS queue.


    :param builtins.str arn: The unique Amazon Resource Name (ARN) of the queue.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:pcs:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        arn=pulumi.get(__response__, 'arn'),
        compute_node_group_configurations=pulumi.get(__response__, 'compute_node_group_configurations'),
        error_info=pulumi.get(__response__, 'error_info'),
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
