# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ComputeNodeGroupArgs', 'ComputeNodeGroup']

@pulumi.input_type
class ComputeNodeGroupArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[builtins.str],
                 custom_launch_template: pulumi.Input['CustomLaunchTemplatePropertiesArgs'],
                 iam_instance_profile_arn: pulumi.Input[builtins.str],
                 instance_configs: pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupInstanceConfigArgs']]],
                 scaling_configuration: pulumi.Input['ScalingConfigurationPropertiesArgs'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purchase_option: Optional[pulumi.Input['ComputeNodeGroupPurchaseOption']] = None,
                 slurm_configuration: Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']] = None,
                 spot_options: Optional[pulumi.Input['SpotOptionsPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ComputeNodeGroup resource.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the cluster of the compute node group.
        :param pulumi.Input['CustomLaunchTemplatePropertiesArgs'] custom_launch_template: An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        :param pulumi.Input[builtins.str] iam_instance_profile_arn: The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupInstanceConfigArgs']]] instance_configs: A list of EC2 instance configurations that AWS PCS can provision in the compute node group.
        :param pulumi.Input['ScalingConfigurationPropertiesArgs'] scaling_configuration: Specifies the boundaries of the compute node group auto scaling.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same VPC as the cluster.
        :param pulumi.Input[builtins.str] ami_id: The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances. If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
        :param pulumi.Input[builtins.str] name: The name that identifies the compute node group.
        :param pulumi.Input['ComputeNodeGroupPurchaseOption'] purchase_option: Specifies how EC2 instances are purchased on your behalf. AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
        :param pulumi.Input['SlurmConfigurationPropertiesArgs'] slurm_configuration: Additional options related to the Slurm scheduler.
        :param pulumi.Input['SpotOptionsPropertiesArgs'] spot_options: Additional configuration when you specify SPOT as the purchase option.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "custom_launch_template", custom_launch_template)
        pulumi.set(__self__, "iam_instance_profile_arn", iam_instance_profile_arn)
        pulumi.set(__self__, "instance_configs", instance_configs)
        pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purchase_option is not None:
            pulumi.set(__self__, "purchase_option", purchase_option)
        if slurm_configuration is not None:
            pulumi.set(__self__, "slurm_configuration", slurm_configuration)
        if spot_options is not None:
            pulumi.set(__self__, "spot_options", spot_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the cluster of the compute node group.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="customLaunchTemplate")
    def custom_launch_template(self) -> pulumi.Input['CustomLaunchTemplatePropertiesArgs']:
        """
        An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        """
        return pulumi.get(self, "custom_launch_template")

    @custom_launch_template.setter
    def custom_launch_template(self, value: pulumi.Input['CustomLaunchTemplatePropertiesArgs']):
        pulumi.set(self, "custom_launch_template", value)

    @property
    @pulumi.getter(name="iamInstanceProfileArn")
    def iam_instance_profile_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
        """
        return pulumi.get(self, "iam_instance_profile_arn")

    @iam_instance_profile_arn.setter
    def iam_instance_profile_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iam_instance_profile_arn", value)

    @property
    @pulumi.getter(name="instanceConfigs")
    def instance_configs(self) -> pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupInstanceConfigArgs']]]:
        """
        A list of EC2 instance configurations that AWS PCS can provision in the compute node group.
        """
        return pulumi.get(self, "instance_configs")

    @instance_configs.setter
    def instance_configs(self, value: pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupInstanceConfigArgs']]]):
        pulumi.set(self, "instance_configs", value)

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Input['ScalingConfigurationPropertiesArgs']:
        """
        Specifies the boundaries of the compute node group auto scaling.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: pulumi.Input['ScalingConfigurationPropertiesArgs']):
        pulumi.set(self, "scaling_configuration", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same VPC as the cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances. If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name that identifies the compute node group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="purchaseOption")
    def purchase_option(self) -> Optional[pulumi.Input['ComputeNodeGroupPurchaseOption']]:
        """
        Specifies how EC2 instances are purchased on your behalf. AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
        """
        return pulumi.get(self, "purchase_option")

    @purchase_option.setter
    def purchase_option(self, value: Optional[pulumi.Input['ComputeNodeGroupPurchaseOption']]):
        pulumi.set(self, "purchase_option", value)

    @property
    @pulumi.getter(name="slurmConfiguration")
    def slurm_configuration(self) -> Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']]:
        """
        Additional options related to the Slurm scheduler.
        """
        return pulumi.get(self, "slurm_configuration")

    @slurm_configuration.setter
    def slurm_configuration(self, value: Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']]):
        pulumi.set(self, "slurm_configuration", value)

    @property
    @pulumi.getter(name="spotOptions")
    def spot_options(self) -> Optional[pulumi.Input['SpotOptionsPropertiesArgs']]:
        """
        Additional configuration when you specify SPOT as the purchase option.
        """
        return pulumi.get(self, "spot_options")

    @spot_options.setter
    def spot_options(self, value: Optional[pulumi.Input['SpotOptionsPropertiesArgs']]):
        pulumi.set(self, "spot_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:pcs:ComputeNodeGroup")
class ComputeNodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_launch_template: Optional[pulumi.Input[Union['CustomLaunchTemplatePropertiesArgs', 'CustomLaunchTemplatePropertiesArgsDict']]] = None,
                 iam_instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeNodeGroupInstanceConfigArgs', 'ComputeNodeGroupInstanceConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purchase_option: Optional[pulumi.Input['ComputeNodeGroupPurchaseOption']] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['ScalingConfigurationPropertiesArgs', 'ScalingConfigurationPropertiesArgsDict']]] = None,
                 slurm_configuration: Optional[pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']]] = None,
                 spot_options: Optional[pulumi.Input[Union['SpotOptionsPropertiesArgs', 'SpotOptionsPropertiesArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        AWS::PCS::ComputeNodeGroup resource creates an AWS PCS compute node group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami_id: The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances. If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
        :param pulumi.Input[builtins.str] cluster_id: The ID of the cluster of the compute node group.
        :param pulumi.Input[Union['CustomLaunchTemplatePropertiesArgs', 'CustomLaunchTemplatePropertiesArgsDict']] custom_launch_template: An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        :param pulumi.Input[builtins.str] iam_instance_profile_arn: The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComputeNodeGroupInstanceConfigArgs', 'ComputeNodeGroupInstanceConfigArgsDict']]]] instance_configs: A list of EC2 instance configurations that AWS PCS can provision in the compute node group.
        :param pulumi.Input[builtins.str] name: The name that identifies the compute node group.
        :param pulumi.Input['ComputeNodeGroupPurchaseOption'] purchase_option: Specifies how EC2 instances are purchased on your behalf. AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
        :param pulumi.Input[Union['ScalingConfigurationPropertiesArgs', 'ScalingConfigurationPropertiesArgsDict']] scaling_configuration: Specifies the boundaries of the compute node group auto scaling.
        :param pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']] slurm_configuration: Additional options related to the Slurm scheduler.
        :param pulumi.Input[Union['SpotOptionsPropertiesArgs', 'SpotOptionsPropertiesArgsDict']] spot_options: Additional configuration when you specify SPOT as the purchase option.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same VPC as the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::PCS::ComputeNodeGroup resource creates an AWS PCS compute node group.

        :param str resource_name: The name of the resource.
        :param ComputeNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_launch_template: Optional[pulumi.Input[Union['CustomLaunchTemplatePropertiesArgs', 'CustomLaunchTemplatePropertiesArgsDict']]] = None,
                 iam_instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComputeNodeGroupInstanceConfigArgs', 'ComputeNodeGroupInstanceConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purchase_option: Optional[pulumi.Input['ComputeNodeGroupPurchaseOption']] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['ScalingConfigurationPropertiesArgs', 'ScalingConfigurationPropertiesArgsDict']]] = None,
                 slurm_configuration: Optional[pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']]] = None,
                 spot_options: Optional[pulumi.Input[Union['SpotOptionsPropertiesArgs', 'SpotOptionsPropertiesArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeNodeGroupArgs.__new__(ComputeNodeGroupArgs)

            __props__.__dict__["ami_id"] = ami_id
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if custom_launch_template is None and not opts.urn:
                raise TypeError("Missing required property 'custom_launch_template'")
            __props__.__dict__["custom_launch_template"] = custom_launch_template
            if iam_instance_profile_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_instance_profile_arn'")
            __props__.__dict__["iam_instance_profile_arn"] = iam_instance_profile_arn
            if instance_configs is None and not opts.urn:
                raise TypeError("Missing required property 'instance_configs'")
            __props__.__dict__["instance_configs"] = instance_configs
            __props__.__dict__["name"] = name
            __props__.__dict__["purchase_option"] = purchase_option
            if scaling_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_configuration'")
            __props__.__dict__["scaling_configuration"] = scaling_configuration
            __props__.__dict__["slurm_configuration"] = slurm_configuration
            __props__.__dict__["spot_options"] = spot_options
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["error_info"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clusterId", "instanceConfigs[*]", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ComputeNodeGroup, __self__).__init__(
            'aws-native:pcs:ComputeNodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ComputeNodeGroup':
        """
        Get an existing ComputeNodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ComputeNodeGroupArgs.__new__(ComputeNodeGroupArgs)

        __props__.__dict__["ami_id"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["cluster_id"] = None
        __props__.__dict__["custom_launch_template"] = None
        __props__.__dict__["error_info"] = None
        __props__.__dict__["iam_instance_profile_arn"] = None
        __props__.__dict__["instance_configs"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["purchase_option"] = None
        __props__.__dict__["scaling_configuration"] = None
        __props__.__dict__["slurm_configuration"] = None
        __props__.__dict__["spot_options"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        return ComputeNodeGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances. If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
        """
        return pulumi.get(self, "ami_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The unique Amazon Resource Name (ARN) of the compute node group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The generated unique ID of the compute node group.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the cluster of the compute node group.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="customLaunchTemplate")
    def custom_launch_template(self) -> pulumi.Output['outputs.CustomLaunchTemplateProperties']:
        """
        An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        """
        return pulumi.get(self, "custom_launch_template")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> pulumi.Output[Sequence['outputs.ComputeNodeGroupErrorInfo']]:
        """
        The list of errors that occurred during compute node group provisioning.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="iamInstanceProfileArn")
    def iam_instance_profile_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
        """
        return pulumi.get(self, "iam_instance_profile_arn")

    @property
    @pulumi.getter(name="instanceConfigs")
    def instance_configs(self) -> pulumi.Output[Sequence['outputs.ComputeNodeGroupInstanceConfig']]:
        """
        A list of EC2 instance configurations that AWS PCS can provision in the compute node group.
        """
        return pulumi.get(self, "instance_configs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name that identifies the compute node group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purchaseOption")
    def purchase_option(self) -> pulumi.Output[Optional['ComputeNodeGroupPurchaseOption']]:
        """
        Specifies how EC2 instances are purchased on your behalf. AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
        """
        return pulumi.get(self, "purchase_option")

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Output['outputs.ScalingConfigurationProperties']:
        """
        Specifies the boundaries of the compute node group auto scaling.
        """
        return pulumi.get(self, "scaling_configuration")

    @property
    @pulumi.getter(name="slurmConfiguration")
    def slurm_configuration(self) -> pulumi.Output[Optional['outputs.SlurmConfigurationProperties']]:
        """
        Additional options related to the Slurm scheduler.
        """
        return pulumi.get(self, "slurm_configuration")

    @property
    @pulumi.getter(name="spotOptions")
    def spot_options(self) -> pulumi.Output[Optional['outputs.SpotOptionsProperties']]:
        """
        Additional configuration when you specify SPOT as the purchase option.
        """
        return pulumi.get(self, "spot_options")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['ComputeNodeGroupStatus']:
        """
        The provisioning status of the compute node group. The provisioning status doesn't indicate the overall health of the compute node group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of subnet IDs where instances are provisioned by the compute node group. The subnets must be in the same VPC as the cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

