# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 networking: pulumi.Input['NetworkingPropertiesArgs'],
                 scheduler: pulumi.Input['SchedulerPropertiesArgs'],
                 size: pulumi.Input['ClusterSize'],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slurm_configuration: Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['NetworkingPropertiesArgs'] networking: The networking configuration for the cluster's control plane.
        :param pulumi.Input['SchedulerPropertiesArgs'] scheduler: The cluster management and job scheduling software associated with the cluster.
        :param pulumi.Input['ClusterSize'] size: The size of the cluster.
        :param pulumi.Input[builtins.str] name: The name that identifies the cluster.
        :param pulumi.Input['SlurmConfigurationPropertiesArgs'] slurm_configuration: Additional options related to the Slurm scheduler.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        pulumi.set(__self__, "networking", networking)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "size", size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slurm_configuration is not None:
            pulumi.set(__self__, "slurm_configuration", slurm_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Input['NetworkingPropertiesArgs']:
        """
        The networking configuration for the cluster's control plane.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: pulumi.Input['NetworkingPropertiesArgs']):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def scheduler(self) -> pulumi.Input['SchedulerPropertiesArgs']:
        """
        The cluster management and job scheduling software associated with the cluster.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: pulumi.Input['SchedulerPropertiesArgs']):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input['ClusterSize']:
        """
        The size of the cluster.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input['ClusterSize']):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name that identifies the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="slurmConfiguration")
    def slurm_configuration(self) -> Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']]:
        """
        Additional options related to the Slurm scheduler.
        """
        return pulumi.get(self, "slurm_configuration")

    @slurm_configuration.setter
    def slurm_configuration(self, value: Optional[pulumi.Input['SlurmConfigurationPropertiesArgs']]):
        pulumi.set(self, "slurm_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:pcs:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['NetworkingPropertiesArgs', 'NetworkingPropertiesArgsDict']]] = None,
                 scheduler: Optional[pulumi.Input[Union['SchedulerPropertiesArgs', 'SchedulerPropertiesArgsDict']]] = None,
                 size: Optional[pulumi.Input['ClusterSize']] = None,
                 slurm_configuration: Optional[pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        AWS::PCS::Cluster resource creates an AWS PCS cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name that identifies the cluster.
        :param pulumi.Input[Union['NetworkingPropertiesArgs', 'NetworkingPropertiesArgsDict']] networking: The networking configuration for the cluster's control plane.
        :param pulumi.Input[Union['SchedulerPropertiesArgs', 'SchedulerPropertiesArgsDict']] scheduler: The cluster management and job scheduling software associated with the cluster.
        :param pulumi.Input['ClusterSize'] size: The size of the cluster.
        :param pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']] slurm_configuration: Additional options related to the Slurm scheduler.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::PCS::Cluster resource creates an AWS PCS cluster.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['NetworkingPropertiesArgs', 'NetworkingPropertiesArgsDict']]] = None,
                 scheduler: Optional[pulumi.Input[Union['SchedulerPropertiesArgs', 'SchedulerPropertiesArgsDict']]] = None,
                 size: Optional[pulumi.Input['ClusterSize']] = None,
                 slurm_configuration: Optional[pulumi.Input[Union['SlurmConfigurationPropertiesArgs', 'SlurmConfigurationPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["name"] = name
            if networking is None and not opts.urn:
                raise TypeError("Missing required property 'networking'")
            __props__.__dict__["networking"] = networking
            if scheduler is None and not opts.urn:
                raise TypeError("Missing required property 'scheduler'")
            __props__.__dict__["scheduler"] = scheduler
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["slurm_configuration"] = slurm_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["error_info"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "networking", "scheduler", "size", "slurmConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Cluster, __self__).__init__(
            'aws-native:pcs:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterArgs.__new__(ClusterArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["endpoints"] = None
        __props__.__dict__["error_info"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["networking"] = None
        __props__.__dict__["scheduler"] = None
        __props__.__dict__["size"] = None
        __props__.__dict__["slurm_configuration"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The unique Amazon Resource Name (ARN) of the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The generated unique ID of the cluster.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterEndpoint']]:
        """
        The list of endpoints available for interaction with the scheduler.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> pulumi.Output[Sequence['outputs.ClusterErrorInfo']]:
        """
        The list of errors that occurred during cluster provisioning.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name that identifies the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Output['outputs.NetworkingProperties']:
        """
        The networking configuration for the cluster's control plane.
        """
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output['outputs.SchedulerProperties']:
        """
        The cluster management and job scheduling software associated with the cluster.
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output['ClusterSize']:
        """
        The size of the cluster.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="slurmConfiguration")
    def slurm_configuration(self) -> pulumi.Output[Optional['outputs.SlurmConfigurationProperties']]:
        """
        Additional options related to the Slurm scheduler.
        """
        return pulumi.get(self, "slurm_configuration")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['ClusterStatus']:
        """
        The provisioning status of the cluster. The provisioning status doesn't indicate the overall health of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        1 or more tags added to the resource. Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
        """
        return pulumi.get(self, "tags")

