# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ComputeNodeGroupInstanceConfigArgs',
    'ComputeNodeGroupInstanceConfigArgsDict',
    'ComputeNodeGroupSlurmCustomSettingArgs',
    'ComputeNodeGroupSlurmCustomSettingArgsDict',
    'CustomLaunchTemplatePropertiesArgs',
    'CustomLaunchTemplatePropertiesArgsDict',
    'NetworkingPropertiesArgs',
    'NetworkingPropertiesArgsDict',
    'QueueComputeNodeGroupConfigurationArgs',
    'QueueComputeNodeGroupConfigurationArgsDict',
    'ScalingConfigurationPropertiesArgs',
    'ScalingConfigurationPropertiesArgsDict',
    'SchedulerPropertiesArgs',
    'SchedulerPropertiesArgsDict',
    'SlurmConfigurationPropertiesArgs',
    'SlurmConfigurationPropertiesArgsDict',
    'SpotOptionsPropertiesArgs',
    'SpotOptionsPropertiesArgsDict',
]

MYPY = False

if not MYPY:
    class ComputeNodeGroupInstanceConfigArgsDict(TypedDict):
        """
        An EC2 instance configuration AWS PCS uses to launch compute nodes.
        """
        instance_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The EC2 instance type that AWS PCS can provision in the compute node group.
        """
elif False:
    ComputeNodeGroupInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeNodeGroupInstanceConfigArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        An EC2 instance configuration AWS PCS uses to launch compute nodes.
        :param pulumi.Input[builtins.str] instance_type: The EC2 instance type that AWS PCS can provision in the compute node group.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC2 instance type that AWS PCS can provision in the compute node group.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)


if not MYPY:
    class ComputeNodeGroupSlurmCustomSettingArgsDict(TypedDict):
        """
        Additional settings that directly map to Slurm settings.
        """
        parameter_name: pulumi.Input[builtins.str]
        """
        AWS PCS supports configuration of the following Slurm parameters for compute node groups: Weight and RealMemory.
        """
        parameter_value: pulumi.Input[builtins.str]
        """
        The value for the configured Slurm setting.
        """
elif False:
    ComputeNodeGroupSlurmCustomSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeNodeGroupSlurmCustomSettingArgs:
    def __init__(__self__, *,
                 parameter_name: pulumi.Input[builtins.str],
                 parameter_value: pulumi.Input[builtins.str]):
        """
        Additional settings that directly map to Slurm settings.
        :param pulumi.Input[builtins.str] parameter_name: AWS PCS supports configuration of the following Slurm parameters for compute node groups: Weight and RealMemory.
        :param pulumi.Input[builtins.str] parameter_value: The value for the configured Slurm setting.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> pulumi.Input[builtins.str]:
        """
        AWS PCS supports configuration of the following Slurm parameters for compute node groups: Weight and RealMemory.
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[builtins.str]:
        """
        The value for the configured Slurm setting.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class CustomLaunchTemplatePropertiesArgsDict(TypedDict):
        """
        An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        """
        version: pulumi.Input[builtins.str]
        """
        The version of the EC2 launch template to use to provision instances.
        """
        template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the EC2 launch template to use to provision instances.
        """
elif False:
    CustomLaunchTemplatePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomLaunchTemplatePropertiesArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[builtins.str],
                 template_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
        :param pulumi.Input[builtins.str] version: The version of the EC2 launch template to use to provision instances.
        :param pulumi.Input[builtins.str] template_id: The ID of the EC2 launch template to use to provision instances.
        """
        pulumi.set(__self__, "version", version)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the EC2 launch template to use to provision instances.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the EC2 launch template to use to provision instances.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)


if not MYPY:
    class NetworkingPropertiesArgsDict(TypedDict):
        """
        The networking configuration for the cluster's control plane.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of subnet IDs where AWS PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and AWS PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone. AWS PCS currently supports only 1 subnet in this list.
        """
elif False:
    NetworkingPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkingPropertiesArgs:
    def __init__(__self__, *,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The networking configuration for the cluster's control plane.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The list of subnet IDs where AWS PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and AWS PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone. AWS PCS currently supports only 1 subnet in this list.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of security group IDs associated with the Elastic Network Interface (ENI) created in subnets.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of subnet IDs where AWS PCS creates an Elastic Network Interface (ENI) to enable communication between managed controllers and AWS PCS resources. The subnet must have an available IP address, cannot reside in AWS Outposts, AWS Wavelength, or an AWS Local Zone. AWS PCS currently supports only 1 subnet in this list.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class QueueComputeNodeGroupConfigurationArgsDict(TypedDict):
        """
        The compute node group configuration for a queue.
        """
        compute_node_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The compute node group ID for the compute node group configuration.
        """
elif False:
    QueueComputeNodeGroupConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueComputeNodeGroupConfigurationArgs:
    def __init__(__self__, *,
                 compute_node_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The compute node group configuration for a queue.
        :param pulumi.Input[builtins.str] compute_node_group_id: The compute node group ID for the compute node group configuration.
        """
        if compute_node_group_id is not None:
            pulumi.set(__self__, "compute_node_group_id", compute_node_group_id)

    @property
    @pulumi.getter(name="computeNodeGroupId")
    def compute_node_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compute node group ID for the compute node group configuration.
        """
        return pulumi.get(self, "compute_node_group_id")

    @compute_node_group_id.setter
    def compute_node_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_node_group_id", value)


if not MYPY:
    class ScalingConfigurationPropertiesArgsDict(TypedDict):
        """
        Specifies the boundaries of the compute node group auto scaling.
        """
        max_instance_count: pulumi.Input[builtins.int]
        """
        The upper bound of the number of instances allowed in the compute fleet.
        """
        min_instance_count: pulumi.Input[builtins.int]
        """
        The lower bound of the number of instances allowed in the compute fleet.
        """
elif False:
    ScalingConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScalingConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 max_instance_count: pulumi.Input[builtins.int],
                 min_instance_count: pulumi.Input[builtins.int]):
        """
        Specifies the boundaries of the compute node group auto scaling.
        :param pulumi.Input[builtins.int] max_instance_count: The upper bound of the number of instances allowed in the compute fleet.
        :param pulumi.Input[builtins.int] min_instance_count: The lower bound of the number of instances allowed in the compute fleet.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> pulumi.Input[builtins.int]:
        """
        The upper bound of the number of instances allowed in the compute fleet.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> pulumi.Input[builtins.int]:
        """
        The lower bound of the number of instances allowed in the compute fleet.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_instance_count", value)


if not MYPY:
    class SchedulerPropertiesArgsDict(TypedDict):
        """
        The cluster management and job scheduling software associated with the cluster.
        """
        type: pulumi.Input['ClusterSchedulerPropertiesType']
        """
        The software AWS PCS uses to manage cluster scaling and job scheduling.
        """
        version: pulumi.Input[builtins.str]
        """
        The version of the specified scheduling software that AWS PCS uses to manage cluster scaling and job scheduling.
        """
elif False:
    SchedulerPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ClusterSchedulerPropertiesType'],
                 version: pulumi.Input[builtins.str]):
        """
        The cluster management and job scheduling software associated with the cluster.
        :param pulumi.Input['ClusterSchedulerPropertiesType'] type: The software AWS PCS uses to manage cluster scaling and job scheduling.
        :param pulumi.Input[builtins.str] version: The version of the specified scheduling software that AWS PCS uses to manage cluster scaling and job scheduling.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ClusterSchedulerPropertiesType']:
        """
        The software AWS PCS uses to manage cluster scaling and job scheduling.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ClusterSchedulerPropertiesType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the specified scheduling software that AWS PCS uses to manage cluster scaling and job scheduling.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)


if not MYPY:
    class SlurmConfigurationPropertiesArgsDict(TypedDict):
        """
        Additional options related to the Slurm scheduler.
        """
        slurm_custom_settings: NotRequired[pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupSlurmCustomSettingArgsDict']]]]
        """
        Additional Slurm-specific configuration that directly maps to Slurm settings.
        """
elif False:
    SlurmConfigurationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SlurmConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 slurm_custom_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupSlurmCustomSettingArgs']]]] = None):
        """
        Additional options related to the Slurm scheduler.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupSlurmCustomSettingArgs']]] slurm_custom_settings: Additional Slurm-specific configuration that directly maps to Slurm settings.
        """
        if slurm_custom_settings is not None:
            pulumi.set(__self__, "slurm_custom_settings", slurm_custom_settings)

    @property
    @pulumi.getter(name="slurmCustomSettings")
    def slurm_custom_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupSlurmCustomSettingArgs']]]]:
        """
        Additional Slurm-specific configuration that directly maps to Slurm settings.
        """
        return pulumi.get(self, "slurm_custom_settings")

    @slurm_custom_settings.setter
    def slurm_custom_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeNodeGroupSlurmCustomSettingArgs']]]]):
        pulumi.set(self, "slurm_custom_settings", value)


if not MYPY:
    class SpotOptionsPropertiesArgsDict(TypedDict):
        """
        Additional configuration when you specify SPOT as the purchase option.
        """
        allocation_strategy: NotRequired[pulumi.Input['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy']]
        """
        The Amazon EC2 allocation strategy AWS PCS uses to provision EC2 instances. AWS PCS supports lowest price, capacity optimized, and price capacity optimized. If you don't provide this option, it defaults to price capacity optimized.
        """
elif False:
    SpotOptionsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SpotOptionsPropertiesArgs:
    def __init__(__self__, *,
                 allocation_strategy: Optional[pulumi.Input['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy']] = None):
        """
        Additional configuration when you specify SPOT as the purchase option.
        :param pulumi.Input['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy'] allocation_strategy: The Amazon EC2 allocation strategy AWS PCS uses to provision EC2 instances. AWS PCS supports lowest price, capacity optimized, and price capacity optimized. If you don't provide this option, it defaults to price capacity optimized.
        """
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy']]:
        """
        The Amazon EC2 allocation strategy AWS PCS uses to provision EC2 instances. AWS PCS supports lowest price, capacity optimized, and price capacity optimized. If you don't provide this option, it defaults to price capacity optimized.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input['ComputeNodeGroupSpotOptionsPropertiesAllocationStrategy']]):
        pulumi.set(self, "allocation_strategy", value)


