# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    def __init__(__self__, connector_arn=None, endpoint=None, open_id_configuration=None, tags=None, type=None):
        if connector_arn and not isinstance(connector_arn, str):
            raise TypeError("Expected argument 'connector_arn' to be a str")
        pulumi.set(__self__, "connector_arn", connector_arn)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if open_id_configuration and not isinstance(open_id_configuration, dict):
            raise TypeError("Expected argument 'open_id_configuration' to be a dict")
        pulumi.set(__self__, "open_id_configuration", open_id_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "connector_arn")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        The connector's HTTPS public SCEP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="openIdConfiguration")
    def open_id_configuration(self) -> Optional['outputs.ConnectorOpenIdConfiguration']:
        return pulumi.get(self, "open_id_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['ConnectorType']:
        """
        The connector type.
        """
        return pulumi.get(self, "type")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            connector_arn=self.connector_arn,
            endpoint=self.endpoint,
            open_id_configuration=self.open_id_configuration,
            tags=self.tags,
            type=self.type)


def get_connector(connector_arn: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Represents a Connector that allows certificate issuance through Simple Certificate Enrollment Protocol (SCEP)


    :param builtins.str connector_arn: The Amazon Resource Name (ARN) of the connector.
    """
    __args__ = dict()
    __args__['connectorArn'] = connector_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:pcaconnectorscep:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        connector_arn=pulumi.get(__ret__, 'connector_arn'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        open_id_configuration=pulumi.get(__ret__, 'open_id_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_connector_output(connector_arn: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Represents a Connector that allows certificate issuance through Simple Certificate Enrollment Protocol (SCEP)


    :param builtins.str connector_arn: The Amazon Resource Name (ARN) of the connector.
    """
    __args__ = dict()
    __args__['connectorArn'] = connector_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:pcaconnectorscep:getConnector', __args__, opts=opts, typ=GetConnectorResult)
    return __ret__.apply(lambda __response__: GetConnectorResult(
        connector_arn=pulumi.get(__response__, 'connector_arn'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        open_id_configuration=pulumi.get(__response__, 'open_id_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
