# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 certificate_authority_arn: pulumi.Input[builtins.str],
                 mobile_device_management: Optional[pulumi.Input['ConnectorMobileDeviceManagementArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input[builtins.str] certificate_authority_arn: The Amazon Resource Name (ARN) of the certificate authority associated with the connector.
        :param pulumi.Input['ConnectorMobileDeviceManagementArgs'] mobile_device_management: Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement` , then the connector is for general-purpose use and this object is empty.
        """
        pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if mobile_device_management is not None:
            pulumi.set(__self__, "mobile_device_management", mobile_device_management)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the certificate authority associated with the connector.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_authority_arn", value)

    @property
    @pulumi.getter(name="mobileDeviceManagement")
    def mobile_device_management(self) -> Optional[pulumi.Input['ConnectorMobileDeviceManagementArgs']]:
        """
        Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement` , then the connector is for general-purpose use and this object is empty.
        """
        return pulumi.get(self, "mobile_device_management")

    @mobile_device_management.setter
    def mobile_device_management(self, value: Optional[pulumi.Input['ConnectorMobileDeviceManagementArgs']]):
        pulumi.set(self, "mobile_device_management", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:pcaconnectorscep:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_device_management: Optional[pulumi.Input[Union['ConnectorMobileDeviceManagementArgs', 'ConnectorMobileDeviceManagementArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Represents a Connector that allows certificate issuance through Simple Certificate Enrollment Protocol (SCEP)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_authority_arn: The Amazon Resource Name (ARN) of the certificate authority associated with the connector.
        :param pulumi.Input[Union['ConnectorMobileDeviceManagementArgs', 'ConnectorMobileDeviceManagementArgsDict']] mobile_device_management: Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement` , then the connector is for general-purpose use and this object is empty.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Connector that allows certificate issuance through Simple Certificate Enrollment Protocol (SCEP)

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mobile_device_management: Optional[pulumi.Input[Union['ConnectorMobileDeviceManagementArgs', 'ConnectorMobileDeviceManagementArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            if certificate_authority_arn is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_arn'")
            __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
            __props__.__dict__["mobile_device_management"] = mobile_device_management
            __props__.__dict__["tags"] = tags
            __props__.__dict__["connector_arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["open_id_configuration"] = None
            __props__.__dict__["type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["certificateAuthorityArn", "mobileDeviceManagement"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Connector, __self__).__init__(
            'aws-native:pcaconnectorscep:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConnectorArgs.__new__(ConnectorArgs)

        __props__.__dict__["certificate_authority_arn"] = None
        __props__.__dict__["connector_arn"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["mobile_device_management"] = None
        __props__.__dict__["open_id_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Connector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the certificate authority associated with the connector.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "connector_arn")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The connector's HTTPS public SCEP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="mobileDeviceManagement")
    def mobile_device_management(self) -> pulumi.Output[Optional['outputs.ConnectorMobileDeviceManagement']]:
        """
        Contains settings relevant to the mobile device management system that you chose for the connector. If you didn't configure `MobileDeviceManagement` , then the connector is for general-purpose use and this object is empty.
        """
        return pulumi.get(self, "mobile_device_management")

    @property
    @pulumi.getter(name="openIdConfiguration")
    def open_id_configuration(self) -> pulumi.Output['outputs.ConnectorOpenIdConfiguration']:
        return pulumi.get(self, "open_id_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['ConnectorType']:
        """
        The connector type.
        """
        return pulumi.get(self, "type")

