# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChallengeArgs', 'Challenge']

@pulumi.input_type
class ChallengeArgs:
    def __init__(__self__, *,
                 connector_arn: pulumi.Input[builtins.str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Challenge resource.
        :param pulumi.Input[builtins.str] connector_arn: The Amazon Resource Name (ARN) of the connector.
        """
        pulumi.set(__self__, "connector_arn", connector_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "connector_arn")

    @connector_arn.setter
    def connector_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connector_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:pcaconnectorscep:Challenge")
class Challenge(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Represents a SCEP Challenge that is used for certificate enrollment

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connector_arn: The Amazon Resource Name (ARN) of the connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChallengeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a SCEP Challenge that is used for certificate enrollment

        :param str resource_name: The name of the resource.
        :param ChallengeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChallengeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChallengeArgs.__new__(ChallengeArgs)

            if connector_arn is None and not opts.urn:
                raise TypeError("Missing required property 'connector_arn'")
            __props__.__dict__["connector_arn"] = connector_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["challenge_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["connectorArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Challenge, __self__).__init__(
            'aws-native:pcaconnectorscep:Challenge',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Challenge':
        """
        Get an existing Challenge resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChallengeArgs.__new__(ChallengeArgs)

        __props__.__dict__["challenge_arn"] = None
        __props__.__dict__["connector_arn"] = None
        __props__.__dict__["tags"] = None
        return Challenge(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="challengeArn")
    def challenge_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the challenge.
        """
        return pulumi.get(self, "challenge_arn")

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "connector_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

