# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    def __init__(__self__, connector_arn=None, tags=None):
        if connector_arn and not isinstance(connector_arn, str):
            raise TypeError("Expected argument 'connector_arn' to be a str")
        pulumi.set(__self__, "connector_arn", connector_arn)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectorArn")
    def connector_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
        """
        return pulumi.get(self, "connector_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Metadata assigned to a connector consisting of a key-value pair.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            connector_arn=self.connector_arn,
            tags=self.tags)


def get_connector(connector_arn: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Represents a Connector that connects AWS PrivateCA and your directory


    :param builtins.str connector_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
    """
    __args__ = dict()
    __args__['connectorArn'] = connector_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:pcaconnectorad:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        connector_arn=pulumi.get(__ret__, 'connector_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connector_output(connector_arn: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Represents a Connector that connects AWS PrivateCA and your directory


    :param builtins.str connector_arn: The Amazon Resource Name (ARN) that was returned when you called [CreateConnector](https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html) .
    """
    __args__ = dict()
    __args__['connectorArn'] = connector_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:pcaconnectorad:getConnector', __args__, opts=opts, typ=GetConnectorResult)
    return __ret__.apply(lambda __response__: GetConnectorResult(
        connector_arn=pulumi.get(__response__, 'connector_arn'),
        tags=pulumi.get(__response__, 'tags')))
