# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetPackageVersionResult',
    'AwaitableGetPackageVersionResult',
    'get_package_version',
    'get_package_version_output',
]

@pulumi.output_type
class GetPackageVersionResult:
    def __init__(__self__, is_latest_patch=None, mark_latest=None, package_arn=None, package_name=None, registered_time=None, status=None, status_description=None):
        if is_latest_patch and not isinstance(is_latest_patch, bool):
            raise TypeError("Expected argument 'is_latest_patch' to be a bool")
        pulumi.set(__self__, "is_latest_patch", is_latest_patch)
        if mark_latest and not isinstance(mark_latest, bool):
            raise TypeError("Expected argument 'mark_latest' to be a bool")
        pulumi.set(__self__, "mark_latest", mark_latest)
        if package_arn and not isinstance(package_arn, str):
            raise TypeError("Expected argument 'package_arn' to be a str")
        pulumi.set(__self__, "package_arn", package_arn)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if registered_time and not isinstance(registered_time, int):
            raise TypeError("Expected argument 'registered_time' to be a int")
        pulumi.set(__self__, "registered_time", registered_time)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_description and not isinstance(status_description, str):
            raise TypeError("Expected argument 'status_description' to be a str")
        pulumi.set(__self__, "status_description", status_description)

    @property
    @pulumi.getter(name="isLatestPatch")
    def is_latest_patch(self) -> Optional[builtins.bool]:
        """
        Whether the package version is the latest version.
        """
        return pulumi.get(self, "is_latest_patch")

    @property
    @pulumi.getter(name="markLatest")
    def mark_latest(self) -> Optional[builtins.bool]:
        """
        Whether to mark the new version as the latest version.
        """
        return pulumi.get(self, "mark_latest")

    @property
    @pulumi.getter(name="packageArn")
    def package_arn(self) -> Optional[builtins.str]:
        """
        The package version's ARN.
        """
        return pulumi.get(self, "package_arn")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[builtins.str]:
        """
        The package version's name.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter(name="registeredTime")
    def registered_time(self) -> Optional[builtins.int]:
        """
        The package version's registered time.
        """
        return pulumi.get(self, "registered_time")

    @property
    @pulumi.getter
    def status(self) -> Optional['PackageVersionStatus']:
        """
        The package version's status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> Optional[builtins.str]:
        """
        The package version's status description.
        """
        return pulumi.get(self, "status_description")


class AwaitableGetPackageVersionResult(GetPackageVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPackageVersionResult(
            is_latest_patch=self.is_latest_patch,
            mark_latest=self.mark_latest,
            package_arn=self.package_arn,
            package_name=self.package_name,
            registered_time=self.registered_time,
            status=self.status,
            status_description=self.status_description)


def get_package_version(package_id: Optional[builtins.str] = None,
                        package_version: Optional[builtins.str] = None,
                        patch_version: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPackageVersionResult:
    """
    Registers a package version.


    :param builtins.str package_id: A package ID.
    :param builtins.str package_version: A package version.
    :param builtins.str patch_version: A patch version.
    """
    __args__ = dict()
    __args__['packageId'] = package_id
    __args__['packageVersion'] = package_version
    __args__['patchVersion'] = patch_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:panorama:getPackageVersion', __args__, opts=opts, typ=GetPackageVersionResult).value

    return AwaitableGetPackageVersionResult(
        is_latest_patch=pulumi.get(__ret__, 'is_latest_patch'),
        mark_latest=pulumi.get(__ret__, 'mark_latest'),
        package_arn=pulumi.get(__ret__, 'package_arn'),
        package_name=pulumi.get(__ret__, 'package_name'),
        registered_time=pulumi.get(__ret__, 'registered_time'),
        status=pulumi.get(__ret__, 'status'),
        status_description=pulumi.get(__ret__, 'status_description'))
def get_package_version_output(package_id: Optional[pulumi.Input[builtins.str]] = None,
                               package_version: Optional[pulumi.Input[builtins.str]] = None,
                               patch_version: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPackageVersionResult]:
    """
    Registers a package version.


    :param builtins.str package_id: A package ID.
    :param builtins.str package_version: A package version.
    :param builtins.str patch_version: A patch version.
    """
    __args__ = dict()
    __args__['packageId'] = package_id
    __args__['packageVersion'] = package_version
    __args__['patchVersion'] = patch_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:panorama:getPackageVersion', __args__, opts=opts, typ=GetPackageVersionResult)
    return __ret__.apply(lambda __response__: GetPackageVersionResult(
        is_latest_patch=pulumi.get(__response__, 'is_latest_patch'),
        mark_latest=pulumi.get(__response__, 'mark_latest'),
        package_arn=pulumi.get(__response__, 'package_arn'),
        package_name=pulumi.get(__response__, 'package_name'),
        registered_time=pulumi.get(__response__, 'registered_time'),
        status=pulumi.get(__response__, 'status'),
        status_description=pulumi.get(__response__, 'status_description')))
