# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 max_units: pulumi.Input[builtins.int],
                 min_units: pulumi.Input[builtins.int],
                 pipeline_configuration_body: pulumi.Input[builtins.str],
                 buffer_options: Optional[pulumi.Input['PipelineBufferOptionsArgs']] = None,
                 encryption_at_rest_options: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']] = None,
                 log_publishing_options: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_options: Optional[pulumi.Input['PipelineVpcOptionsArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The Data Prepper pipeline configuration.
        :param pulumi.Input['PipelineBufferOptionsArgs'] buffer_options: Options that specify the configuration of a persistent buffer. To configure how OpenSearch Ingestion encrypts this data, set the `EncryptionAtRestOptions` . For more information, see [Persistent buffering](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering) .
        :param pulumi.Input['PipelineEncryptionAtRestOptionsArgs'] encryption_at_rest_options: Options to control how OpenSearch encrypts buffer data.
        :param pulumi.Input['PipelineLogPublishingOptionsArgs'] log_publishing_options: Key-value pairs that represent log publishing settings.
        :param pulumi.Input[builtins.str] pipeline_name: Name of the OpenSearch Ingestion Service pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['PipelineVpcOptionsArgs'] vpc_options: Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
        """
        pulumi.set(__self__, "max_units", max_units)
        pulumi.set(__self__, "min_units", min_units)
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if buffer_options is not None:
            pulumi.set(__self__, "buffer_options", buffer_options)
        if encryption_at_rest_options is not None:
            pulumi.set(__self__, "encryption_at_rest_options", encryption_at_rest_options)
        if log_publishing_options is not None:
            pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if pipeline_name is not None:
            pulumi.set(__self__, "pipeline_name", pipeline_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> pulumi.Input[builtins.int]:
        """
        The maximum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "max_units")

    @max_units.setter
    def max_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_units", value)

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> pulumi.Input[builtins.int]:
        """
        The minimum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "min_units")

    @min_units.setter
    def min_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_units", value)

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Input[builtins.str]:
        """
        The Data Prepper pipeline configuration.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_configuration_body", value)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> Optional[pulumi.Input['PipelineBufferOptionsArgs']]:
        """
        Options that specify the configuration of a persistent buffer. To configure how OpenSearch Ingestion encrypts this data, set the `EncryptionAtRestOptions` . For more information, see [Persistent buffering](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering) .
        """
        return pulumi.get(self, "buffer_options")

    @buffer_options.setter
    def buffer_options(self, value: Optional[pulumi.Input['PipelineBufferOptionsArgs']]):
        pulumi.set(self, "buffer_options", value)

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]:
        """
        Options to control how OpenSearch encrypts buffer data.
        """
        return pulumi.get(self, "encryption_at_rest_options")

    @encryption_at_rest_options.setter
    def encryption_at_rest_options(self, value: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]):
        pulumi.set(self, "encryption_at_rest_options", value)

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]:
        """
        Key-value pairs that represent log publishing settings.
        """
        return pulumi.get(self, "log_publishing_options")

    @log_publishing_options.setter
    def log_publishing_options(self, value: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]):
        pulumi.set(self, "log_publishing_options", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the OpenSearch Ingestion Service pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input['PipelineVpcOptionsArgs']]:
        """
        Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
        """
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input['PipelineVpcOptionsArgs']]):
        pulumi.set(self, "vpc_options", value)


@pulumi.type_token("aws-native:osis:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buffer_options: Optional[pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']]] = None,
                 encryption_at_rest_options: Optional[pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']]] = None,
                 log_publishing_options: Optional[pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']]] = None,
                 max_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_units: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_options: Optional[pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']]] = None,
                 __props__=None):
        """
        An OpenSearch Ingestion Service Data Prepper pipeline running Data Prepper.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']] buffer_options: Options that specify the configuration of a persistent buffer. To configure how OpenSearch Ingestion encrypts this data, set the `EncryptionAtRestOptions` . For more information, see [Persistent buffering](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering) .
        :param pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']] encryption_at_rest_options: Options to control how OpenSearch encrypts buffer data.
        :param pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']] log_publishing_options: Key-value pairs that represent log publishing settings.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The Data Prepper pipeline configuration.
        :param pulumi.Input[builtins.str] pipeline_name: Name of the OpenSearch Ingestion Service pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']] vpc_options: Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An OpenSearch Ingestion Service Data Prepper pipeline running Data Prepper.

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buffer_options: Optional[pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']]] = None,
                 encryption_at_rest_options: Optional[pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']]] = None,
                 log_publishing_options: Optional[pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']]] = None,
                 max_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_units: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_options: Optional[pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["buffer_options"] = buffer_options
            __props__.__dict__["encryption_at_rest_options"] = encryption_at_rest_options
            __props__.__dict__["log_publishing_options"] = log_publishing_options
            if max_units is None and not opts.urn:
                raise TypeError("Missing required property 'max_units'")
            __props__.__dict__["max_units"] = max_units
            if min_units is None and not opts.urn:
                raise TypeError("Missing required property 'min_units'")
            __props__.__dict__["min_units"] = min_units
            if pipeline_configuration_body is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_configuration_body'")
            __props__.__dict__["pipeline_configuration_body"] = pipeline_configuration_body
            __props__.__dict__["pipeline_name"] = pipeline_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_options"] = vpc_options
            __props__.__dict__["ingest_endpoint_urls"] = None
            __props__.__dict__["pipeline_arn"] = None
            __props__.__dict__["vpc_endpoint_service"] = None
            __props__.__dict__["vpc_endpoints"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["pipelineName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Pipeline, __self__).__init__(
            'aws-native:osis:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PipelineArgs.__new__(PipelineArgs)

        __props__.__dict__["buffer_options"] = None
        __props__.__dict__["encryption_at_rest_options"] = None
        __props__.__dict__["ingest_endpoint_urls"] = None
        __props__.__dict__["log_publishing_options"] = None
        __props__.__dict__["max_units"] = None
        __props__.__dict__["min_units"] = None
        __props__.__dict__["pipeline_arn"] = None
        __props__.__dict__["pipeline_configuration_body"] = None
        __props__.__dict__["pipeline_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_endpoint_service"] = None
        __props__.__dict__["vpc_endpoints"] = None
        __props__.__dict__["vpc_options"] = None
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> pulumi.Output[Optional['outputs.PipelineBufferOptions']]:
        """
        Options that specify the configuration of a persistent buffer. To configure how OpenSearch Ingestion encrypts this data, set the `EncryptionAtRestOptions` . For more information, see [Persistent buffering](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering) .
        """
        return pulumi.get(self, "buffer_options")

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> pulumi.Output[Optional['outputs.PipelineEncryptionAtRestOptions']]:
        """
        Options to control how OpenSearch encrypts buffer data.
        """
        return pulumi.get(self, "encryption_at_rest_options")

    @property
    @pulumi.getter(name="ingestEndpointUrls")
    def ingest_endpoint_urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of endpoints that can be used for ingesting data into a pipeline
        """
        return pulumi.get(self, "ingest_endpoint_urls")

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> pulumi.Output[Optional['outputs.PipelineLogPublishingOptions']]:
        """
        Key-value pairs that represent log publishing settings.
        """
        return pulumi.get(self, "log_publishing_options")

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> pulumi.Output[builtins.int]:
        """
        The maximum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "max_units")

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> pulumi.Output[builtins.int]:
        """
        The minimum pipeline capacity, in Ingestion OpenSearch Compute Units (OCUs).
        """
        return pulumi.get(self, "min_units")

    @property
    @pulumi.getter(name="pipelineArn")
    def pipeline_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "pipeline_arn")

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Output[builtins.str]:
        """
        The Data Prepper pipeline configuration.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the OpenSearch Ingestion Service pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
        """
        return pulumi.get(self, "pipeline_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpointService")
    def vpc_endpoint_service(self) -> pulumi.Output[builtins.str]:
        """
        The VPC endpoint service name for the pipeline.
        """
        return pulumi.get(self, "vpc_endpoint_service")

    @property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> pulumi.Output[Sequence['outputs.PipelineVpcEndpoint']]:
        """
        The VPC interface endpoints that have access to the pipeline.
        """
        return pulumi.get(self, "vpc_endpoints")

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> pulumi.Output[Optional['outputs.PipelineVpcOptions']]:
        """
        Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
        """
        return pulumi.get(self, "vpc_options")

