# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'PipelineBufferOptionsArgs',
    'PipelineBufferOptionsArgsDict',
    'PipelineEncryptionAtRestOptionsArgs',
    'PipelineEncryptionAtRestOptionsArgsDict',
    'PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs',
    'PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgsDict',
    'PipelineLogPublishingOptionsArgs',
    'PipelineLogPublishingOptionsArgsDict',
    'PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs',
    'PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgsDict',
    'PipelineVpcOptionsArgs',
    'PipelineVpcOptionsArgsDict',
]

MYPY = False

if not MYPY:
    class PipelineBufferOptionsArgsDict(TypedDict):
        """
        Key-value pairs to configure buffering.
        """
        persistent_buffer_enabled: pulumi.Input[builtins.bool]
        """
        Whether persistent buffering should be enabled.
        """
elif False:
    PipelineBufferOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineBufferOptionsArgs:
    def __init__(__self__, *,
                 persistent_buffer_enabled: pulumi.Input[builtins.bool]):
        """
        Key-value pairs to configure buffering.
        :param pulumi.Input[builtins.bool] persistent_buffer_enabled: Whether persistent buffering should be enabled.
        """
        pulumi.set(__self__, "persistent_buffer_enabled", persistent_buffer_enabled)

    @property
    @pulumi.getter(name="persistentBufferEnabled")
    def persistent_buffer_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether persistent buffering should be enabled.
        """
        return pulumi.get(self, "persistent_buffer_enabled")

    @persistent_buffer_enabled.setter
    def persistent_buffer_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "persistent_buffer_enabled", value)


if not MYPY:
    class PipelineEncryptionAtRestOptionsArgsDict(TypedDict):
        """
        Key-value pairs to configure encryption at rest.
        """
        kms_key_arn: pulumi.Input[builtins.str]
        """
        The KMS key to use for encrypting data. By default an AWS owned key is used
        """
elif False:
    PipelineEncryptionAtRestOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineEncryptionAtRestOptionsArgs:
    def __init__(__self__, *,
                 kms_key_arn: pulumi.Input[builtins.str]):
        """
        Key-value pairs to configure encryption at rest.
        :param pulumi.Input[builtins.str] kms_key_arn: The KMS key to use for encrypting data. By default an AWS owned key is used
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Input[builtins.str]:
        """
        The KMS key to use for encrypting data. By default an AWS owned key is used
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgsDict(TypedDict):
        """
        The destination for OpenSearch Ingestion Service logs sent to Amazon CloudWatch.
        """
        log_group: pulumi.Input[builtins.str]
elif False:
    PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs:
    def __init__(__self__, *,
                 log_group: pulumi.Input[builtins.str]):
        """
        The destination for OpenSearch Ingestion Service logs sent to Amazon CloudWatch.
        """
        pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_group", value)


if not MYPY:
    class PipelineLogPublishingOptionsArgsDict(TypedDict):
        """
        Key-value pairs to configure log publishing.
        """
        cloud_watch_log_destination: NotRequired[pulumi.Input['PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgsDict']]
        """
        The destination for OpenSearch Ingestion Service logs sent to Amazon CloudWatch.
        """
        is_logging_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether logs should be published.
        """
elif False:
    PipelineLogPublishingOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineLogPublishingOptionsArgs:
    def __init__(__self__, *,
                 cloud_watch_log_destination: Optional[pulumi.Input['PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs']] = None,
                 is_logging_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Key-value pairs to configure log publishing.
        :param pulumi.Input['PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs'] cloud_watch_log_destination: The destination for OpenSearch Ingestion Service logs sent to Amazon CloudWatch.
        :param pulumi.Input[builtins.bool] is_logging_enabled: Whether logs should be published.
        """
        if cloud_watch_log_destination is not None:
            pulumi.set(__self__, "cloud_watch_log_destination", cloud_watch_log_destination)
        if is_logging_enabled is not None:
            pulumi.set(__self__, "is_logging_enabled", is_logging_enabled)

    @property
    @pulumi.getter(name="cloudWatchLogDestination")
    def cloud_watch_log_destination(self) -> Optional[pulumi.Input['PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs']]:
        """
        The destination for OpenSearch Ingestion Service logs sent to Amazon CloudWatch.
        """
        return pulumi.get(self, "cloud_watch_log_destination")

    @cloud_watch_log_destination.setter
    def cloud_watch_log_destination(self, value: Optional[pulumi.Input['PipelineLogPublishingOptionsCloudWatchLogDestinationPropertiesArgs']]):
        pulumi.set(self, "cloud_watch_log_destination", value)

    @property
    @pulumi.getter(name="isLoggingEnabled")
    def is_logging_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether logs should be published.
        """
        return pulumi.get(self, "is_logging_enabled")

    @is_logging_enabled.setter
    def is_logging_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_logging_enabled", value)


if not MYPY:
    class PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgsDict(TypedDict):
        """
        Options for attaching a VPC to the pipeline.
        """
        attach_to_vpc: pulumi.Input[builtins.bool]
        """
        Whether the pipeline should be attached to the provided VPC
        """
        cidr_block: pulumi.Input[builtins.str]
        """
        The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
        """
elif False:
    PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs:
    def __init__(__self__, *,
                 attach_to_vpc: pulumi.Input[builtins.bool],
                 cidr_block: pulumi.Input[builtins.str]):
        """
        Options for attaching a VPC to the pipeline.
        :param pulumi.Input[builtins.bool] attach_to_vpc: Whether the pipeline should be attached to the provided VPC
        :param pulumi.Input[builtins.str] cidr_block: The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
        """
        pulumi.set(__self__, "attach_to_vpc", attach_to_vpc)
        pulumi.set(__self__, "cidr_block", cidr_block)

    @property
    @pulumi.getter(name="attachToVpc")
    def attach_to_vpc(self) -> pulumi.Input[builtins.bool]:
        """
        Whether the pipeline should be attached to the provided VPC
        """
        return pulumi.get(self, "attach_to_vpc")

    @attach_to_vpc.setter
    def attach_to_vpc(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "attach_to_vpc", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[builtins.str]:
        """
        The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cidr_block", value)


if not MYPY:
    class PipelineVpcOptionsArgsDict(TypedDict):
        """
        Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion Service creates the pipeline with a public endpoint.
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of subnet IDs associated with the VPC endpoint.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of security groups associated with the VPC endpoint.
        """
        vpc_attachment_options: NotRequired[pulumi.Input['PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgsDict']]
        """
        Options for attaching a VPC to the pipeline.
        """
        vpc_endpoint_management: NotRequired[pulumi.Input['PipelineVpcOptionsVpcEndpointManagement']]
        """
        Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the pipeline.
        """
elif False:
    PipelineVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PipelineVpcOptionsArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_attachment_options: Optional[pulumi.Input['PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs']] = None,
                 vpc_endpoint_management: Optional[pulumi.Input['PipelineVpcOptionsVpcEndpointManagement']] = None):
        """
        Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion Service creates the pipeline with a public endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs associated with the VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of security groups associated with the VPC endpoint.
        :param pulumi.Input['PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs'] vpc_attachment_options: Options for attaching a VPC to the pipeline.
        :param pulumi.Input['PipelineVpcOptionsVpcEndpointManagement'] vpc_endpoint_management: Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the pipeline.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_attachment_options is not None:
            pulumi.set(__self__, "vpc_attachment_options", vpc_attachment_options)
        if vpc_endpoint_management is not None:
            pulumi.set(__self__, "vpc_endpoint_management", vpc_endpoint_management)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of subnet IDs associated with the VPC endpoint.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of security groups associated with the VPC endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="vpcAttachmentOptions")
    def vpc_attachment_options(self) -> Optional[pulumi.Input['PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs']]:
        """
        Options for attaching a VPC to the pipeline.
        """
        return pulumi.get(self, "vpc_attachment_options")

    @vpc_attachment_options.setter
    def vpc_attachment_options(self, value: Optional[pulumi.Input['PipelineVpcOptionsVpcAttachmentOptionsPropertiesArgs']]):
        pulumi.set(self, "vpc_attachment_options", value)

    @property
    @pulumi.getter(name="vpcEndpointManagement")
    def vpc_endpoint_management(self) -> Optional[pulumi.Input['PipelineVpcOptionsVpcEndpointManagement']]:
        """
        Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the pipeline.
        """
        return pulumi.get(self, "vpc_endpoint_management")

    @vpc_endpoint_management.setter
    def vpc_endpoint_management(self, value: Optional[pulumi.Input['PipelineVpcOptionsVpcEndpointManagement']]):
        pulumi.set(self, "vpc_endpoint_management", value)


