# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    def __init__(__self__, account_id=None, account_name=None, arn=None, email=None, joined_method=None, joined_timestamp=None, parent_ids=None, status=None, tags=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if joined_method and not isinstance(joined_method, str):
            raise TypeError("Expected argument 'joined_method' to be a str")
        pulumi.set(__self__, "joined_method", joined_method)
        if joined_timestamp and not isinstance(joined_timestamp, str):
            raise TypeError("Expected argument 'joined_timestamp' to be a str")
        pulumi.set(__self__, "joined_timestamp", joined_timestamp)
        if parent_ids and not isinstance(parent_ids, list):
            raise TypeError("Expected argument 'parent_ids' to be a list")
        pulumi.set(__self__, "parent_ids", parent_ids)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        If the account was created successfully, the unique identifier (ID) of the new account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[builtins.str]:
        """
        The friendly name of the member account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the account.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        The email address of the owner to assign to the new member account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="joinedMethod")
    def joined_method(self) -> Optional['AccountJoinedMethod']:
        """
        The method by which the account joined the organization.
        """
        return pulumi.get(self, "joined_method")

    @property
    @pulumi.getter(name="joinedTimestamp")
    def joined_timestamp(self) -> Optional[builtins.str]:
        """
        The date the account became a part of the organization.
        """
        return pulumi.get(self, "joined_timestamp")

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of parent nodes for the member account. Currently only one parent at a time is supported. Default is root.
        """
        return pulumi.get(self, "parent_ids")

    @property
    @pulumi.getter
    def status(self) -> Optional['AccountStatus']:
        """
        The status of the account in the organization.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags that you want to attach to the newly created account. For each tag in the list, you must specify both a tag key and a value.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            account_id=self.account_id,
            account_name=self.account_name,
            arn=self.arn,
            email=self.email,
            joined_method=self.joined_method,
            joined_timestamp=self.joined_timestamp,
            parent_ids=self.parent_ids,
            status=self.status,
            tags=self.tags)


def get_account(account_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    You can use AWS::Organizations::Account to manage accounts in organization.


    :param builtins.str account_id: If the account was created successfully, the unique identifier (ID) of the new account.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:organizations:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        account_name=pulumi.get(__ret__, 'account_name'),
        arn=pulumi.get(__ret__, 'arn'),
        email=pulumi.get(__ret__, 'email'),
        joined_method=pulumi.get(__ret__, 'joined_method'),
        joined_timestamp=pulumi.get(__ret__, 'joined_timestamp'),
        parent_ids=pulumi.get(__ret__, 'parent_ids'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_account_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    You can use AWS::Organizations::Account to manage accounts in organization.


    :param builtins.str account_id: If the account was created successfully, the unique identifier (ID) of the new account.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:organizations:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        account_id=pulumi.get(__response__, 'account_id'),
        account_name=pulumi.get(__response__, 'account_name'),
        arn=pulumi.get(__response__, 'arn'),
        email=pulumi.get(__response__, 'email'),
        joined_method=pulumi.get(__response__, 'joined_method'),
        joined_timestamp=pulumi.get(__response__, 'joined_timestamp'),
        parent_ids=pulumi.get(__response__, 'parent_ids'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
