# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 instance_profile_arn: pulumi.Input[builtins.str],
                 instance_type: pulumi.Input[builtins.str],
                 service_role_arn: pulumi.Input[builtins.str],
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_count: Optional[pulumi.Input[builtins.int]] = None,
                 custom_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[builtins.str]] = None,
                 custom_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 disable_automated_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEngineAttributeArgs']]]] = None,
                 engine_model: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[builtins.str] instance_profile_arn: The ARN of the instance profile that your Amazon EC2 instances use.
        :param pulumi.Input[builtins.str] instance_type: The Amazon EC2 instance type to use. For example, `m5.large` .
        :param pulumi.Input[builtins.str] service_role_arn: The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Associate a public IP address with a server that you are launching. Valid values are `true` or `false` . The default value is `true` .
        :param pulumi.Input[builtins.str] backup_id: If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
        :param pulumi.Input[builtins.int] backup_retention_count: The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1` .
        :param pulumi.Input[builtins.str] custom_certificate: Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:
               
               - You can provide either a self-signed, custom certificate, or the full certificate chain.
               - The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
               - The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
               - The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain` .
               - The certificate must match the value of `CustomPrivateKey` .
        :param pulumi.Input[builtins.str] custom_domain: Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
        :param pulumi.Input[builtins.str] custom_private_key: Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
        :param pulumi.Input[builtins.bool] disable_automated_backup: Enable or disable scheduled backups. Valid values are `true` or `false` . The default value is `true` .
        :param pulumi.Input[builtins.str] engine: The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet` .
        :param pulumi.Input[Sequence[pulumi.Input['ServerEngineAttributeArgs']]] engine_attributes: Optional engine attributes on a specified server.
               
               **Attributes accepted in a Chef createServer request:** - `CHEF_AUTOMATE_PIVOTAL_KEY` : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( `\\n` ) characters at the end of each line of the pivotal key value.
               - `CHEF_AUTOMATE_ADMIN_PASSWORD` : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
               
               **Attributes accepted in a Puppet createServer request:** - `PUPPET_ADMIN_PASSWORD` : To work with the Puppet Enterprise console, a password must use ASCII characters.
               - `PUPPET_R10K_REMOTE` : The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
               - `PUPPET_R10K_PRIVATE_KEY` : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
        :param pulumi.Input[builtins.str] engine_model: The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
        :param pulumi.Input[builtins.str] engine_version: The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2` . For a Puppet server, valid values are `2019` or `2017` .
        :param pulumi.Input[builtins.str] key_pair: The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
        :param pulumi.Input[builtins.str] preferred_backup_window: The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:
               
               - `HH:MM` for daily backups
               - `DDD:HH:MM` for weekly backups
               
               `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
               
               *Example:* `08:00` , which represents a daily start time of 08:00 UTC.
               
               *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM` . `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.
               
               *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds` .
               
               If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
        :param pulumi.Input[builtins.str] server_name: The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The IDs of subnets in which to launch the server EC2 instance.
               
               Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
               
               EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
               
               For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html) .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
               
               - The key cannot be empty.
               - The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
               - The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
               - Leading and trailing spaces are trimmed from both the key and value.
               - A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.
        """
        pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "service_role_arn", service_role_arn)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if backup_retention_count is not None:
            pulumi.set(__self__, "backup_retention_count", backup_retention_count)
        if custom_certificate is not None:
            pulumi.set(__self__, "custom_certificate", custom_certificate)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if custom_private_key is not None:
            pulumi.set(__self__, "custom_private_key", custom_private_key)
        if disable_automated_backup is not None:
            pulumi.set(__self__, "disable_automated_backup", disable_automated_backup)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_attributes is not None:
            pulumi.set(__self__, "engine_attributes", engine_attributes)
        if engine_model is not None:
            pulumi.set(__self__, "engine_model", engine_model)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the instance profile that your Amazon EC2 instances use.
        """
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon EC2 instance type to use. For example, `m5.large` .
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Associate a public IP address with a server that you are launching. Valid values are `true` or `false` . The default value is `true` .
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="backupRetentionCount")
    def backup_retention_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1` .
        """
        return pulumi.get(self, "backup_retention_count")

    @backup_retention_count.setter
    def backup_retention_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_count", value)

    @property
    @pulumi.getter(name="customCertificate")
    def custom_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:

        - You can provide either a self-signed, custom certificate, or the full certificate chain.
        - The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
        - The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
        - The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain` .
        - The certificate must match the value of `CustomPrivateKey` .
        """
        return pulumi.get(self, "custom_certificate")

    @custom_certificate.setter
    def custom_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_certificate", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="customPrivateKey")
    def custom_private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
        """
        return pulumi.get(self, "custom_private_key")

    @custom_private_key.setter
    def custom_private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_private_key", value)

    @property
    @pulumi.getter(name="disableAutomatedBackup")
    def disable_automated_backup(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable scheduled backups. Valid values are `true` or `false` . The default value is `true` .
        """
        return pulumi.get(self, "disable_automated_backup")

    @disable_automated_backup.setter
    def disable_automated_backup(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_automated_backup", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet` .
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineAttributes")
    def engine_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerEngineAttributeArgs']]]]:
        """
        Optional engine attributes on a specified server.

        **Attributes accepted in a Chef createServer request:** - `CHEF_AUTOMATE_PIVOTAL_KEY` : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( `\\n` ) characters at the end of each line of the pivotal key value.
        - `CHEF_AUTOMATE_ADMIN_PASSWORD` : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.

        **Attributes accepted in a Puppet createServer request:** - `PUPPET_ADMIN_PASSWORD` : To work with the Puppet Enterprise console, a password must use ASCII characters.
        - `PUPPET_R10K_REMOTE` : The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
        - `PUPPET_R10K_PRIVATE_KEY` : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
        """
        return pulumi.get(self, "engine_attributes")

    @engine_attributes.setter
    def engine_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEngineAttributeArgs']]]]):
        pulumi.set(self, "engine_attributes", value)

    @property
    @pulumi.getter(name="engineModel")
    def engine_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
        """
        return pulumi.get(self, "engine_model")

    @engine_model.setter
    def engine_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_model", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2` . For a Puppet server, valid values are `2019` or `2017` .
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:

        - `HH:MM` for daily backups
        - `DDD:HH:MM` for weekly backups

        `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.

        *Example:* `08:00` , which represents a daily start time of 08:00 UTC.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM` . `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds` .

        If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of subnets in which to launch the server EC2 instance.

        Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.

        EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.

        For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html) .
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.

        - The key cannot be empty.
        - The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
        - The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
        - Leading and trailing spaces are trimmed from both the key and value.
        - A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:opsworkscm:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_count: Optional[pulumi.Input[builtins.int]] = None,
                 custom_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[builtins.str]] = None,
                 custom_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 disable_automated_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerEngineAttributeArgs', 'ServerEngineAttributeArgsDict']]]]] = None,
                 engine_model: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::OpsWorksCM::Server

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        pivotal_key = config.require("pivotalKey")
        password = config.require("password")
        my_chef_server = aws_native.opsworkscm.Server("myChefServer",
            backup_retention_count=12,
            custom_certificate="-----BEGIN CERTIFICATE----- EXAMPLEqEXAMPLE== -----END CERTIFICATE-----",
            custom_domain="https://aws.my-company.com",
            custom_private_key="-----BEGIN RSA PRIVATE KEY----- EXAMPLEqEXAMPLE= -----END RSA PRIVATE KEY-----",
            disable_automated_backup=False,
            engine="ChefAutomate",
            engine_version="2",
            engine_attributes=[
                {
                    "name": "CHEF_AUTOMATE_PIVOTAL_KEY",
                    "value": pivotal_key,
                },
                {
                    "name": "CHEF_AUTOMATE_ADMIN_PASSWORD",
                    "value": password,
                },
            ],
            engine_model="Single",
            instance_profile_arn="INSTANCE-PROFILE-ARN",
            instance_type="r5.xlarge",
            preferred_backup_window="08:00",
            preferred_maintenance_window="Fri:08:00",
            service_role_arn="SERVICE-ROLE-ARN",
            tags=[
                {
                    "key": "Stage",
                    "value": "Production",
                },
                {
                    "key": "Name",
                    "value": "test-owcm-server",
                },
            ])
        pulumi.export("endpoint", my_chef_server.endpoint)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Associate a public IP address with a server that you are launching. Valid values are `true` or `false` . The default value is `true` .
        :param pulumi.Input[builtins.str] backup_id: If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
        :param pulumi.Input[builtins.int] backup_retention_count: The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1` .
        :param pulumi.Input[builtins.str] custom_certificate: Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:
               
               - You can provide either a self-signed, custom certificate, or the full certificate chain.
               - The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
               - The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
               - The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain` .
               - The certificate must match the value of `CustomPrivateKey` .
        :param pulumi.Input[builtins.str] custom_domain: Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
        :param pulumi.Input[builtins.str] custom_private_key: Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
        :param pulumi.Input[builtins.bool] disable_automated_backup: Enable or disable scheduled backups. Valid values are `true` or `false` . The default value is `true` .
        :param pulumi.Input[builtins.str] engine: The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerEngineAttributeArgs', 'ServerEngineAttributeArgsDict']]]] engine_attributes: Optional engine attributes on a specified server.
               
               **Attributes accepted in a Chef createServer request:** - `CHEF_AUTOMATE_PIVOTAL_KEY` : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( `\\n` ) characters at the end of each line of the pivotal key value.
               - `CHEF_AUTOMATE_ADMIN_PASSWORD` : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.
               
               **Attributes accepted in a Puppet createServer request:** - `PUPPET_ADMIN_PASSWORD` : To work with the Puppet Enterprise console, a password must use ASCII characters.
               - `PUPPET_R10K_REMOTE` : The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
               - `PUPPET_R10K_PRIVATE_KEY` : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
        :param pulumi.Input[builtins.str] engine_model: The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
        :param pulumi.Input[builtins.str] engine_version: The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2` . For a Puppet server, valid values are `2019` or `2017` .
        :param pulumi.Input[builtins.str] instance_profile_arn: The ARN of the instance profile that your Amazon EC2 instances use.
        :param pulumi.Input[builtins.str] instance_type: The Amazon EC2 instance type to use. For example, `m5.large` .
        :param pulumi.Input[builtins.str] key_pair: The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
        :param pulumi.Input[builtins.str] preferred_backup_window: The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:
               
               - `HH:MM` for daily backups
               - `DDD:HH:MM` for weekly backups
               
               `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
               
               *Example:* `08:00` , which represents a daily start time of 08:00 UTC.
               
               *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM` . `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.
               
               *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds` .
               
               If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
        :param pulumi.Input[builtins.str] server_name: The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
        :param pulumi.Input[builtins.str] service_role_arn: The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The IDs of subnets in which to launch the server EC2 instance.
               
               Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
               
               EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
               
               For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
               
               - The key cannot be empty.
               - The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
               - The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
               - Leading and trailing spaces are trimmed from both the key and value.
               - A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::OpsWorksCM::Server

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        pivotal_key = config.require("pivotalKey")
        password = config.require("password")
        my_chef_server = aws_native.opsworkscm.Server("myChefServer",
            backup_retention_count=12,
            custom_certificate="-----BEGIN CERTIFICATE----- EXAMPLEqEXAMPLE== -----END CERTIFICATE-----",
            custom_domain="https://aws.my-company.com",
            custom_private_key="-----BEGIN RSA PRIVATE KEY----- EXAMPLEqEXAMPLE= -----END RSA PRIVATE KEY-----",
            disable_automated_backup=False,
            engine="ChefAutomate",
            engine_version="2",
            engine_attributes=[
                {
                    "name": "CHEF_AUTOMATE_PIVOTAL_KEY",
                    "value": pivotal_key,
                },
                {
                    "name": "CHEF_AUTOMATE_ADMIN_PASSWORD",
                    "value": password,
                },
            ],
            engine_model="Single",
            instance_profile_arn="INSTANCE-PROFILE-ARN",
            instance_type="r5.xlarge",
            preferred_backup_window="08:00",
            preferred_maintenance_window="Fri:08:00",
            service_role_arn="SERVICE-ROLE-ARN",
            tags=[
                {
                    "key": "Stage",
                    "value": "Production",
                },
                {
                    "key": "Name",
                    "value": "test-owcm-server",
                },
            ])
        pulumi.export("endpoint", my_chef_server.endpoint)

        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_id: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_count: Optional[pulumi.Input[builtins.int]] = None,
                 custom_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[builtins.str]] = None,
                 custom_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 disable_automated_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerEngineAttributeArgs', 'ServerEngineAttributeArgsDict']]]]] = None,
                 engine_model: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 instance_profile_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 server_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["backup_retention_count"] = backup_retention_count
            __props__.__dict__["custom_certificate"] = custom_certificate
            __props__.__dict__["custom_domain"] = custom_domain
            __props__.__dict__["custom_private_key"] = custom_private_key
            __props__.__dict__["disable_automated_backup"] = disable_automated_backup
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_attributes"] = engine_attributes
            __props__.__dict__["engine_model"] = engine_model
            __props__.__dict__["engine_version"] = engine_version
            if instance_profile_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_profile_arn'")
            __props__.__dict__["instance_profile_arn"] = instance_profile_arn
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["server_name"] = server_name
            if service_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_role_arn'")
            __props__.__dict__["service_role_arn"] = service_role_arn
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["associatePublicIpAddress", "backupId", "customCertificate", "customDomain", "customPrivateKey", "engine", "engineModel", "engineVersion", "instanceProfileArn", "instanceType", "keyPair", "securityGroupIds[*]", "serverName", "serviceRoleArn", "subnetIds[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Server, __self__).__init__(
            'aws-native:opsworkscm:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServerArgs.__new__(ServerArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["associate_public_ip_address"] = None
        __props__.__dict__["backup_id"] = None
        __props__.__dict__["backup_retention_count"] = None
        __props__.__dict__["custom_certificate"] = None
        __props__.__dict__["custom_domain"] = None
        __props__.__dict__["custom_private_key"] = None
        __props__.__dict__["disable_automated_backup"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_attributes"] = None
        __props__.__dict__["engine_model"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["instance_profile_arn"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["key_pair"] = None
        __props__.__dict__["preferred_backup_window"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["server_name"] = None
        __props__.__dict__["service_role_arn"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the server, such as `arn:aws:OpsWorksCM:us-east-1:123456789012:server/server-a1bzhi` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Associate a public IP address with a server that you are launching. Valid values are `true` or `false` . The default value is `true` .
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="backupRetentionCount")
    def backup_retention_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of automated backups that you want to keep. Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is `1` .
        """
        return pulumi.get(self, "backup_retention_count")

    @property
    @pulumi.getter(name="customCertificate")
    def custom_certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:

        - You can provide either a self-signed, custom certificate, or the full certificate chain.
        - The certificate must be a valid X509 certificate, or a certificate chain in PEM format.
        - The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's `NotBefore` date), or after it expires (the certificate's `NotAfter` date).
        - The certificate’s common name or subject alternative names (SANs), if present, must match the value of `CustomDomain` .
        - The certificate must match the value of `CustomPrivateKey` .
        """
        return pulumi.get(self, "custom_certificate")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="customPrivateKey")
    def custom_private_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
        """
        return pulumi.get(self, "custom_private_key")

    @property
    @pulumi.getter(name="disableAutomatedBackup")
    def disable_automated_backup(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable scheduled backups. Valid values are `true` or `false` . The default value is `true` .
        """
        return pulumi.get(self, "disable_automated_backup")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        A DNS name that can be used to access the engine. Example: `myserver-asdfghjkl.us-east-1.opsworks.io` .
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The configuration management engine to use. Valid values include `ChefAutomate` and `Puppet` .
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineAttributes")
    def engine_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.ServerEngineAttribute']]]:
        """
        Optional engine attributes on a specified server.

        **Attributes accepted in a Chef createServer request:** - `CHEF_AUTOMATE_PIVOTAL_KEY` : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( `\\n` ) characters at the end of each line of the pivotal key value.
        - `CHEF_AUTOMATE_ADMIN_PASSWORD` : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/@#$%^&+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.

        **Attributes accepted in a Puppet createServer request:** - `PUPPET_ADMIN_PASSWORD` : To work with the Puppet Enterprise console, a password must use ASCII characters.
        - `PUPPET_R10K_REMOTE` : The r10k remote is the URL of your control repository (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.
        - `PUPPET_R10K_PRIVATE_KEY` : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
        """
        return pulumi.get(self, "engine_attributes")

    @property
    @pulumi.getter(name="engineModel")
    def engine_model(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The engine model of the server. Valid values in this release include `Monolithic` for Puppet and `Single` for Chef.
        """
        return pulumi.get(self, "engine_model")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The major release version of the engine that you want to use. For a Chef server, the valid value for EngineVersion is currently `2` . For a Puppet server, valid values are `2019` or `2017` .
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the instance profile that your Amazon EC2 instances use.
        """
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon EC2 instance type to use. For example, `m5.large` .
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon EC2 key pair to set for the instance. This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. Valid values must be specified in one of the following formats:

        - `HH:MM` for daily backups
        - `DDD:HH:MM` for weekly backups

        `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.

        *Example:* `08:00` , which represents a daily start time of 08:00 UTC.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. Valid values must be specified in the following format: `DDD:HH:MM` . `MM` must be specified as `00` . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See `TimeWindowDefinition` for more information.

        *Example:* `Mon:08:00` , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of security group IDs to attach to the Amazon EC2 instance. If you add this parameter, the specified security groups must be within the VPC that is specified by `SubnetIds` .

        If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the server. The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The service role that the AWS OpsWorks CM service backend uses to work with your account. Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of subnets in which to launch the server EC2 instance.

        Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.

        EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.

        For more information about supported Amazon EC2 platforms, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html) .
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.

        - The key cannot be empty.
        - The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
        - The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : / @`
        - Leading and trailing spaces are trimmed from both the key and value.
        - A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.
        """
        return pulumi.get(self, "tags")

