# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, app_configs=None, arn=None, data_sources=None, endpoint=None, iam_identity_center_options=None, id=None, tags=None):
        if app_configs and not isinstance(app_configs, list):
            raise TypeError("Expected argument 'app_configs' to be a list")
        pulumi.set(__self__, "app_configs", app_configs)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if data_sources and not isinstance(data_sources, list):
            raise TypeError("Expected argument 'data_sources' to be a list")
        pulumi.set(__self__, "data_sources", data_sources)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if iam_identity_center_options and not isinstance(iam_identity_center_options, dict):
            raise TypeError("Expected argument 'iam_identity_center_options' to be a dict")
        pulumi.set(__self__, "iam_identity_center_options", iam_identity_center_options)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appConfigs")
    def app_configs(self) -> Optional[Sequence['outputs.ApplicationAppConfig']]:
        """
        List of application configurations.
        """
        return pulumi.get(self, "app_configs")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) format.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[Sequence['outputs.ApplicationDataSource']]:
        """
        List of data sources.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        The endpoint for the application.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> Optional['outputs.IamIdentityCenterOptionsProperties']:
        """
        Options for configuring IAM Identity Center
        """
        return pulumi.get(self, "iam_identity_center_options")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier of the application.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this application.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            app_configs=self.app_configs,
            arn=self.arn,
            data_sources=self.data_sources,
            endpoint=self.endpoint,
            iam_identity_center_options=self.iam_identity_center_options,
            id=self.id,
            tags=self.tags)


def get_application(name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Amazon OpenSearchService application resource


    :param builtins.str name: The name of the application.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchservice:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        app_configs=pulumi.get(__ret__, 'app_configs'),
        arn=pulumi.get(__ret__, 'arn'),
        data_sources=pulumi.get(__ret__, 'data_sources'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        iam_identity_center_options=pulumi.get(__ret__, 'iam_identity_center_options'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_application_output(name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Amazon OpenSearchService application resource


    :param builtins.str name: The name of the application.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchservice:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        app_configs=pulumi.get(__response__, 'app_configs'),
        arn=pulumi.get(__response__, 'arn'),
        data_sources=pulumi.get(__response__, 'data_sources'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        iam_identity_center_options=pulumi.get(__response__, 'iam_identity_center_options'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
