# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 app_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppConfigArgs']]]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationDataSourceArgs']]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input['IamIdentityCenterOptionsPropertiesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationAppConfigArgs']]] app_configs: List of application configurations.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationDataSourceArgs']]] data_sources: List of data sources.
        :param pulumi.Input[builtins.str] endpoint: The endpoint for the application.
        :param pulumi.Input['IamIdentityCenterOptionsPropertiesArgs'] iam_identity_center_options: Options for configuring IAM Identity Center
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this application.
        """
        if app_configs is not None:
            pulumi.set(__self__, "app_configs", app_configs)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if iam_identity_center_options is not None:
            pulumi.set(__self__, "iam_identity_center_options", iam_identity_center_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appConfigs")
    def app_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppConfigArgs']]]]:
        """
        List of application configurations.
        """
        return pulumi.get(self, "app_configs")

    @app_configs.setter
    def app_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationAppConfigArgs']]]]):
        pulumi.set(self, "app_configs", value)

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationDataSourceArgs']]]]:
        """
        List of data sources.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationDataSourceArgs']]]]):
        pulumi.set(self, "data_sources", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint for the application.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> Optional[pulumi.Input['IamIdentityCenterOptionsPropertiesArgs']]:
        """
        Options for configuring IAM Identity Center
        """
        return pulumi.get(self, "iam_identity_center_options")

    @iam_identity_center_options.setter
    def iam_identity_center_options(self, value: Optional[pulumi.Input['IamIdentityCenterOptionsPropertiesArgs']]):
        pulumi.set(self, "iam_identity_center_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:opensearchservice:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppConfigArgs', 'ApplicationAppConfigArgsDict']]]]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationDataSourceArgs', 'ApplicationDataSourceArgsDict']]]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input[Union['IamIdentityCenterOptionsPropertiesArgs', 'IamIdentityCenterOptionsPropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Amazon OpenSearchService application resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppConfigArgs', 'ApplicationAppConfigArgsDict']]]] app_configs: List of application configurations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationDataSourceArgs', 'ApplicationDataSourceArgsDict']]]] data_sources: List of data sources.
        :param pulumi.Input[builtins.str] endpoint: The endpoint for the application.
        :param pulumi.Input[Union['IamIdentityCenterOptionsPropertiesArgs', 'IamIdentityCenterOptionsPropertiesArgsDict']] iam_identity_center_options: Options for configuring IAM Identity Center
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Amazon OpenSearchService application resource

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationAppConfigArgs', 'ApplicationAppConfigArgsDict']]]]] = None,
                 data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationDataSourceArgs', 'ApplicationDataSourceArgsDict']]]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input[Union['IamIdentityCenterOptionsPropertiesArgs', 'IamIdentityCenterOptionsPropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["app_configs"] = app_configs
            __props__.__dict__["data_sources"] = data_sources
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["iam_identity_center_options"] = iam_identity_center_options
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Application, __self__).__init__(
            'aws-native:opensearchservice:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["app_configs"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["data_sources"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["iam_identity_center_options"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appConfigs")
    def app_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationAppConfig']]]:
        """
        List of application configurations.
        """
        return pulumi.get(self, "app_configs")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) format.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the application.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationDataSource']]]:
        """
        List of data sources.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The endpoint for the application.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> pulumi.Output[Optional['outputs.IamIdentityCenterOptionsProperties']]:
        """
        Options for configuring IAM Identity Center
        """
        return pulumi.get(self, "iam_identity_center_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this application.
        """
        return pulumi.get(self, "tags")

