# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SecurityConfigArgs', 'SecurityConfig']

@pulumi.input_type
class SecurityConfigArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input['SecurityConfigIamIdentityCenterConfigOptionsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 saml_options: Optional[pulumi.Input['SecurityConfigSamlConfigOptionsArgs']] = None,
                 type: Optional[pulumi.Input['SecurityConfigType']] = None):
        """
        The set of arguments for constructing a SecurityConfig resource.
        :param pulumi.Input[builtins.str] description: Security config description
        :param pulumi.Input['SecurityConfigIamIdentityCenterConfigOptionsArgs'] iam_identity_center_options: Describes IAM Identity Center options in the form of a key-value map.
        :param pulumi.Input[builtins.str] name: The friendly name of the security config
        :param pulumi.Input['SecurityConfigSamlConfigOptionsArgs'] saml_options: SAML options for the security configuration in the form of a key-value map.
        :param pulumi.Input['SecurityConfigType'] type: The type of security configuration. Currently the only option is `saml` .
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_identity_center_options is not None:
            pulumi.set(__self__, "iam_identity_center_options", iam_identity_center_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml_options is not None:
            pulumi.set(__self__, "saml_options", saml_options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Security config description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> Optional[pulumi.Input['SecurityConfigIamIdentityCenterConfigOptionsArgs']]:
        """
        Describes IAM Identity Center options in the form of a key-value map.
        """
        return pulumi.get(self, "iam_identity_center_options")

    @iam_identity_center_options.setter
    def iam_identity_center_options(self, value: Optional[pulumi.Input['SecurityConfigIamIdentityCenterConfigOptionsArgs']]):
        pulumi.set(self, "iam_identity_center_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name of the security config
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> Optional[pulumi.Input['SecurityConfigSamlConfigOptionsArgs']]:
        """
        SAML options for the security configuration in the form of a key-value map.
        """
        return pulumi.get(self, "saml_options")

    @saml_options.setter
    def saml_options(self, value: Optional[pulumi.Input['SecurityConfigSamlConfigOptionsArgs']]):
        pulumi.set(self, "saml_options", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['SecurityConfigType']]:
        """
        The type of security configuration. Currently the only option is `saml` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['SecurityConfigType']]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws-native:opensearchserverless:SecurityConfig")
class SecurityConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input[Union['SecurityConfigIamIdentityCenterConfigOptionsArgs', 'SecurityConfigIamIdentityCenterConfigOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 saml_options: Optional[pulumi.Input[Union['SecurityConfigSamlConfigOptionsArgs', 'SecurityConfigSamlConfigOptionsArgsDict']]] = None,
                 type: Optional[pulumi.Input['SecurityConfigType']] = None,
                 __props__=None):
        """
        Amazon OpenSearchServerless security config resource

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        test_security_config = aws_native.opensearchserverless.SecurityConfig("testSecurityConfig",
            name="my-provider",
            type=aws_native.opensearchserverless.SecurityConfigType.SAML,
            description="Serverless SAML configuration",
            saml_options={
                "metadata": "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?><md:EntityDescriptor entityID=\\"http://www.okta.com/foobar\\" xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\"><md:IDPSSODescriptor WantAuthnRequestsSigned=\\"false\\" protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"><md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>Mfoobar</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</md:NameIDFormat><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
                "user_attribute": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier",
                "group_attribute": "ALLGroups",
                "session_timeout": 120,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        test_security_config = aws_native.opensearchserverless.SecurityConfig("testSecurityConfig",
            name="my-provider",
            type=aws_native.opensearchserverless.SecurityConfigType.SAML,
            description="Serverless SAML configuration",
            saml_options={
                "metadata": "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?><md:EntityDescriptor entityID=\\"http://www.okta.com/foobar\\" xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\"><md:IDPSSODescriptor WantAuthnRequestsSigned=\\"false\\" protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"><md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>Mfoobar</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</md:NameIDFormat><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
                "user_attribute": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier",
                "group_attribute": "ALLGroups",
                "session_timeout": 120,
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Security config description
        :param pulumi.Input[Union['SecurityConfigIamIdentityCenterConfigOptionsArgs', 'SecurityConfigIamIdentityCenterConfigOptionsArgsDict']] iam_identity_center_options: Describes IAM Identity Center options in the form of a key-value map.
        :param pulumi.Input[builtins.str] name: The friendly name of the security config
        :param pulumi.Input[Union['SecurityConfigSamlConfigOptionsArgs', 'SecurityConfigSamlConfigOptionsArgsDict']] saml_options: SAML options for the security configuration in the form of a key-value map.
        :param pulumi.Input['SecurityConfigType'] type: The type of security configuration. Currently the only option is `saml` .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Amazon OpenSearchServerless security config resource

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        test_security_config = aws_native.opensearchserverless.SecurityConfig("testSecurityConfig",
            name="my-provider",
            type=aws_native.opensearchserverless.SecurityConfigType.SAML,
            description="Serverless SAML configuration",
            saml_options={
                "metadata": "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?><md:EntityDescriptor entityID=\\"http://www.okta.com/foobar\\" xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\"><md:IDPSSODescriptor WantAuthnRequestsSigned=\\"false\\" protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"><md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>Mfoobar</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</md:NameIDFormat><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
                "user_attribute": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier",
                "group_attribute": "ALLGroups",
                "session_timeout": 120,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        test_security_config = aws_native.opensearchserverless.SecurityConfig("testSecurityConfig",
            name="my-provider",
            type=aws_native.opensearchserverless.SecurityConfigType.SAML,
            description="Serverless SAML configuration",
            saml_options={
                "metadata": "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?><md:EntityDescriptor entityID=\\"http://www.okta.com/foobar\\" xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\"><md:IDPSSODescriptor WantAuthnRequestsSigned=\\"false\\" protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"><md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>Mfoobar</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</md:NameIDFormat><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://trial-1234567.okta.com/app/trial-1234567_saml2_1/foobar/sso/saml\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
                "user_attribute": "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier",
                "group_attribute": "ALLGroups",
                "session_timeout": 120,
            })

        ```

        :param str resource_name: The name of the resource.
        :param SecurityConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iam_identity_center_options: Optional[pulumi.Input[Union['SecurityConfigIamIdentityCenterConfigOptionsArgs', 'SecurityConfigIamIdentityCenterConfigOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 saml_options: Optional[pulumi.Input[Union['SecurityConfigSamlConfigOptionsArgs', 'SecurityConfigSamlConfigOptionsArgsDict']]] = None,
                 type: Optional[pulumi.Input['SecurityConfigType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityConfigArgs.__new__(SecurityConfigArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["iam_identity_center_options"] = iam_identity_center_options
            __props__.__dict__["name"] = name
            __props__.__dict__["saml_options"] = saml_options
            __props__.__dict__["type"] = type
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["iamIdentityCenterOptions.instanceArn", "name", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SecurityConfig, __self__).__init__(
            'aws-native:opensearchserverless:SecurityConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecurityConfig':
        """
        Get an existing SecurityConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecurityConfigArgs.__new__(SecurityConfigArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["iam_identity_center_options"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["saml_options"] = None
        __props__.__dict__["type"] = None
        return SecurityConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the security config
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Security config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> pulumi.Output[Optional['outputs.SecurityConfigIamIdentityCenterConfigOptions']]:
        """
        Describes IAM Identity Center options in the form of a key-value map.
        """
        return pulumi.get(self, "iam_identity_center_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The friendly name of the security config
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> pulumi.Output[Optional['outputs.SecurityConfigSamlConfigOptions']]:
        """
        SAML options for the security configuration in the form of a key-value map.
        """
        return pulumi.get(self, "saml_options")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional['SecurityConfigType']]:
        """
        The type of security configuration. Currently the only option is `saml` .
        """
        return pulumi.get(self, "type")

