# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'IndexPropertyMapping',
    'IndexPropertyMappingMethodProperties',
    'IndexPropertyMappingMethodPropertiesParametersProperties',
    'IndexSettings',
    'IndexSettingsIndexProperties',
    'MappingsProperties',
    'SecurityConfigIamIdentityCenterConfigOptions',
    'SecurityConfigSamlConfigOptions',
]

@pulumi.output_type
class IndexPropertyMapping(dict):
    def __init__(__self__, *,
                 type: 'IndexPropertyMappingType',
                 dimension: Optional[builtins.int] = None,
                 index: Optional[builtins.bool] = None,
                 method: Optional['outputs.IndexPropertyMappingMethodProperties'] = None,
                 properties: Optional[Mapping[str, 'outputs.IndexPropertyMapping']] = None,
                 value: Optional[builtins.str] = None):
        """
        :param 'IndexPropertyMappingType' type: The field data type. Must be a valid OpenSearch field type.
        :param builtins.int dimension: Dimension size for vector fields, defines the number of dimensions in the vector
        :param builtins.bool index: Whether a field should be indexed
        :param 'IndexPropertyMappingMethodProperties' method: Configuration for k-NN search method
        :param Mapping[str, 'IndexPropertyMapping'] properties: Nested fields within an object or nested field type
        :param builtins.str value: Default value for the field when not specified in a document
        """
        pulumi.set(__self__, "type", type)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> 'IndexPropertyMappingType':
        """
        The field data type. Must be a valid OpenSearch field type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dimension(self) -> Optional[builtins.int]:
        """
        Dimension size for vector fields, defines the number of dimensions in the vector
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter
    def index(self) -> Optional[builtins.bool]:
        """
        Whether a field should be indexed
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def method(self) -> Optional['outputs.IndexPropertyMappingMethodProperties']:
        """
        Configuration for k-NN search method
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.IndexPropertyMapping']]:
        """
        Nested fields within an object or nested field type
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Default value for the field when not specified in a document
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IndexPropertyMappingMethodProperties(dict):
    """
    Configuration for k-NN search method
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spaceType":
            suggest = "space_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexPropertyMappingMethodProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexPropertyMappingMethodProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexPropertyMappingMethodProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engine: 'IndexPropertyMappingMethodPropertiesEngine',
                 name: 'IndexPropertyMappingMethodPropertiesName',
                 parameters: Optional['outputs.IndexPropertyMappingMethodPropertiesParametersProperties'] = None,
                 space_type: Optional['IndexPropertyMappingMethodPropertiesSpaceType'] = None):
        """
        Configuration for k-NN search method
        :param 'IndexPropertyMappingMethodPropertiesEngine' engine: The k-NN search engine to use
        :param 'IndexPropertyMappingMethodPropertiesName' name: The algorithm name for k-NN search
        :param 'IndexPropertyMappingMethodPropertiesParametersProperties' parameters: Additional parameters for the k-NN algorithm
        :param 'IndexPropertyMappingMethodPropertiesSpaceType' space_type: The distance function used for k-NN search
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if space_type is not None:
            pulumi.set(__self__, "space_type", space_type)

    @property
    @pulumi.getter
    def engine(self) -> 'IndexPropertyMappingMethodPropertiesEngine':
        """
        The k-NN search engine to use
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def name(self) -> 'IndexPropertyMappingMethodPropertiesName':
        """
        The algorithm name for k-NN search
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.IndexPropertyMappingMethodPropertiesParametersProperties']:
        """
        Additional parameters for the k-NN algorithm
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="spaceType")
    def space_type(self) -> Optional['IndexPropertyMappingMethodPropertiesSpaceType']:
        """
        The distance function used for k-NN search
        """
        return pulumi.get(self, "space_type")


@pulumi.output_type
class IndexPropertyMappingMethodPropertiesParametersProperties(dict):
    """
    Additional parameters for the k-NN algorithm
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efConstruction":
            suggest = "ef_construction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexPropertyMappingMethodPropertiesParametersProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexPropertyMappingMethodPropertiesParametersProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexPropertyMappingMethodPropertiesParametersProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ef_construction: Optional[builtins.int] = None,
                 m: Optional[builtins.int] = None):
        """
        Additional parameters for the k-NN algorithm
        :param builtins.int ef_construction: The size of the dynamic list used during k-NN graph creation
        :param builtins.int m: Number of neighbors to consider during k-NN search
        """
        if ef_construction is not None:
            pulumi.set(__self__, "ef_construction", ef_construction)
        if m is not None:
            pulumi.set(__self__, "m", m)

    @property
    @pulumi.getter(name="efConstruction")
    def ef_construction(self) -> Optional[builtins.int]:
        """
        The size of the dynamic list used during k-NN graph creation
        """
        return pulumi.get(self, "ef_construction")

    @property
    @pulumi.getter
    def m(self) -> Optional[builtins.int]:
        """
        Number of neighbors to consider during k-NN search
        """
        return pulumi.get(self, "m")


@pulumi.output_type
class IndexSettings(dict):
    def __init__(__self__, *,
                 index: Optional['outputs.IndexSettingsIndexProperties'] = None):
        """
        :param 'IndexSettingsIndexProperties' index: Index settings.
        """
        if index is not None:
            pulumi.set(__self__, "index", index)

    @property
    @pulumi.getter
    def index(self) -> Optional['outputs.IndexSettingsIndexProperties']:
        """
        Index settings.
        """
        return pulumi.get(self, "index")


@pulumi.output_type
class IndexSettingsIndexProperties(dict):
    """
    Index settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knnAlgoParamEfSearch":
            suggest = "knn_algo_param_ef_search"
        elif key == "refreshInterval":
            suggest = "refresh_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexSettingsIndexProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexSettingsIndexProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexSettingsIndexProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 knn: Optional[builtins.bool] = None,
                 knn_algo_param_ef_search: Optional[builtins.int] = None,
                 refresh_interval: Optional[builtins.str] = None):
        """
        Index settings.
        :param builtins.bool knn: Enable/disable k-nearest neighbor search capability
        :param builtins.int knn_algo_param_ef_search: Size of the dynamic list for the nearest neighbors
        :param builtins.str refresh_interval: How often to perform refresh operation (e.g. '1s', '5s')
        """
        if knn is not None:
            pulumi.set(__self__, "knn", knn)
        if knn_algo_param_ef_search is not None:
            pulumi.set(__self__, "knn_algo_param_ef_search", knn_algo_param_ef_search)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)

    @property
    @pulumi.getter
    def knn(self) -> Optional[builtins.bool]:
        """
        Enable/disable k-nearest neighbor search capability
        """
        return pulumi.get(self, "knn")

    @property
    @pulumi.getter(name="knnAlgoParamEfSearch")
    def knn_algo_param_ef_search(self) -> Optional[builtins.int]:
        """
        Size of the dynamic list for the nearest neighbors
        """
        return pulumi.get(self, "knn_algo_param_ef_search")

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[builtins.str]:
        """
        How often to perform refresh operation (e.g. '1s', '5s')
        """
        return pulumi.get(self, "refresh_interval")


@pulumi.output_type
class MappingsProperties(dict):
    """
    Index Mappings
    """
    def __init__(__self__, *,
                 properties: Optional[Mapping[str, 'outputs.IndexPropertyMapping']] = None):
        """
        Index Mappings
        :param Mapping[str, 'IndexPropertyMapping'] properties: Defines the fields within the mapping, including their types and configurations
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.IndexPropertyMapping']]:
        """
        Defines the fields within the mapping, including their types and configurations
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SecurityConfigIamIdentityCenterConfigOptions(dict):
    """
    Describes IAM Identity Center options for an OpenSearch Serverless security configuration in the form of a key-value map
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceArn":
            suggest = "instance_arn"
        elif key == "applicationArn":
            suggest = "application_arn"
        elif key == "applicationDescription":
            suggest = "application_description"
        elif key == "applicationName":
            suggest = "application_name"
        elif key == "groupAttribute":
            suggest = "group_attribute"
        elif key == "userAttribute":
            suggest = "user_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigIamIdentityCenterConfigOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigIamIdentityCenterConfigOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigIamIdentityCenterConfigOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_arn: builtins.str,
                 application_arn: Optional[builtins.str] = None,
                 application_description: Optional[builtins.str] = None,
                 application_name: Optional[builtins.str] = None,
                 group_attribute: Optional[builtins.str] = None,
                 user_attribute: Optional[builtins.str] = None):
        """
        Describes IAM Identity Center options for an OpenSearch Serverless security configuration in the form of a key-value map
        :param builtins.str instance_arn: The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
        :param builtins.str application_arn: The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
        :param builtins.str application_description: The description of the IAM Identity Center application used to integrate with OpenSearch Serverless
        :param builtins.str application_name: The name of the IAM Identity Center application used to integrate with OpenSearch Serverless
        :param builtins.str group_attribute: The group attribute for this IAM Identity Center integration. Defaults to `GroupId` .
        :param builtins.str user_attribute: The user attribute for this IAM Identity Center integration. Defaults to `UserId`
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if application_description is not None:
            pulumi.set(__self__, "application_description", application_description)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if user_attribute is not None:
            pulumi.set(__self__, "user_attribute", user_attribute)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> builtins.str:
        """
        The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationDescription")
    def application_description(self) -> Optional[builtins.str]:
        """
        The description of the IAM Identity Center application used to integrate with OpenSearch Serverless
        """
        return pulumi.get(self, "application_description")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[builtins.str]:
        """
        The name of the IAM Identity Center application used to integrate with OpenSearch Serverless
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[builtins.str]:
        """
        The group attribute for this IAM Identity Center integration. Defaults to `GroupId` .
        """
        return pulumi.get(self, "group_attribute")

    @property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> Optional[builtins.str]:
        """
        The user attribute for this IAM Identity Center integration. Defaults to `UserId`
        """
        return pulumi.get(self, "user_attribute")


@pulumi.output_type
class SecurityConfigSamlConfigOptions(dict):
    """
    Describes saml options in form of key value map
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupAttribute":
            suggest = "group_attribute"
        elif key == "openSearchServerlessEntityId":
            suggest = "open_search_serverless_entity_id"
        elif key == "sessionTimeout":
            suggest = "session_timeout"
        elif key == "userAttribute":
            suggest = "user_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigSamlConfigOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigSamlConfigOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigSamlConfigOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata: builtins.str,
                 group_attribute: Optional[builtins.str] = None,
                 open_search_serverless_entity_id: Optional[builtins.str] = None,
                 session_timeout: Optional[builtins.int] = None,
                 user_attribute: Optional[builtins.str] = None):
        """
        Describes saml options in form of key value map
        :param builtins.str metadata: The XML saml provider metadata document that you want to use
        :param builtins.str group_attribute: Group attribute for this saml integration
        :param builtins.str open_search_serverless_entity_id: Custom entity id attribute to override default entity id for this saml integration
        :param builtins.int session_timeout: Defines the session timeout in minutes
        :param builtins.str user_attribute: Custom attribute for this saml integration
        """
        pulumi.set(__self__, "metadata", metadata)
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if open_search_serverless_entity_id is not None:
            pulumi.set(__self__, "open_search_serverless_entity_id", open_search_serverless_entity_id)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if user_attribute is not None:
            pulumi.set(__self__, "user_attribute", user_attribute)

    @property
    @pulumi.getter
    def metadata(self) -> builtins.str:
        """
        The XML saml provider metadata document that you want to use
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[builtins.str]:
        """
        Group attribute for this saml integration
        """
        return pulumi.get(self, "group_attribute")

    @property
    @pulumi.getter(name="openSearchServerlessEntityId")
    def open_search_serverless_entity_id(self) -> Optional[builtins.str]:
        """
        Custom entity id attribute to override default entity id for this saml integration
        """
        return pulumi.get(self, "open_search_serverless_entity_id")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[builtins.int]:
        """
        Defines the session timeout in minutes
        """
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> Optional[builtins.str]:
        """
        Custom attribute for this saml integration
        """
        return pulumi.get(self, "user_attribute")


