# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 collection_endpoint: pulumi.Input[builtins.str],
                 index_name: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input['MappingsPropertiesArgs']] = None,
                 settings: Optional[pulumi.Input['IndexSettingsArgs']] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[builtins.str] collection_endpoint: The endpoint for the collection.
        :param pulumi.Input[builtins.str] index_name: The name of the OpenSearch Serverless index.
        :param pulumi.Input['MappingsPropertiesArgs'] mappings: Index Mappings
        :param pulumi.Input['IndexSettingsArgs'] settings: Index settings
        """
        pulumi.set(__self__, "collection_endpoint", collection_endpoint)
        if index_name is not None:
            pulumi.set(__self__, "index_name", index_name)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="collectionEndpoint")
    def collection_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint for the collection.
        """
        return pulumi.get(self, "collection_endpoint")

    @collection_endpoint.setter
    def collection_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "collection_endpoint", value)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the OpenSearch Serverless index.
        """
        return pulumi.get(self, "index_name")

    @index_name.setter
    def index_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "index_name", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input['MappingsPropertiesArgs']]:
        """
        Index Mappings
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input['MappingsPropertiesArgs']]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['IndexSettingsArgs']]:
        """
        Index settings
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['IndexSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.type_token("aws-native:opensearchserverless:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 index_name: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input[Union['MappingsPropertiesArgs', 'MappingsPropertiesArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Union['IndexSettingsArgs', 'IndexSettingsArgsDict']]] = None,
                 __props__=None):
        """
        An OpenSearch Serverless index resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] collection_endpoint: The endpoint for the collection.
        :param pulumi.Input[builtins.str] index_name: The name of the OpenSearch Serverless index.
        :param pulumi.Input[Union['MappingsPropertiesArgs', 'MappingsPropertiesArgsDict']] mappings: Index Mappings
        :param pulumi.Input[Union['IndexSettingsArgs', 'IndexSettingsArgsDict']] settings: Index settings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An OpenSearch Serverless index resource

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 index_name: Optional[pulumi.Input[builtins.str]] = None,
                 mappings: Optional[pulumi.Input[Union['MappingsPropertiesArgs', 'MappingsPropertiesArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Union['IndexSettingsArgs', 'IndexSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            if collection_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'collection_endpoint'")
            __props__.__dict__["collection_endpoint"] = collection_endpoint
            __props__.__dict__["index_name"] = index_name
            __props__.__dict__["mappings"] = mappings
            __props__.__dict__["settings"] = settings
            __props__.__dict__["uuid"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["collectionEndpoint", "indexName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Index, __self__).__init__(
            'aws-native:opensearchserverless:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IndexArgs.__new__(IndexArgs)

        __props__.__dict__["collection_endpoint"] = None
        __props__.__dict__["index_name"] = None
        __props__.__dict__["mappings"] = None
        __props__.__dict__["settings"] = None
        __props__.__dict__["uuid"] = None
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="collectionEndpoint")
    def collection_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint for the collection.
        """
        return pulumi.get(self, "collection_endpoint")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the OpenSearch Serverless index.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Output[Optional['outputs.MappingsProperties']]:
        """
        Index Mappings
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional['outputs.IndexSettings']]:
        """
        Index settings
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the index.
        """
        return pulumi.get(self, "uuid")

