# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSecurityPolicyResult',
    'AwaitableGetSecurityPolicyResult',
    'get_security_policy',
    'get_security_policy_output',
]

@pulumi.output_type
class GetSecurityPolicyResult:
    def __init__(__self__, description=None, policy=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        The JSON policy document that is the content for the policy
        """
        return pulumi.get(self, "policy")


class AwaitableGetSecurityPolicyResult(GetSecurityPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyResult(
            description=self.description,
            policy=self.policy)


def get_security_policy(name: Optional[builtins.str] = None,
                        type: Optional['SecurityPolicyType'] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyResult:
    """
    Amazon OpenSearchServerless security policy resource


    :param builtins.str name: The name of the policy
    :param 'SecurityPolicyType' type: The type of security policy. Can be either `encryption` or `network` .
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult).value

    return AwaitableGetSecurityPolicyResult(
        description=pulumi.get(__ret__, 'description'),
        policy=pulumi.get(__ret__, 'policy'))
def get_security_policy_output(name: Optional[pulumi.Input[builtins.str]] = None,
                               type: Optional[pulumi.Input['SecurityPolicyType']] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyResult]:
    """
    Amazon OpenSearchServerless security policy resource


    :param builtins.str name: The name of the policy
    :param 'SecurityPolicyType' type: The type of security policy. Can be either `encryption` or `network` .
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyResult(
        description=pulumi.get(__response__, 'description'),
        policy=pulumi.get(__response__, 'policy')))
