# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityConfigResult',
    'AwaitableGetSecurityConfigResult',
    'get_security_config',
    'get_security_config_output',
]

@pulumi.output_type
class GetSecurityConfigResult:
    def __init__(__self__, description=None, iam_identity_center_options=None, id=None, saml_options=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if iam_identity_center_options and not isinstance(iam_identity_center_options, dict):
            raise TypeError("Expected argument 'iam_identity_center_options' to be a dict")
        pulumi.set(__self__, "iam_identity_center_options", iam_identity_center_options)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if saml_options and not isinstance(saml_options, dict):
            raise TypeError("Expected argument 'saml_options' to be a dict")
        pulumi.set(__self__, "saml_options", saml_options)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Security config description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iamIdentityCenterOptions")
    def iam_identity_center_options(self) -> Optional['outputs.SecurityConfigIamIdentityCenterConfigOptions']:
        """
        Describes IAM Identity Center options in the form of a key-value map.
        """
        return pulumi.get(self, "iam_identity_center_options")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier of the security config
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> Optional['outputs.SecurityConfigSamlConfigOptions']:
        """
        SAML options for the security configuration in the form of a key-value map.
        """
        return pulumi.get(self, "saml_options")


class AwaitableGetSecurityConfigResult(GetSecurityConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityConfigResult(
            description=self.description,
            iam_identity_center_options=self.iam_identity_center_options,
            id=self.id,
            saml_options=self.saml_options)


def get_security_config(id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityConfigResult:
    """
    Amazon OpenSearchServerless security config resource


    :param builtins.str id: The identifier of the security config
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getSecurityConfig', __args__, opts=opts, typ=GetSecurityConfigResult).value

    return AwaitableGetSecurityConfigResult(
        description=pulumi.get(__ret__, 'description'),
        iam_identity_center_options=pulumi.get(__ret__, 'iam_identity_center_options'),
        id=pulumi.get(__ret__, 'id'),
        saml_options=pulumi.get(__ret__, 'saml_options'))
def get_security_config_output(id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityConfigResult]:
    """
    Amazon OpenSearchServerless security config resource


    :param builtins.str id: The identifier of the security config
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getSecurityConfig', __args__, opts=opts, typ=GetSecurityConfigResult)
    return __ret__.apply(lambda __response__: GetSecurityConfigResult(
        description=pulumi.get(__response__, 'description'),
        iam_identity_center_options=pulumi.get(__response__, 'iam_identity_center_options'),
        id=pulumi.get(__response__, 'id'),
        saml_options=pulumi.get(__response__, 'saml_options')))
