# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetIndexResult',
    'AwaitableGetIndexResult',
    'get_index',
    'get_index_output',
]

@pulumi.output_type
class GetIndexResult:
    def __init__(__self__, mappings=None, settings=None, uuid=None):
        if mappings and not isinstance(mappings, dict):
            raise TypeError("Expected argument 'mappings' to be a dict")
        pulumi.set(__self__, "mappings", mappings)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def mappings(self) -> Optional['outputs.MappingsProperties']:
        """
        Index Mappings
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.IndexSettings']:
        """
        Index settings
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        """
        The unique identifier for the index.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetIndexResult(GetIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexResult(
            mappings=self.mappings,
            settings=self.settings,
            uuid=self.uuid)


def get_index(collection_endpoint: Optional[builtins.str] = None,
              index_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexResult:
    """
    An OpenSearch Serverless index resource


    :param builtins.str collection_endpoint: The endpoint for the collection.
    :param builtins.str index_name: The name of the OpenSearch Serverless index.
    """
    __args__ = dict()
    __args__['collectionEndpoint'] = collection_endpoint
    __args__['indexName'] = index_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getIndex', __args__, opts=opts, typ=GetIndexResult).value

    return AwaitableGetIndexResult(
        mappings=pulumi.get(__ret__, 'mappings'),
        settings=pulumi.get(__ret__, 'settings'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_index_output(collection_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                     index_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIndexResult]:
    """
    An OpenSearch Serverless index resource


    :param builtins.str collection_endpoint: The endpoint for the collection.
    :param builtins.str index_name: The name of the OpenSearch Serverless index.
    """
    __args__ = dict()
    __args__['collectionEndpoint'] = collection_endpoint
    __args__['indexName'] = index_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getIndex', __args__, opts=opts, typ=GetIndexResult)
    return __ret__.apply(lambda __response__: GetIndexResult(
        mappings=pulumi.get(__response__, 'mappings'),
        settings=pulumi.get(__response__, 'settings'),
        uuid=pulumi.get(__response__, 'uuid')))
