# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetAccessPolicyResult',
    'AwaitableGetAccessPolicyResult',
    'get_access_policy',
    'get_access_policy_output',
]

@pulumi.output_type
class GetAccessPolicyResult:
    def __init__(__self__, description=None, policy=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def policy(self) -> Optional[builtins.str]:
        """
        The JSON policy document that is the content for the policy
        """
        return pulumi.get(self, "policy")


class AwaitableGetAccessPolicyResult(GetAccessPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPolicyResult(
            description=self.description,
            policy=self.policy)


def get_access_policy(name: Optional[builtins.str] = None,
                      type: Optional['AccessPolicyType'] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPolicyResult:
    """
    Amazon OpenSearchServerless access policy resource


    :param builtins.str name: The name of the policy
    :param 'AccessPolicyType' type: The type of access policy. Currently the only option is `data` .
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:opensearchserverless:getAccessPolicy', __args__, opts=opts, typ=GetAccessPolicyResult).value

    return AwaitableGetAccessPolicyResult(
        description=pulumi.get(__ret__, 'description'),
        policy=pulumi.get(__ret__, 'policy'))
def get_access_policy_output(name: Optional[pulumi.Input[builtins.str]] = None,
                             type: Optional[pulumi.Input['AccessPolicyType']] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessPolicyResult]:
    """
    Amazon OpenSearchServerless access policy resource


    :param builtins.str name: The name of the policy
    :param 'AccessPolicyType' type: The type of access policy. Currently the only option is `data` .
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:opensearchserverless:getAccessPolicy', __args__, opts=opts, typ=GetAccessPolicyResult)
    return __ret__.apply(lambda __response__: GetAccessPolicyResult(
        description=pulumi.get(__response__, 'description'),
        policy=pulumi.get(__response__, 'policy')))
