# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['WorkflowVersionArgs', 'WorkflowVersion']

@pulumi.input_type
class WorkflowVersionArgs:
    def __init__(__self__, *,
                 workflow_id: pulumi.Input[builtins.str],
                 accelerators: Optional[pulumi.Input['WorkflowVersionAccelerators']] = None,
                 definition_uri: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input['WorkflowVersionWorkflowEngine']] = None,
                 main: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_template: Optional[pulumi.Input[Mapping[str, pulumi.Input['WorkflowVersionWorkflowParameterArgs']]]] = None,
                 storage_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 storage_type: Optional[pulumi.Input['WorkflowVersionStorageType']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 workflow_bucket_owner_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkflowVersion resource.
        :param pulumi.Input[builtins.str] workflow_id: The workflow's ID.
        :param pulumi.Input[builtins.str] description: The description of the workflow version.
        :param pulumi.Input[builtins.str] version_name: The name of the workflow version.
        """
        pulumi.set(__self__, "workflow_id", workflow_id)
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if definition_uri is not None:
            pulumi.set(__self__, "definition_uri", definition_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if main is not None:
            pulumi.set(__self__, "main", main)
        if parameter_template is not None:
            pulumi.set(__self__, "parameter_template", parameter_template)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if workflow_bucket_owner_id is not None:
            pulumi.set(__self__, "workflow_bucket_owner_id", workflow_bucket_owner_id)

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Input[builtins.str]:
        """
        The workflow's ID.
        """
        return pulumi.get(self, "workflow_id")

    @workflow_id.setter
    def workflow_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workflow_id", value)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input['WorkflowVersionAccelerators']]:
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input['WorkflowVersionAccelerators']]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="definitionUri")
    def definition_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "definition_uri")

    @definition_uri.setter
    def definition_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "definition_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the workflow version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input['WorkflowVersionWorkflowEngine']]:
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input['WorkflowVersionWorkflowEngine']]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def main(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "main")

    @main.setter
    def main(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "main", value)

    @property
    @pulumi.getter(name="parameterTemplate")
    def parameter_template(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['WorkflowVersionWorkflowParameterArgs']]]]:
        return pulumi.get(self, "parameter_template")

    @parameter_template.setter
    def parameter_template(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['WorkflowVersionWorkflowParameterArgs']]]]):
        pulumi.set(self, "parameter_template", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input['WorkflowVersionStorageType']]:
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input['WorkflowVersionStorageType']]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the workflow version.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="workflowBucketOwnerId")
    def workflow_bucket_owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "workflow_bucket_owner_id")

    @workflow_bucket_owner_id.setter
    def workflow_bucket_owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workflow_bucket_owner_id", value)


@pulumi.type_token("aws-native:omics:WorkflowVersion")
class WorkflowVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input['WorkflowVersionAccelerators']] = None,
                 definition_uri: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input['WorkflowVersionWorkflowEngine']] = None,
                 main: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_template: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['WorkflowVersionWorkflowParameterArgs', 'WorkflowVersionWorkflowParameterArgsDict']]]]] = None,
                 storage_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 storage_type: Optional[pulumi.Input['WorkflowVersionStorageType']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 workflow_bucket_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 workflow_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::Omics::WorkflowVersion Resource Type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the workflow version.
        :param pulumi.Input[builtins.str] version_name: The name of the workflow version.
        :param pulumi.Input[builtins.str] workflow_id: The workflow's ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Omics::WorkflowVersion Resource Type.

        :param str resource_name: The name of the resource.
        :param WorkflowVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input['WorkflowVersionAccelerators']] = None,
                 definition_uri: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input['WorkflowVersionWorkflowEngine']] = None,
                 main: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_template: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['WorkflowVersionWorkflowParameterArgs', 'WorkflowVersionWorkflowParameterArgsDict']]]]] = None,
                 storage_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 storage_type: Optional[pulumi.Input['WorkflowVersionStorageType']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version_name: Optional[pulumi.Input[builtins.str]] = None,
                 workflow_bucket_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 workflow_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowVersionArgs.__new__(WorkflowVersionArgs)

            __props__.__dict__["accelerators"] = accelerators
            __props__.__dict__["definition_uri"] = definition_uri
            __props__.__dict__["description"] = description
            __props__.__dict__["engine"] = engine
            __props__.__dict__["main"] = main
            __props__.__dict__["parameter_template"] = parameter_template
            __props__.__dict__["storage_capacity"] = storage_capacity
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["workflow_bucket_owner_id"] = workflow_bucket_owner_id
            if workflow_id is None and not opts.urn:
                raise TypeError("Missing required property 'workflow_id'")
            __props__.__dict__["workflow_id"] = workflow_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["uuid"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["accelerators", "definitionUri", "engine", "main", "parameterTemplate.*", "versionName", "workflowBucketOwnerId", "workflowId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(WorkflowVersion, __self__).__init__(
            'aws-native:omics:WorkflowVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WorkflowVersion':
        """
        Get an existing WorkflowVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkflowVersionArgs.__new__(WorkflowVersionArgs)

        __props__.__dict__["accelerators"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["definition_uri"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["main"] = None
        __props__.__dict__["parameter_template"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["storage_capacity"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["uuid"] = None
        __props__.__dict__["version_name"] = None
        __props__.__dict__["workflow_bucket_owner_id"] = None
        __props__.__dict__["workflow_id"] = None
        return WorkflowVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accelerators(self) -> pulumi.Output[Optional['WorkflowVersionAccelerators']]:
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the workflow version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The creation time of the workflow version.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="definitionUri")
    def definition_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "definition_uri")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the workflow version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional['WorkflowVersionWorkflowEngine']]:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def main(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "main")

    @property
    @pulumi.getter(name="parameterTemplate")
    def parameter_template(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.WorkflowVersionWorkflowParameter']]]:
        return pulumi.get(self, "parameter_template")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['WorkflowVersionWorkflowStatus']:
        """
        The status of the workflow version.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Output[Optional[builtins.float]]:
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional['WorkflowVersionStorageType']]:
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['WorkflowVersionWorkflowType']:
        """
        The type of the workflow version.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the workflow version.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="workflowBucketOwnerId")
    def workflow_bucket_owner_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "workflow_bucket_owner_id")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Output[builtins.str]:
        """
        The workflow's ID.
        """
        return pulumi.get(self, "workflow_id")

