# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SequenceStoreArgs', 'SequenceStore']

@pulumi.input_type
class SequenceStoreArgs:
    def __init__(__self__, *,
                 access_log_location: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 e_tag_algorithm_family: Optional[pulumi.Input['SequenceStoreETagAlgorithmFamily']] = None,
                 fallback_location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_set_level_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_access_policy: Optional[Any] = None,
                 sse_config: Optional[pulumi.Input['SequenceStoreSseConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a SequenceStore resource.
        :param pulumi.Input[builtins.str] access_log_location: Location of the access logs.
        :param pulumi.Input[builtins.str] description: A description for the store.
        :param pulumi.Input['SequenceStoreETagAlgorithmFamily'] e_tag_algorithm_family: The algorithm family of the ETag.
        :param pulumi.Input[builtins.str] fallback_location: An S3 location that is used to store files that have failed a direct upload.
        :param pulumi.Input[builtins.str] name: A name for the store.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] propagated_set_level_tags: The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
        :param Any s3_access_policy: The resource policy that controls S3 access on the store
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Omics::SequenceStore` for more information about the expected schema for this property.
        :param pulumi.Input['SequenceStoreSseConfigArgs'] sse_config: Server-side encryption (SSE) settings for the store.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the store.
        """
        if access_log_location is not None:
            pulumi.set(__self__, "access_log_location", access_log_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if e_tag_algorithm_family is not None:
            pulumi.set(__self__, "e_tag_algorithm_family", e_tag_algorithm_family)
        if fallback_location is not None:
            pulumi.set(__self__, "fallback_location", fallback_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if propagated_set_level_tags is not None:
            pulumi.set(__self__, "propagated_set_level_tags", propagated_set_level_tags)
        if s3_access_policy is not None:
            pulumi.set(__self__, "s3_access_policy", s3_access_policy)
        if sse_config is not None:
            pulumi.set(__self__, "sse_config", sse_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessLogLocation")
    def access_log_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the access logs.
        """
        return pulumi.get(self, "access_log_location")

    @access_log_location.setter
    def access_log_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_log_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eTagAlgorithmFamily")
    def e_tag_algorithm_family(self) -> Optional[pulumi.Input['SequenceStoreETagAlgorithmFamily']]:
        """
        The algorithm family of the ETag.
        """
        return pulumi.get(self, "e_tag_algorithm_family")

    @e_tag_algorithm_family.setter
    def e_tag_algorithm_family(self, value: Optional[pulumi.Input['SequenceStoreETagAlgorithmFamily']]):
        pulumi.set(self, "e_tag_algorithm_family", value)

    @property
    @pulumi.getter(name="fallbackLocation")
    def fallback_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An S3 location that is used to store files that have failed a direct upload.
        """
        return pulumi.get(self, "fallback_location")

    @fallback_location.setter
    def fallback_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the store.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="propagatedSetLevelTags")
    def propagated_set_level_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
        """
        return pulumi.get(self, "propagated_set_level_tags")

    @propagated_set_level_tags.setter
    def propagated_set_level_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "propagated_set_level_tags", value)

    @property
    @pulumi.getter(name="s3AccessPolicy")
    def s3_access_policy(self) -> Optional[Any]:
        """
        The resource policy that controls S3 access on the store

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Omics::SequenceStore` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "s3_access_policy")

    @s3_access_policy.setter
    def s3_access_policy(self, value: Optional[Any]):
        pulumi.set(self, "s3_access_policy", value)

    @property
    @pulumi.getter(name="sseConfig")
    def sse_config(self) -> Optional[pulumi.Input['SequenceStoreSseConfigArgs']]:
        """
        Server-side encryption (SSE) settings for the store.
        """
        return pulumi.get(self, "sse_config")

    @sse_config.setter
    def sse_config(self, value: Optional[pulumi.Input['SequenceStoreSseConfigArgs']]):
        pulumi.set(self, "sse_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags for the store.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:omics:SequenceStore")
class SequenceStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_location: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 e_tag_algorithm_family: Optional[pulumi.Input['SequenceStoreETagAlgorithmFamily']] = None,
                 fallback_location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_set_level_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_access_policy: Optional[Any] = None,
                 sse_config: Optional[pulumi.Input[Union['SequenceStoreSseConfigArgs', 'SequenceStoreSseConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Omics::SequenceStore

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_log_location: Location of the access logs.
        :param pulumi.Input[builtins.str] description: A description for the store.
        :param pulumi.Input['SequenceStoreETagAlgorithmFamily'] e_tag_algorithm_family: The algorithm family of the ETag.
        :param pulumi.Input[builtins.str] fallback_location: An S3 location that is used to store files that have failed a direct upload.
        :param pulumi.Input[builtins.str] name: A name for the store.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] propagated_set_level_tags: The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
        :param Any s3_access_policy: The resource policy that controls S3 access on the store
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Omics::SequenceStore` for more information about the expected schema for this property.
        :param pulumi.Input[Union['SequenceStoreSseConfigArgs', 'SequenceStoreSseConfigArgsDict']] sse_config: Server-side encryption (SSE) settings for the store.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags for the store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SequenceStoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Omics::SequenceStore

        :param str resource_name: The name of the resource.
        :param SequenceStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SequenceStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_location: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 e_tag_algorithm_family: Optional[pulumi.Input['SequenceStoreETagAlgorithmFamily']] = None,
                 fallback_location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_set_level_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 s3_access_policy: Optional[Any] = None,
                 sse_config: Optional[pulumi.Input[Union['SequenceStoreSseConfigArgs', 'SequenceStoreSseConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SequenceStoreArgs.__new__(SequenceStoreArgs)

            __props__.__dict__["access_log_location"] = access_log_location
            __props__.__dict__["description"] = description
            __props__.__dict__["e_tag_algorithm_family"] = e_tag_algorithm_family
            __props__.__dict__["fallback_location"] = fallback_location
            __props__.__dict__["name"] = name
            __props__.__dict__["propagated_set_level_tags"] = propagated_set_level_tags
            __props__.__dict__["s3_access_policy"] = s3_access_policy
            __props__.__dict__["sse_config"] = sse_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["s3_access_point_arn"] = None
            __props__.__dict__["s3_uri"] = None
            __props__.__dict__["sequence_store_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["eTagAlgorithmFamily", "sseConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SequenceStore, __self__).__init__(
            'aws-native:omics:SequenceStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SequenceStore':
        """
        Get an existing SequenceStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SequenceStoreArgs.__new__(SequenceStoreArgs)

        __props__.__dict__["access_log_location"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["e_tag_algorithm_family"] = None
        __props__.__dict__["fallback_location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["propagated_set_level_tags"] = None
        __props__.__dict__["s3_access_point_arn"] = None
        __props__.__dict__["s3_access_policy"] = None
        __props__.__dict__["s3_uri"] = None
        __props__.__dict__["sequence_store_id"] = None
        __props__.__dict__["sse_config"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_message"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["update_time"] = None
        return SequenceStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogLocation")
    def access_log_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location of the access logs.
        """
        return pulumi.get(self, "access_log_location")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The store's ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        When the store was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the store.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eTagAlgorithmFamily")
    def e_tag_algorithm_family(self) -> pulumi.Output[Optional['SequenceStoreETagAlgorithmFamily']]:
        """
        The algorithm family of the ETag.
        """
        return pulumi.get(self, "e_tag_algorithm_family")

    @property
    @pulumi.getter(name="fallbackLocation")
    def fallback_location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An S3 location that is used to store files that have failed a direct upload.
        """
        return pulumi.get(self, "fallback_location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the store.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propagatedSetLevelTags")
    def propagated_set_level_tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
        """
        return pulumi.get(self, "propagated_set_level_tags")

    @property
    @pulumi.getter(name="s3AccessPointArn")
    def s3_access_point_arn(self) -> pulumi.Output[builtins.str]:
        """
        This is ARN of the access point associated with the S3 bucket storing read sets.
        """
        return pulumi.get(self, "s3_access_point_arn")

    @property
    @pulumi.getter(name="s3AccessPolicy")
    def s3_access_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The resource policy that controls S3 access on the store

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Omics::SequenceStore` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "s3_access_policy")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Output[builtins.str]:
        """
        The S3 URI of the sequence store.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="sequenceStoreId")
    def sequence_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The store's ID.
        """
        return pulumi.get(self, "sequence_store_id")

    @property
    @pulumi.getter(name="sseConfig")
    def sse_config(self) -> pulumi.Output[Optional['outputs.SequenceStoreSseConfig']]:
        """
        Server-side encryption (SSE) settings for the store.
        """
        return pulumi.get(self, "sse_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['SequenceStoreStatus']:
        """
        Status of the sequence store.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[builtins.str]:
        """
        The status message of the sequence store.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Tags for the store.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The last-updated time of the sequence store.
        """
        return pulumi.get(self, "update_time")

