# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetWorkflowVersionResult',
    'AwaitableGetWorkflowVersionResult',
    'get_workflow_version',
    'get_workflow_version_output',
]

@pulumi.output_type
class GetWorkflowVersionResult:
    def __init__(__self__, arn=None, creation_time=None, description=None, status=None, storage_capacity=None, storage_type=None, tags=None, type=None, uuid=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_capacity and not isinstance(storage_capacity, float):
            raise TypeError("Expected argument 'storage_capacity' to be a float")
        pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN of the workflow version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        The creation time of the workflow version.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the workflow version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional['WorkflowVersionWorkflowStatus']:
        """
        The status of the workflow version.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[builtins.float]:
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional['WorkflowVersionStorageType']:
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['WorkflowVersionWorkflowType']:
        """
        The type of the workflow version.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[builtins.str]:
        return pulumi.get(self, "uuid")


class AwaitableGetWorkflowVersionResult(GetWorkflowVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowVersionResult(
            arn=self.arn,
            creation_time=self.creation_time,
            description=self.description,
            status=self.status,
            storage_capacity=self.storage_capacity,
            storage_type=self.storage_type,
            tags=self.tags,
            type=self.type,
            uuid=self.uuid)


def get_workflow_version(arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowVersionResult:
    """
    Definition of AWS::Omics::WorkflowVersion Resource Type.


    :param builtins.str arn: ARN of the workflow version.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:omics:getWorkflowVersion', __args__, opts=opts, typ=GetWorkflowVersionResult).value

    return AwaitableGetWorkflowVersionResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        description=pulumi.get(__ret__, 'description'),
        status=pulumi.get(__ret__, 'status'),
        storage_capacity=pulumi.get(__ret__, 'storage_capacity'),
        storage_type=pulumi.get(__ret__, 'storage_type'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_workflow_version_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkflowVersionResult]:
    """
    Definition of AWS::Omics::WorkflowVersion Resource Type.


    :param builtins.str arn: ARN of the workflow version.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:omics:getWorkflowVersion', __args__, opts=opts, typ=GetWorkflowVersionResult)
    return __ret__.apply(lambda __response__: GetWorkflowVersionResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        description=pulumi.get(__response__, 'description'),
        status=pulumi.get(__response__, 'status'),
        storage_capacity=pulumi.get(__response__, 'storage_capacity'),
        storage_type=pulumi.get(__response__, 'storage_type'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        uuid=pulumi.get(__response__, 'uuid')))
