# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSequenceStoreResult',
    'AwaitableGetSequenceStoreResult',
    'get_sequence_store',
    'get_sequence_store_output',
]

@pulumi.output_type
class GetSequenceStoreResult:
    def __init__(__self__, access_log_location=None, arn=None, creation_time=None, description=None, fallback_location=None, name=None, propagated_set_level_tags=None, s3_access_point_arn=None, s3_access_policy=None, s3_uri=None, sequence_store_id=None, status=None, status_message=None, tags=None, update_time=None):
        if access_log_location and not isinstance(access_log_location, str):
            raise TypeError("Expected argument 'access_log_location' to be a str")
        pulumi.set(__self__, "access_log_location", access_log_location)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fallback_location and not isinstance(fallback_location, str):
            raise TypeError("Expected argument 'fallback_location' to be a str")
        pulumi.set(__self__, "fallback_location", fallback_location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if propagated_set_level_tags and not isinstance(propagated_set_level_tags, list):
            raise TypeError("Expected argument 'propagated_set_level_tags' to be a list")
        pulumi.set(__self__, "propagated_set_level_tags", propagated_set_level_tags)
        if s3_access_point_arn and not isinstance(s3_access_point_arn, str):
            raise TypeError("Expected argument 's3_access_point_arn' to be a str")
        pulumi.set(__self__, "s3_access_point_arn", s3_access_point_arn)
        if s3_access_policy and not isinstance(s3_access_policy, dict):
            raise TypeError("Expected argument 's3_access_policy' to be a dict")
        pulumi.set(__self__, "s3_access_policy", s3_access_policy)
        if s3_uri and not isinstance(s3_uri, str):
            raise TypeError("Expected argument 's3_uri' to be a str")
        pulumi.set(__self__, "s3_uri", s3_uri)
        if sequence_store_id and not isinstance(sequence_store_id, str):
            raise TypeError("Expected argument 'sequence_store_id' to be a str")
        pulumi.set(__self__, "sequence_store_id", sequence_store_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accessLogLocation")
    def access_log_location(self) -> Optional[builtins.str]:
        """
        Location of the access logs.
        """
        return pulumi.get(self, "access_log_location")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The store's ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        When the store was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the store.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fallbackLocation")
    def fallback_location(self) -> Optional[builtins.str]:
        """
        An S3 location that is used to store files that have failed a direct upload.
        """
        return pulumi.get(self, "fallback_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A name for the store.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propagatedSetLevelTags")
    def propagated_set_level_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
        """
        return pulumi.get(self, "propagated_set_level_tags")

    @property
    @pulumi.getter(name="s3AccessPointArn")
    def s3_access_point_arn(self) -> Optional[builtins.str]:
        """
        This is ARN of the access point associated with the S3 bucket storing read sets.
        """
        return pulumi.get(self, "s3_access_point_arn")

    @property
    @pulumi.getter(name="s3AccessPolicy")
    def s3_access_policy(self) -> Optional[Any]:
        """
        The resource policy that controls S3 access on the store

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Omics::SequenceStore` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "s3_access_policy")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[builtins.str]:
        """
        The S3 URI of the sequence store.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="sequenceStoreId")
    def sequence_store_id(self) -> Optional[builtins.str]:
        """
        The store's ID.
        """
        return pulumi.get(self, "sequence_store_id")

    @property
    @pulumi.getter
    def status(self) -> Optional['SequenceStoreStatus']:
        """
        Status of the sequence store.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[builtins.str]:
        """
        The status message of the sequence store.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Tags for the store.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[builtins.str]:
        """
        The last-updated time of the sequence store.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetSequenceStoreResult(GetSequenceStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSequenceStoreResult(
            access_log_location=self.access_log_location,
            arn=self.arn,
            creation_time=self.creation_time,
            description=self.description,
            fallback_location=self.fallback_location,
            name=self.name,
            propagated_set_level_tags=self.propagated_set_level_tags,
            s3_access_point_arn=self.s3_access_point_arn,
            s3_access_policy=self.s3_access_policy,
            s3_uri=self.s3_uri,
            sequence_store_id=self.sequence_store_id,
            status=self.status,
            status_message=self.status_message,
            tags=self.tags,
            update_time=self.update_time)


def get_sequence_store(sequence_store_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSequenceStoreResult:
    """
    Resource Type definition for AWS::Omics::SequenceStore


    :param builtins.str sequence_store_id: The store's ID.
    """
    __args__ = dict()
    __args__['sequenceStoreId'] = sequence_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:omics:getSequenceStore', __args__, opts=opts, typ=GetSequenceStoreResult).value

    return AwaitableGetSequenceStoreResult(
        access_log_location=pulumi.get(__ret__, 'access_log_location'),
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        description=pulumi.get(__ret__, 'description'),
        fallback_location=pulumi.get(__ret__, 'fallback_location'),
        name=pulumi.get(__ret__, 'name'),
        propagated_set_level_tags=pulumi.get(__ret__, 'propagated_set_level_tags'),
        s3_access_point_arn=pulumi.get(__ret__, 's3_access_point_arn'),
        s3_access_policy=pulumi.get(__ret__, 's3_access_policy'),
        s3_uri=pulumi.get(__ret__, 's3_uri'),
        sequence_store_id=pulumi.get(__ret__, 'sequence_store_id'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_sequence_store_output(sequence_store_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSequenceStoreResult]:
    """
    Resource Type definition for AWS::Omics::SequenceStore


    :param builtins.str sequence_store_id: The store's ID.
    """
    __args__ = dict()
    __args__['sequenceStoreId'] = sequence_store_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:omics:getSequenceStore', __args__, opts=opts, typ=GetSequenceStoreResult)
    return __ret__.apply(lambda __response__: GetSequenceStoreResult(
        access_log_location=pulumi.get(__response__, 'access_log_location'),
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        description=pulumi.get(__response__, 'description'),
        fallback_location=pulumi.get(__response__, 'fallback_location'),
        name=pulumi.get(__response__, 'name'),
        propagated_set_level_tags=pulumi.get(__response__, 'propagated_set_level_tags'),
        s3_access_point_arn=pulumi.get(__response__, 's3_access_point_arn'),
        s3_access_policy=pulumi.get(__response__, 's3_access_policy'),
        s3_uri=pulumi.get(__response__, 's3_uri'),
        sequence_store_id=pulumi.get(__response__, 'sequence_store_id'),
        status=pulumi.get(__response__, 'status'),
        status_message=pulumi.get(__response__, 'status_message'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time')))
