# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'LinkConfiguration',
    'LinkFilter',
]

@pulumi.output_type
class LinkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupConfiguration":
            suggest = "log_group_configuration"
        elif key == "metricConfiguration":
            suggest = "metric_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_configuration: Optional['outputs.LinkFilter'] = None,
                 metric_configuration: Optional['outputs.LinkFilter'] = None):
        """
        :param 'LinkFilter' log_group_configuration: Use this structure to filter which log groups are to share log events from this source account to the monitoring account.
        :param 'LinkFilter' metric_configuration: Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring account.
        """
        if log_group_configuration is not None:
            pulumi.set(__self__, "log_group_configuration", log_group_configuration)
        if metric_configuration is not None:
            pulumi.set(__self__, "metric_configuration", metric_configuration)

    @property
    @pulumi.getter(name="logGroupConfiguration")
    def log_group_configuration(self) -> Optional['outputs.LinkFilter']:
        """
        Use this structure to filter which log groups are to share log events from this source account to the monitoring account.
        """
        return pulumi.get(self, "log_group_configuration")

    @property
    @pulumi.getter(name="metricConfiguration")
    def metric_configuration(self) -> Optional['outputs.LinkFilter']:
        """
        Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring account.
        """
        return pulumi.get(self, "metric_configuration")


@pulumi.output_type
class LinkFilter(dict):
    def __init__(__self__, *,
                 filter: builtins.str):
        """
        :param builtins.str filter: When used in `MetricConfiguration` this field specifies which metric namespaces are to be shared with the monitoring account
               
               When used in `LogGroupConfiguration` this field specifies which log groups are to share their log events with the monitoring account. Use the term `LogGroupName` and one or more of the following operands.
               
               Use single quotation marks (') around log group names and metric namespaces.
               
               The matching of log group names and metric namespaces is case sensitive. Each filter has a limit of five conditional operands. Conditional operands are `AND` and `OR` .
               
               - `=` and `!=`
               - `AND`
               - `OR`
               - `LIKE` and `NOT LIKE` . These can be used only as prefix searches. Include a `%` at the end of the string that you want to search for and include.
               - `IN` and `NOT IN` , using parentheses `( )`
               
               Examples:
               
               - `Namespace NOT LIKE 'AWS/%'` includes only namespaces that don't start with `AWS/` , such as custom namespaces.
               - `Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')` includes only the metrics in the EC2, Elastic Load Balancing , and Amazon S3 namespaces.
               - `Namespace = 'AWS/EC2' OR Namespace NOT LIKE 'AWS/%'` includes only the EC2 namespace and your custom namespaces.
               - `LogGroupName IN ('This-Log-Group', 'Other-Log-Group')` includes only the log groups with names `This-Log-Group` and `Other-Log-Group` .
               - `LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')` includes all log groups except the log groups with names `Private-Log-Group` and `Private-Log-Group-2` .
               - `LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'` includes all log groups that have names that start with `aws/lambda/` or `AWSLogs` .
               
               > If you are updating a link that uses filters, you can specify `*` as the only value for the `filter` parameter to delete the filter and share all log groups with the monitoring account.
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        When used in `MetricConfiguration` this field specifies which metric namespaces are to be shared with the monitoring account

        When used in `LogGroupConfiguration` this field specifies which log groups are to share their log events with the monitoring account. Use the term `LogGroupName` and one or more of the following operands.

        Use single quotation marks (') around log group names and metric namespaces.

        The matching of log group names and metric namespaces is case sensitive. Each filter has a limit of five conditional operands. Conditional operands are `AND` and `OR` .

        - `=` and `!=`
        - `AND`
        - `OR`
        - `LIKE` and `NOT LIKE` . These can be used only as prefix searches. Include a `%` at the end of the string that you want to search for and include.
        - `IN` and `NOT IN` , using parentheses `( )`

        Examples:

        - `Namespace NOT LIKE 'AWS/%'` includes only namespaces that don't start with `AWS/` , such as custom namespaces.
        - `Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')` includes only the metrics in the EC2, Elastic Load Balancing , and Amazon S3 namespaces.
        - `Namespace = 'AWS/EC2' OR Namespace NOT LIKE 'AWS/%'` includes only the EC2 namespace and your custom namespaces.
        - `LogGroupName IN ('This-Log-Group', 'Other-Log-Group')` includes only the log groups with names `This-Log-Group` and `Other-Log-Group` .
        - `LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')` includes all log groups except the log groups with names `Private-Log-Group` and `Private-Log-Group-2` .
        - `LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'` includes all log groups that have names that start with `aws/lambda/` or `AWSLogs` .

        > If you are updating a link that uses filters, you can specify `*` as the only value for the `filter` parameter to delete the filter and share all log groups with the monitoring account.
        """
        return pulumi.get(self, "filter")


