# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetLinkResult',
    'AwaitableGetLinkResult',
    'get_link',
    'get_link_output',
]

@pulumi.output_type
class GetLinkResult:
    def __init__(__self__, arn=None, label=None, link_configuration=None, resource_types=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if link_configuration and not isinstance(link_configuration, dict):
            raise TypeError("Expected argument 'link_configuration' to be a dict")
        pulumi.set(__self__, "link_configuration", link_configuration)
        if resource_types and not isinstance(resource_types, list):
            raise TypeError("Expected argument 'resource_types' to be a list")
        pulumi.set(__self__, "resource_types", resource_types)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the link. For example, `arn:aws:oam:us-west-1:111111111111:link:abcd1234-a123-456a-a12b-a123b456c789`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        The friendly human-readable name used to identify this source account when it is viewed from the monitoring account. For example, `my-account1` .
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="linkConfiguration")
    def link_configuration(self) -> Optional['outputs.LinkConfiguration']:
        """
        Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account.
        """
        return pulumi.get(self, "link_configuration")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence['LinkResourceType']]:
        """
        An array of strings that define which types of data that the source account shares with the monitoring account. Valid values are `AWS::CloudWatch::Metric | AWS::Logs::LogGroup | AWS::XRay::Trace | AWS::ApplicationInsights::Application | AWS::InternetMonitor::Monitor` .
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Tags to apply to the link
        """
        return pulumi.get(self, "tags")


class AwaitableGetLinkResult(GetLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLinkResult(
            arn=self.arn,
            label=self.label,
            link_configuration=self.link_configuration,
            resource_types=self.resource_types,
            tags=self.tags)


def get_link(arn: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLinkResult:
    """
    Definition of AWS::Oam::Link Resource Type


    :param builtins.str arn: The ARN of the link. For example, `arn:aws:oam:us-west-1:111111111111:link:abcd1234-a123-456a-a12b-a123b456c789`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:oam:getLink', __args__, opts=opts, typ=GetLinkResult).value

    return AwaitableGetLinkResult(
        arn=pulumi.get(__ret__, 'arn'),
        label=pulumi.get(__ret__, 'label'),
        link_configuration=pulumi.get(__ret__, 'link_configuration'),
        resource_types=pulumi.get(__ret__, 'resource_types'),
        tags=pulumi.get(__ret__, 'tags'))
def get_link_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLinkResult]:
    """
    Definition of AWS::Oam::Link Resource Type


    :param builtins.str arn: The ARN of the link. For example, `arn:aws:oam:us-west-1:111111111111:link:abcd1234-a123-456a-a12b-a123b456c789`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:oam:getLink', __args__, opts=opts, typ=GetLinkResult)
    return __ret__.apply(lambda __response__: GetLinkResult(
        arn=pulumi.get(__response__, 'arn'),
        label=pulumi.get(__response__, 'label'),
        link_configuration=pulumi.get(__response__, 'link_configuration'),
        resource_types=pulumi.get(__response__, 'resource_types'),
        tags=pulumi.get(__response__, 'tags')))
