# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LaunchProfileStreamConfiguration',
    'LaunchProfileStreamConfigurationSessionBackup',
    'LaunchProfileStreamConfigurationSessionStorage',
    'LaunchProfileStreamingSessionStorageRoot',
    'LaunchProfileVolumeConfiguration',
    'StreamingImageEncryptionConfiguration',
    'StudioComponentActiveDirectoryComputerAttribute',
    'StudioComponentActiveDirectoryConfiguration',
    'StudioComponentComputeFarmConfiguration',
    'StudioComponentConfiguration',
    'StudioComponentInitializationScript',
    'StudioComponentLicenseServiceConfiguration',
    'StudioComponentScriptParameterKeyValue',
    'StudioComponentSharedFileSystemConfiguration',
    'StudioEncryptionConfiguration',
]

@pulumi.output_type
class LaunchProfileStreamConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clipboardMode":
            suggest = "clipboard_mode"
        elif key == "ec2InstanceTypes":
            suggest = "ec2_instance_types"
        elif key == "streamingImageIds":
            suggest = "streaming_image_ids"
        elif key == "automaticTerminationMode":
            suggest = "automatic_termination_mode"
        elif key == "maxSessionLengthInMinutes":
            suggest = "max_session_length_in_minutes"
        elif key == "maxStoppedSessionLengthInMinutes":
            suggest = "max_stopped_session_length_in_minutes"
        elif key == "sessionBackup":
            suggest = "session_backup"
        elif key == "sessionPersistenceMode":
            suggest = "session_persistence_mode"
        elif key == "sessionStorage":
            suggest = "session_storage"
        elif key == "volumeConfiguration":
            suggest = "volume_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchProfileStreamConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchProfileStreamConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchProfileStreamConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clipboard_mode: builtins.str,
                 ec2_instance_types: Sequence[builtins.str],
                 streaming_image_ids: Sequence[builtins.str],
                 automatic_termination_mode: Optional[builtins.str] = None,
                 max_session_length_in_minutes: Optional[builtins.float] = None,
                 max_stopped_session_length_in_minutes: Optional[builtins.float] = None,
                 session_backup: Optional['outputs.LaunchProfileStreamConfigurationSessionBackup'] = None,
                 session_persistence_mode: Optional[builtins.str] = None,
                 session_storage: Optional['outputs.LaunchProfileStreamConfigurationSessionStorage'] = None,
                 volume_configuration: Optional['outputs.LaunchProfileVolumeConfiguration'] = None):
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "ec2_instance_types", ec2_instance_types)
        pulumi.set(__self__, "streaming_image_ids", streaming_image_ids)
        if automatic_termination_mode is not None:
            pulumi.set(__self__, "automatic_termination_mode", automatic_termination_mode)
        if max_session_length_in_minutes is not None:
            pulumi.set(__self__, "max_session_length_in_minutes", max_session_length_in_minutes)
        if max_stopped_session_length_in_minutes is not None:
            pulumi.set(__self__, "max_stopped_session_length_in_minutes", max_stopped_session_length_in_minutes)
        if session_backup is not None:
            pulumi.set(__self__, "session_backup", session_backup)
        if session_persistence_mode is not None:
            pulumi.set(__self__, "session_persistence_mode", session_persistence_mode)
        if session_storage is not None:
            pulumi.set(__self__, "session_storage", session_storage)
        if volume_configuration is not None:
            pulumi.set(__self__, "volume_configuration", volume_configuration)

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> builtins.str:
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="ec2InstanceTypes")
    def ec2_instance_types(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "ec2_instance_types")

    @property
    @pulumi.getter(name="streamingImageIds")
    def streaming_image_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "streaming_image_ids")

    @property
    @pulumi.getter(name="automaticTerminationMode")
    def automatic_termination_mode(self) -> Optional[builtins.str]:
        return pulumi.get(self, "automatic_termination_mode")

    @property
    @pulumi.getter(name="maxSessionLengthInMinutes")
    def max_session_length_in_minutes(self) -> Optional[builtins.float]:
        return pulumi.get(self, "max_session_length_in_minutes")

    @property
    @pulumi.getter(name="maxStoppedSessionLengthInMinutes")
    def max_stopped_session_length_in_minutes(self) -> Optional[builtins.float]:
        return pulumi.get(self, "max_stopped_session_length_in_minutes")

    @property
    @pulumi.getter(name="sessionBackup")
    def session_backup(self) -> Optional['outputs.LaunchProfileStreamConfigurationSessionBackup']:
        return pulumi.get(self, "session_backup")

    @property
    @pulumi.getter(name="sessionPersistenceMode")
    def session_persistence_mode(self) -> Optional[builtins.str]:
        return pulumi.get(self, "session_persistence_mode")

    @property
    @pulumi.getter(name="sessionStorage")
    def session_storage(self) -> Optional['outputs.LaunchProfileStreamConfigurationSessionStorage']:
        return pulumi.get(self, "session_storage")

    @property
    @pulumi.getter(name="volumeConfiguration")
    def volume_configuration(self) -> Optional['outputs.LaunchProfileVolumeConfiguration']:
        return pulumi.get(self, "volume_configuration")


@pulumi.output_type
class LaunchProfileStreamConfigurationSessionBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBackupsToRetain":
            suggest = "max_backups_to_retain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchProfileStreamConfigurationSessionBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchProfileStreamConfigurationSessionBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchProfileStreamConfigurationSessionBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_backups_to_retain: Optional[builtins.float] = None,
                 mode: Optional[builtins.str] = None):
        if max_backups_to_retain is not None:
            pulumi.set(__self__, "max_backups_to_retain", max_backups_to_retain)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="maxBackupsToRetain")
    def max_backups_to_retain(self) -> Optional[builtins.float]:
        return pulumi.get(self, "max_backups_to_retain")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        return pulumi.get(self, "mode")


@pulumi.output_type
class LaunchProfileStreamConfigurationSessionStorage(dict):
    def __init__(__self__, *,
                 mode: Sequence[builtins.str],
                 root: Optional['outputs.LaunchProfileStreamingSessionStorageRoot'] = None):
        pulumi.set(__self__, "mode", mode)
        if root is not None:
            pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def mode(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def root(self) -> Optional['outputs.LaunchProfileStreamingSessionStorageRoot']:
        return pulumi.get(self, "root")


@pulumi.output_type
class LaunchProfileStreamingSessionStorageRoot(dict):
    def __init__(__self__, *,
                 linux: Optional[builtins.str] = None,
                 windows: Optional[builtins.str] = None):
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter
    def linux(self) -> Optional[builtins.str]:
        return pulumi.get(self, "linux")

    @property
    @pulumi.getter
    def windows(self) -> Optional[builtins.str]:
        return pulumi.get(self, "windows")


@pulumi.output_type
class LaunchProfileVolumeConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[builtins.float] = None,
                 size: Optional[builtins.float] = None,
                 throughput: Optional[builtins.float] = None):
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.float]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.float]:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.float]:
        return pulumi.get(self, "throughput")


@pulumi.output_type
class StreamingImageEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingImageEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingImageEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingImageEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_type: builtins.str,
                 key_arn: Optional[builtins.str] = None):
        pulumi.set(__self__, "key_type", key_type)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> builtins.str:
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_arn")


@pulumi.output_type
class StudioComponentActiveDirectoryComputerAttribute(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class StudioComponentActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerAttributes":
            suggest = "computer_attributes"
        elif key == "directoryId":
            suggest = "directory_id"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_attributes: Optional[Sequence['outputs.StudioComponentActiveDirectoryComputerAttribute']] = None,
                 directory_id: Optional[builtins.str] = None,
                 organizational_unit_distinguished_name: Optional[builtins.str] = None):
        if computer_attributes is not None:
            pulumi.set(__self__, "computer_attributes", computer_attributes)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="computerAttributes")
    def computer_attributes(self) -> Optional[Sequence['outputs.StudioComponentActiveDirectoryComputerAttribute']]:
        return pulumi.get(self, "computer_attributes")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class StudioComponentComputeFarmConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryUser":
            suggest = "active_directory_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentComputeFarmConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentComputeFarmConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentComputeFarmConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_user: Optional[builtins.str] = None,
                 endpoint: Optional[builtins.str] = None):
        if active_directory_user is not None:
            pulumi.set(__self__, "active_directory_user", active_directory_user)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="activeDirectoryUser")
    def active_directory_user(self) -> Optional[builtins.str]:
        return pulumi.get(self, "active_directory_user")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class StudioComponentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryConfiguration":
            suggest = "active_directory_configuration"
        elif key == "computeFarmConfiguration":
            suggest = "compute_farm_configuration"
        elif key == "licenseServiceConfiguration":
            suggest = "license_service_configuration"
        elif key == "sharedFileSystemConfiguration":
            suggest = "shared_file_system_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_configuration: Optional['outputs.StudioComponentActiveDirectoryConfiguration'] = None,
                 compute_farm_configuration: Optional['outputs.StudioComponentComputeFarmConfiguration'] = None,
                 license_service_configuration: Optional['outputs.StudioComponentLicenseServiceConfiguration'] = None,
                 shared_file_system_configuration: Optional['outputs.StudioComponentSharedFileSystemConfiguration'] = None):
        if active_directory_configuration is not None:
            pulumi.set(__self__, "active_directory_configuration", active_directory_configuration)
        if compute_farm_configuration is not None:
            pulumi.set(__self__, "compute_farm_configuration", compute_farm_configuration)
        if license_service_configuration is not None:
            pulumi.set(__self__, "license_service_configuration", license_service_configuration)
        if shared_file_system_configuration is not None:
            pulumi.set(__self__, "shared_file_system_configuration", shared_file_system_configuration)

    @property
    @pulumi.getter(name="activeDirectoryConfiguration")
    def active_directory_configuration(self) -> Optional['outputs.StudioComponentActiveDirectoryConfiguration']:
        return pulumi.get(self, "active_directory_configuration")

    @property
    @pulumi.getter(name="computeFarmConfiguration")
    def compute_farm_configuration(self) -> Optional['outputs.StudioComponentComputeFarmConfiguration']:
        return pulumi.get(self, "compute_farm_configuration")

    @property
    @pulumi.getter(name="licenseServiceConfiguration")
    def license_service_configuration(self) -> Optional['outputs.StudioComponentLicenseServiceConfiguration']:
        return pulumi.get(self, "license_service_configuration")

    @property
    @pulumi.getter(name="sharedFileSystemConfiguration")
    def shared_file_system_configuration(self) -> Optional['outputs.StudioComponentSharedFileSystemConfiguration']:
        return pulumi.get(self, "shared_file_system_configuration")


@pulumi.output_type
class StudioComponentInitializationScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchProfileProtocolVersion":
            suggest = "launch_profile_protocol_version"
        elif key == "runContext":
            suggest = "run_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentInitializationScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentInitializationScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentInitializationScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_profile_protocol_version: Optional[builtins.str] = None,
                 platform: Optional[builtins.str] = None,
                 run_context: Optional[builtins.str] = None,
                 script: Optional[builtins.str] = None):
        if launch_profile_protocol_version is not None:
            pulumi.set(__self__, "launch_profile_protocol_version", launch_profile_protocol_version)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if run_context is not None:
            pulumi.set(__self__, "run_context", run_context)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter(name="launchProfileProtocolVersion")
    def launch_profile_protocol_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "launch_profile_protocol_version")

    @property
    @pulumi.getter
    def platform(self) -> Optional[builtins.str]:
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="runContext")
    def run_context(self) -> Optional[builtins.str]:
        return pulumi.get(self, "run_context")

    @property
    @pulumi.getter
    def script(self) -> Optional[builtins.str]:
        return pulumi.get(self, "script")


@pulumi.output_type
class StudioComponentLicenseServiceConfiguration(dict):
    def __init__(__self__, *,
                 endpoint: Optional[builtins.str] = None):
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class StudioComponentScriptParameterKeyValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class StudioComponentSharedFileSystemConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "linuxMountPoint":
            suggest = "linux_mount_point"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "windowsMountDrive":
            suggest = "windows_mount_drive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioComponentSharedFileSystemConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioComponentSharedFileSystemConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioComponentSharedFileSystemConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[builtins.str] = None,
                 file_system_id: Optional[builtins.str] = None,
                 linux_mount_point: Optional[builtins.str] = None,
                 share_name: Optional[builtins.str] = None,
                 windows_mount_drive: Optional[builtins.str] = None):
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if linux_mount_point is not None:
            pulumi.set(__self__, "linux_mount_point", linux_mount_point)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if windows_mount_drive is not None:
            pulumi.set(__self__, "windows_mount_drive", windows_mount_drive)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="linuxMountPoint")
    def linux_mount_point(self) -> Optional[builtins.str]:
        return pulumi.get(self, "linux_mount_point")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter(name="windowsMountDrive")
    def windows_mount_drive(self) -> Optional[builtins.str]:
        return pulumi.get(self, "windows_mount_drive")


@pulumi.output_type
class StudioEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyType":
            suggest = "key_type"
        elif key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StudioEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StudioEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StudioEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_type: builtins.str,
                 key_arn: Optional[builtins.str] = None):
        pulumi.set(__self__, "key_type", key_type)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> builtins.str:
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key_arn")


