# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['GlobalNetworkArgs', 'GlobalNetwork']

@pulumi.input_type
class GlobalNetworkArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a GlobalNetwork resource.
        :param pulumi.Input[builtins.str] created_at: The date and time that the global network was created.
        :param pulumi.Input[builtins.str] description: The description of the global network.
        :param pulumi.Input[builtins.str] state: The state of the global network.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags for the global network.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the global network was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the global network.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the global network.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags for the global network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:networkmanager:GlobalNetwork")
class GlobalNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::NetworkManager::GlobalNetwork type specifies a global network of the user's account

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        global_network = aws_native.networkmanager.GlobalNetwork("globalNetwork")
        site = aws_native.networkmanager.Site("site",
            global_network_id=global_network.id,
            location={
                "address": "227 W Monroe St, Chicago, IL 60606",
                "latitude": "41.8",
                "longitude": "-87.6",
            })
        link = aws_native.networkmanager.Link("link",
            description="Broadband link",
            global_network_id=global_network.id,
            site_id=site.site_id,
            bandwidth={
                "download_speed": 20,
                "upload_speed": 20,
            },
            provider="AnyCompany",
            type="Broadband",
            tags=[{
                "key": "Name",
                "value": "broadband-link-1",
            }])
        device = aws_native.networkmanager.Device("device",
            description="Chicago office device",
            global_network_id=global_network.id,
            site_id=site.site_id,
            tags=[{
                "key": "Network",
                "value": "north-america",
            }])
        link_association = aws_native.networkmanager.LinkAssociation("linkAssociation",
            global_network_id=global_network.id,
            link_id=link.link_id,
            device_id=device.device_id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        global_network = aws_native.networkmanager.GlobalNetwork("globalNetwork")
        site = aws_native.networkmanager.Site("site",
            global_network_id=global_network.id,
            location={
                "address": "227 W Monroe St, Chicago, IL 60606",
                "latitude": "41.8",
                "longitude": "-87.6",
            })
        link = aws_native.networkmanager.Link("link",
            description="Broadband link",
            global_network_id=global_network.id,
            site_id=site.site_id,
            bandwidth={
                "download_speed": 20,
                "upload_speed": 20,
            },
            provider="AnyCompany",
            type="Broadband",
            tags=[{
                "key": "Name",
                "value": "broadband-link-1",
            }])
        device = aws_native.networkmanager.Device("device",
            description="Chicago office device",
            global_network_id=global_network.id,
            site_id=site.site_id,
            tags=[{
                "key": "Network",
                "value": "north-america",
            }])
        link_association = aws_native.networkmanager.LinkAssociation("linkAssociation",
            global_network_id=global_network.id,
            link_id=link.link_id,
            device_id=device.device_id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time that the global network was created.
        :param pulumi.Input[builtins.str] description: The description of the global network.
        :param pulumi.Input[builtins.str] state: The state of the global network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags for the global network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalNetworkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::NetworkManager::GlobalNetwork type specifies a global network of the user's account

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        global_network = aws_native.networkmanager.GlobalNetwork("globalNetwork")
        site = aws_native.networkmanager.Site("site",
            global_network_id=global_network.id,
            location={
                "address": "227 W Monroe St, Chicago, IL 60606",
                "latitude": "41.8",
                "longitude": "-87.6",
            })
        link = aws_native.networkmanager.Link("link",
            description="Broadband link",
            global_network_id=global_network.id,
            site_id=site.site_id,
            bandwidth={
                "download_speed": 20,
                "upload_speed": 20,
            },
            provider="AnyCompany",
            type="Broadband",
            tags=[{
                "key": "Name",
                "value": "broadband-link-1",
            }])
        device = aws_native.networkmanager.Device("device",
            description="Chicago office device",
            global_network_id=global_network.id,
            site_id=site.site_id,
            tags=[{
                "key": "Network",
                "value": "north-america",
            }])
        link_association = aws_native.networkmanager.LinkAssociation("linkAssociation",
            global_network_id=global_network.id,
            link_id=link.link_id,
            device_id=device.device_id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        global_network = aws_native.networkmanager.GlobalNetwork("globalNetwork")
        site = aws_native.networkmanager.Site("site",
            global_network_id=global_network.id,
            location={
                "address": "227 W Monroe St, Chicago, IL 60606",
                "latitude": "41.8",
                "longitude": "-87.6",
            })
        link = aws_native.networkmanager.Link("link",
            description="Broadband link",
            global_network_id=global_network.id,
            site_id=site.site_id,
            bandwidth={
                "download_speed": 20,
                "upload_speed": 20,
            },
            provider="AnyCompany",
            type="Broadband",
            tags=[{
                "key": "Name",
                "value": "broadband-link-1",
            }])
        device = aws_native.networkmanager.Device("device",
            description="Chicago office device",
            global_network_id=global_network.id,
            site_id=site.site_id,
            tags=[{
                "key": "Network",
                "value": "north-america",
            }])
        link_association = aws_native.networkmanager.LinkAssociation("linkAssociation",
            global_network_id=global_network.id,
            link_id=link.link_id,
            device_id=device.device_id)

        ```

        :param str resource_name: The name of the resource.
        :param GlobalNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalNetworkArgs.__new__(GlobalNetworkArgs)

            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["description"] = description
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        super(GlobalNetwork, __self__).__init__(
            'aws-native:networkmanager:GlobalNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GlobalNetwork':
        """
        Get an existing GlobalNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GlobalNetworkArgs.__new__(GlobalNetworkArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        return GlobalNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the global network.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the global network.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time that the global network was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the global network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state of the global network.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags for the global network.
        """
        return pulumi.get(self, "tags")

