# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DirectConnectGatewayAttachmentArgs', 'DirectConnectGatewayAttachment']

@pulumi.input_type
class DirectConnectGatewayAttachmentArgs:
    def __init__(__self__, *,
                 core_network_id: pulumi.Input[builtins.str],
                 direct_connect_gateway_arn: pulumi.Input[builtins.str],
                 edge_locations: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 proposed_network_function_group_change: Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs']] = None,
                 proposed_segment_change: Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedSegmentChangeArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DirectConnectGatewayAttachment resource.
        :param pulumi.Input[builtins.str] core_network_id: The ID of a core network for the Direct Connect Gateway attachment.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: The ARN of the Direct Connect Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: The Regions where the edges are located.
        :param pulumi.Input['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs'] proposed_network_function_group_change: The attachment to move from one network function group to another.
        :param pulumi.Input['DirectConnectGatewayAttachmentProposedSegmentChangeArgs'] proposed_segment_change: The attachment to move from one segment to another.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags for the attachment.
        """
        pulumi.set(__self__, "core_network_id", core_network_id)
        pulumi.set(__self__, "direct_connect_gateway_arn", direct_connect_gateway_arn)
        pulumi.set(__self__, "edge_locations", edge_locations)
        if proposed_network_function_group_change is not None:
            pulumi.set(__self__, "proposed_network_function_group_change", proposed_network_function_group_change)
        if proposed_segment_change is not None:
            pulumi.set(__self__, "proposed_segment_change", proposed_segment_change)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of a core network for the Direct Connect Gateway attachment.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="directConnectGatewayArn")
    def direct_connect_gateway_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Direct Connect Gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_arn")

    @direct_connect_gateway_arn.setter
    def direct_connect_gateway_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direct_connect_gateway_arn", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The Regions where the edges are located.
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter(name="proposedNetworkFunctionGroupChange")
    def proposed_network_function_group_change(self) -> Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs']]:
        """
        The attachment to move from one network function group to another.
        """
        return pulumi.get(self, "proposed_network_function_group_change")

    @proposed_network_function_group_change.setter
    def proposed_network_function_group_change(self, value: Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs']]):
        pulumi.set(self, "proposed_network_function_group_change", value)

    @property
    @pulumi.getter(name="proposedSegmentChange")
    def proposed_segment_change(self) -> Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedSegmentChangeArgs']]:
        """
        The attachment to move from one segment to another.
        """
        return pulumi.get(self, "proposed_segment_change")

    @proposed_segment_change.setter
    def proposed_segment_change(self, value: Optional[pulumi.Input['DirectConnectGatewayAttachmentProposedSegmentChangeArgs']]):
        pulumi.set(self, "proposed_segment_change", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags for the attachment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:networkmanager:DirectConnectGatewayAttachment")
class DirectConnectGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 proposed_network_function_group_change: Optional[pulumi.Input[Union['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs', 'DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgsDict']]] = None,
                 proposed_segment_change: Optional[pulumi.Input[Union['DirectConnectGatewayAttachmentProposedSegmentChangeArgs', 'DirectConnectGatewayAttachmentProposedSegmentChangeArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        AWS::NetworkManager::DirectConnectGatewayAttachment Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] core_network_id: The ID of a core network for the Direct Connect Gateway attachment.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: The ARN of the Direct Connect Gateway.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: The Regions where the edges are located.
        :param pulumi.Input[Union['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs', 'DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgsDict']] proposed_network_function_group_change: The attachment to move from one network function group to another.
        :param pulumi.Input[Union['DirectConnectGatewayAttachmentProposedSegmentChangeArgs', 'DirectConnectGatewayAttachmentProposedSegmentChangeArgsDict']] proposed_segment_change: The attachment to move from one segment to another.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags for the attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectConnectGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::NetworkManager::DirectConnectGatewayAttachment Resource Type

        :param str resource_name: The name of the resource.
        :param DirectConnectGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectConnectGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 proposed_network_function_group_change: Optional[pulumi.Input[Union['DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgs', 'DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChangeArgsDict']]] = None,
                 proposed_segment_change: Optional[pulumi.Input[Union['DirectConnectGatewayAttachmentProposedSegmentChangeArgs', 'DirectConnectGatewayAttachmentProposedSegmentChangeArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectConnectGatewayAttachmentArgs.__new__(DirectConnectGatewayAttachmentArgs)

            if core_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'core_network_id'")
            __props__.__dict__["core_network_id"] = core_network_id
            if direct_connect_gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_gateway_arn'")
            __props__.__dict__["direct_connect_gateway_arn"] = direct_connect_gateway_arn
            if edge_locations is None and not opts.urn:
                raise TypeError("Missing required property 'edge_locations'")
            __props__.__dict__["edge_locations"] = edge_locations
            __props__.__dict__["proposed_network_function_group_change"] = proposed_network_function_group_change
            __props__.__dict__["proposed_segment_change"] = proposed_segment_change
            __props__.__dict__["tags"] = tags
            __props__.__dict__["attachment_id"] = None
            __props__.__dict__["attachment_policy_rule_number"] = None
            __props__.__dict__["attachment_type"] = None
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["network_function_group_name"] = None
            __props__.__dict__["owner_account_id"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["segment_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["coreNetworkId", "directConnectGatewayArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DirectConnectGatewayAttachment, __self__).__init__(
            'aws-native:networkmanager:DirectConnectGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DirectConnectGatewayAttachment':
        """
        Get an existing DirectConnectGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DirectConnectGatewayAttachmentArgs.__new__(DirectConnectGatewayAttachmentArgs)

        __props__.__dict__["attachment_id"] = None
        __props__.__dict__["attachment_policy_rule_number"] = None
        __props__.__dict__["attachment_type"] = None
        __props__.__dict__["core_network_arn"] = None
        __props__.__dict__["core_network_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["direct_connect_gateway_arn"] = None
        __props__.__dict__["edge_locations"] = None
        __props__.__dict__["network_function_group_name"] = None
        __props__.__dict__["owner_account_id"] = None
        __props__.__dict__["proposed_network_function_group_change"] = None
        __props__.__dict__["proposed_segment_change"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["segment_name"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return DirectConnectGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Output[builtins.str]:
        """
        Id of the attachment.
        """
        return pulumi.get(self, "attachment_id")

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> pulumi.Output[builtins.int]:
        """
        The policy rule number associated with the attachment.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[builtins.str]:
        """
        Attachment type.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of a core network for the Direct Connect Gateway attachment.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of a core network for the Direct Connect Gateway attachment.
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation time of the attachment.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="directConnectGatewayArn")
    def direct_connect_gateway_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Direct Connect Gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_arn")

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The Regions where the edges are located.
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter(name="networkFunctionGroupName")
    def network_function_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the network function group attachment.
        """
        return pulumi.get(self, "network_function_group_name")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[builtins.str]:
        """
        Owner account of the attachment.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="proposedNetworkFunctionGroupChange")
    def proposed_network_function_group_change(self) -> pulumi.Output[Optional['outputs.DirectConnectGatewayAttachmentProposedNetworkFunctionGroupChange']]:
        """
        The attachment to move from one network function group to another.
        """
        return pulumi.get(self, "proposed_network_function_group_change")

    @property
    @pulumi.getter(name="proposedSegmentChange")
    def proposed_segment_change(self) -> pulumi.Output[Optional['outputs.DirectConnectGatewayAttachmentProposedSegmentChange']]:
        """
        The attachment to move from one segment to another.
        """
        return pulumi.get(self, "proposed_segment_change")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Resource.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the segment attachment..
        """
        return pulumi.get(self, "segment_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the attachment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags for the attachment.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Last update time of the attachment.
        """
        return pulumi.get(self, "updated_at")

