# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'FirewallPolicy',
    'FirewallPolicyActionDefinition',
    'FirewallPolicyCustomAction',
    'FirewallPolicyDimension',
    'FirewallPolicyIpSet',
    'FirewallPolicyPolicyVariablesProperties',
    'FirewallPolicyPublishMetricAction',
    'FirewallPolicyStatefulEngineOptions',
    'FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties',
    'FirewallPolicyStatefulRuleGroupOverride',
    'FirewallPolicyStatefulRuleGroupReference',
    'FirewallPolicyStatelessRuleGroupReference',
    'FirewallSubnetMapping',
    'LoggingConfiguration',
    'LoggingConfigurationLogDestinationConfig',
    'RuleGroup',
    'RuleGroupActionDefinition',
    'RuleGroupAddress',
    'RuleGroupCustomAction',
    'RuleGroupDimension',
    'RuleGroupHeader',
    'RuleGroupIpSet',
    'RuleGroupIpSetReference',
    'RuleGroupMatchAttributes',
    'RuleGroupPortRange',
    'RuleGroupPortSet',
    'RuleGroupPublishMetricAction',
    'RuleGroupReferenceSets',
    'RuleGroupRuleDefinition',
    'RuleGroupRuleOption',
    'RuleGroupRuleVariables',
    'RuleGroupRulesSource',
    'RuleGroupRulesSourceList',
    'RuleGroupStatefulRule',
    'RuleGroupStatefulRuleOptions',
    'RuleGroupStatelessRule',
    'RuleGroupStatelessRulesAndCustomActions',
    'RuleGroupTcpFlagField',
    'TlsInspectionConfigurationAddress',
    'TlsInspectionConfigurationPortRange',
    'TlsInspectionConfigurationServerCertificate',
    'TlsInspectionConfigurationServerCertificateConfiguration',
    'TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties',
    'TlsInspectionConfigurationServerCertificateScope',
    'TlsInspectionConfigurationTlsInspectionConfiguration',
]

@pulumi.output_type
class FirewallPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statelessDefaultActions":
            suggest = "stateless_default_actions"
        elif key == "statelessFragmentDefaultActions":
            suggest = "stateless_fragment_default_actions"
        elif key == "policyVariables":
            suggest = "policy_variables"
        elif key == "statefulDefaultActions":
            suggest = "stateful_default_actions"
        elif key == "statefulEngineOptions":
            suggest = "stateful_engine_options"
        elif key == "statefulRuleGroupReferences":
            suggest = "stateful_rule_group_references"
        elif key == "statelessCustomActions":
            suggest = "stateless_custom_actions"
        elif key == "statelessRuleGroupReferences":
            suggest = "stateless_rule_group_references"
        elif key == "tlsInspectionConfigurationArn":
            suggest = "tls_inspection_configuration_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stateless_default_actions: Sequence[builtins.str],
                 stateless_fragment_default_actions: Sequence[builtins.str],
                 policy_variables: Optional['outputs.FirewallPolicyPolicyVariablesProperties'] = None,
                 stateful_default_actions: Optional[Sequence[builtins.str]] = None,
                 stateful_engine_options: Optional['outputs.FirewallPolicyStatefulEngineOptions'] = None,
                 stateful_rule_group_references: Optional[Sequence['outputs.FirewallPolicyStatefulRuleGroupReference']] = None,
                 stateless_custom_actions: Optional[Sequence['outputs.FirewallPolicyCustomAction']] = None,
                 stateless_rule_group_references: Optional[Sequence['outputs.FirewallPolicyStatelessRuleGroupReference']] = None,
                 tls_inspection_configuration_arn: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] stateless_default_actions: The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe` .
               
               You must specify one of the standard actions: `aws:pass` , `aws:drop` , or `aws:forward_to_sfe` . In addition, you can specify custom actions that are compatible with your standard section choice.
               
               For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", "customActionName"]` . For information about compatibility, see the custom action descriptions.
        :param Sequence[builtins.str] stateless_fragment_default_actions: The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. If you want non-matching fragmented packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe` .
               
               You must specify one of the standard actions: `aws:pass` , `aws:drop` , or `aws:forward_to_sfe` . In addition, you can specify custom actions that are compatible with your standard section choice.
               
               For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", "customActionName"]` . For information about compatibility, see the custom action descriptions.
        :param 'FirewallPolicyPolicyVariablesProperties' policy_variables: Contains variables that you can use to override default Suricata settings in your firewall policy.
        :param Sequence[builtins.str] stateful_default_actions: The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.
               
               Valid values of the stateful default action:
               
               - aws:drop_strict
               - aws:drop_established
               - aws:alert_strict
               - aws:alert_established
               
               For more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        :param 'FirewallPolicyStatefulEngineOptions' stateful_engine_options: Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
        :param Sequence['FirewallPolicyStatefulRuleGroupReference'] stateful_rule_group_references: References to the stateful rule groups that are used in the policy. These define the inspection criteria in stateful rules.
        :param Sequence['FirewallPolicyCustomAction'] stateless_custom_actions: The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting. You name each custom action that you define, and then you can use it by name in your default actions specifications.
        :param Sequence['FirewallPolicyStatelessRuleGroupReference'] stateless_rule_group_references: References to the stateless rule groups that are used in the policy. These define the matching criteria in stateless rules.
        :param builtins.str tls_inspection_configuration_arn: The Amazon Resource Name (ARN) of the TLS inspection configuration.
        """
        pulumi.set(__self__, "stateless_default_actions", stateless_default_actions)
        pulumi.set(__self__, "stateless_fragment_default_actions", stateless_fragment_default_actions)
        if policy_variables is not None:
            pulumi.set(__self__, "policy_variables", policy_variables)
        if stateful_default_actions is not None:
            pulumi.set(__self__, "stateful_default_actions", stateful_default_actions)
        if stateful_engine_options is not None:
            pulumi.set(__self__, "stateful_engine_options", stateful_engine_options)
        if stateful_rule_group_references is not None:
            pulumi.set(__self__, "stateful_rule_group_references", stateful_rule_group_references)
        if stateless_custom_actions is not None:
            pulumi.set(__self__, "stateless_custom_actions", stateless_custom_actions)
        if stateless_rule_group_references is not None:
            pulumi.set(__self__, "stateless_rule_group_references", stateless_rule_group_references)
        if tls_inspection_configuration_arn is not None:
            pulumi.set(__self__, "tls_inspection_configuration_arn", tls_inspection_configuration_arn)

    @property
    @pulumi.getter(name="statelessDefaultActions")
    def stateless_default_actions(self) -> Sequence[builtins.str]:
        """
        The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe` .

        You must specify one of the standard actions: `aws:pass` , `aws:drop` , or `aws:forward_to_sfe` . In addition, you can specify custom actions that are compatible with your standard section choice.

        For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", "customActionName"]` . For information about compatibility, see the custom action descriptions.
        """
        return pulumi.get(self, "stateless_default_actions")

    @property
    @pulumi.getter(name="statelessFragmentDefaultActions")
    def stateless_fragment_default_actions(self) -> Sequence[builtins.str]:
        """
        The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. If you want non-matching fragmented packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe` .

        You must specify one of the standard actions: `aws:pass` , `aws:drop` , or `aws:forward_to_sfe` . In addition, you can specify custom actions that are compatible with your standard section choice.

        For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", "customActionName"]` . For information about compatibility, see the custom action descriptions.
        """
        return pulumi.get(self, "stateless_fragment_default_actions")

    @property
    @pulumi.getter(name="policyVariables")
    def policy_variables(self) -> Optional['outputs.FirewallPolicyPolicyVariablesProperties']:
        """
        Contains variables that you can use to override default Suricata settings in your firewall policy.
        """
        return pulumi.get(self, "policy_variables")

    @property
    @pulumi.getter(name="statefulDefaultActions")
    def stateful_default_actions(self) -> Optional[Sequence[builtins.str]]:
        """
        The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.

        Valid values of the stateful default action:

        - aws:drop_strict
        - aws:drop_established
        - aws:alert_strict
        - aws:alert_established

        For more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "stateful_default_actions")

    @property
    @pulumi.getter(name="statefulEngineOptions")
    def stateful_engine_options(self) -> Optional['outputs.FirewallPolicyStatefulEngineOptions']:
        """
        Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
        """
        return pulumi.get(self, "stateful_engine_options")

    @property
    @pulumi.getter(name="statefulRuleGroupReferences")
    def stateful_rule_group_references(self) -> Optional[Sequence['outputs.FirewallPolicyStatefulRuleGroupReference']]:
        """
        References to the stateful rule groups that are used in the policy. These define the inspection criteria in stateful rules.
        """
        return pulumi.get(self, "stateful_rule_group_references")

    @property
    @pulumi.getter(name="statelessCustomActions")
    def stateless_custom_actions(self) -> Optional[Sequence['outputs.FirewallPolicyCustomAction']]:
        """
        The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting. You name each custom action that you define, and then you can use it by name in your default actions specifications.
        """
        return pulumi.get(self, "stateless_custom_actions")

    @property
    @pulumi.getter(name="statelessRuleGroupReferences")
    def stateless_rule_group_references(self) -> Optional[Sequence['outputs.FirewallPolicyStatelessRuleGroupReference']]:
        """
        References to the stateless rule groups that are used in the policy. These define the matching criteria in stateless rules.
        """
        return pulumi.get(self, "stateless_rule_group_references")

    @property
    @pulumi.getter(name="tlsInspectionConfigurationArn")
    def tls_inspection_configuration_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the TLS inspection configuration.
        """
        return pulumi.get(self, "tls_inspection_configuration_arn")


@pulumi.output_type
class FirewallPolicyActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMetricAction":
            suggest = "publish_metric_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_metric_action: Optional['outputs.FirewallPolicyPublishMetricAction'] = None):
        """
        :param 'FirewallPolicyPublishMetricAction' publish_metric_action: Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.
               
               You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
        """
        if publish_metric_action is not None:
            pulumi.set(__self__, "publish_metric_action", publish_metric_action)

    @property
    @pulumi.getter(name="publishMetricAction")
    def publish_metric_action(self) -> Optional['outputs.FirewallPolicyPublishMetricAction']:
        """
        Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.

        You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
        """
        return pulumi.get(self, "publish_metric_action")


@pulumi.output_type
class FirewallPolicyCustomAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionDefinition":
            suggest = "action_definition"
        elif key == "actionName":
            suggest = "action_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyCustomAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyCustomAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyCustomAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_definition: 'outputs.FirewallPolicyActionDefinition',
                 action_name: builtins.str):
        """
        :param 'FirewallPolicyActionDefinition' action_definition: The custom action associated with the action name.
        :param builtins.str action_name: The descriptive name of the custom action. You can't change the name of a custom action after you create it.
        """
        pulumi.set(__self__, "action_definition", action_definition)
        pulumi.set(__self__, "action_name", action_name)

    @property
    @pulumi.getter(name="actionDefinition")
    def action_definition(self) -> 'outputs.FirewallPolicyActionDefinition':
        """
        The custom action associated with the action name.
        """
        return pulumi.get(self, "action_definition")

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> builtins.str:
        """
        The descriptive name of the custom action. You can't change the name of a custom action after you create it.
        """
        return pulumi.get(self, "action_name")


@pulumi.output_type
class FirewallPolicyDimension(dict):
    def __init__(__self__, *,
                 value: builtins.str):
        """
        :param builtins.str value: The value to use in the custom metric dimension.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value to use in the custom metric dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FirewallPolicyIpSet(dict):
    def __init__(__self__, *,
                 definition: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] definition: The list of IP addresses and address ranges, in CIDR notation.
        """
        if definition is not None:
            pulumi.set(__self__, "definition", definition)

    @property
    @pulumi.getter
    def definition(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of IP addresses and address ranges, in CIDR notation.
        """
        return pulumi.get(self, "definition")


@pulumi.output_type
class FirewallPolicyPolicyVariablesProperties(dict):
    """
    Contains variables that you can use to override default Suricata settings in your firewall policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleVariables":
            suggest = "rule_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyPolicyVariablesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyPolicyVariablesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyPolicyVariablesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_variables: Optional[Mapping[str, 'outputs.FirewallPolicyIpSet']] = None):
        """
        Contains variables that you can use to override default Suricata settings in your firewall policy.
        """
        if rule_variables is not None:
            pulumi.set(__self__, "rule_variables", rule_variables)

    @property
    @pulumi.getter(name="ruleVariables")
    def rule_variables(self) -> Optional[Mapping[str, 'outputs.FirewallPolicyIpSet']]:
        return pulumi.get(self, "rule_variables")


@pulumi.output_type
class FirewallPolicyPublishMetricAction(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.FirewallPolicyDimension']):
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.FirewallPolicyDimension']:
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class FirewallPolicyStatefulEngineOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowTimeouts":
            suggest = "flow_timeouts"
        elif key == "ruleOrder":
            suggest = "rule_order"
        elif key == "streamExceptionPolicy":
            suggest = "stream_exception_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyStatefulEngineOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyStatefulEngineOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyStatefulEngineOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_timeouts: Optional['outputs.FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties'] = None,
                 rule_order: Optional['FirewallPolicyRuleOrder'] = None,
                 stream_exception_policy: Optional['FirewallPolicyStreamExceptionPolicy'] = None):
        """
        :param 'FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties' flow_timeouts: Configures the amount of time that can pass without any traffic sent through the firewall before the firewall determines that the connection is idle.
        :param 'FirewallPolicyRuleOrder' rule_order: Indicates how to manage the order of stateful rule evaluation for the policy. `DEFAULT_ACTION_ORDER` is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        :param 'FirewallPolicyStreamExceptionPolicy' stream_exception_policy: Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections can break due to disruptions in external networks or within the firewall itself.
               
               - `DROP` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is the default behavior.
               - `CONTINUE` - Network Firewall continues to apply rules to the subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you have a stateful rule to `drop http` traffic, Network Firewall won't match the traffic for this rule because the service won't have the context from session initialization defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a `flow:stateless` rule would still match, as would the `aws:drop_strict` default action.
               - `REJECT` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. Network Firewall also sends a TCP reject packet back to your client so that the client can immediately establish a new session. Network Firewall will have context about the new session and will apply rules to the subsequent traffic.
        """
        if flow_timeouts is not None:
            pulumi.set(__self__, "flow_timeouts", flow_timeouts)
        if rule_order is not None:
            pulumi.set(__self__, "rule_order", rule_order)
        if stream_exception_policy is not None:
            pulumi.set(__self__, "stream_exception_policy", stream_exception_policy)

    @property
    @pulumi.getter(name="flowTimeouts")
    def flow_timeouts(self) -> Optional['outputs.FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties']:
        """
        Configures the amount of time that can pass without any traffic sent through the firewall before the firewall determines that the connection is idle.
        """
        return pulumi.get(self, "flow_timeouts")

    @property
    @pulumi.getter(name="ruleOrder")
    def rule_order(self) -> Optional['FirewallPolicyRuleOrder']:
        """
        Indicates how to manage the order of stateful rule evaluation for the policy. `DEFAULT_ACTION_ORDER` is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "rule_order")

    @property
    @pulumi.getter(name="streamExceptionPolicy")
    def stream_exception_policy(self) -> Optional['FirewallPolicyStreamExceptionPolicy']:
        """
        Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections can break due to disruptions in external networks or within the firewall itself.

        - `DROP` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is the default behavior.
        - `CONTINUE` - Network Firewall continues to apply rules to the subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you have a stateful rule to `drop http` traffic, Network Firewall won't match the traffic for this rule because the service won't have the context from session initialization defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a `flow:stateless` rule would still match, as would the `aws:drop_strict` default action.
        - `REJECT` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. Network Firewall also sends a TCP reject packet back to your client so that the client can immediately establish a new session. Network Firewall will have context about the new session and will apply rules to the subsequent traffic.
        """
        return pulumi.get(self, "stream_exception_policy")


@pulumi.output_type
class FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties(dict):
    """
    Configures the amount of time that can pass without any traffic sent through the firewall before the firewall determines that the connection is idle.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tcpIdleTimeoutSeconds":
            suggest = "tcp_idle_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyStatefulEngineOptionsFlowTimeoutsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tcp_idle_timeout_seconds: Optional[builtins.int] = None):
        """
        Configures the amount of time that can pass without any traffic sent through the firewall before the firewall determines that the connection is idle.
        """
        if tcp_idle_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_idle_timeout_seconds", tcp_idle_timeout_seconds)

    @property
    @pulumi.getter(name="tcpIdleTimeoutSeconds")
    def tcp_idle_timeout_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "tcp_idle_timeout_seconds")


@pulumi.output_type
class FirewallPolicyStatefulRuleGroupOverride(dict):
    def __init__(__self__, *,
                 action: Optional['FirewallPolicyOverrideAction'] = None):
        """
        :param 'FirewallPolicyOverrideAction' action: The action that changes the rule group from `DROP` to `ALERT` . This only applies to managed rule groups.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter
    def action(self) -> Optional['FirewallPolicyOverrideAction']:
        """
        The action that changes the rule group from `DROP` to `ALERT` . This only applies to managed rule groups.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class FirewallPolicyStatefulRuleGroupReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyStatefulRuleGroupReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyStatefulRuleGroupReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyStatefulRuleGroupReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: builtins.str,
                 override: Optional['outputs.FirewallPolicyStatefulRuleGroupOverride'] = None,
                 priority: Optional[builtins.int] = None):
        """
        :param builtins.str resource_arn: The Amazon Resource Name (ARN) of the stateful rule group.
        :param 'FirewallPolicyStatefulRuleGroupOverride' override: The action that allows the policy owner to override the behavior of the rule group within a policy.
        :param builtins.int priority: An integer setting that indicates the order in which to run the stateful rule groups in a single `FirewallPolicy` . This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.
               
               Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
               
               You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the stateful rule group.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def override(self) -> Optional['outputs.FirewallPolicyStatefulRuleGroupOverride']:
        """
        The action that allows the policy owner to override the behavior of the rule group within a policy.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.int]:
        """
        An integer setting that indicates the order in which to run the stateful rule groups in a single `FirewallPolicy` . This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.

        Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.

        You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class FirewallPolicyStatelessRuleGroupReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyStatelessRuleGroupReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyStatelessRuleGroupReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyStatelessRuleGroupReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority: builtins.int,
                 resource_arn: builtins.str):
        """
        :param builtins.int priority: An integer setting that indicates the order in which to run the stateless rule groups in a single `FirewallPolicy` . Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
        :param builtins.str resource_arn: The Amazon Resource Name (ARN) of the stateless rule group.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        An integer setting that indicates the order in which to run the stateless rule groups in a single `FirewallPolicy` . Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the stateless rule group.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class FirewallSubnetMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ipAddressType":
            suggest = "ip_address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallSubnetMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallSubnetMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallSubnetMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 ip_address_type: Optional[builtins.str] = None):
        """
        :param builtins.str subnet_id: A SubnetId.
        :param builtins.str ip_address_type: A IPAddressType
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        A SubnetId.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[builtins.str]:
        """
        A IPAddressType
        """
        return pulumi.get(self, "ip_address_type")


@pulumi.output_type
class LoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestinationConfigs":
            suggest = "log_destination_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_destination_configs: Sequence['outputs.LoggingConfigurationLogDestinationConfig']):
        """
        :param Sequence['LoggingConfigurationLogDestinationConfig'] log_destination_configs: Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful rule groups.
        """
        pulumi.set(__self__, "log_destination_configs", log_destination_configs)

    @property
    @pulumi.getter(name="logDestinationConfigs")
    def log_destination_configs(self) -> Sequence['outputs.LoggingConfigurationLogDestinationConfig']:
        """
        Defines the logging destinations for the logs for a firewall. Network Firewall generates logs for stateful rule groups.
        """
        return pulumi.get(self, "log_destination_configs")


@pulumi.output_type
class LoggingConfigurationLogDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestination":
            suggest = "log_destination"
        elif key == "logDestinationType":
            suggest = "log_destination_type"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigurationLogDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigurationLogDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigurationLogDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_destination: Mapping[str, builtins.str],
                 log_destination_type: 'LoggingConfigurationLogDestinationConfigLogDestinationType',
                 log_type: 'LoggingConfigurationLogDestinationConfigLogType'):
        """
        :param Mapping[str, builtins.str] log_destination: A key-value pair to configure the logDestinations.
        :param 'LoggingConfigurationLogDestinationConfigLogDestinationType' log_destination_type: The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
        :param 'LoggingConfigurationLogDestinationConfigLogType' log_type: The type of log to record. You can record the following types of logs from your Network Firewall stateful engine.
               
               - `ALERT` - Logs for traffic that matches your stateful rules and that have an action that sends an alert. A stateful rule sends alerts for the rule actions DROP, ALERT, and REJECT. For more information, see the `StatefulRule` property.
               - `FLOW` - Standard network traffic flow logs. The stateful rules engine records flow logs for all network traffic that it receives. Each flow log record captures the network flow for a specific standard stateless rule group.
               - `TLS` - Logs for events that are related to TLS inspection. For more information, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html) in the *Network Firewall Developer Guide* .
        """
        pulumi.set(__self__, "log_destination", log_destination)
        pulumi.set(__self__, "log_destination_type", log_destination_type)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Mapping[str, builtins.str]:
        """
        A key-value pair to configure the logDestinations.
        """
        return pulumi.get(self, "log_destination")

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> 'LoggingConfigurationLogDestinationConfigLogDestinationType':
        """
        The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
        """
        return pulumi.get(self, "log_destination_type")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> 'LoggingConfigurationLogDestinationConfigLogType':
        """
        The type of log to record. You can record the following types of logs from your Network Firewall stateful engine.

        - `ALERT` - Logs for traffic that matches your stateful rules and that have an action that sends an alert. A stateful rule sends alerts for the rule actions DROP, ALERT, and REJECT. For more information, see the `StatefulRule` property.
        - `FLOW` - Standard network traffic flow logs. The stateful rules engine records flow logs for all network traffic that it receives. Each flow log record captures the network flow for a specific standard stateless rule group.
        - `TLS` - Logs for events that are related to TLS inspection. For more information, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html) in the *Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class RuleGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rulesSource":
            suggest = "rules_source"
        elif key == "referenceSets":
            suggest = "reference_sets"
        elif key == "ruleVariables":
            suggest = "rule_variables"
        elif key == "statefulRuleOptions":
            suggest = "stateful_rule_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rules_source: 'outputs.RuleGroupRulesSource',
                 reference_sets: Optional['outputs.RuleGroupReferenceSets'] = None,
                 rule_variables: Optional['outputs.RuleGroupRuleVariables'] = None,
                 stateful_rule_options: Optional['outputs.RuleGroupStatefulRuleOptions'] = None):
        """
        :param 'RuleGroupRulesSource' rules_source: The stateful rules or stateless rules for the rule group.
        :param 'RuleGroupReferenceSets' reference_sets: The reference sets for the stateful rule group.
        :param 'RuleGroupRuleVariables' rule_variables: Settings that are available for use in the rules in the rule group. You can only use these for stateful rule groups.
        :param 'RuleGroupStatefulRuleOptions' stateful_rule_options: Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html) in the *AWS Network Firewall Developer Guide* .
        """
        pulumi.set(__self__, "rules_source", rules_source)
        if reference_sets is not None:
            pulumi.set(__self__, "reference_sets", reference_sets)
        if rule_variables is not None:
            pulumi.set(__self__, "rule_variables", rule_variables)
        if stateful_rule_options is not None:
            pulumi.set(__self__, "stateful_rule_options", stateful_rule_options)

    @property
    @pulumi.getter(name="rulesSource")
    def rules_source(self) -> 'outputs.RuleGroupRulesSource':
        """
        The stateful rules or stateless rules for the rule group.
        """
        return pulumi.get(self, "rules_source")

    @property
    @pulumi.getter(name="referenceSets")
    def reference_sets(self) -> Optional['outputs.RuleGroupReferenceSets']:
        """
        The reference sets for the stateful rule group.
        """
        return pulumi.get(self, "reference_sets")

    @property
    @pulumi.getter(name="ruleVariables")
    def rule_variables(self) -> Optional['outputs.RuleGroupRuleVariables']:
        """
        Settings that are available for use in the rules in the rule group. You can only use these for stateful rule groups.
        """
        return pulumi.get(self, "rule_variables")

    @property
    @pulumi.getter(name="statefulRuleOptions")
    def stateful_rule_options(self) -> Optional['outputs.RuleGroupStatefulRuleOptions']:
        """
        Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings. Some limitations apply; for more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-limitations-caveats.html) in the *AWS Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "stateful_rule_options")


@pulumi.output_type
class RuleGroupActionDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishMetricAction":
            suggest = "publish_metric_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupActionDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupActionDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupActionDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_metric_action: Optional['outputs.RuleGroupPublishMetricAction'] = None):
        """
        :param 'RuleGroupPublishMetricAction' publish_metric_action: Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.
               
               You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
        """
        if publish_metric_action is not None:
            pulumi.set(__self__, "publish_metric_action", publish_metric_action)

    @property
    @pulumi.getter(name="publishMetricAction")
    def publish_metric_action(self) -> Optional['outputs.RuleGroupPublishMetricAction']:
        """
        Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet. This setting defines a CloudWatch dimension value to be published.

        You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
        """
        return pulumi.get(self, "publish_metric_action")


@pulumi.output_type
class RuleGroupAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressDefinition":
            suggest = "address_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_definition: builtins.str):
        """
        :param builtins.str address_definition: Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
               
               Examples:
               
               - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
               - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
               - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
               - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .
               
               For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        pulumi.set(__self__, "address_definition", address_definition)

    @property
    @pulumi.getter(name="addressDefinition")
    def address_definition(self) -> builtins.str:
        """
        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.

        Examples:

        - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
        - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
        - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
        - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .

        For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        return pulumi.get(self, "address_definition")


@pulumi.output_type
class RuleGroupCustomAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionDefinition":
            suggest = "action_definition"
        elif key == "actionName":
            suggest = "action_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCustomAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCustomAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCustomAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_definition: 'outputs.RuleGroupActionDefinition',
                 action_name: builtins.str):
        """
        :param 'RuleGroupActionDefinition' action_definition: The custom action associated with the action name.
        :param builtins.str action_name: The descriptive name of the custom action. You can't change the name of a custom action after you create it.
        """
        pulumi.set(__self__, "action_definition", action_definition)
        pulumi.set(__self__, "action_name", action_name)

    @property
    @pulumi.getter(name="actionDefinition")
    def action_definition(self) -> 'outputs.RuleGroupActionDefinition':
        """
        The custom action associated with the action name.
        """
        return pulumi.get(self, "action_definition")

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> builtins.str:
        """
        The descriptive name of the custom action. You can't change the name of a custom action after you create it.
        """
        return pulumi.get(self, "action_name")


@pulumi.output_type
class RuleGroupDimension(dict):
    def __init__(__self__, *,
                 value: builtins.str):
        """
        :param builtins.str value: The value to use in the custom metric dimension.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value to use in the custom metric dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleGroupHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: builtins.str,
                 destination_port: builtins.str,
                 direction: 'RuleGroupHeaderDirection',
                 protocol: 'RuleGroupHeaderProtocol',
                 source: builtins.str,
                 source_port: builtins.str):
        """
        :param builtins.str destination: The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY` .
               
               Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
               
               Examples:
               
               - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
               - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
               - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
               - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .
               
               For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        :param builtins.str destination_port: The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
        :param 'RuleGroupHeaderDirection' direction: The direction of traffic flow to inspect. If set to `ANY` , the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to `FORWARD` , the inspection only matches traffic going from the source to the destination.
        :param 'RuleGroupHeaderProtocol' protocol: The protocol to inspect for. To specify all, you can use `IP` , because all traffic on AWS and on the internet is IP.
        :param builtins.str source: The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY` .
               
               Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
               
               Examples:
               
               - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
               - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
               - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
               - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .
               
               For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        :param builtins.str source_port: The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY` .

        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.

        Examples:

        - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
        - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
        - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
        - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .

        For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.str:
        """
        The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def direction(self) -> 'RuleGroupHeaderDirection':
        """
        The direction of traffic flow to inspect. If set to `ANY` , the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to `FORWARD` , the inspection only matches traffic going from the source to the destination.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> 'RuleGroupHeaderProtocol':
        """
        The protocol to inspect for. To specify all, you can use `IP` , because all traffic on AWS and on the internet is IP.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY` .

        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.

        Examples:

        - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
        - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
        - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
        - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .

        For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> builtins.str:
        """
        The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class RuleGroupIpSet(dict):
    def __init__(__self__, *,
                 definition: Optional[Sequence[builtins.str]] = None):
        if definition is not None:
            pulumi.set(__self__, "definition", definition)

    @property
    @pulumi.getter
    def definition(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "definition")


@pulumi.output_type
class RuleGroupIpSetReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceArn":
            suggest = "reference_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupIpSetReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupIpSetReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupIpSetReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_arn: Optional[builtins.str] = None):
        if reference_arn is not None:
            pulumi.set(__self__, "reference_arn", reference_arn)

    @property
    @pulumi.getter(name="referenceArn")
    def reference_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "reference_arn")


@pulumi.output_type
class RuleGroupMatchAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourcePorts":
            suggest = "source_ports"
        elif key == "tcpFlags":
            suggest = "tcp_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupMatchAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupMatchAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupMatchAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_ports: Optional[Sequence['outputs.RuleGroupPortRange']] = None,
                 destinations: Optional[Sequence['outputs.RuleGroupAddress']] = None,
                 protocols: Optional[Sequence[builtins.int]] = None,
                 source_ports: Optional[Sequence['outputs.RuleGroupPortRange']] = None,
                 sources: Optional[Sequence['outputs.RuleGroupAddress']] = None,
                 tcp_flags: Optional[Sequence['outputs.RuleGroupTcpFlagField']] = None):
        """
        :param Sequence['RuleGroupPortRange'] destination_ports: The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
               
               This setting is only used for protocols 6 (TCP) and 17 (UDP).
        :param Sequence['RuleGroupAddress'] destinations: The destination IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address.
        :param Sequence[builtins.int] protocols: The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If not specified, this matches with any protocol.
        :param Sequence['RuleGroupPortRange'] source_ports: The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .
               
               If not specified, this matches with any source port.
               
               This setting is only used for protocols 6 (TCP) and 17 (UDP).
        :param Sequence['RuleGroupAddress'] sources: The source IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address.
        :param Sequence['RuleGroupTcpFlagField'] tcp_flags: The TCP flags and masks to inspect for. If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
        """
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_ports is not None:
            pulumi.set(__self__, "source_ports", source_ports)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tcp_flags is not None:
            pulumi.set(__self__, "tcp_flags", tcp_flags)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence['outputs.RuleGroupPortRange']]:
        """
        The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .

        This setting is only used for protocols 6 (TCP) and 17 (UDP).
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.RuleGroupAddress']]:
        """
        The destination IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[builtins.int]]:
        """
        The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If not specified, this matches with any protocol.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> Optional[Sequence['outputs.RuleGroupPortRange']]:
        """
        The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994` . To match with any port, specify `ANY` .

        If not specified, this matches with any source port.

        This setting is only used for protocols 6 (TCP) and 17 (UDP).
        """
        return pulumi.get(self, "source_ports")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.RuleGroupAddress']]:
        """
        The source IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="tcpFlags")
    def tcp_flags(self) -> Optional[Sequence['outputs.RuleGroupTcpFlagField']]:
        """
        The TCP flags and masks to inspect for. If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
        """
        return pulumi.get(self, "tcp_flags")


@pulumi.output_type
class RuleGroupPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 to_port: builtins.int):
        """
        :param builtins.int from_port: The lower limit of the port range. This must be less than or equal to the `ToPort` specification.
        :param builtins.int to_port: The upper limit of the port range. This must be greater than or equal to the `FromPort` specification.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        The lower limit of the port range. This must be less than or equal to the `ToPort` specification.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        The upper limit of the port range. This must be greater than or equal to the `FromPort` specification.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class RuleGroupPortSet(dict):
    def __init__(__self__, *,
                 definition: Optional[Sequence[builtins.str]] = None):
        if definition is not None:
            pulumi.set(__self__, "definition", definition)

    @property
    @pulumi.getter
    def definition(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "definition")


@pulumi.output_type
class RuleGroupPublishMetricAction(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.RuleGroupDimension']):
        pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.RuleGroupDimension']:
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class RuleGroupReferenceSets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipSetReferences":
            suggest = "ip_set_references"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupReferenceSets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupReferenceSets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupReferenceSets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_set_references: Optional[Mapping[str, 'outputs.RuleGroupIpSetReference']] = None):
        """
        :param Mapping[str, 'RuleGroupIpSetReference'] ip_set_references: The IP set references to use in the stateful rule group.
        """
        if ip_set_references is not None:
            pulumi.set(__self__, "ip_set_references", ip_set_references)

    @property
    @pulumi.getter(name="ipSetReferences")
    def ip_set_references(self) -> Optional[Mapping[str, 'outputs.RuleGroupIpSetReference']]:
        """
        The IP set references to use in the stateful rule group.
        """
        return pulumi.get(self, "ip_set_references")


@pulumi.output_type
class RuleGroupRuleDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAttributes":
            suggest = "match_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[builtins.str],
                 match_attributes: 'outputs.RuleGroupMatchAttributes'):
        """
        :param Sequence[builtins.str] actions: The actions to take on a packet that matches one of the stateless rule definition's match attributes. You must specify a standard action and you can add custom actions.
               
               > Network Firewall only forwards a packet for stateful rule inspection if you specify `aws:forward_to_sfe` for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify `aws:forward_to_sfe` for the `StatelessDefaultActions` setting for the `FirewallPolicy` . 
               
               For every rule, you must specify exactly one of the following standard actions.
               
               - *aws:pass* - Discontinues all inspection of the packet and permits it to go to its intended destination.
               - *aws:drop* - Discontinues all inspection of the packet and blocks it from going to its intended destination.
               - *aws:forward_to_sfe* - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.
               
               Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this `Actions` setting.
               
               To provide more than one action in this setting, separate the settings with a comma. For example, if you have a publish metrics custom action that you've named `MyMetricsAction` , then you could specify the standard action `aws:pass` combined with the custom action using `["aws:pass", "MyMetricsAction"]` .
        :param 'RuleGroupMatchAttributes' match_attributes: Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "match_attributes", match_attributes)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[builtins.str]:
        """
        The actions to take on a packet that matches one of the stateless rule definition's match attributes. You must specify a standard action and you can add custom actions.

        > Network Firewall only forwards a packet for stateful rule inspection if you specify `aws:forward_to_sfe` for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify `aws:forward_to_sfe` for the `StatelessDefaultActions` setting for the `FirewallPolicy` . 

        For every rule, you must specify exactly one of the following standard actions.

        - *aws:pass* - Discontinues all inspection of the packet and permits it to go to its intended destination.
        - *aws:drop* - Discontinues all inspection of the packet and blocks it from going to its intended destination.
        - *aws:forward_to_sfe* - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.

        Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this `Actions` setting.

        To provide more than one action in this setting, separate the settings with a comma. For example, if you have a publish metrics custom action that you've named `MyMetricsAction` , then you could specify the standard action `aws:pass` combined with the custom action using `["aws:pass", "MyMetricsAction"]` .
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="matchAttributes")
    def match_attributes(self) -> 'outputs.RuleGroupMatchAttributes':
        """
        Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
        """
        return pulumi.get(self, "match_attributes")


@pulumi.output_type
class RuleGroupRuleOption(dict):
    def __init__(__self__, *,
                 keyword: builtins.str,
                 settings: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str keyword: The Suricata rule option keywords. For Network Firewall , the keyword signature ID (sid) is required in the format `sid:112233` . The sid must be unique within the rule group. For information about Suricata rule option keywords, see [Rule options](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) .
        :param Sequence[builtins.str] settings: The Suricata rule option settings. Settings have zero or more values, and the number of possible settings and required settings depends on the keyword. The format for Settings is `number` . For information about Suricata rule option settings, see [Rule options](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) .
        """
        pulumi.set(__self__, "keyword", keyword)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def keyword(self) -> builtins.str:
        """
        The Suricata rule option keywords. For Network Firewall , the keyword signature ID (sid) is required in the format `sid:112233` . The sid must be unique within the rule group. For information about Suricata rule option keywords, see [Rule options](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) .
        """
        return pulumi.get(self, "keyword")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Sequence[builtins.str]]:
        """
        The Suricata rule option settings. Settings have zero or more values, and the number of possible settings and required settings depends on the keyword. The format for Settings is `number` . For information about Suricata rule option settings, see [Rule options](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) .
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class RuleGroupRuleVariables(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipSets":
            suggest = "ip_sets"
        elif key == "portSets":
            suggest = "port_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRuleVariables. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRuleVariables.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRuleVariables.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_sets: Optional[Mapping[str, 'outputs.RuleGroupIpSet']] = None,
                 port_sets: Optional[Mapping[str, 'outputs.RuleGroupPortSet']] = None):
        """
        :param Mapping[str, 'RuleGroupIpSet'] ip_sets: A list of IP addresses and address ranges, in CIDR notation.
        :param Mapping[str, 'RuleGroupPortSet'] port_sets: A list of port ranges.
        """
        if ip_sets is not None:
            pulumi.set(__self__, "ip_sets", ip_sets)
        if port_sets is not None:
            pulumi.set(__self__, "port_sets", port_sets)

    @property
    @pulumi.getter(name="ipSets")
    def ip_sets(self) -> Optional[Mapping[str, 'outputs.RuleGroupIpSet']]:
        """
        A list of IP addresses and address ranges, in CIDR notation.
        """
        return pulumi.get(self, "ip_sets")

    @property
    @pulumi.getter(name="portSets")
    def port_sets(self) -> Optional[Mapping[str, 'outputs.RuleGroupPortSet']]:
        """
        A list of port ranges.
        """
        return pulumi.get(self, "port_sets")


@pulumi.output_type
class RuleGroupRulesSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rulesSourceList":
            suggest = "rules_source_list"
        elif key == "rulesString":
            suggest = "rules_string"
        elif key == "statefulRules":
            suggest = "stateful_rules"
        elif key == "statelessRulesAndCustomActions":
            suggest = "stateless_rules_and_custom_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRulesSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRulesSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRulesSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rules_source_list: Optional['outputs.RuleGroupRulesSourceList'] = None,
                 rules_string: Optional[builtins.str] = None,
                 stateful_rules: Optional[Sequence['outputs.RuleGroupStatefulRule']] = None,
                 stateless_rules_and_custom_actions: Optional['outputs.RuleGroupStatelessRulesAndCustomActions'] = None):
        """
        :param 'RuleGroupRulesSourceList' rules_source_list: Stateful inspection criteria for a domain list rule group.
        :param builtins.str rules_string: Stateful inspection criteria, provided in Suricata compatible rules. Suricata is an open-source threat detection framework that includes a standard rule-based language for network traffic inspection.
               
               These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this type of rule group doesn't have a separate action setting.
               
               > You can't use the `priority` keyword if the `RuleOrder` option in `StatefulRuleOptions` is set to `STRICT_ORDER` .
        :param Sequence['RuleGroupStatefulRule'] stateful_rules: An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata `Rules` format, see [Rules Format](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html) .
        :param 'RuleGroupStatelessRulesAndCustomActions' stateless_rules_and_custom_actions: Stateless inspection criteria to be used in a stateless rule group.
        """
        if rules_source_list is not None:
            pulumi.set(__self__, "rules_source_list", rules_source_list)
        if rules_string is not None:
            pulumi.set(__self__, "rules_string", rules_string)
        if stateful_rules is not None:
            pulumi.set(__self__, "stateful_rules", stateful_rules)
        if stateless_rules_and_custom_actions is not None:
            pulumi.set(__self__, "stateless_rules_and_custom_actions", stateless_rules_and_custom_actions)

    @property
    @pulumi.getter(name="rulesSourceList")
    def rules_source_list(self) -> Optional['outputs.RuleGroupRulesSourceList']:
        """
        Stateful inspection criteria for a domain list rule group.
        """
        return pulumi.get(self, "rules_source_list")

    @property
    @pulumi.getter(name="rulesString")
    def rules_string(self) -> Optional[builtins.str]:
        """
        Stateful inspection criteria, provided in Suricata compatible rules. Suricata is an open-source threat detection framework that includes a standard rule-based language for network traffic inspection.

        These rules contain the inspection criteria and the action to take for traffic that matches the criteria, so this type of rule group doesn't have a separate action setting.

        > You can't use the `priority` keyword if the `RuleOrder` option in `StatefulRuleOptions` is set to `STRICT_ORDER` .
        """
        return pulumi.get(self, "rules_string")

    @property
    @pulumi.getter(name="statefulRules")
    def stateful_rules(self) -> Optional[Sequence['outputs.RuleGroupStatefulRule']]:
        """
        An array of individual stateful rules inspection criteria to be used together in a stateful rule group. Use this option to specify simple Suricata rules with protocol, source and destination, ports, direction, and rule options. For information about the Suricata `Rules` format, see [Rules Format](https://docs.aws.amazon.com/https://suricata.readthedocs.io/en/suricata-7.0.3/rules/intro.html) .
        """
        return pulumi.get(self, "stateful_rules")

    @property
    @pulumi.getter(name="statelessRulesAndCustomActions")
    def stateless_rules_and_custom_actions(self) -> Optional['outputs.RuleGroupStatelessRulesAndCustomActions']:
        """
        Stateless inspection criteria to be used in a stateless rule group.
        """
        return pulumi.get(self, "stateless_rules_and_custom_actions")


@pulumi.output_type
class RuleGroupRulesSourceList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generatedRulesType":
            suggest = "generated_rules_type"
        elif key == "targetTypes":
            suggest = "target_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRulesSourceList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRulesSourceList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRulesSourceList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generated_rules_type: 'RuleGroupGeneratedRulesType',
                 target_types: Sequence['RuleGroupTargetType'],
                 targets: Sequence[builtins.str]):
        """
        :param 'RuleGroupGeneratedRulesType' generated_rules_type: Whether you want to allow or deny access to the domains in your target list.
        :param Sequence['RuleGroupTargetType'] target_types: The types of targets to inspect for. Valid values are `TLS_SNI` and `HTTP_HOST` .
        :param Sequence[builtins.str] targets: The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:
               
               - Explicit names. For example, `abc.example.com` matches only the domain `abc.example.com` .
               - Names that use a domain wildcard, which you indicate with an initial ' `.` '. For example, `.example.com` matches `example.com` and matches all subdomains of `example.com` , such as `abc.example.com` and `www.example.com` .
        """
        pulumi.set(__self__, "generated_rules_type", generated_rules_type)
        pulumi.set(__self__, "target_types", target_types)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="generatedRulesType")
    def generated_rules_type(self) -> 'RuleGroupGeneratedRulesType':
        """
        Whether you want to allow or deny access to the domains in your target list.
        """
        return pulumi.get(self, "generated_rules_type")

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Sequence['RuleGroupTargetType']:
        """
        The types of targets to inspect for. Valid values are `TLS_SNI` and `HTTP_HOST` .
        """
        return pulumi.get(self, "target_types")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        The domains that you want to inspect for in your traffic flows. Valid domain specifications are the following:

        - Explicit names. For example, `abc.example.com` matches only the domain `abc.example.com` .
        - Names that use a domain wildcard, which you indicate with an initial ' `.` '. For example, `.example.com` matches `example.com` and matches all subdomains of `example.com` , such as `abc.example.com` and `www.example.com` .
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class RuleGroupStatefulRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleOptions":
            suggest = "rule_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupStatefulRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupStatefulRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupStatefulRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'RuleGroupStatefulRuleAction',
                 header: 'outputs.RuleGroupHeader',
                 rule_options: Sequence['outputs.RuleGroupRuleOption']):
        """
        :param 'RuleGroupStatefulRuleAction' action: Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.
               
               The actions for a stateful rule are defined as follows:
               
               - *PASS* - Permits the packets to go to the intended destination.
               - *DROP* - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the `Firewall` `LoggingConfiguration` .
               - *REJECT* - Drops traffic that matches the conditions of the stateful rule and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a `RST` bit contained in the TCP header flags. `REJECT` is available only for TCP traffic.
               - *ALERT* - Permits the packets to go to the intended destination and sends an alert log message, if alert logging is configured in the `Firewall` `LoggingConfiguration` .
               
               You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with `ALERT` action, verify in the logs that the rule is filtering as you want, then change the action to `DROP` .
               - *REJECT* - Drops TCP traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a `RST` bit contained in the TCP header flags. Also sends an alert log mesage if alert logging is configured in the `Firewall` `LoggingConfiguration` .
               
               `REJECT` isn't currently available for use with IMAP and FTP protocols.
        :param 'RuleGroupHeader' header: The stateful inspection criteria for this rule, used to inspect traffic flows.
        :param Sequence['RuleGroupRuleOption'] rule_options: Additional settings for a stateful rule, provided as keywords and settings.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "rule_options", rule_options)

    @property
    @pulumi.getter
    def action(self) -> 'RuleGroupStatefulRuleAction':
        """
        Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.

        The actions for a stateful rule are defined as follows:

        - *PASS* - Permits the packets to go to the intended destination.
        - *DROP* - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the `Firewall` `LoggingConfiguration` .
        - *REJECT* - Drops traffic that matches the conditions of the stateful rule and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a `RST` bit contained in the TCP header flags. `REJECT` is available only for TCP traffic.
        - *ALERT* - Permits the packets to go to the intended destination and sends an alert log message, if alert logging is configured in the `Firewall` `LoggingConfiguration` .

        You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with `ALERT` action, verify in the logs that the rule is filtering as you want, then change the action to `DROP` .
        - *REJECT* - Drops TCP traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and a `RST` bit contained in the TCP header flags. Also sends an alert log mesage if alert logging is configured in the `Firewall` `LoggingConfiguration` .

        `REJECT` isn't currently available for use with IMAP and FTP protocols.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def header(self) -> 'outputs.RuleGroupHeader':
        """
        The stateful inspection criteria for this rule, used to inspect traffic flows.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="ruleOptions")
    def rule_options(self) -> Sequence['outputs.RuleGroupRuleOption']:
        """
        Additional settings for a stateful rule, provided as keywords and settings.
        """
        return pulumi.get(self, "rule_options")


@pulumi.output_type
class RuleGroupStatefulRuleOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleOrder":
            suggest = "rule_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupStatefulRuleOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupStatefulRuleOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupStatefulRuleOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_order: Optional['RuleGroupRuleOrder'] = None):
        """
        :param 'RuleGroupRuleOrder' rule_order: Indicates how to manage the order of the rule evaluation for the rule group. `DEFAULT_ACTION_ORDER` is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        """
        if rule_order is not None:
            pulumi.set(__self__, "rule_order", rule_order)

    @property
    @pulumi.getter(name="ruleOrder")
    def rule_order(self) -> Optional['RuleGroupRuleOrder']:
        """
        Indicates how to manage the order of the rule evaluation for the rule group. `DEFAULT_ACTION_ORDER` is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *AWS Network Firewall Developer Guide* .
        """
        return pulumi.get(self, "rule_order")


@pulumi.output_type
class RuleGroupStatelessRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleDefinition":
            suggest = "rule_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupStatelessRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupStatelessRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupStatelessRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority: builtins.int,
                 rule_definition: 'outputs.RuleGroupRuleDefinition'):
        """
        :param builtins.int priority: Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.
               
               Each stateless rule group uses exactly one `StatelessRulesAndCustomActions` object, and each `StatelessRulesAndCustomActions` contains exactly one `StatelessRules` object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single `StatelessRules` object.
               
               You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
        :param 'RuleGroupRuleDefinition' rule_definition: Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_definition", rule_definition)

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must ensure that the priority settings are unique for the rule group.

        Each stateless rule group uses exactly one `StatelessRulesAndCustomActions` object, and each `StatelessRulesAndCustomActions` contains exactly one `StatelessRules` object. To ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you define inside any single `StatelessRules` object.

        You can change the priority settings of your rules at any time. To make it easier to insert rules later, number them so there's a wide range in between, for example use 100, 200, and so on.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleDefinition")
    def rule_definition(self) -> 'outputs.RuleGroupRuleDefinition':
        """
        Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria.
        """
        return pulumi.get(self, "rule_definition")


@pulumi.output_type
class RuleGroupStatelessRulesAndCustomActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statelessRules":
            suggest = "stateless_rules"
        elif key == "customActions":
            suggest = "custom_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupStatelessRulesAndCustomActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupStatelessRulesAndCustomActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupStatelessRulesAndCustomActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stateless_rules: Sequence['outputs.RuleGroupStatelessRule'],
                 custom_actions: Optional[Sequence['outputs.RuleGroupCustomAction']] = None):
        """
        :param Sequence['RuleGroupStatelessRule'] stateless_rules: Defines the set of stateless rules for use in a stateless rule group.
        :param Sequence['RuleGroupCustomAction'] custom_actions: Defines an array of individual custom action definitions that are available for use by the stateless rules in this `StatelessRulesAndCustomActions` specification. You name each custom action that you define, and then you can use it by name in your stateless rule `RuleGroup.RuleDefinition` `Actions` specification.
        """
        pulumi.set(__self__, "stateless_rules", stateless_rules)
        if custom_actions is not None:
            pulumi.set(__self__, "custom_actions", custom_actions)

    @property
    @pulumi.getter(name="statelessRules")
    def stateless_rules(self) -> Sequence['outputs.RuleGroupStatelessRule']:
        """
        Defines the set of stateless rules for use in a stateless rule group.
        """
        return pulumi.get(self, "stateless_rules")

    @property
    @pulumi.getter(name="customActions")
    def custom_actions(self) -> Optional[Sequence['outputs.RuleGroupCustomAction']]:
        """
        Defines an array of individual custom action definitions that are available for use by the stateless rules in this `StatelessRulesAndCustomActions` specification. You name each custom action that you define, and then you can use it by name in your stateless rule `RuleGroup.RuleDefinition` `Actions` specification.
        """
        return pulumi.get(self, "custom_actions")


@pulumi.output_type
class RuleGroupTcpFlagField(dict):
    def __init__(__self__, *,
                 flags: Sequence['RuleGroupTcpFlag'],
                 masks: Optional[Sequence['RuleGroupTcpFlag']] = None):
        """
        :param Sequence['RuleGroupTcpFlag'] flags: Used in conjunction with the `Masks` setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the `Masks` setting.
               
               For the flags that are specified in the masks setting, the following must be true for the packet to match:
               
               - The ones that are set in this flags setting must be set in the packet.
               - The ones that are not set in this flags setting must also not be set in the packet.
        :param Sequence['RuleGroupTcpFlag'] masks: The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.
        """
        pulumi.set(__self__, "flags", flags)
        if masks is not None:
            pulumi.set(__self__, "masks", masks)

    @property
    @pulumi.getter
    def flags(self) -> Sequence['RuleGroupTcpFlag']:
        """
        Used in conjunction with the `Masks` setting to define the flags that must be set and flags that must not be set in order for the packet to match. This setting can only specify values that are also specified in the `Masks` setting.

        For the flags that are specified in the masks setting, the following must be true for the packet to match:

        - The ones that are set in this flags setting must be set in the packet.
        - The ones that are not set in this flags setting must also not be set in the packet.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def masks(self) -> Optional[Sequence['RuleGroupTcpFlag']]:
        """
        The set of flags to consider in the inspection. To inspect all flags in the valid values list, leave this with no setting.
        """
        return pulumi.get(self, "masks")


@pulumi.output_type
class TlsInspectionConfigurationAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressDefinition":
            suggest = "address_definition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_definition: builtins.str):
        """
        :param builtins.str address_definition: Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
               
               Examples:
               
               - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
               - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
               - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
               - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .
               
               For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        pulumi.set(__self__, "address_definition", address_definition)

    @property
    @pulumi.getter(name="addressDefinition")
    def address_definition(self) -> builtins.str:
        """
        Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.

        Examples:

        - To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32` .
        - To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24` .
        - To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128` .
        - To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64` .

        For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) .
        """
        return pulumi.get(self, "address_definition")


@pulumi.output_type
class TlsInspectionConfigurationPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: builtins.int,
                 to_port: builtins.int):
        """
        :param builtins.int from_port: The lower limit of the port range. This must be less than or equal to the `ToPort` specification.
        :param builtins.int to_port: The upper limit of the port range. This must be greater than or equal to the `FromPort` specification.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> builtins.int:
        """
        The lower limit of the port range. This must be less than or equal to the `ToPort` specification.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> builtins.int:
        """
        The upper limit of the port range. This must be greater than or equal to the `FromPort` specification.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class TlsInspectionConfigurationServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: Optional[builtins.str] = None):
        """
        :param builtins.str resource_arn: The Amazon Resource Name (ARN) of the AWS Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
        """
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager SSL/TLS server certificate that's used for inbound SSL/TLS inspection.
        """
        return pulumi.get(self, "resource_arn")


@pulumi.output_type
class TlsInspectionConfigurationServerCertificateConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArn":
            suggest = "certificate_authority_arn"
        elif key == "checkCertificateRevocationStatus":
            suggest = "check_certificate_revocation_status"
        elif key == "serverCertificates":
            suggest = "server_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationServerCertificateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationServerCertificateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationServerCertificateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arn: Optional[builtins.str] = None,
                 check_certificate_revocation_status: Optional['outputs.TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties'] = None,
                 scopes: Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificateScope']] = None,
                 server_certificates: Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificate']] = None):
        """
        :param builtins.str certificate_authority_arn: The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within AWS Certificate Manager (ACM) to use for outbound SSL/TLS inspection.
               
               The following limitations apply:
               
               - You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.
               - You can't use certificates issued by AWS Private Certificate Authority .
               
               For more information about configuring certificates for outbound inspection, see [Using SSL/TLS certificates with certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *AWS Network Firewall Developer Guide* .
               
               For information about working with certificates in ACM, see [Importing certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .
        :param 'TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties' check_certificate_revocation_status: When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in [ServerCertificateConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html) .
        :param Sequence['TlsInspectionConfigurationServerCertificateScope'] scopes: A list of scopes.
        :param Sequence['TlsInspectionConfigurationServerCertificate'] server_certificates: The list of server certificates to use for inbound SSL/TLS inspection.
        """
        if certificate_authority_arn is not None:
            pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if check_certificate_revocation_status is not None:
            pulumi.set(__self__, "check_certificate_revocation_status", check_certificate_revocation_status)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if server_certificates is not None:
            pulumi.set(__self__, "server_certificates", server_certificates)

    @property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within AWS Certificate Manager (ACM) to use for outbound SSL/TLS inspection.

        The following limitations apply:

        - You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.
        - You can't use certificates issued by AWS Private Certificate Authority .

        For more information about configuring certificates for outbound inspection, see [Using SSL/TLS certificates with certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *AWS Network Firewall Developer Guide* .

        For information about working with certificates in ACM, see [Importing certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .
        """
        return pulumi.get(self, "certificate_authority_arn")

    @property
    @pulumi.getter(name="checkCertificateRevocationStatus")
    def check_certificate_revocation_status(self) -> Optional['outputs.TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties']:
        """
        When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in [ServerCertificateConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html) .
        """
        return pulumi.get(self, "check_certificate_revocation_status")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificateScope']]:
        """
        A list of scopes.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="serverCertificates")
    def server_certificates(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificate']]:
        """
        The list of server certificates to use for inbound SSL/TLS inspection.
        """
        return pulumi.get(self, "server_certificates")


@pulumi.output_type
class TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties(dict):
    """
    When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in [ServerCertificateConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html) .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revokedStatusAction":
            suggest = "revoked_status_action"
        elif key == "unknownStatusAction":
            suggest = "unknown_status_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatusProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revoked_status_action: Optional['TlsInspectionConfigurationRevokedStatusAction'] = None,
                 unknown_status_action: Optional['TlsInspectionConfigurationUnknownStatusAction'] = None):
        """
        When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in [ServerCertificateConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-servercertificateconfiguration.html) .
        """
        if revoked_status_action is not None:
            pulumi.set(__self__, "revoked_status_action", revoked_status_action)
        if unknown_status_action is not None:
            pulumi.set(__self__, "unknown_status_action", unknown_status_action)

    @property
    @pulumi.getter(name="revokedStatusAction")
    def revoked_status_action(self) -> Optional['TlsInspectionConfigurationRevokedStatusAction']:
        return pulumi.get(self, "revoked_status_action")

    @property
    @pulumi.getter(name="unknownStatusAction")
    def unknown_status_action(self) -> Optional['TlsInspectionConfigurationUnknownStatusAction']:
        return pulumi.get(self, "unknown_status_action")


@pulumi.output_type
class TlsInspectionConfigurationServerCertificateScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourcePorts":
            suggest = "source_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationServerCertificateScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationServerCertificateScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationServerCertificateScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_ports: Optional[Sequence['outputs.TlsInspectionConfigurationPortRange']] = None,
                 destinations: Optional[Sequence['outputs.TlsInspectionConfigurationAddress']] = None,
                 protocols: Optional[Sequence[builtins.int]] = None,
                 source_ports: Optional[Sequence['outputs.TlsInspectionConfigurationPortRange']] = None,
                 sources: Optional[Sequence['outputs.TlsInspectionConfigurationAddress']] = None):
        """
        :param Sequence['TlsInspectionConfigurationPortRange'] destination_ports: The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any destination port.
               
               You can specify individual ports, for example `1994` , and you can specify port ranges, such as `1990:1994` .
        :param Sequence['TlsInspectionConfigurationAddress'] destinations: The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this
               matches with any destination address.
        :param Sequence[builtins.int] protocols: The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If not specified, this matches with any protocol.
               
               Network Firewall currently supports only TCP.
        :param Sequence['TlsInspectionConfigurationPortRange'] source_ports: The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any source port.
               
               You can specify individual ports, for example `1994` , and you can specify port ranges, such as `1990:1994` .
        :param Sequence['TlsInspectionConfigurationAddress'] sources: The source IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this
               matches with any source address.
        """
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_ports is not None:
            pulumi.set(__self__, "source_ports", source_ports)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationPortRange']]:
        """
        The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any destination port.

        You can specify individual ports, for example `1994` , and you can specify port ranges, such as `1990:1994` .
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationAddress']]:
        """
        The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this
        matches with any destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[builtins.int]]:
        """
        The protocols to inspect for, specified using the assigned internet protocol number (IANA) for each protocol. If not specified, this matches with any protocol.

        Network Firewall currently supports only TCP.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourcePorts")
    def source_ports(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationPortRange']]:
        """
        The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any source port.

        You can specify individual ports, for example `1994` , and you can specify port ranges, such as `1990:1994` .
        """
        return pulumi.get(self, "source_ports")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationAddress']]:
        """
        The source IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this
        matches with any source address.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class TlsInspectionConfigurationTlsInspectionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverCertificateConfigurations":
            suggest = "server_certificate_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsInspectionConfigurationTlsInspectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsInspectionConfigurationTlsInspectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsInspectionConfigurationTlsInspectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_certificate_configurations: Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificateConfiguration']] = None):
        """
        :param Sequence['TlsInspectionConfigurationServerCertificateConfiguration'] server_certificate_configurations: Lists the server certificate configurations that are associated with the TLS configuration.
        """
        if server_certificate_configurations is not None:
            pulumi.set(__self__, "server_certificate_configurations", server_certificate_configurations)

    @property
    @pulumi.getter(name="serverCertificateConfigurations")
    def server_certificate_configurations(self) -> Optional[Sequence['outputs.TlsInspectionConfigurationServerCertificateConfiguration']]:
        """
        Lists the server certificate configurations that are associated with the TLS configuration.
        """
        return pulumi.get(self, "server_certificate_configurations")


