# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRuleGroupResult',
    'AwaitableGetRuleGroupResult',
    'get_rule_group',
    'get_rule_group_output',
]

@pulumi.output_type
class GetRuleGroupResult:
    def __init__(__self__, description=None, rule_group=None, rule_group_arn=None, rule_group_id=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if rule_group and not isinstance(rule_group, dict):
            raise TypeError("Expected argument 'rule_group' to be a dict")
        pulumi.set(__self__, "rule_group", rule_group)
        if rule_group_arn and not isinstance(rule_group_arn, str):
            raise TypeError("Expected argument 'rule_group_arn' to be a str")
        pulumi.set(__self__, "rule_group_arn", rule_group_arn)
        if rule_group_id and not isinstance(rule_group_id, str):
            raise TypeError("Expected argument 'rule_group_id' to be a str")
        pulumi.set(__self__, "rule_group_id", rule_group_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the rule group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ruleGroup")
    def rule_group(self) -> Optional['outputs.RuleGroup']:
        """
        An object that defines the rule group rules.
        """
        return pulumi.get(self, "rule_group")

    @property
    @pulumi.getter(name="ruleGroupArn")
    def rule_group_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the `RuleGroup` .
        """
        return pulumi.get(self, "rule_group_arn")

    @property
    @pulumi.getter(name="ruleGroupId")
    def rule_group_id(self) -> Optional[builtins.str]:
        """
        The unique ID of the `RuleGroup` resource.
        """
        return pulumi.get(self, "rule_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetRuleGroupResult(GetRuleGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleGroupResult(
            description=self.description,
            rule_group=self.rule_group,
            rule_group_arn=self.rule_group_arn,
            rule_group_id=self.rule_group_id,
            tags=self.tags)


def get_rule_group(rule_group_arn: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleGroupResult:
    """
    Resource type definition for AWS::NetworkFirewall::RuleGroup


    :param builtins.str rule_group_arn: The Amazon Resource Name (ARN) of the `RuleGroup` .
    """
    __args__ = dict()
    __args__['ruleGroupArn'] = rule_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:networkfirewall:getRuleGroup', __args__, opts=opts, typ=GetRuleGroupResult).value

    return AwaitableGetRuleGroupResult(
        description=pulumi.get(__ret__, 'description'),
        rule_group=pulumi.get(__ret__, 'rule_group'),
        rule_group_arn=pulumi.get(__ret__, 'rule_group_arn'),
        rule_group_id=pulumi.get(__ret__, 'rule_group_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_rule_group_output(rule_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleGroupResult]:
    """
    Resource type definition for AWS::NetworkFirewall::RuleGroup


    :param builtins.str rule_group_arn: The Amazon Resource Name (ARN) of the `RuleGroup` .
    """
    __args__ = dict()
    __args__['ruleGroupArn'] = rule_group_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:networkfirewall:getRuleGroup', __args__, opts=opts, typ=GetRuleGroupResult)
    return __ret__.apply(lambda __response__: GetRuleGroupResult(
        description=pulumi.get(__response__, 'description'),
        rule_group=pulumi.get(__response__, 'rule_group'),
        rule_group_arn=pulumi.get(__response__, 'rule_group_arn'),
        rule_group_id=pulumi.get(__response__, 'rule_group_id'),
        tags=pulumi.get(__response__, 'tags')))
