# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetFirewallResult',
    'AwaitableGetFirewallResult',
    'get_firewall',
    'get_firewall_output',
]

@pulumi.output_type
class GetFirewallResult:
    def __init__(__self__, delete_protection=None, description=None, enabled_analysis_types=None, endpoint_ids=None, firewall_arn=None, firewall_id=None, firewall_policy_arn=None, firewall_policy_change_protection=None, subnet_change_protection=None, subnet_mappings=None, tags=None):
        if delete_protection and not isinstance(delete_protection, bool):
            raise TypeError("Expected argument 'delete_protection' to be a bool")
        pulumi.set(__self__, "delete_protection", delete_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled_analysis_types and not isinstance(enabled_analysis_types, list):
            raise TypeError("Expected argument 'enabled_analysis_types' to be a list")
        pulumi.set(__self__, "enabled_analysis_types", enabled_analysis_types)
        if endpoint_ids and not isinstance(endpoint_ids, list):
            raise TypeError("Expected argument 'endpoint_ids' to be a list")
        pulumi.set(__self__, "endpoint_ids", endpoint_ids)
        if firewall_arn and not isinstance(firewall_arn, str):
            raise TypeError("Expected argument 'firewall_arn' to be a str")
        pulumi.set(__self__, "firewall_arn", firewall_arn)
        if firewall_id and not isinstance(firewall_id, str):
            raise TypeError("Expected argument 'firewall_id' to be a str")
        pulumi.set(__self__, "firewall_id", firewall_id)
        if firewall_policy_arn and not isinstance(firewall_policy_arn, str):
            raise TypeError("Expected argument 'firewall_policy_arn' to be a str")
        pulumi.set(__self__, "firewall_policy_arn", firewall_policy_arn)
        if firewall_policy_change_protection and not isinstance(firewall_policy_change_protection, bool):
            raise TypeError("Expected argument 'firewall_policy_change_protection' to be a bool")
        pulumi.set(__self__, "firewall_policy_change_protection", firewall_policy_change_protection)
        if subnet_change_protection and not isinstance(subnet_change_protection, bool):
            raise TypeError("Expected argument 'subnet_change_protection' to be a bool")
        pulumi.set(__self__, "subnet_change_protection", subnet_change_protection)
        if subnet_mappings and not isinstance(subnet_mappings, list):
            raise TypeError("Expected argument 'subnet_mappings' to be a list")
        pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[builtins.bool]:
        """
        A flag indicating whether it is possible to delete the firewall. A setting of `TRUE` indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to `TRUE` .
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the firewall.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enabledAnalysisTypes")
    def enabled_analysis_types(self) -> Optional[Sequence['FirewallEnabledAnalysisType']]:
        """
        The types of analysis to enable for the firewall. Can be TLS_SNI, HTTP_HOST, or both.
        """
        return pulumi.get(self, "enabled_analysis_types")

    @property
    @pulumi.getter(name="endpointIds")
    def endpoint_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The unique IDs of the firewall endpoints for all of the subnets that you attached to the firewall. The subnets are not listed in any particular order. For example: `["us-west-2c:vpce-111122223333", "us-west-2a:vpce-987654321098", "us-west-2b:vpce-012345678901"]` .
        """
        return pulumi.get(self, "endpoint_ids")

    @property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the `Firewall` .
        """
        return pulumi.get(self, "firewall_arn")

    @property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[builtins.str]:
        """
        The name of the `Firewall` resource.
        """
        return pulumi.get(self, "firewall_id")

    @property
    @pulumi.getter(name="firewallPolicyArn")
    def firewall_policy_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the firewall policy.

        The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
        """
        return pulumi.get(self, "firewall_policy_arn")

    @property
    @pulumi.getter(name="firewallPolicyChangeProtection")
    def firewall_policy_change_protection(self) -> Optional[builtins.bool]:
        """
        A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE` .
        """
        return pulumi.get(self, "firewall_policy_change_protection")

    @property
    @pulumi.getter(name="subnetChangeProtection")
    def subnet_change_protection(self) -> Optional[builtins.bool]:
        """
        A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE` .
        """
        return pulumi.get(self, "subnet_change_protection")

    @property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[Sequence['outputs.FirewallSubnetMapping']]:
        """
        The primary public subnets that Network Firewall is using for the firewall. Network Firewall creates a firewall endpoint in each subnet. Create a subnet mapping for each Availability Zone where you want to use the firewall.

        These subnets are all defined for a single, primary VPC, and each must belong to a different Availability Zone. Each of these subnets establishes the availability of the firewall in its Availability Zone.

        In addition to these subnets, you can define other endpoints for the firewall in `VpcEndpointAssociation` resources. You can define these additional endpoints for any VPC, and for any of the Availability Zones where the firewall resource already has a subnet mapping. VPC endpoint associations give you the ability to protect multiple VPCs using a single firewall, and to define multiple firewall endpoints for a VPC in a single Availability Zone.
        """
        return pulumi.get(self, "subnet_mappings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetFirewallResult(GetFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallResult(
            delete_protection=self.delete_protection,
            description=self.description,
            enabled_analysis_types=self.enabled_analysis_types,
            endpoint_ids=self.endpoint_ids,
            firewall_arn=self.firewall_arn,
            firewall_id=self.firewall_id,
            firewall_policy_arn=self.firewall_policy_arn,
            firewall_policy_change_protection=self.firewall_policy_change_protection,
            subnet_change_protection=self.subnet_change_protection,
            subnet_mappings=self.subnet_mappings,
            tags=self.tags)


def get_firewall(firewall_arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallResult:
    """
    Resource type definition for AWS::NetworkFirewall::Firewall


    :param builtins.str firewall_arn: The Amazon Resource Name (ARN) of the `Firewall` .
    """
    __args__ = dict()
    __args__['firewallArn'] = firewall_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:networkfirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult).value

    return AwaitableGetFirewallResult(
        delete_protection=pulumi.get(__ret__, 'delete_protection'),
        description=pulumi.get(__ret__, 'description'),
        enabled_analysis_types=pulumi.get(__ret__, 'enabled_analysis_types'),
        endpoint_ids=pulumi.get(__ret__, 'endpoint_ids'),
        firewall_arn=pulumi.get(__ret__, 'firewall_arn'),
        firewall_id=pulumi.get(__ret__, 'firewall_id'),
        firewall_policy_arn=pulumi.get(__ret__, 'firewall_policy_arn'),
        firewall_policy_change_protection=pulumi.get(__ret__, 'firewall_policy_change_protection'),
        subnet_change_protection=pulumi.get(__ret__, 'subnet_change_protection'),
        subnet_mappings=pulumi.get(__ret__, 'subnet_mappings'),
        tags=pulumi.get(__ret__, 'tags'))
def get_firewall_output(firewall_arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallResult]:
    """
    Resource type definition for AWS::NetworkFirewall::Firewall


    :param builtins.str firewall_arn: The Amazon Resource Name (ARN) of the `Firewall` .
    """
    __args__ = dict()
    __args__['firewallArn'] = firewall_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:networkfirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult)
    return __ret__.apply(lambda __response__: GetFirewallResult(
        delete_protection=pulumi.get(__response__, 'delete_protection'),
        description=pulumi.get(__response__, 'description'),
        enabled_analysis_types=pulumi.get(__response__, 'enabled_analysis_types'),
        endpoint_ids=pulumi.get(__response__, 'endpoint_ids'),
        firewall_arn=pulumi.get(__response__, 'firewall_arn'),
        firewall_id=pulumi.get(__response__, 'firewall_id'),
        firewall_policy_arn=pulumi.get(__response__, 'firewall_policy_arn'),
        firewall_policy_change_protection=pulumi.get(__response__, 'firewall_policy_change_protection'),
        subnet_change_protection=pulumi.get(__response__, 'subnet_change_protection'),
        subnet_mappings=pulumi.get(__response__, 'subnet_mappings'),
        tags=pulumi.get(__response__, 'tags')))
