# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FirewallPolicyInitArgs', 'FirewallPolicy']

@pulumi.input_type
class FirewallPolicyInitArgs:
    def __init__(__self__, *,
                 firewall_policy: pulumi.Input['FirewallPolicyArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a FirewallPolicy resource.
        :param pulumi.Input['FirewallPolicyArgs'] firewall_policy: The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
        :param pulumi.Input[builtins.str] description: A description of the firewall policy.
        :param pulumi.Input[builtins.str] firewall_policy_name: The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        pulumi.set(__self__, "firewall_policy", firewall_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if firewall_policy_name is not None:
            pulumi.set(__self__, "firewall_policy_name", firewall_policy_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Input['FirewallPolicyArgs']:
        """
        The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: pulumi.Input['FirewallPolicyArgs']):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the firewall policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="firewallPolicyName")
    def firewall_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
        """
        return pulumi.get(self, "firewall_policy_name")

    @firewall_policy_name.setter
    def firewall_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "firewall_policy_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:networkfirewall:FirewallPolicy")
class FirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_policy: Optional[pulumi.Input[Union['FirewallPolicyArgs', 'FirewallPolicyArgsDict']]] = None,
                 firewall_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource type definition for AWS::NetworkFirewall::FirewallPolicy

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the firewall policy.
        :param pulumi.Input[Union['FirewallPolicyArgs', 'FirewallPolicyArgsDict']] firewall_policy: The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
        :param pulumi.Input[builtins.str] firewall_policy_name: The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource type definition for AWS::NetworkFirewall::FirewallPolicy

        :param str resource_name: The name of the resource.
        :param FirewallPolicyInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_policy: Optional[pulumi.Input[Union['FirewallPolicyArgs', 'FirewallPolicyArgsDict']]] = None,
                 firewall_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyInitArgs.__new__(FirewallPolicyInitArgs)

            __props__.__dict__["description"] = description
            if firewall_policy is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_policy'")
            __props__.__dict__["firewall_policy"] = firewall_policy
            __props__.__dict__["firewall_policy_name"] = firewall_policy_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["firewall_policy_arn"] = None
            __props__.__dict__["firewall_policy_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["firewallPolicyName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FirewallPolicy, __self__).__init__(
            'aws-native:networkfirewall:FirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FirewallPolicy':
        """
        Get an existing FirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FirewallPolicyInitArgs.__new__(FirewallPolicyInitArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["firewall_policy"] = None
        __props__.__dict__["firewall_policy_arn"] = None
        __props__.__dict__["firewall_policy_id"] = None
        __props__.__dict__["firewall_policy_name"] = None
        __props__.__dict__["tags"] = None
        return FirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the firewall policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Output['outputs.FirewallPolicy']:
        """
        The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter(name="firewallPolicyArn")
    def firewall_policy_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the `FirewallPolicy` .
        """
        return pulumi.get(self, "firewall_policy_arn")

    @property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID of the `FirewallPolicy` resource.
        """
        return pulumi.get(self, "firewall_policy_id")

    @property
    @pulumi.getter(name="firewallPolicyName")
    def firewall_policy_name(self) -> pulumi.Output[builtins.str]:
        """
        The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
        """
        return pulumi.get(self, "firewall_policy_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

