# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetGraphResult',
    'AwaitableGetGraphResult',
    'get_graph',
    'get_graph_output',
]

@pulumi.output_type
class GetGraphResult:
    def __init__(__self__, deletion_protection=None, endpoint=None, graph_arn=None, graph_id=None, provisioned_memory=None, public_connectivity=None, tags=None):
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if graph_arn and not isinstance(graph_arn, str):
            raise TypeError("Expected argument 'graph_arn' to be a str")
        pulumi.set(__self__, "graph_arn", graph_arn)
        if graph_id and not isinstance(graph_id, str):
            raise TypeError("Expected argument 'graph_id' to be a str")
        pulumi.set(__self__, "graph_id", graph_id)
        if provisioned_memory and not isinstance(provisioned_memory, int):
            raise TypeError("Expected argument 'provisioned_memory' to be a int")
        pulumi.set(__self__, "provisioned_memory", provisioned_memory)
        if public_connectivity and not isinstance(public_connectivity, bool):
            raise TypeError("Expected argument 'public_connectivity' to be a bool")
        pulumi.set(__self__, "public_connectivity", public_connectivity)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[builtins.bool]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.

        _Default_: If not specified, the default value is true.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="graphArn")
    def graph_arn(self) -> Optional[builtins.str]:
        """
        Graph resource ARN
        """
        return pulumi.get(self, "graph_arn")

    @property
    @pulumi.getter(name="graphId")
    def graph_id(self) -> Optional[builtins.str]:
        """
        The auto-generated id assigned by the service.
        """
        return pulumi.get(self, "graph_id")

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> Optional[builtins.int]:
        """
        Memory for the Graph.
        """
        return pulumi.get(self, "provisioned_memory")

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> Optional[builtins.bool]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.

        When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.

        When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.

        _Default_: If not specified, the default value is false.
        """
        return pulumi.get(self, "public_connectivity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags associated with this graph.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGraphResult(GetGraphResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGraphResult(
            deletion_protection=self.deletion_protection,
            endpoint=self.endpoint,
            graph_arn=self.graph_arn,
            graph_id=self.graph_id,
            provisioned_memory=self.provisioned_memory,
            public_connectivity=self.public_connectivity,
            tags=self.tags)


def get_graph(graph_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGraphResult:
    """
    The AWS::NeptuneGraph::Graph resource creates an Amazon NeptuneGraph Graph.


    :param builtins.str graph_id: The auto-generated id assigned by the service.
    """
    __args__ = dict()
    __args__['graphId'] = graph_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:neptunegraph:getGraph', __args__, opts=opts, typ=GetGraphResult).value

    return AwaitableGetGraphResult(
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        graph_arn=pulumi.get(__ret__, 'graph_arn'),
        graph_id=pulumi.get(__ret__, 'graph_id'),
        provisioned_memory=pulumi.get(__ret__, 'provisioned_memory'),
        public_connectivity=pulumi.get(__ret__, 'public_connectivity'),
        tags=pulumi.get(__ret__, 'tags'))
def get_graph_output(graph_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGraphResult]:
    """
    The AWS::NeptuneGraph::Graph resource creates an Amazon NeptuneGraph Graph.


    :param builtins.str graph_id: The auto-generated id assigned by the service.
    """
    __args__ = dict()
    __args__['graphId'] = graph_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:neptunegraph:getGraph', __args__, opts=opts, typ=GetGraphResult)
    return __ret__.apply(lambda __response__: GetGraphResult(
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        graph_arn=pulumi.get(__response__, 'graph_arn'),
        graph_id=pulumi.get(__response__, 'graph_id'),
        provisioned_memory=pulumi.get(__response__, 'provisioned_memory'),
        public_connectivity=pulumi.get(__response__, 'public_connectivity'),
        tags=pulumi.get(__response__, 'tags')))
