# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DbClusterDbClusterRoleArgs',
    'DbClusterDbClusterRoleArgsDict',
    'DbClusterServerlessScalingConfigurationArgs',
    'DbClusterServerlessScalingConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class DbClusterDbClusterRoleArgsDict(TypedDict):
        """
        Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        """
        feature_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see DBEngineVersion in the Amazon Neptune API Reference.
        """
elif False:
    DbClusterDbClusterRoleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterDbClusterRoleArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 feature_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        :param pulumi.Input[builtins.str] feature_name: The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see DBEngineVersion in the Amazon Neptune API Reference.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. For the list of supported feature names, see DBEngineVersion in the Amazon Neptune API Reference.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_name", value)


if not MYPY:
    class DbClusterServerlessScalingConfigurationArgsDict(TypedDict):
        """
        Contains the scaling configuration of an Neptune Serverless DB cluster.
        """
        max_capacity: pulumi.Input[builtins.float]
        """
        The maximum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on. The smallest value you can use is 2.5, whereas the largest is 128.
        """
        min_capacity: pulumi.Input[builtins.float]
        """
        The minimum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value you can use is 1, whereas the largest is 128.
        """
elif False:
    DbClusterServerlessScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterServerlessScalingConfigurationArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[builtins.float],
                 min_capacity: pulumi.Input[builtins.float]):
        """
        Contains the scaling configuration of an Neptune Serverless DB cluster.
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on. The smallest value you can use is 2.5, whereas the largest is 128.
        :param pulumi.Input[builtins.float] min_capacity: The minimum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value you can use is 1, whereas the largest is 128.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[builtins.float]:
        """
        The maximum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 40, 40.5, 41, and so on. The smallest value you can use is 2.5, whereas the largest is 128.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[builtins.float]:
        """
        The minimum number of Neptune capacity units (NCUs) for a DB instance in an Neptune Serverless cluster. You can specify NCU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value you can use is 1, whereas the largest is 128.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "min_capacity", value)


