# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 airflow_configuration_options: Optional[Any] = None,
                 airflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 dag_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_management: Optional[pulumi.Input['EnvironmentEndpointManagement']] = None,
                 environment_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 logging_configuration: Optional[pulumi.Input['EnvironmentLoggingConfigurationArgs']] = None,
                 max_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 max_workers: Optional[pulumi.Input[builtins.int]] = None,
                 min_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 min_workers: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['EnvironmentNetworkConfigurationArgs']] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 schedulers: Optional[pulumi.Input[builtins.int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 webserver_access_mode: Optional[pulumi.Input['EnvironmentWebserverAccessMode']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param Any airflow_configuration_options: Key/value pairs representing Airflow configuration variables.
                   Keys are prefixed by their section:
               
                   [core]
                   dags_folder={AIRFLOW_HOME}/dags
               
                   Would be represented as
               
                   "core.dags_folder": "{AIRFLOW_HOME}/dags"
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] airflow_version: The version of Apache Airflow to use for the environment. If no value is specified, defaults to the latest version.
               
               If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.
               
               *Allowed Values* : `1.10.12` | `2.0.2` | `2.2.2` | `2.4.3` | `2.5.1` | `2.6.3` | `2.7.2` | `2.8.1` | `2.9.2` | `2.10.1` (latest)
        :param pulumi.Input[builtins.str] dag_s3_path: The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags` . To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html) .
        :param pulumi.Input['EnvironmentEndpointManagement'] endpoint_management: Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE` , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER` , you must create, and manage, the VPC endpoints in your VPC.
        :param pulumi.Input[builtins.str] environment_class: The environment class type. Valid values: `mw1.micro` , `mw1.small` , `mw1.medium` , `mw1.large` , `mw1.1large` , and `mw1.2large` . To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html) .
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role` . To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) .
        :param pulumi.Input[builtins.str] kms_key: The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment. You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
        :param pulumi.Input['EnvironmentLoggingConfigurationArgs'] logging_configuration: The Apache Airflow logs being sent to CloudWatch Logs: `DagProcessingLogs` , `SchedulerLogs` , `TaskLogs` , `WebserverLogs` , `WorkerLogs` .
        :param pulumi.Input[builtins.int] max_webservers: The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers` . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .
               
               Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        :param pulumi.Input[builtins.int] max_workers: The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20` . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers` .
        :param pulumi.Input[builtins.int] min_webservers: The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .
               
               Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        :param pulumi.Input[builtins.int] min_workers: The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2` .
        :param pulumi.Input[builtins.str] name: The name of your Amazon MWAA environment.
        :param pulumi.Input['EnvironmentNetworkConfigurationArgs'] network_configuration: The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html) .
        :param pulumi.Input[builtins.str] plugins_s3_object_version: The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        :param pulumi.Input[builtins.str] plugins_s3_path: The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip` . To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        :param pulumi.Input[builtins.str] requirements_s3_object_version: The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        :param pulumi.Input[builtins.str] requirements_s3_path: The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt` . To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        :param pulumi.Input[builtins.int] schedulers: The number of schedulers that you want to run in your environment. Valid values:
               
               - *v2* - For environments larger than mw1.micro, accepts values from 2 to 5. Defaults to 2 for all environment sizes except mw1.micro, which defaults to 1.
               - *v1* - Accepts 1.
        :param pulumi.Input[builtins.str] source_bucket_arn: The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name` . To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html) .
        :param pulumi.Input[builtins.str] startup_script_s3_object_version: The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.
               
               Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
               
               `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
               
               For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        :param pulumi.Input[builtins.str] startup_script_s3_path: The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh` .
               
               Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        :param Any tags: A map of tags for the environment.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        :param pulumi.Input['EnvironmentWebserverAccessMode'] webserver_access_mode: The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html) . Valid values: `PRIVATE_ONLY` or `PUBLIC_ONLY` .
        :param pulumi.Input[builtins.str] weekly_maintenance_window_start: The day and time of the week to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM` . For example: `TUE:03:30` . You can specify a start time in 30 minute increments only. Supported input includes the following:
               
               - MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)
        """
        if airflow_configuration_options is not None:
            pulumi.set(__self__, "airflow_configuration_options", airflow_configuration_options)
        if airflow_version is not None:
            pulumi.set(__self__, "airflow_version", airflow_version)
        if dag_s3_path is not None:
            pulumi.set(__self__, "dag_s3_path", dag_s3_path)
        if endpoint_management is not None:
            pulumi.set(__self__, "endpoint_management", endpoint_management)
        if environment_class is not None:
            pulumi.set(__self__, "environment_class", environment_class)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if logging_configuration is not None:
            pulumi.set(__self__, "logging_configuration", logging_configuration)
        if max_webservers is not None:
            pulumi.set(__self__, "max_webservers", max_webservers)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if min_webservers is not None:
            pulumi.set(__self__, "min_webservers", min_webservers)
        if min_workers is not None:
            pulumi.set(__self__, "min_workers", min_workers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if plugins_s3_object_version is not None:
            pulumi.set(__self__, "plugins_s3_object_version", plugins_s3_object_version)
        if plugins_s3_path is not None:
            pulumi.set(__self__, "plugins_s3_path", plugins_s3_path)
        if requirements_s3_object_version is not None:
            pulumi.set(__self__, "requirements_s3_object_version", requirements_s3_object_version)
        if requirements_s3_path is not None:
            pulumi.set(__self__, "requirements_s3_path", requirements_s3_path)
        if schedulers is not None:
            pulumi.set(__self__, "schedulers", schedulers)
        if source_bucket_arn is not None:
            pulumi.set(__self__, "source_bucket_arn", source_bucket_arn)
        if startup_script_s3_object_version is not None:
            pulumi.set(__self__, "startup_script_s3_object_version", startup_script_s3_object_version)
        if startup_script_s3_path is not None:
            pulumi.set(__self__, "startup_script_s3_path", startup_script_s3_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if webserver_access_mode is not None:
            pulumi.set(__self__, "webserver_access_mode", webserver_access_mode)
        if weekly_maintenance_window_start is not None:
            pulumi.set(__self__, "weekly_maintenance_window_start", weekly_maintenance_window_start)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> Optional[Any]:
        """
        Key/value pairs representing Airflow configuration variables.
            Keys are prefixed by their section:

            [core]
            dags_folder={AIRFLOW_HOME}/dags

            Would be represented as

            "core.dags_folder": "{AIRFLOW_HOME}/dags"

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "airflow_configuration_options")

    @airflow_configuration_options.setter
    def airflow_configuration_options(self, value: Optional[Any]):
        pulumi.set(self, "airflow_configuration_options", value)

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Apache Airflow to use for the environment. If no value is specified, defaults to the latest version.

        If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.

        *Allowed Values* : `1.10.12` | `2.0.2` | `2.2.2` | `2.4.3` | `2.5.1` | `2.6.3` | `2.7.2` | `2.8.1` | `2.9.2` | `2.10.1` (latest)
        """
        return pulumi.get(self, "airflow_version")

    @airflow_version.setter
    def airflow_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "airflow_version", value)

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags` . To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html) .
        """
        return pulumi.get(self, "dag_s3_path")

    @dag_s3_path.setter
    def dag_s3_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dag_s3_path", value)

    @property
    @pulumi.getter(name="endpointManagement")
    def endpoint_management(self) -> Optional[pulumi.Input['EnvironmentEndpointManagement']]:
        """
        Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE` , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER` , you must create, and manage, the VPC endpoints in your VPC.
        """
        return pulumi.get(self, "endpoint_management")

    @endpoint_management.setter
    def endpoint_management(self, value: Optional[pulumi.Input['EnvironmentEndpointManagement']]):
        pulumi.set(self, "endpoint_management", value)

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment class type. Valid values: `mw1.micro` , `mw1.small` , `mw1.medium` , `mw1.large` , `mw1.1large` , and `mw1.2large` . To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html) .
        """
        return pulumi.get(self, "environment_class")

    @environment_class.setter
    def environment_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_class", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role` . To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) .
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment. You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional[pulumi.Input['EnvironmentLoggingConfigurationArgs']]:
        """
        The Apache Airflow logs being sent to CloudWatch Logs: `DagProcessingLogs` , `SchedulerLogs` , `TaskLogs` , `WebserverLogs` , `WorkerLogs` .
        """
        return pulumi.get(self, "logging_configuration")

    @logging_configuration.setter
    def logging_configuration(self, value: Optional[pulumi.Input['EnvironmentLoggingConfigurationArgs']]):
        pulumi.set(self, "logging_configuration", value)

    @property
    @pulumi.getter(name="maxWebservers")
    def max_webservers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers` . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        """
        return pulumi.get(self, "max_webservers")

    @max_webservers.setter
    def max_webservers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_webservers", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20` . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers` .
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter(name="minWebservers")
    def min_webservers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        """
        return pulumi.get(self, "min_webservers")

    @min_webservers.setter
    def min_webservers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_webservers", value)

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2` .
        """
        return pulumi.get(self, "min_workers")

    @min_workers.setter
    def min_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_workers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of your Amazon MWAA environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['EnvironmentNetworkConfigurationArgs']]:
        """
        The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html) .
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['EnvironmentNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @plugins_s3_object_version.setter
    def plugins_s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugins_s3_object_version", value)

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip` . To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_path")

    @plugins_s3_path.setter
    def plugins_s3_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugins_s3_path", value)

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @requirements_s3_object_version.setter
    def requirements_s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requirements_s3_object_version", value)

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt` . To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_path")

    @requirements_s3_path.setter
    def requirements_s3_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requirements_s3_path", value)

    @property
    @pulumi.getter
    def schedulers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of schedulers that you want to run in your environment. Valid values:

        - *v2* - For environments larger than mw1.micro, accepts values from 2 to 5. Defaults to 2 for all environment sizes except mw1.micro, which defaults to 1.
        - *v1* - Accepts 1.
        """
        return pulumi.get(self, "schedulers")

    @schedulers.setter
    def schedulers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "schedulers", value)

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name` . To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html) .
        """
        return pulumi.get(self, "source_bucket_arn")

    @source_bucket_arn.setter
    def source_bucket_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_bucket_arn", value)

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.

        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:

        `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`

        For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @startup_script_s3_object_version.setter
    def startup_script_s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "startup_script_s3_object_version", value)

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh` .

        Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_path")

    @startup_script_s3_path.setter
    def startup_script_s3_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "startup_script_s3_path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        A map of tags for the environment.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Any]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> Optional[pulumi.Input['EnvironmentWebserverAccessMode']]:
        """
        The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html) . Valid values: `PRIVATE_ONLY` or `PUBLIC_ONLY` .
        """
        return pulumi.get(self, "webserver_access_mode")

    @webserver_access_mode.setter
    def webserver_access_mode(self, value: Optional[pulumi.Input['EnvironmentWebserverAccessMode']]):
        pulumi.set(self, "webserver_access_mode", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The day and time of the week to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM` . For example: `TUE:03:30` . You can specify a start time in 30 minute increments only. Supported input includes the following:

        - MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

    @weekly_maintenance_window_start.setter
    def weekly_maintenance_window_start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "weekly_maintenance_window_start", value)


@pulumi.type_token("aws-native:mwaa:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_configuration_options: Optional[Any] = None,
                 airflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 dag_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_management: Optional[pulumi.Input['EnvironmentEndpointManagement']] = None,
                 environment_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['EnvironmentLoggingConfigurationArgs', 'EnvironmentLoggingConfigurationArgsDict']]] = None,
                 max_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 max_workers: Optional[pulumi.Input[builtins.int]] = None,
                 min_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 min_workers: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['EnvironmentNetworkConfigurationArgs', 'EnvironmentNetworkConfigurationArgsDict']]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 schedulers: Optional[pulumi.Input[builtins.int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 webserver_access_mode: Optional[pulumi.Input['EnvironmentWebserverAccessMode']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MWAA::Environment

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any airflow_configuration_options: Key/value pairs representing Airflow configuration variables.
                   Keys are prefixed by their section:
               
                   [core]
                   dags_folder={AIRFLOW_HOME}/dags
               
                   Would be represented as
               
                   "core.dags_folder": "{AIRFLOW_HOME}/dags"
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] airflow_version: The version of Apache Airflow to use for the environment. If no value is specified, defaults to the latest version.
               
               If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.
               
               *Allowed Values* : `1.10.12` | `2.0.2` | `2.2.2` | `2.4.3` | `2.5.1` | `2.6.3` | `2.7.2` | `2.8.1` | `2.9.2` | `2.10.1` (latest)
        :param pulumi.Input[builtins.str] dag_s3_path: The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags` . To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html) .
        :param pulumi.Input['EnvironmentEndpointManagement'] endpoint_management: Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE` , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER` , you must create, and manage, the VPC endpoints in your VPC.
        :param pulumi.Input[builtins.str] environment_class: The environment class type. Valid values: `mw1.micro` , `mw1.small` , `mw1.medium` , `mw1.large` , `mw1.1large` , and `mw1.2large` . To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html) .
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role` . To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) .
        :param pulumi.Input[builtins.str] kms_key: The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment. You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
        :param pulumi.Input[Union['EnvironmentLoggingConfigurationArgs', 'EnvironmentLoggingConfigurationArgsDict']] logging_configuration: The Apache Airflow logs being sent to CloudWatch Logs: `DagProcessingLogs` , `SchedulerLogs` , `TaskLogs` , `WebserverLogs` , `WorkerLogs` .
        :param pulumi.Input[builtins.int] max_webservers: The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers` . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .
               
               Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        :param pulumi.Input[builtins.int] max_workers: The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20` . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers` .
        :param pulumi.Input[builtins.int] min_webservers: The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .
               
               Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        :param pulumi.Input[builtins.int] min_workers: The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2` .
        :param pulumi.Input[builtins.str] name: The name of your Amazon MWAA environment.
        :param pulumi.Input[Union['EnvironmentNetworkConfigurationArgs', 'EnvironmentNetworkConfigurationArgsDict']] network_configuration: The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html) .
        :param pulumi.Input[builtins.str] plugins_s3_object_version: The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        :param pulumi.Input[builtins.str] plugins_s3_path: The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip` . To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        :param pulumi.Input[builtins.str] requirements_s3_object_version: The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        :param pulumi.Input[builtins.str] requirements_s3_path: The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt` . To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        :param pulumi.Input[builtins.int] schedulers: The number of schedulers that you want to run in your environment. Valid values:
               
               - *v2* - For environments larger than mw1.micro, accepts values from 2 to 5. Defaults to 2 for all environment sizes except mw1.micro, which defaults to 1.
               - *v1* - Accepts 1.
        :param pulumi.Input[builtins.str] source_bucket_arn: The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name` . To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html) .
        :param pulumi.Input[builtins.str] startup_script_s3_object_version: The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.
               
               Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
               
               `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
               
               For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        :param pulumi.Input[builtins.str] startup_script_s3_path: The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh` .
               
               Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        :param Any tags: A map of tags for the environment.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        :param pulumi.Input['EnvironmentWebserverAccessMode'] webserver_access_mode: The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html) . Valid values: `PRIVATE_ONLY` or `PUBLIC_ONLY` .
        :param pulumi.Input[builtins.str] weekly_maintenance_window_start: The day and time of the week to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM` . For example: `TUE:03:30` . You can specify a start time in 30 minute increments only. Supported input includes the following:
               
               - MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EnvironmentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MWAA::Environment

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_configuration_options: Optional[Any] = None,
                 airflow_version: Optional[pulumi.Input[builtins.str]] = None,
                 dag_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_management: Optional[pulumi.Input['EnvironmentEndpointManagement']] = None,
                 environment_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 logging_configuration: Optional[pulumi.Input[Union['EnvironmentLoggingConfigurationArgs', 'EnvironmentLoggingConfigurationArgsDict']]] = None,
                 max_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 max_workers: Optional[pulumi.Input[builtins.int]] = None,
                 min_webservers: Optional[pulumi.Input[builtins.int]] = None,
                 min_workers: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['EnvironmentNetworkConfigurationArgs', 'EnvironmentNetworkConfigurationArgsDict']]] = None,
                 plugins_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 plugins_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 requirements_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 schedulers: Optional[pulumi.Input[builtins.int]] = None,
                 source_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 startup_script_s3_path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[Any] = None,
                 webserver_access_mode: Optional[pulumi.Input['EnvironmentWebserverAccessMode']] = None,
                 weekly_maintenance_window_start: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["airflow_configuration_options"] = airflow_configuration_options
            __props__.__dict__["airflow_version"] = airflow_version
            __props__.__dict__["dag_s3_path"] = dag_s3_path
            __props__.__dict__["endpoint_management"] = endpoint_management
            __props__.__dict__["environment_class"] = environment_class
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["logging_configuration"] = logging_configuration
            __props__.__dict__["max_webservers"] = max_webservers
            __props__.__dict__["max_workers"] = max_workers
            __props__.__dict__["min_webservers"] = min_webservers
            __props__.__dict__["min_workers"] = min_workers
            __props__.__dict__["name"] = name
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["plugins_s3_object_version"] = plugins_s3_object_version
            __props__.__dict__["plugins_s3_path"] = plugins_s3_path
            __props__.__dict__["requirements_s3_object_version"] = requirements_s3_object_version
            __props__.__dict__["requirements_s3_path"] = requirements_s3_path
            __props__.__dict__["schedulers"] = schedulers
            __props__.__dict__["source_bucket_arn"] = source_bucket_arn
            __props__.__dict__["startup_script_s3_object_version"] = startup_script_s3_object_version
            __props__.__dict__["startup_script_s3_path"] = startup_script_s3_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["webserver_access_mode"] = webserver_access_mode
            __props__.__dict__["weekly_maintenance_window_start"] = weekly_maintenance_window_start
            __props__.__dict__["arn"] = None
            __props__.__dict__["celery_executor_queue"] = None
            __props__.__dict__["database_vpc_endpoint_service"] = None
            __props__.__dict__["webserver_url"] = None
            __props__.__dict__["webserver_vpc_endpoint_service"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["endpointManagement", "kmsKey", "name", "networkConfiguration.subnetIds[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Environment, __self__).__init__(
            'aws-native:mwaa:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

        __props__.__dict__["airflow_configuration_options"] = None
        __props__.__dict__["airflow_version"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["celery_executor_queue"] = None
        __props__.__dict__["dag_s3_path"] = None
        __props__.__dict__["database_vpc_endpoint_service"] = None
        __props__.__dict__["endpoint_management"] = None
        __props__.__dict__["environment_class"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["kms_key"] = None
        __props__.__dict__["logging_configuration"] = None
        __props__.__dict__["max_webservers"] = None
        __props__.__dict__["max_workers"] = None
        __props__.__dict__["min_webservers"] = None
        __props__.__dict__["min_workers"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_configuration"] = None
        __props__.__dict__["plugins_s3_object_version"] = None
        __props__.__dict__["plugins_s3_path"] = None
        __props__.__dict__["requirements_s3_object_version"] = None
        __props__.__dict__["requirements_s3_path"] = None
        __props__.__dict__["schedulers"] = None
        __props__.__dict__["source_bucket_arn"] = None
        __props__.__dict__["startup_script_s3_object_version"] = None
        __props__.__dict__["startup_script_s3_path"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["webserver_access_mode"] = None
        __props__.__dict__["webserver_url"] = None
        __props__.__dict__["webserver_vpc_endpoint_service"] = None
        __props__.__dict__["weekly_maintenance_window_start"] = None
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="airflowConfigurationOptions")
    def airflow_configuration_options(self) -> pulumi.Output[Optional[Any]]:
        """
        Key/value pairs representing Airflow configuration variables.
            Keys are prefixed by their section:

            [core]
            dags_folder={AIRFLOW_HOME}/dags

            Would be represented as

            "core.dags_folder": "{AIRFLOW_HOME}/dags"

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "airflow_configuration_options")

    @property
    @pulumi.getter(name="airflowVersion")
    def airflow_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of Apache Airflow to use for the environment. If no value is specified, defaults to the latest version.

        If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.

        *Allowed Values* : `1.10.12` | `2.0.2` | `2.2.2` | `2.4.3` | `2.5.1` | `2.6.3` | `2.7.2` | `2.8.1` | `2.9.2` | `2.10.1` (latest)
        """
        return pulumi.get(self, "airflow_version")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN for the Amazon MWAA environment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="celeryExecutorQueue")
    def celery_executor_queue(self) -> pulumi.Output[builtins.str]:
        """
        The queue ARN for the environment's [Celery Executor](https://docs.aws.amazon.com/https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html) . Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
        """
        return pulumi.get(self, "celery_executor_queue")

    @property
    @pulumi.getter(name="dagS3Path")
    def dag_s3_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags` . To learn more, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html) .
        """
        return pulumi.get(self, "dag_s3_path")

    @property
    @pulumi.getter(name="databaseVpcEndpointService")
    def database_vpc_endpoint_service(self) -> pulumi.Output[builtins.str]:
        """
        The VPC endpoint for the environment's Amazon RDS database.
        """
        return pulumi.get(self, "database_vpc_endpoint_service")

    @property
    @pulumi.getter(name="endpointManagement")
    def endpoint_management(self) -> pulumi.Output[Optional['EnvironmentEndpointManagement']]:
        """
        Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE` , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER` , you must create, and manage, the VPC endpoints in your VPC.
        """
        return pulumi.get(self, "endpoint_management")

    @property
    @pulumi.getter(name="environmentClass")
    def environment_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The environment class type. Valid values: `mw1.micro` , `mw1.small` , `mw1.medium` , `mw1.large` , `mw1.1large` , and `mw1.2large` . To learn more, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html) .
        """
        return pulumi.get(self, "environment_class")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role` . To learn more, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html) .
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment. You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> pulumi.Output[Optional['outputs.EnvironmentLoggingConfiguration']]:
        """
        The Apache Airflow logs being sent to CloudWatch Logs: `DagProcessingLogs` , `SchedulerLogs` , `TaskLogs` , `WebserverLogs` , `WorkerLogs` .
        """
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter(name="maxWebservers")
    def max_webservers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers` . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        """
        return pulumi.get(self, "max_webservers")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20` . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers` .
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter(name="minWebservers")
    def min_webservers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers` .

        Valid values: For environments larger than mw1.micro, accepts values from `2` to `5` . Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1` .
        """
        return pulumi.get(self, "min_webservers")

    @property
    @pulumi.getter(name="minWorkers")
    def min_workers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2` .
        """
        return pulumi.get(self, "min_workers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of your Amazon MWAA environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.EnvironmentNetworkConfiguration']]:
        """
        The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. To learn more, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html) .
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="pluginsS3ObjectVersion")
    def plugins_s3_object_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_object_version")

    @property
    @pulumi.getter(name="pluginsS3Path")
    def plugins_s3_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip` . To learn more, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html) .
        """
        return pulumi.get(self, "plugins_s3_path")

    @property
    @pulumi.getter(name="requirementsS3ObjectVersion")
    def requirements_s3_object_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_object_version")

    @property
    @pulumi.getter(name="requirementsS3Path")
    def requirements_s3_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt` . To learn more, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html) .
        """
        return pulumi.get(self, "requirements_s3_path")

    @property
    @pulumi.getter
    def schedulers(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of schedulers that you want to run in your environment. Valid values:

        - *v2* - For environments larger than mw1.micro, accepts values from 2 to 5. Defaults to 2 for all environment sizes except mw1.micro, which defaults to 1.
        - *v1* - Accepts 1.
        """
        return pulumi.get(self, "schedulers")

    @property
    @pulumi.getter(name="sourceBucketArn")
    def source_bucket_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name` . To learn more, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html) .
        """
        return pulumi.get(self, "source_bucket_arn")

    @property
    @pulumi.getter(name="startupScriptS3ObjectVersion")
    def startup_script_s3_object_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.

        Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:

        `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`

        For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_object_version")

    @property
    @pulumi.getter(name="startupScriptS3Path")
    def startup_script_s3_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh` .

        Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html) .
        """
        return pulumi.get(self, "startup_script_s3_path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Any]]:
        """
        A map of tags for the environment.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MWAA::Environment` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="webserverAccessMode")
    def webserver_access_mode(self) -> pulumi.Output[Optional['EnvironmentWebserverAccessMode']]:
        """
        The Apache Airflow *Web server* access mode. To learn more, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html) . Valid values: `PRIVATE_ONLY` or `PUBLIC_ONLY` .
        """
        return pulumi.get(self, "webserver_access_mode")

    @property
    @pulumi.getter(name="webserverUrl")
    def webserver_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of your Apache Airflow UI.
        """
        return pulumi.get(self, "webserver_url")

    @property
    @pulumi.getter(name="webserverVpcEndpointService")
    def webserver_vpc_endpoint_service(self) -> pulumi.Output[builtins.str]:
        """
        The VPC endpoint for the environment's web server.
        """
        return pulumi.get(self, "webserver_vpc_endpoint_service")

    @property
    @pulumi.getter(name="weeklyMaintenanceWindowStart")
    def weekly_maintenance_window_start(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The day and time of the week to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM` . For example: `TUE:03:30` . You can specify a start time in 30 minute increments only. Supported input includes the following:

        - MON|TUE|WED|THU|FRI|SAT|SUN:([01]\\\\d|2[0-3]):(00|30)
        """
        return pulumi.get(self, "weekly_maintenance_window_start")

