# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterBrokerLogs',
    'ClusterBrokerNodeGroupInfo',
    'ClusterClientAuthentication',
    'ClusterCloudWatchLogs',
    'ClusterConfigurationInfo',
    'ClusterConnectivityInfo',
    'ClusterEbsStorageInfo',
    'ClusterEncryptionAtRest',
    'ClusterEncryptionInTransit',
    'ClusterEncryptionInfo',
    'ClusterFirehose',
    'ClusterIam',
    'ClusterJmxExporter',
    'ClusterLoggingInfo',
    'ClusterNodeExporter',
    'ClusterOpenMonitoring',
    'ClusterPrometheus',
    'ClusterProvisionedThroughput',
    'ClusterPublicAccess',
    'ClusterS3',
    'ClusterSasl',
    'ClusterScram',
    'ClusterStorageInfo',
    'ClusterTls',
    'ClusterUnauthenticated',
    'ClusterVpcConnectivity',
    'ClusterVpcConnectivityClientAuthentication',
    'ClusterVpcConnectivityIam',
    'ClusterVpcConnectivitySasl',
    'ClusterVpcConnectivityScram',
    'ClusterVpcConnectivityTls',
    'ConfigurationLatestRevision',
    'ReplicatorAmazonMskCluster',
    'ReplicatorConsumerGroupReplication',
    'ReplicatorKafkaCluster',
    'ReplicatorKafkaClusterClientVpcConfig',
    'ReplicatorReplicationInfo',
    'ReplicatorReplicationStartingPosition',
    'ReplicatorReplicationTopicNameConfiguration',
    'ReplicatorTopicReplication',
    'ServerlessClusterClientAuthentication',
    'ServerlessClusterIam',
    'ServerlessClusterSasl',
    'ServerlessClusterVpcConfig',
]

@pulumi.output_type
class ClusterBrokerLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogs":
            suggest = "cloud_watch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs: Optional['outputs.ClusterCloudWatchLogs'] = None,
                 firehose: Optional['outputs.ClusterFirehose'] = None,
                 s3: Optional['outputs.ClusterS3'] = None):
        """
        :param 'ClusterFirehose' firehose: Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
        :param 'ClusterS3' s3: Details of the Amazon S3 destination for broker logs.
        """
        if cloud_watch_logs is not None:
            pulumi.set(__self__, "cloud_watch_logs", cloud_watch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudWatchLogs")
    def cloud_watch_logs(self) -> Optional['outputs.ClusterCloudWatchLogs']:
        return pulumi.get(self, "cloud_watch_logs")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.ClusterFirehose']:
        """
        Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ClusterS3']:
        """
        Details of the Amazon S3 destination for broker logs.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class ClusterBrokerNodeGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSubnets":
            suggest = "client_subnets"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "brokerAzDistribution":
            suggest = "broker_az_distribution"
        elif key == "connectivityInfo":
            suggest = "connectivity_info"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "storageInfo":
            suggest = "storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_subnets: Sequence[builtins.str],
                 instance_type: builtins.str,
                 broker_az_distribution: Optional[builtins.str] = None,
                 connectivity_info: Optional['outputs.ClusterConnectivityInfo'] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None,
                 storage_info: Optional['outputs.ClusterStorageInfo'] = None):
        """
        :param Sequence[builtins.str] client_subnets: The list of subnets to connect to in the client virtual private cloud (VPC). Amazon creates elastic network interfaces (ENIs) inside these subnets. Client applications use ENIs to produce and consume data.
               
               If you use the US West (N. California) Region, specify exactly two subnets. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
               
               Client subnets can't occupy the Availability Zone with ID `use1-az3` .
        :param builtins.str instance_type: The type of Amazon EC2 instances to use for brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, kafka.m5.24xlarge, and kafka.t3.small.
        :param builtins.str broker_az_distribution: This parameter is currently not in use.
        :param 'ClusterConnectivityInfo' connectivity_info: Information about the cluster's connectivity setting.
        :param Sequence[builtins.str] security_groups: The security groups to associate with the ENIs in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the `ec2:DescribeSecurityGroups` permission.
        :param 'ClusterStorageInfo' storage_info: Contains information about storage volumes attached to Amazon MSK broker nodes.
        """
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "instance_type", instance_type)
        if broker_az_distribution is not None:
            pulumi.set(__self__, "broker_az_distribution", broker_az_distribution)
        if connectivity_info is not None:
            pulumi.set(__self__, "connectivity_info", connectivity_info)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if storage_info is not None:
            pulumi.set(__self__, "storage_info", storage_info)

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[builtins.str]:
        """
        The list of subnets to connect to in the client virtual private cloud (VPC). Amazon creates elastic network interfaces (ENIs) inside these subnets. Client applications use ENIs to produce and consume data.

        If you use the US West (N. California) Region, specify exactly two subnets. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.

        Client subnets can't occupy the Availability Zone with ID `use1-az3` .
        """
        return pulumi.get(self, "client_subnets")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        """
        The type of Amazon EC2 instances to use for brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, kafka.m5.24xlarge, and kafka.t3.small.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="brokerAzDistribution")
    def broker_az_distribution(self) -> Optional[builtins.str]:
        """
        This parameter is currently not in use.
        """
        return pulumi.get(self, "broker_az_distribution")

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> Optional['outputs.ClusterConnectivityInfo']:
        """
        Information about the cluster's connectivity setting.
        """
        return pulumi.get(self, "connectivity_info")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The security groups to associate with the ENIs in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the `ec2:DescribeSecurityGroups` permission.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="storageInfo")
    def storage_info(self) -> Optional['outputs.ClusterStorageInfo']:
        """
        Contains information about storage volumes attached to Amazon MSK broker nodes.
        """
        return pulumi.get(self, "storage_info")


@pulumi.output_type
class ClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterSasl'] = None,
                 tls: Optional['outputs.ClusterTls'] = None,
                 unauthenticated: Optional['outputs.ClusterUnauthenticated'] = None):
        """
        :param 'ClusterSasl' sasl: Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        :param 'ClusterTls' tls: Details for ClientAuthentication using TLS. To turn on TLS access control, you must also turn on `EncryptionInTransit` by setting `inCluster` to true and `clientBroker` to `TLS` .
        :param 'ClusterUnauthenticated' unauthenticated: Details for ClientAuthentication using no authentication.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if unauthenticated is not None:
            pulumi.set(__self__, "unauthenticated", unauthenticated)

    @property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterSasl']:
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        return pulumi.get(self, "sasl")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterTls']:
        """
        Details for ClientAuthentication using TLS. To turn on TLS access control, you must also turn on `EncryptionInTransit` by setting `inCluster` to true and `clientBroker` to `TLS` .
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def unauthenticated(self) -> Optional['outputs.ClusterUnauthenticated']:
        """
        Details for ClientAuthentication using no authentication.
        """
        return pulumi.get(self, "unauthenticated")


@pulumi.output_type
class ClusterCloudWatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudWatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudWatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudWatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 log_group: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
        :param builtins.str log_group: The CloudWatch log group that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[builtins.str]:
        """
        The CloudWatch log group that is the destination for broker logs.
        """
        return pulumi.get(self, "log_group")


@pulumi.output_type
class ClusterConfigurationInfo(dict):
    def __init__(__self__, *,
                 arn: builtins.str,
                 revision: builtins.int):
        """
        :param builtins.str arn: ARN of the configuration to use.
        :param builtins.int revision: The revision of the configuration to use.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the configuration to use.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def revision(self) -> builtins.int:
        """
        The revision of the configuration to use.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ClusterConnectivityInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicAccess":
            suggest = "public_access"
        elif key == "vpcConnectivity":
            suggest = "vpc_connectivity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConnectivityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConnectivityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConnectivityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_access: Optional['outputs.ClusterPublicAccess'] = None,
                 vpc_connectivity: Optional['outputs.ClusterVpcConnectivity'] = None):
        """
        :param 'ClusterPublicAccess' public_access: Access control settings for the cluster's brokers.
        :param 'ClusterVpcConnectivity' vpc_connectivity: VPC connection control settings for brokers.
        """
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if vpc_connectivity is not None:
            pulumi.set(__self__, "vpc_connectivity", vpc_connectivity)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional['outputs.ClusterPublicAccess']:
        """
        Access control settings for the cluster's brokers.
        """
        return pulumi.get(self, "public_access")

    @property
    @pulumi.getter(name="vpcConnectivity")
    def vpc_connectivity(self) -> Optional['outputs.ClusterVpcConnectivity']:
        """
        VPC connection control settings for brokers.
        """
        return pulumi.get(self, "vpc_connectivity")


@pulumi.output_type
class ClusterEbsStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedThroughput":
            suggest = "provisioned_throughput"
        elif key == "volumeSize":
            suggest = "volume_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEbsStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEbsStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEbsStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_throughput: Optional['outputs.ClusterProvisionedThroughput'] = None,
                 volume_size: Optional[builtins.int] = None):
        """
        :param 'ClusterProvisionedThroughput' provisioned_throughput: EBS volume provisioned throughput information.
        :param builtins.int volume_size: The size in GiB of the EBS volume for the data drive on each broker node.
        """
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional['outputs.ClusterProvisionedThroughput']:
        """
        EBS volume provisioned throughput information.
        """
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        The size in GiB of the EBS volume for the data drive on each broker node.
        """
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class ClusterEncryptionAtRest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataVolumeKmsKeyId":
            suggest = "data_volume_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionAtRest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionAtRest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionAtRest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_volume_kms_key_id: builtins.str):
        """
        :param builtins.str data_volume_kms_key_id: The ARN of the Amazon KMS key for encrypting data at rest. If you don't specify a KMS key, MSK creates one for you and uses it.
        """
        pulumi.set(__self__, "data_volume_kms_key_id", data_volume_kms_key_id)

    @property
    @pulumi.getter(name="dataVolumeKmsKeyId")
    def data_volume_kms_key_id(self) -> builtins.str:
        """
        The ARN of the Amazon KMS key for encrypting data at rest. If you don't specify a KMS key, MSK creates one for you and uses it.
        """
        return pulumi.get(self, "data_volume_kms_key_id")


@pulumi.output_type
class ClusterEncryptionInTransit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientBroker":
            suggest = "client_broker"
        elif key == "inCluster":
            suggest = "in_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInTransit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInTransit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInTransit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_broker: Optional['ClusterEncryptionInTransitClientBroker'] = None,
                 in_cluster: Optional[builtins.bool] = None):
        """
        :param 'ClusterEncryptionInTransitClientBroker' client_broker: Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.
               
               - `TLS` : Indicates that client-broker communication is enabled with TLS only.
               - `TLS_PLAINTEXT` : Indicates that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
               - `PLAINTEXT` : Indicates that client-broker communication is enabled in plaintext only.
               
               The default value is `TLS` .
        :param builtins.bool in_cluster: When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
               
               The default value is true.
        """
        if client_broker is not None:
            pulumi.set(__self__, "client_broker", client_broker)
        if in_cluster is not None:
            pulumi.set(__self__, "in_cluster", in_cluster)

    @property
    @pulumi.getter(name="clientBroker")
    def client_broker(self) -> Optional['ClusterEncryptionInTransitClientBroker']:
        """
        Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.

        - `TLS` : Indicates that client-broker communication is enabled with TLS only.
        - `TLS_PLAINTEXT` : Indicates that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
        - `PLAINTEXT` : Indicates that client-broker communication is enabled in plaintext only.

        The default value is `TLS` .
        """
        return pulumi.get(self, "client_broker")

    @property
    @pulumi.getter(name="inCluster")
    def in_cluster(self) -> Optional[builtins.bool]:
        """
        When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.

        The default value is true.
        """
        return pulumi.get(self, "in_cluster")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAtRest":
            suggest = "encryption_at_rest"
        elif key == "encryptionInTransit":
            suggest = "encryption_in_transit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_at_rest: Optional['outputs.ClusterEncryptionAtRest'] = None,
                 encryption_in_transit: Optional['outputs.ClusterEncryptionInTransit'] = None):
        """
        :param 'ClusterEncryptionAtRest' encryption_at_rest: The data-volume encryption details.
        :param 'ClusterEncryptionInTransit' encryption_in_transit: The details for encryption in transit.
        """
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional['outputs.ClusterEncryptionAtRest']:
        """
        The data-volume encryption details.
        """
        return pulumi.get(self, "encryption_at_rest")

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional['outputs.ClusterEncryptionInTransit']:
        """
        The details for encryption in transit.
        """
        return pulumi.get(self, "encryption_in_transit")


@pulumi.output_type
class ClusterFirehose(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStream":
            suggest = "delivery_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 delivery_stream: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Specifies whether broker logs get send to the specified Kinesis Data Firehose delivery stream.
        :param builtins.str delivery_stream: The Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether broker logs get send to the specified Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[builtins.str]:
        """
        The Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class ClusterIam(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterJmxExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterJmxExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterJmxExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterJmxExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: builtins.bool):
        """
        :param builtins.bool enabled_in_broker: Indicates whether you want to enable or disable the JMX Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> builtins.bool:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterLoggingInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokerLogs":
            suggest = "broker_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker_logs: 'outputs.ClusterBrokerLogs'):
        """
        :param 'ClusterBrokerLogs' broker_logs: You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.
        """
        pulumi.set(__self__, "broker_logs", broker_logs)

    @property
    @pulumi.getter(name="brokerLogs")
    def broker_logs(self) -> 'outputs.ClusterBrokerLogs':
        """
        You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.
        """
        return pulumi.get(self, "broker_logs")


@pulumi.output_type
class ClusterNodeExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: builtins.bool):
        """
        :param builtins.bool enabled_in_broker: Indicates whether you want to enable or disable the Node Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> builtins.bool:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterOpenMonitoring(dict):
    def __init__(__self__, *,
                 prometheus: 'outputs.ClusterPrometheus'):
        """
        :param 'ClusterPrometheus' prometheus: Prometheus exporter settings.
        """
        pulumi.set(__self__, "prometheus", prometheus)

    @property
    @pulumi.getter
    def prometheus(self) -> 'outputs.ClusterPrometheus':
        """
        Prometheus exporter settings.
        """
        return pulumi.get(self, "prometheus")


@pulumi.output_type
class ClusterPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jmxExporter":
            suggest = "jmx_exporter"
        elif key == "nodeExporter":
            suggest = "node_exporter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jmx_exporter: Optional['outputs.ClusterJmxExporter'] = None,
                 node_exporter: Optional['outputs.ClusterNodeExporter'] = None):
        """
        :param 'ClusterJmxExporter' jmx_exporter: Indicates whether you want to enable or disable the JMX Exporter.
        :param 'ClusterNodeExporter' node_exporter: Indicates whether you want to enable or disable the Node Exporter.
        """
        if jmx_exporter is not None:
            pulumi.set(__self__, "jmx_exporter", jmx_exporter)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)

    @property
    @pulumi.getter(name="jmxExporter")
    def jmx_exporter(self) -> Optional['outputs.ClusterJmxExporter']:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "jmx_exporter")

    @property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional['outputs.ClusterNodeExporter']:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "node_exporter")


@pulumi.output_type
class ClusterProvisionedThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeThroughput":
            suggest = "volume_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterProvisionedThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterProvisionedThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterProvisionedThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 volume_throughput: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Provisioned throughput is on or off.
        :param builtins.int volume_throughput: Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if volume_throughput is not None:
            pulumi.set(__self__, "volume_throughput", volume_throughput)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Provisioned throughput is on or off.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> Optional[builtins.int]:
        """
        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
        """
        return pulumi.get(self, "volume_throughput")


@pulumi.output_type
class ClusterPublicAccess(dict):
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str type: DISABLED means that public access is turned off. SERVICE_PROVIDED_EIPS means that public access is turned on.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        DISABLED means that public access is turned off. SERVICE_PROVIDED_EIPS means that public access is turned on.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterS3(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 bucket: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Specifies whether broker logs get sent to the specified Amazon S3 destination.
        :param builtins.str bucket: The name of the S3 bucket that is the destination for broker logs.
        :param builtins.str prefix: The S3 prefix that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether broker logs get sent to the specified Amazon S3 destination.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The name of the S3 bucket that is the destination for broker logs.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The S3 prefix that is the destination for broker logs.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ClusterSasl(dict):
    def __init__(__self__, *,
                 iam: Optional['outputs.ClusterIam'] = None,
                 scram: Optional['outputs.ClusterScram'] = None):
        """
        :param 'ClusterIam' iam: Details for ClientAuthentication using IAM.
        :param 'ClusterScram' scram: Details for SASL/SCRAM client authentication.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional['outputs.ClusterIam']:
        """
        Details for ClientAuthentication using IAM.
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def scram(self) -> Optional['outputs.ClusterScram']:
        """
        Details for SASL/SCRAM client authentication.
        """
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterScram(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: SASL/SCRAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        SASL/SCRAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsStorageInfo":
            suggest = "ebs_storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_storage_info: Optional['outputs.ClusterEbsStorageInfo'] = None):
        """
        :param 'ClusterEbsStorageInfo' ebs_storage_info: EBS volume information.
        """
        if ebs_storage_info is not None:
            pulumi.set(__self__, "ebs_storage_info", ebs_storage_info)

    @property
    @pulumi.getter(name="ebsStorageInfo")
    def ebs_storage_info(self) -> Optional['outputs.ClusterEbsStorageInfo']:
        """
        EBS volume information.
        """
        return pulumi.get(self, "ebs_storage_info")


@pulumi.output_type
class ClusterTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArnList":
            suggest = "certificate_authority_arn_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arn_list: Optional[Sequence[builtins.str]] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] certificate_authority_arn_list: List of AWS Private CA ARNs.
        :param builtins.bool enabled: TLS authentication is enabled or not.
        """
        if certificate_authority_arn_list is not None:
            pulumi.set(__self__, "certificate_authority_arn_list", certificate_authority_arn_list)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="certificateAuthorityArnList")
    def certificate_authority_arn_list(self) -> Optional[Sequence[builtins.str]]:
        """
        List of AWS Private CA ARNs.
        """
        return pulumi.get(self, "certificate_authority_arn_list")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        TLS authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterUnauthenticated(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Unauthenticated is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Unauthenticated is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthentication":
            suggest = "client_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVpcConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVpcConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVpcConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_authentication: Optional['outputs.ClusterVpcConnectivityClientAuthentication'] = None):
        """
        :param 'ClusterVpcConnectivityClientAuthentication' client_authentication: VPC connection control settings for brokers.
        """
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional['outputs.ClusterVpcConnectivityClientAuthentication']:
        """
        VPC connection control settings for brokers.
        """
        return pulumi.get(self, "client_authentication")


@pulumi.output_type
class ClusterVpcConnectivityClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterVpcConnectivitySasl'] = None,
                 tls: Optional['outputs.ClusterVpcConnectivityTls'] = None):
        """
        :param 'ClusterVpcConnectivitySasl' sasl: Details for VpcConnectivity ClientAuthentication using SASL.
        :param 'ClusterVpcConnectivityTls' tls: Details for VpcConnectivity ClientAuthentication using TLS.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterVpcConnectivitySasl']:
        """
        Details for VpcConnectivity ClientAuthentication using SASL.
        """
        return pulumi.get(self, "sasl")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterVpcConnectivityTls']:
        """
        Details for VpcConnectivity ClientAuthentication using TLS.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class ClusterVpcConnectivityIam(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivitySasl(dict):
    def __init__(__self__, *,
                 iam: Optional['outputs.ClusterVpcConnectivityIam'] = None,
                 scram: Optional['outputs.ClusterVpcConnectivityScram'] = None):
        """
        :param 'ClusterVpcConnectivityIam' iam: Details for ClientAuthentication using IAM for VpcConnectivity.
        :param 'ClusterVpcConnectivityScram' scram: Details for SASL/SCRAM client authentication for VpcConnectivity.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional['outputs.ClusterVpcConnectivityIam']:
        """
        Details for ClientAuthentication using IAM for VpcConnectivity.
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def scram(self) -> Optional['outputs.ClusterVpcConnectivityScram']:
        """
        Details for SASL/SCRAM client authentication for VpcConnectivity.
        """
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterVpcConnectivityScram(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: SASL/SCRAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        SASL/SCRAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterVpcConnectivityTls(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: TLS authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        TLS authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigurationLatestRevision(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationLatestRevision. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationLatestRevision.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationLatestRevision.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 revision: Optional[builtins.int] = None):
        """
        :param builtins.str creation_time: The time when the configuration revision was created.
        :param builtins.str description: The description of the configuration revision.
        :param builtins.int revision: The revision number.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        The time when the configuration revision was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the configuration revision.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def revision(self) -> Optional[builtins.int]:
        """
        The revision number.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ReplicatorAmazonMskCluster(dict):
    """
    Details of an Amazon MSK cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mskClusterArn":
            suggest = "msk_cluster_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorAmazonMskCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorAmazonMskCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorAmazonMskCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msk_cluster_arn: builtins.str):
        """
        Details of an Amazon MSK cluster.
        :param builtins.str msk_cluster_arn: The ARN of an Amazon MSK cluster.
        """
        pulumi.set(__self__, "msk_cluster_arn", msk_cluster_arn)

    @property
    @pulumi.getter(name="mskClusterArn")
    def msk_cluster_arn(self) -> builtins.str:
        """
        The ARN of an Amazon MSK cluster.
        """
        return pulumi.get(self, "msk_cluster_arn")


@pulumi.output_type
class ReplicatorConsumerGroupReplication(dict):
    """
    Configuration relating to consumer group replication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupsToReplicate":
            suggest = "consumer_groups_to_replicate"
        elif key == "consumerGroupsToExclude":
            suggest = "consumer_groups_to_exclude"
        elif key == "detectAndCopyNewConsumerGroups":
            suggest = "detect_and_copy_new_consumer_groups"
        elif key == "synchroniseConsumerGroupOffsets":
            suggest = "synchronise_consumer_group_offsets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorConsumerGroupReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorConsumerGroupReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorConsumerGroupReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_groups_to_replicate: Sequence[builtins.str],
                 consumer_groups_to_exclude: Optional[Sequence[builtins.str]] = None,
                 detect_and_copy_new_consumer_groups: Optional[builtins.bool] = None,
                 synchronise_consumer_group_offsets: Optional[builtins.bool] = None):
        """
        Configuration relating to consumer group replication.
        :param Sequence[builtins.str] consumer_groups_to_replicate: List of regular expression patterns indicating the consumer groups to copy.
        :param Sequence[builtins.str] consumer_groups_to_exclude: List of regular expression patterns indicating the consumer groups that should not be replicated.
        :param builtins.bool detect_and_copy_new_consumer_groups: Whether to periodically check for new consumer groups.
        :param builtins.bool synchronise_consumer_group_offsets: Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        pulumi.set(__self__, "consumer_groups_to_replicate", consumer_groups_to_replicate)
        if consumer_groups_to_exclude is not None:
            pulumi.set(__self__, "consumer_groups_to_exclude", consumer_groups_to_exclude)
        if detect_and_copy_new_consumer_groups is not None:
            pulumi.set(__self__, "detect_and_copy_new_consumer_groups", detect_and_copy_new_consumer_groups)
        if synchronise_consumer_group_offsets is not None:
            pulumi.set(__self__, "synchronise_consumer_group_offsets", synchronise_consumer_group_offsets)

    @property
    @pulumi.getter(name="consumerGroupsToReplicate")
    def consumer_groups_to_replicate(self) -> Sequence[builtins.str]:
        """
        List of regular expression patterns indicating the consumer groups to copy.
        """
        return pulumi.get(self, "consumer_groups_to_replicate")

    @property
    @pulumi.getter(name="consumerGroupsToExclude")
    def consumer_groups_to_exclude(self) -> Optional[Sequence[builtins.str]]:
        """
        List of regular expression patterns indicating the consumer groups that should not be replicated.
        """
        return pulumi.get(self, "consumer_groups_to_exclude")

    @property
    @pulumi.getter(name="detectAndCopyNewConsumerGroups")
    def detect_and_copy_new_consumer_groups(self) -> Optional[builtins.bool]:
        """
        Whether to periodically check for new consumer groups.
        """
        return pulumi.get(self, "detect_and_copy_new_consumer_groups")

    @property
    @pulumi.getter(name="synchroniseConsumerGroupOffsets")
    def synchronise_consumer_group_offsets(self) -> Optional[builtins.bool]:
        """
        Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        return pulumi.get(self, "synchronise_consumer_group_offsets")


@pulumi.output_type
class ReplicatorKafkaCluster(dict):
    """
    Details of a Kafka cluster for replication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amazonMskCluster":
            suggest = "amazon_msk_cluster"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amazon_msk_cluster: 'outputs.ReplicatorAmazonMskCluster',
                 vpc_config: 'outputs.ReplicatorKafkaClusterClientVpcConfig'):
        """
        Details of a Kafka cluster for replication.
        :param 'ReplicatorAmazonMskCluster' amazon_msk_cluster: Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        :param 'ReplicatorKafkaClusterClientVpcConfig' vpc_config: Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        pulumi.set(__self__, "amazon_msk_cluster", amazon_msk_cluster)
        pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="amazonMskCluster")
    def amazon_msk_cluster(self) -> 'outputs.ReplicatorAmazonMskCluster':
        """
        Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        """
        return pulumi.get(self, "amazon_msk_cluster")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.ReplicatorKafkaClusterClientVpcConfig':
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ReplicatorKafkaClusterClientVpcConfig(dict):
    """
    Details of an Amazon VPC which has network connectivity to the Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaClusterClientVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaClusterClientVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaClusterClientVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[builtins.str],
                 security_group_ids: Optional[Sequence[builtins.str]] = None):
        """
        Details of an Amazon VPC which has network connectivity to the Kafka cluster.
        :param Sequence[builtins.str] subnet_ids: The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        :param Sequence[builtins.str] security_group_ids: The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class ReplicatorReplicationInfo(dict):
    """
    Specifies configuration for replication between a source and target Kafka cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupReplication":
            suggest = "consumer_group_replication"
        elif key == "sourceKafkaClusterArn":
            suggest = "source_kafka_cluster_arn"
        elif key == "targetCompressionType":
            suggest = "target_compression_type"
        elif key == "targetKafkaClusterArn":
            suggest = "target_kafka_cluster_arn"
        elif key == "topicReplication":
            suggest = "topic_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorReplicationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorReplicationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorReplicationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_replication: 'outputs.ReplicatorConsumerGroupReplication',
                 source_kafka_cluster_arn: builtins.str,
                 target_compression_type: 'ReplicatorReplicationInfoTargetCompressionType',
                 target_kafka_cluster_arn: builtins.str,
                 topic_replication: 'outputs.ReplicatorTopicReplication'):
        """
        Specifies configuration for replication between a source and target Kafka cluster.
        :param 'ReplicatorConsumerGroupReplication' consumer_group_replication: Configuration relating to consumer group replication.
        :param builtins.str source_kafka_cluster_arn: Amazon Resource Name of the source Kafka cluster.
        :param 'ReplicatorReplicationInfoTargetCompressionType' target_compression_type: The type of compression to use writing records to target Kafka cluster.
        :param builtins.str target_kafka_cluster_arn: Amazon Resource Name of the target Kafka cluster.
        :param 'ReplicatorTopicReplication' topic_replication: Configuration relating to topic replication.
        """
        pulumi.set(__self__, "consumer_group_replication", consumer_group_replication)
        pulumi.set(__self__, "source_kafka_cluster_arn", source_kafka_cluster_arn)
        pulumi.set(__self__, "target_compression_type", target_compression_type)
        pulumi.set(__self__, "target_kafka_cluster_arn", target_kafka_cluster_arn)
        pulumi.set(__self__, "topic_replication", topic_replication)

    @property
    @pulumi.getter(name="consumerGroupReplication")
    def consumer_group_replication(self) -> 'outputs.ReplicatorConsumerGroupReplication':
        """
        Configuration relating to consumer group replication.
        """
        return pulumi.get(self, "consumer_group_replication")

    @property
    @pulumi.getter(name="sourceKafkaClusterArn")
    def source_kafka_cluster_arn(self) -> builtins.str:
        """
        Amazon Resource Name of the source Kafka cluster.
        """
        return pulumi.get(self, "source_kafka_cluster_arn")

    @property
    @pulumi.getter(name="targetCompressionType")
    def target_compression_type(self) -> 'ReplicatorReplicationInfoTargetCompressionType':
        """
        The type of compression to use writing records to target Kafka cluster.
        """
        return pulumi.get(self, "target_compression_type")

    @property
    @pulumi.getter(name="targetKafkaClusterArn")
    def target_kafka_cluster_arn(self) -> builtins.str:
        """
        Amazon Resource Name of the target Kafka cluster.
        """
        return pulumi.get(self, "target_kafka_cluster_arn")

    @property
    @pulumi.getter(name="topicReplication")
    def topic_replication(self) -> 'outputs.ReplicatorTopicReplication':
        """
        Configuration relating to topic replication.
        """
        return pulumi.get(self, "topic_replication")


@pulumi.output_type
class ReplicatorReplicationStartingPosition(dict):
    """
    Configuration for specifying the position in the topics to start replicating from.
    """
    def __init__(__self__, *,
                 type: Optional['ReplicatorReplicationStartingPositionType'] = None):
        """
        Configuration for specifying the position in the topics to start replicating from.
        :param 'ReplicatorReplicationStartingPositionType' type: The type of replication starting position.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ReplicatorReplicationStartingPositionType']:
        """
        The type of replication starting position.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicatorReplicationTopicNameConfiguration(dict):
    """
    Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
    """
    def __init__(__self__, *,
                 type: Optional['ReplicatorReplicationTopicNameConfigurationType'] = None):
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        :param 'ReplicatorReplicationTopicNameConfigurationType' type: The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ReplicatorReplicationTopicNameConfigurationType']:
        """
        The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicatorTopicReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicsToReplicate":
            suggest = "topics_to_replicate"
        elif key == "copyAccessControlListsForTopics":
            suggest = "copy_access_control_lists_for_topics"
        elif key == "copyTopicConfigurations":
            suggest = "copy_topic_configurations"
        elif key == "detectAndCopyNewTopics":
            suggest = "detect_and_copy_new_topics"
        elif key == "startingPosition":
            suggest = "starting_position"
        elif key == "topicNameConfiguration":
            suggest = "topic_name_configuration"
        elif key == "topicsToExclude":
            suggest = "topics_to_exclude"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorTopicReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorTopicReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorTopicReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topics_to_replicate: Sequence[builtins.str],
                 copy_access_control_lists_for_topics: Optional[builtins.bool] = None,
                 copy_topic_configurations: Optional[builtins.bool] = None,
                 detect_and_copy_new_topics: Optional[builtins.bool] = None,
                 starting_position: Optional['outputs.ReplicatorReplicationStartingPosition'] = None,
                 topic_name_configuration: Optional['outputs.ReplicatorReplicationTopicNameConfiguration'] = None,
                 topics_to_exclude: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] topics_to_replicate: List of regular expression patterns indicating the topics to copy.
        :param builtins.bool copy_access_control_lists_for_topics: Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        :param builtins.bool copy_topic_configurations: Whether to periodically configure remote topics to match their corresponding upstream topics.
        :param builtins.bool detect_and_copy_new_topics: Whether to periodically check for new topics and partitions.
        :param 'ReplicatorReplicationStartingPosition' starting_position: Configuration for specifying the position in the topics to start replicating from.
        :param 'ReplicatorReplicationTopicNameConfiguration' topic_name_configuration: Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        :param Sequence[builtins.str] topics_to_exclude: List of regular expression patterns indicating the topics that should not be replicated.
        """
        pulumi.set(__self__, "topics_to_replicate", topics_to_replicate)
        if copy_access_control_lists_for_topics is not None:
            pulumi.set(__self__, "copy_access_control_lists_for_topics", copy_access_control_lists_for_topics)
        if copy_topic_configurations is not None:
            pulumi.set(__self__, "copy_topic_configurations", copy_topic_configurations)
        if detect_and_copy_new_topics is not None:
            pulumi.set(__self__, "detect_and_copy_new_topics", detect_and_copy_new_topics)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if topic_name_configuration is not None:
            pulumi.set(__self__, "topic_name_configuration", topic_name_configuration)
        if topics_to_exclude is not None:
            pulumi.set(__self__, "topics_to_exclude", topics_to_exclude)

    @property
    @pulumi.getter(name="topicsToReplicate")
    def topics_to_replicate(self) -> Sequence[builtins.str]:
        """
        List of regular expression patterns indicating the topics to copy.
        """
        return pulumi.get(self, "topics_to_replicate")

    @property
    @pulumi.getter(name="copyAccessControlListsForTopics")
    def copy_access_control_lists_for_topics(self) -> Optional[builtins.bool]:
        """
        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_access_control_lists_for_topics")

    @property
    @pulumi.getter(name="copyTopicConfigurations")
    def copy_topic_configurations(self) -> Optional[builtins.bool]:
        """
        Whether to periodically configure remote topics to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_topic_configurations")

    @property
    @pulumi.getter(name="detectAndCopyNewTopics")
    def detect_and_copy_new_topics(self) -> Optional[builtins.bool]:
        """
        Whether to periodically check for new topics and partitions.
        """
        return pulumi.get(self, "detect_and_copy_new_topics")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional['outputs.ReplicatorReplicationStartingPosition']:
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="topicNameConfiguration")
    def topic_name_configuration(self) -> Optional['outputs.ReplicatorReplicationTopicNameConfiguration']:
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        """
        return pulumi.get(self, "topic_name_configuration")

    @property
    @pulumi.getter(name="topicsToExclude")
    def topics_to_exclude(self) -> Optional[Sequence[builtins.str]]:
        """
        List of regular expression patterns indicating the topics that should not be replicated.
        """
        return pulumi.get(self, "topics_to_exclude")


@pulumi.output_type
class ServerlessClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: 'outputs.ServerlessClusterSasl'):
        """
        :param 'ServerlessClusterSasl' sasl: Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        pulumi.set(__self__, "sasl", sasl)

    @property
    @pulumi.getter
    def sasl(self) -> 'outputs.ServerlessClusterSasl':
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        return pulumi.get(self, "sasl")


@pulumi.output_type
class ServerlessClusterIam(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerlessClusterSasl(dict):
    def __init__(__self__, *,
                 iam: 'outputs.ServerlessClusterIam'):
        """
        :param 'ServerlessClusterIam' iam: Details for ClientAuthentication using IAM.
        """
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.ServerlessClusterIam':
        """
        Details for ClientAuthentication using IAM.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class ServerlessClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[builtins.str],
                 security_groups: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "security_groups")


