# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClusterPolicyResult',
    'AwaitableGetClusterPolicyResult',
    'get_cluster_policy',
    'get_cluster_policy_output',
]

@pulumi.output_type
class GetClusterPolicyResult:
    def __init__(__self__, current_version=None, policy=None):
        if current_version and not isinstance(current_version, str):
            raise TypeError("Expected argument 'current_version' to be a str")
        pulumi.set(__self__, "current_version", current_version)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[builtins.str]:
        """
        The current version of the policy attached to the specified cluster
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A policy document containing permissions to add to the specified cluster.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::MSK::ClusterPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")


class AwaitableGetClusterPolicyResult(GetClusterPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterPolicyResult(
            current_version=self.current_version,
            policy=self.policy)


def get_cluster_policy(cluster_arn: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterPolicyResult:
    """
    Resource Type definition for AWS::MSK::ClusterPolicy


    :param builtins.str cluster_arn: The arn of the cluster for the resource policy.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:msk:getClusterPolicy', __args__, opts=opts, typ=GetClusterPolicyResult).value

    return AwaitableGetClusterPolicyResult(
        current_version=pulumi.get(__ret__, 'current_version'),
        policy=pulumi.get(__ret__, 'policy'))
def get_cluster_policy_output(cluster_arn: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterPolicyResult]:
    """
    Resource Type definition for AWS::MSK::ClusterPolicy


    :param builtins.str cluster_arn: The arn of the cluster for the resource policy.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:msk:getClusterPolicy', __args__, opts=opts, typ=GetClusterPolicyResult)
    return __ret__.apply(lambda __response__: GetClusterPolicyResult(
        current_version=pulumi.get(__response__, 'current_version'),
        policy=pulumi.get(__response__, 'policy')))
