# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ClusterBrokerLogsArgs',
    'ClusterBrokerLogsArgsDict',
    'ClusterBrokerNodeGroupInfoArgs',
    'ClusterBrokerNodeGroupInfoArgsDict',
    'ClusterClientAuthenticationArgs',
    'ClusterClientAuthenticationArgsDict',
    'ClusterCloudWatchLogsArgs',
    'ClusterCloudWatchLogsArgsDict',
    'ClusterConfigurationInfoArgs',
    'ClusterConfigurationInfoArgsDict',
    'ClusterConnectivityInfoArgs',
    'ClusterConnectivityInfoArgsDict',
    'ClusterEbsStorageInfoArgs',
    'ClusterEbsStorageInfoArgsDict',
    'ClusterEncryptionAtRestArgs',
    'ClusterEncryptionAtRestArgsDict',
    'ClusterEncryptionInTransitArgs',
    'ClusterEncryptionInTransitArgsDict',
    'ClusterEncryptionInfoArgs',
    'ClusterEncryptionInfoArgsDict',
    'ClusterFirehoseArgs',
    'ClusterFirehoseArgsDict',
    'ClusterIamArgs',
    'ClusterIamArgsDict',
    'ClusterJmxExporterArgs',
    'ClusterJmxExporterArgsDict',
    'ClusterLoggingInfoArgs',
    'ClusterLoggingInfoArgsDict',
    'ClusterNodeExporterArgs',
    'ClusterNodeExporterArgsDict',
    'ClusterOpenMonitoringArgs',
    'ClusterOpenMonitoringArgsDict',
    'ClusterPrometheusArgs',
    'ClusterPrometheusArgsDict',
    'ClusterProvisionedThroughputArgs',
    'ClusterProvisionedThroughputArgsDict',
    'ClusterPublicAccessArgs',
    'ClusterPublicAccessArgsDict',
    'ClusterS3Args',
    'ClusterS3ArgsDict',
    'ClusterSaslArgs',
    'ClusterSaslArgsDict',
    'ClusterScramArgs',
    'ClusterScramArgsDict',
    'ClusterStorageInfoArgs',
    'ClusterStorageInfoArgsDict',
    'ClusterTlsArgs',
    'ClusterTlsArgsDict',
    'ClusterUnauthenticatedArgs',
    'ClusterUnauthenticatedArgsDict',
    'ClusterVpcConnectivityClientAuthenticationArgs',
    'ClusterVpcConnectivityClientAuthenticationArgsDict',
    'ClusterVpcConnectivityIamArgs',
    'ClusterVpcConnectivityIamArgsDict',
    'ClusterVpcConnectivitySaslArgs',
    'ClusterVpcConnectivitySaslArgsDict',
    'ClusterVpcConnectivityScramArgs',
    'ClusterVpcConnectivityScramArgsDict',
    'ClusterVpcConnectivityTlsArgs',
    'ClusterVpcConnectivityTlsArgsDict',
    'ClusterVpcConnectivityArgs',
    'ClusterVpcConnectivityArgsDict',
    'ConfigurationLatestRevisionArgs',
    'ConfigurationLatestRevisionArgsDict',
    'ReplicatorAmazonMskClusterArgs',
    'ReplicatorAmazonMskClusterArgsDict',
    'ReplicatorConsumerGroupReplicationArgs',
    'ReplicatorConsumerGroupReplicationArgsDict',
    'ReplicatorKafkaClusterClientVpcConfigArgs',
    'ReplicatorKafkaClusterClientVpcConfigArgsDict',
    'ReplicatorKafkaClusterArgs',
    'ReplicatorKafkaClusterArgsDict',
    'ReplicatorReplicationInfoArgs',
    'ReplicatorReplicationInfoArgsDict',
    'ReplicatorReplicationStartingPositionArgs',
    'ReplicatorReplicationStartingPositionArgsDict',
    'ReplicatorReplicationTopicNameConfigurationArgs',
    'ReplicatorReplicationTopicNameConfigurationArgsDict',
    'ReplicatorTopicReplicationArgs',
    'ReplicatorTopicReplicationArgsDict',
    'ServerlessClusterClientAuthenticationArgs',
    'ServerlessClusterClientAuthenticationArgsDict',
    'ServerlessClusterIamArgs',
    'ServerlessClusterIamArgsDict',
    'ServerlessClusterSaslArgs',
    'ServerlessClusterSaslArgsDict',
    'ServerlessClusterVpcConfigArgs',
    'ServerlessClusterVpcConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterBrokerLogsArgsDict(TypedDict):
        cloud_watch_logs: NotRequired[pulumi.Input['ClusterCloudWatchLogsArgsDict']]
        firehose: NotRequired[pulumi.Input['ClusterFirehoseArgsDict']]
        """
        Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        s3: NotRequired[pulumi.Input['ClusterS3ArgsDict']]
        """
        Details of the Amazon S3 destination for broker logs.
        """
elif False:
    ClusterBrokerLogsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBrokerLogsArgs:
    def __init__(__self__, *,
                 cloud_watch_logs: Optional[pulumi.Input['ClusterCloudWatchLogsArgs']] = None,
                 firehose: Optional[pulumi.Input['ClusterFirehoseArgs']] = None,
                 s3: Optional[pulumi.Input['ClusterS3Args']] = None):
        """
        :param pulumi.Input['ClusterFirehoseArgs'] firehose: Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
        :param pulumi.Input['ClusterS3Args'] s3: Details of the Amazon S3 destination for broker logs.
        """
        if cloud_watch_logs is not None:
            pulumi.set(__self__, "cloud_watch_logs", cloud_watch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudWatchLogs")
    def cloud_watch_logs(self) -> Optional[pulumi.Input['ClusterCloudWatchLogsArgs']]:
        return pulumi.get(self, "cloud_watch_logs")

    @cloud_watch_logs.setter
    def cloud_watch_logs(self, value: Optional[pulumi.Input['ClusterCloudWatchLogsArgs']]):
        pulumi.set(self, "cloud_watch_logs", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['ClusterFirehoseArgs']]:
        """
        Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['ClusterFirehoseArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['ClusterS3Args']]:
        """
        Details of the Amazon S3 destination for broker logs.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['ClusterS3Args']]):
        pulumi.set(self, "s3", value)


if not MYPY:
    class ClusterBrokerNodeGroupInfoArgsDict(TypedDict):
        client_subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of subnets to connect to in the client virtual private cloud (VPC). Amazon creates elastic network interfaces (ENIs) inside these subnets. Client applications use ENIs to produce and consume data.

        If you use the US West (N. California) Region, specify exactly two subnets. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.

        Client subnets can't occupy the Availability Zone with ID `use1-az3` .
        """
        instance_type: pulumi.Input[builtins.str]
        """
        The type of Amazon EC2 instances to use for brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, kafka.m5.24xlarge, and kafka.t3.small.
        """
        broker_az_distribution: NotRequired[pulumi.Input[builtins.str]]
        """
        This parameter is currently not in use.
        """
        connectivity_info: NotRequired[pulumi.Input['ClusterConnectivityInfoArgsDict']]
        """
        Information about the cluster's connectivity setting.
        """
        security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The security groups to associate with the ENIs in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the `ec2:DescribeSecurityGroups` permission.
        """
        storage_info: NotRequired[pulumi.Input['ClusterStorageInfoArgsDict']]
        """
        Contains information about storage volumes attached to Amazon MSK broker nodes.
        """
elif False:
    ClusterBrokerNodeGroupInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBrokerNodeGroupInfoArgs:
    def __init__(__self__, *,
                 client_subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 instance_type: pulumi.Input[builtins.str],
                 broker_az_distribution: Optional[pulumi.Input[builtins.str]] = None,
                 connectivity_info: Optional[pulumi.Input['ClusterConnectivityInfoArgs']] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 storage_info: Optional[pulumi.Input['ClusterStorageInfoArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] client_subnets: The list of subnets to connect to in the client virtual private cloud (VPC). Amazon creates elastic network interfaces (ENIs) inside these subnets. Client applications use ENIs to produce and consume data.
               
               If you use the US West (N. California) Region, specify exactly two subnets. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
               
               Client subnets can't occupy the Availability Zone with ID `use1-az3` .
        :param pulumi.Input[builtins.str] instance_type: The type of Amazon EC2 instances to use for brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, kafka.m5.24xlarge, and kafka.t3.small.
        :param pulumi.Input[builtins.str] broker_az_distribution: This parameter is currently not in use.
        :param pulumi.Input['ClusterConnectivityInfoArgs'] connectivity_info: Information about the cluster's connectivity setting.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: The security groups to associate with the ENIs in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the `ec2:DescribeSecurityGroups` permission.
        :param pulumi.Input['ClusterStorageInfoArgs'] storage_info: Contains information about storage volumes attached to Amazon MSK broker nodes.
        """
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "instance_type", instance_type)
        if broker_az_distribution is not None:
            pulumi.set(__self__, "broker_az_distribution", broker_az_distribution)
        if connectivity_info is not None:
            pulumi.set(__self__, "connectivity_info", connectivity_info)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if storage_info is not None:
            pulumi.set(__self__, "storage_info", storage_info)

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of subnets to connect to in the client virtual private cloud (VPC). Amazon creates elastic network interfaces (ENIs) inside these subnets. Client applications use ENIs to produce and consume data.

        If you use the US West (N. California) Region, specify exactly two subnets. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.

        Client subnets can't occupy the Availability Zone with ID `use1-az3` .
        """
        return pulumi.get(self, "client_subnets")

    @client_subnets.setter
    def client_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "client_subnets", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Amazon EC2 instances to use for brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, kafka.m5.24xlarge, and kafka.t3.small.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="brokerAzDistribution")
    def broker_az_distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This parameter is currently not in use.
        """
        return pulumi.get(self, "broker_az_distribution")

    @broker_az_distribution.setter
    def broker_az_distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "broker_az_distribution", value)

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> Optional[pulumi.Input['ClusterConnectivityInfoArgs']]:
        """
        Information about the cluster's connectivity setting.
        """
        return pulumi.get(self, "connectivity_info")

    @connectivity_info.setter
    def connectivity_info(self, value: Optional[pulumi.Input['ClusterConnectivityInfoArgs']]):
        pulumi.set(self, "connectivity_info", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The security groups to associate with the ENIs in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the `ec2:DescribeSecurityGroups` permission.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="storageInfo")
    def storage_info(self) -> Optional[pulumi.Input['ClusterStorageInfoArgs']]:
        """
        Contains information about storage volumes attached to Amazon MSK broker nodes.
        """
        return pulumi.get(self, "storage_info")

    @storage_info.setter
    def storage_info(self, value: Optional[pulumi.Input['ClusterStorageInfoArgs']]):
        pulumi.set(self, "storage_info", value)


if not MYPY:
    class ClusterClientAuthenticationArgsDict(TypedDict):
        sasl: NotRequired[pulumi.Input['ClusterSaslArgsDict']]
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        tls: NotRequired[pulumi.Input['ClusterTlsArgsDict']]
        """
        Details for ClientAuthentication using TLS. To turn on TLS access control, you must also turn on `EncryptionInTransit` by setting `inCluster` to true and `clientBroker` to `TLS` .
        """
        unauthenticated: NotRequired[pulumi.Input['ClusterUnauthenticatedArgsDict']]
        """
        Details for ClientAuthentication using no authentication.
        """
elif False:
    ClusterClientAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClientAuthenticationArgs:
    def __init__(__self__, *,
                 sasl: Optional[pulumi.Input['ClusterSaslArgs']] = None,
                 tls: Optional[pulumi.Input['ClusterTlsArgs']] = None,
                 unauthenticated: Optional[pulumi.Input['ClusterUnauthenticatedArgs']] = None):
        """
        :param pulumi.Input['ClusterSaslArgs'] sasl: Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        :param pulumi.Input['ClusterTlsArgs'] tls: Details for ClientAuthentication using TLS. To turn on TLS access control, you must also turn on `EncryptionInTransit` by setting `inCluster` to true and `clientBroker` to `TLS` .
        :param pulumi.Input['ClusterUnauthenticatedArgs'] unauthenticated: Details for ClientAuthentication using no authentication.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if unauthenticated is not None:
            pulumi.set(__self__, "unauthenticated", unauthenticated)

    @property
    @pulumi.getter
    def sasl(self) -> Optional[pulumi.Input['ClusterSaslArgs']]:
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        return pulumi.get(self, "sasl")

    @sasl.setter
    def sasl(self, value: Optional[pulumi.Input['ClusterSaslArgs']]):
        pulumi.set(self, "sasl", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['ClusterTlsArgs']]:
        """
        Details for ClientAuthentication using TLS. To turn on TLS access control, you must also turn on `EncryptionInTransit` by setting `inCluster` to true and `clientBroker` to `TLS` .
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['ClusterTlsArgs']]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter
    def unauthenticated(self) -> Optional[pulumi.Input['ClusterUnauthenticatedArgs']]:
        """
        Details for ClientAuthentication using no authentication.
        """
        return pulumi.get(self, "unauthenticated")

    @unauthenticated.setter
    def unauthenticated(self, value: Optional[pulumi.Input['ClusterUnauthenticatedArgs']]):
        pulumi.set(self, "unauthenticated", value)


if not MYPY:
    class ClusterCloudWatchLogsArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
        """
        log_group: NotRequired[pulumi.Input[builtins.str]]
        """
        The CloudWatch log group that is the destination for broker logs.
        """
elif False:
    ClusterCloudWatchLogsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCloudWatchLogsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 log_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
        :param pulumi.Input[builtins.str] log_group: The CloudWatch log group that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CloudWatch log group that is the destination for broker logs.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group", value)


if not MYPY:
    class ClusterConfigurationInfoArgsDict(TypedDict):
        arn: pulumi.Input[builtins.str]
        """
        ARN of the configuration to use.
        """
        revision: pulumi.Input[builtins.int]
        """
        The revision of the configuration to use.
        """
elif False:
    ClusterConfigurationInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterConfigurationInfoArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str],
                 revision: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] arn: ARN of the configuration to use.
        :param pulumi.Input[builtins.int] revision: The revision of the configuration to use.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the configuration to use.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Input[builtins.int]:
        """
        The revision of the configuration to use.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "revision", value)


if not MYPY:
    class ClusterConnectivityInfoArgsDict(TypedDict):
        public_access: NotRequired[pulumi.Input['ClusterPublicAccessArgsDict']]
        """
        Access control settings for the cluster's brokers.
        """
        vpc_connectivity: NotRequired[pulumi.Input['ClusterVpcConnectivityArgsDict']]
        """
        VPC connection control settings for brokers.
        """
elif False:
    ClusterConnectivityInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterConnectivityInfoArgs:
    def __init__(__self__, *,
                 public_access: Optional[pulumi.Input['ClusterPublicAccessArgs']] = None,
                 vpc_connectivity: Optional[pulumi.Input['ClusterVpcConnectivityArgs']] = None):
        """
        :param pulumi.Input['ClusterPublicAccessArgs'] public_access: Access control settings for the cluster's brokers.
        :param pulumi.Input['ClusterVpcConnectivityArgs'] vpc_connectivity: VPC connection control settings for brokers.
        """
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if vpc_connectivity is not None:
            pulumi.set(__self__, "vpc_connectivity", vpc_connectivity)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[pulumi.Input['ClusterPublicAccessArgs']]:
        """
        Access control settings for the cluster's brokers.
        """
        return pulumi.get(self, "public_access")

    @public_access.setter
    def public_access(self, value: Optional[pulumi.Input['ClusterPublicAccessArgs']]):
        pulumi.set(self, "public_access", value)

    @property
    @pulumi.getter(name="vpcConnectivity")
    def vpc_connectivity(self) -> Optional[pulumi.Input['ClusterVpcConnectivityArgs']]:
        """
        VPC connection control settings for brokers.
        """
        return pulumi.get(self, "vpc_connectivity")

    @vpc_connectivity.setter
    def vpc_connectivity(self, value: Optional[pulumi.Input['ClusterVpcConnectivityArgs']]):
        pulumi.set(self, "vpc_connectivity", value)


if not MYPY:
    class ClusterEbsStorageInfoArgsDict(TypedDict):
        provisioned_throughput: NotRequired[pulumi.Input['ClusterProvisionedThroughputArgsDict']]
        """
        EBS volume provisioned throughput information.
        """
        volume_size: NotRequired[pulumi.Input[builtins.int]]
        """
        The size in GiB of the EBS volume for the data drive on each broker node.
        """
elif False:
    ClusterEbsStorageInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEbsStorageInfoArgs:
    def __init__(__self__, *,
                 provisioned_throughput: Optional[pulumi.Input['ClusterProvisionedThroughputArgs']] = None,
                 volume_size: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input['ClusterProvisionedThroughputArgs'] provisioned_throughput: EBS volume provisioned throughput information.
        :param pulumi.Input[builtins.int] volume_size: The size in GiB of the EBS volume for the data drive on each broker node.
        """
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional[pulumi.Input['ClusterProvisionedThroughputArgs']]:
        """
        EBS volume provisioned throughput information.
        """
        return pulumi.get(self, "provisioned_throughput")

    @provisioned_throughput.setter
    def provisioned_throughput(self, value: Optional[pulumi.Input['ClusterProvisionedThroughputArgs']]):
        pulumi.set(self, "provisioned_throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size in GiB of the EBS volume for the data drive on each broker node.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size", value)


if not MYPY:
    class ClusterEncryptionAtRestArgsDict(TypedDict):
        data_volume_kms_key_id: pulumi.Input[builtins.str]
        """
        The ARN of the Amazon KMS key for encrypting data at rest. If you don't specify a KMS key, MSK creates one for you and uses it.
        """
elif False:
    ClusterEncryptionAtRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionAtRestArgs:
    def __init__(__self__, *,
                 data_volume_kms_key_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] data_volume_kms_key_id: The ARN of the Amazon KMS key for encrypting data at rest. If you don't specify a KMS key, MSK creates one for you and uses it.
        """
        pulumi.set(__self__, "data_volume_kms_key_id", data_volume_kms_key_id)

    @property
    @pulumi.getter(name="dataVolumeKmsKeyId")
    def data_volume_kms_key_id(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Amazon KMS key for encrypting data at rest. If you don't specify a KMS key, MSK creates one for you and uses it.
        """
        return pulumi.get(self, "data_volume_kms_key_id")

    @data_volume_kms_key_id.setter
    def data_volume_kms_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_volume_kms_key_id", value)


if not MYPY:
    class ClusterEncryptionInTransitArgsDict(TypedDict):
        client_broker: NotRequired[pulumi.Input['ClusterEncryptionInTransitClientBroker']]
        """
        Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.

        - `TLS` : Indicates that client-broker communication is enabled with TLS only.
        - `TLS_PLAINTEXT` : Indicates that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
        - `PLAINTEXT` : Indicates that client-broker communication is enabled in plaintext only.

        The default value is `TLS` .
        """
        in_cluster: NotRequired[pulumi.Input[builtins.bool]]
        """
        When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.

        The default value is true.
        """
elif False:
    ClusterEncryptionInTransitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionInTransitArgs:
    def __init__(__self__, *,
                 client_broker: Optional[pulumi.Input['ClusterEncryptionInTransitClientBroker']] = None,
                 in_cluster: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input['ClusterEncryptionInTransitClientBroker'] client_broker: Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.
               
               - `TLS` : Indicates that client-broker communication is enabled with TLS only.
               - `TLS_PLAINTEXT` : Indicates that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
               - `PLAINTEXT` : Indicates that client-broker communication is enabled in plaintext only.
               
               The default value is `TLS` .
        :param pulumi.Input[builtins.bool] in_cluster: When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
               
               The default value is true.
        """
        if client_broker is not None:
            pulumi.set(__self__, "client_broker", client_broker)
        if in_cluster is not None:
            pulumi.set(__self__, "in_cluster", in_cluster)

    @property
    @pulumi.getter(name="clientBroker")
    def client_broker(self) -> Optional[pulumi.Input['ClusterEncryptionInTransitClientBroker']]:
        """
        Indicates the encryption setting for data in transit between clients and brokers. You must set it to one of the following values.

        - `TLS` : Indicates that client-broker communication is enabled with TLS only.
        - `TLS_PLAINTEXT` : Indicates that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
        - `PLAINTEXT` : Indicates that client-broker communication is enabled in plaintext only.

        The default value is `TLS` .
        """
        return pulumi.get(self, "client_broker")

    @client_broker.setter
    def client_broker(self, value: Optional[pulumi.Input['ClusterEncryptionInTransitClientBroker']]):
        pulumi.set(self, "client_broker", value)

    @property
    @pulumi.getter(name="inCluster")
    def in_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.

        The default value is true.
        """
        return pulumi.get(self, "in_cluster")

    @in_cluster.setter
    def in_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "in_cluster", value)


if not MYPY:
    class ClusterEncryptionInfoArgsDict(TypedDict):
        encryption_at_rest: NotRequired[pulumi.Input['ClusterEncryptionAtRestArgsDict']]
        """
        The data-volume encryption details.
        """
        encryption_in_transit: NotRequired[pulumi.Input['ClusterEncryptionInTransitArgsDict']]
        """
        The details for encryption in transit.
        """
elif False:
    ClusterEncryptionInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionInfoArgs:
    def __init__(__self__, *,
                 encryption_at_rest: Optional[pulumi.Input['ClusterEncryptionAtRestArgs']] = None,
                 encryption_in_transit: Optional[pulumi.Input['ClusterEncryptionInTransitArgs']] = None):
        """
        :param pulumi.Input['ClusterEncryptionAtRestArgs'] encryption_at_rest: The data-volume encryption details.
        :param pulumi.Input['ClusterEncryptionInTransitArgs'] encryption_in_transit: The details for encryption in transit.
        """
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional[pulumi.Input['ClusterEncryptionAtRestArgs']]:
        """
        The data-volume encryption details.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: Optional[pulumi.Input['ClusterEncryptionAtRestArgs']]):
        pulumi.set(self, "encryption_at_rest", value)

    @property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional[pulumi.Input['ClusterEncryptionInTransitArgs']]:
        """
        The details for encryption in transit.
        """
        return pulumi.get(self, "encryption_in_transit")

    @encryption_in_transit.setter
    def encryption_in_transit(self, value: Optional[pulumi.Input['ClusterEncryptionInTransitArgs']]):
        pulumi.set(self, "encryption_in_transit", value)


if not MYPY:
    class ClusterFirehoseArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Specifies whether broker logs get send to the specified Kinesis Data Firehose delivery stream.
        """
        delivery_stream: NotRequired[pulumi.Input[builtins.str]]
        """
        The Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
elif False:
    ClusterFirehoseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterFirehoseArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 delivery_stream: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Specifies whether broker logs get send to the specified Kinesis Data Firehose delivery stream.
        :param pulumi.Input[builtins.str] delivery_stream: The Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether broker logs get send to the specified Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kinesis Data Firehose delivery stream that is the destination for broker logs.
        """
        return pulumi.get(self, "delivery_stream")

    @delivery_stream.setter
    def delivery_stream(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delivery_stream", value)


if not MYPY:
    class ClusterIamArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        SASL/IAM authentication is enabled or not.
        """
elif False:
    ClusterIamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterIamArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterJmxExporterArgsDict(TypedDict):
        enabled_in_broker: pulumi.Input[builtins.bool]
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
elif False:
    ClusterJmxExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterJmxExporterArgs:
    def __init__(__self__, *,
                 enabled_in_broker: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled_in_broker: Indicates whether you want to enable or disable the JMX Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")

    @enabled_in_broker.setter
    def enabled_in_broker(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled_in_broker", value)


if not MYPY:
    class ClusterLoggingInfoArgsDict(TypedDict):
        broker_logs: pulumi.Input['ClusterBrokerLogsArgsDict']
        """
        You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.
        """
elif False:
    ClusterLoggingInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterLoggingInfoArgs:
    def __init__(__self__, *,
                 broker_logs: pulumi.Input['ClusterBrokerLogsArgs']):
        """
        :param pulumi.Input['ClusterBrokerLogsArgs'] broker_logs: You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.
        """
        pulumi.set(__self__, "broker_logs", broker_logs)

    @property
    @pulumi.getter(name="brokerLogs")
    def broker_logs(self) -> pulumi.Input['ClusterBrokerLogsArgs']:
        """
        You can configure your MSK cluster to send broker logs to different destination types. This configuration specifies the details of these destinations.
        """
        return pulumi.get(self, "broker_logs")

    @broker_logs.setter
    def broker_logs(self, value: pulumi.Input['ClusterBrokerLogsArgs']):
        pulumi.set(self, "broker_logs", value)


if not MYPY:
    class ClusterNodeExporterArgsDict(TypedDict):
        enabled_in_broker: pulumi.Input[builtins.bool]
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
elif False:
    ClusterNodeExporterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeExporterArgs:
    def __init__(__self__, *,
                 enabled_in_broker: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled_in_broker: Indicates whether you want to enable or disable the Node Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")

    @enabled_in_broker.setter
    def enabled_in_broker(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled_in_broker", value)


if not MYPY:
    class ClusterOpenMonitoringArgsDict(TypedDict):
        prometheus: pulumi.Input['ClusterPrometheusArgsDict']
        """
        Prometheus exporter settings.
        """
elif False:
    ClusterOpenMonitoringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOpenMonitoringArgs:
    def __init__(__self__, *,
                 prometheus: pulumi.Input['ClusterPrometheusArgs']):
        """
        :param pulumi.Input['ClusterPrometheusArgs'] prometheus: Prometheus exporter settings.
        """
        pulumi.set(__self__, "prometheus", prometheus)

    @property
    @pulumi.getter
    def prometheus(self) -> pulumi.Input['ClusterPrometheusArgs']:
        """
        Prometheus exporter settings.
        """
        return pulumi.get(self, "prometheus")

    @prometheus.setter
    def prometheus(self, value: pulumi.Input['ClusterPrometheusArgs']):
        pulumi.set(self, "prometheus", value)


if not MYPY:
    class ClusterPrometheusArgsDict(TypedDict):
        jmx_exporter: NotRequired[pulumi.Input['ClusterJmxExporterArgsDict']]
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        node_exporter: NotRequired[pulumi.Input['ClusterNodeExporterArgsDict']]
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
elif False:
    ClusterPrometheusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPrometheusArgs:
    def __init__(__self__, *,
                 jmx_exporter: Optional[pulumi.Input['ClusterJmxExporterArgs']] = None,
                 node_exporter: Optional[pulumi.Input['ClusterNodeExporterArgs']] = None):
        """
        :param pulumi.Input['ClusterJmxExporterArgs'] jmx_exporter: Indicates whether you want to enable or disable the JMX Exporter.
        :param pulumi.Input['ClusterNodeExporterArgs'] node_exporter: Indicates whether you want to enable or disable the Node Exporter.
        """
        if jmx_exporter is not None:
            pulumi.set(__self__, "jmx_exporter", jmx_exporter)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)

    @property
    @pulumi.getter(name="jmxExporter")
    def jmx_exporter(self) -> Optional[pulumi.Input['ClusterJmxExporterArgs']]:
        """
        Indicates whether you want to enable or disable the JMX Exporter.
        """
        return pulumi.get(self, "jmx_exporter")

    @jmx_exporter.setter
    def jmx_exporter(self, value: Optional[pulumi.Input['ClusterJmxExporterArgs']]):
        pulumi.set(self, "jmx_exporter", value)

    @property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional[pulumi.Input['ClusterNodeExporterArgs']]:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "node_exporter")

    @node_exporter.setter
    def node_exporter(self, value: Optional[pulumi.Input['ClusterNodeExporterArgs']]):
        pulumi.set(self, "node_exporter", value)


if not MYPY:
    class ClusterProvisionedThroughputArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Provisioned throughput is on or off.
        """
        volume_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
        """
elif False:
    ClusterProvisionedThroughputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterProvisionedThroughputArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 volume_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Provisioned throughput is on or off.
        :param pulumi.Input[builtins.int] volume_throughput: Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if volume_throughput is not None:
            pulumi.set(__self__, "volume_throughput", volume_throughput)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Provisioned throughput is on or off.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
        """
        return pulumi.get(self, "volume_throughput")

    @volume_throughput.setter
    def volume_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_throughput", value)


if not MYPY:
    class ClusterPublicAccessArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        DISABLED means that public access is turned off. SERVICE_PROVIDED_EIPS means that public access is turned on.
        """
elif False:
    ClusterPublicAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPublicAccessArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: DISABLED means that public access is turned off. SERVICE_PROVIDED_EIPS means that public access is turned on.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DISABLED means that public access is turned off. SERVICE_PROVIDED_EIPS means that public access is turned on.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ClusterS3ArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Specifies whether broker logs get sent to the specified Amazon S3 destination.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the S3 bucket that is the destination for broker logs.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The S3 prefix that is the destination for broker logs.
        """
elif False:
    ClusterS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterS3Args:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Specifies whether broker logs get sent to the specified Amazon S3 destination.
        :param pulumi.Input[builtins.str] bucket: The name of the S3 bucket that is the destination for broker logs.
        :param pulumi.Input[builtins.str] prefix: The S3 prefix that is the destination for broker logs.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether broker logs get sent to the specified Amazon S3 destination.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the S3 bucket that is the destination for broker logs.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The S3 prefix that is the destination for broker logs.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class ClusterSaslArgsDict(TypedDict):
        iam: NotRequired[pulumi.Input['ClusterIamArgsDict']]
        """
        Details for ClientAuthentication using IAM.
        """
        scram: NotRequired[pulumi.Input['ClusterScramArgsDict']]
        """
        Details for SASL/SCRAM client authentication.
        """
elif False:
    ClusterSaslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSaslArgs:
    def __init__(__self__, *,
                 iam: Optional[pulumi.Input['ClusterIamArgs']] = None,
                 scram: Optional[pulumi.Input['ClusterScramArgs']] = None):
        """
        :param pulumi.Input['ClusterIamArgs'] iam: Details for ClientAuthentication using IAM.
        :param pulumi.Input['ClusterScramArgs'] scram: Details for SASL/SCRAM client authentication.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['ClusterIamArgs']]:
        """
        Details for ClientAuthentication using IAM.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['ClusterIamArgs']]):
        pulumi.set(self, "iam", value)

    @property
    @pulumi.getter
    def scram(self) -> Optional[pulumi.Input['ClusterScramArgs']]:
        """
        Details for SASL/SCRAM client authentication.
        """
        return pulumi.get(self, "scram")

    @scram.setter
    def scram(self, value: Optional[pulumi.Input['ClusterScramArgs']]):
        pulumi.set(self, "scram", value)


if not MYPY:
    class ClusterScramArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        SASL/SCRAM authentication is enabled or not.
        """
elif False:
    ClusterScramArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterScramArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: SASL/SCRAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        SASL/SCRAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterStorageInfoArgsDict(TypedDict):
        ebs_storage_info: NotRequired[pulumi.Input['ClusterEbsStorageInfoArgsDict']]
        """
        EBS volume information.
        """
elif False:
    ClusterStorageInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStorageInfoArgs:
    def __init__(__self__, *,
                 ebs_storage_info: Optional[pulumi.Input['ClusterEbsStorageInfoArgs']] = None):
        """
        :param pulumi.Input['ClusterEbsStorageInfoArgs'] ebs_storage_info: EBS volume information.
        """
        if ebs_storage_info is not None:
            pulumi.set(__self__, "ebs_storage_info", ebs_storage_info)

    @property
    @pulumi.getter(name="ebsStorageInfo")
    def ebs_storage_info(self) -> Optional[pulumi.Input['ClusterEbsStorageInfoArgs']]:
        """
        EBS volume information.
        """
        return pulumi.get(self, "ebs_storage_info")

    @ebs_storage_info.setter
    def ebs_storage_info(self, value: Optional[pulumi.Input['ClusterEbsStorageInfoArgs']]):
        pulumi.set(self, "ebs_storage_info", value)


if not MYPY:
    class ClusterTlsArgsDict(TypedDict):
        certificate_authority_arn_list: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of AWS Private CA ARNs.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        TLS authentication is enabled or not.
        """
elif False:
    ClusterTlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTlsArgs:
    def __init__(__self__, *,
                 certificate_authority_arn_list: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificate_authority_arn_list: List of AWS Private CA ARNs.
        :param pulumi.Input[builtins.bool] enabled: TLS authentication is enabled or not.
        """
        if certificate_authority_arn_list is not None:
            pulumi.set(__self__, "certificate_authority_arn_list", certificate_authority_arn_list)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="certificateAuthorityArnList")
    def certificate_authority_arn_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of AWS Private CA ARNs.
        """
        return pulumi.get(self, "certificate_authority_arn_list")

    @certificate_authority_arn_list.setter
    def certificate_authority_arn_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificate_authority_arn_list", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        TLS authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterUnauthenticatedArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Unauthenticated is enabled or not.
        """
elif False:
    ClusterUnauthenticatedArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUnauthenticatedArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: Unauthenticated is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Unauthenticated is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterVpcConnectivityClientAuthenticationArgsDict(TypedDict):
        sasl: NotRequired[pulumi.Input['ClusterVpcConnectivitySaslArgsDict']]
        """
        Details for VpcConnectivity ClientAuthentication using SASL.
        """
        tls: NotRequired[pulumi.Input['ClusterVpcConnectivityTlsArgsDict']]
        """
        Details for VpcConnectivity ClientAuthentication using TLS.
        """
elif False:
    ClusterVpcConnectivityClientAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivityClientAuthenticationArgs:
    def __init__(__self__, *,
                 sasl: Optional[pulumi.Input['ClusterVpcConnectivitySaslArgs']] = None,
                 tls: Optional[pulumi.Input['ClusterVpcConnectivityTlsArgs']] = None):
        """
        :param pulumi.Input['ClusterVpcConnectivitySaslArgs'] sasl: Details for VpcConnectivity ClientAuthentication using SASL.
        :param pulumi.Input['ClusterVpcConnectivityTlsArgs'] tls: Details for VpcConnectivity ClientAuthentication using TLS.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def sasl(self) -> Optional[pulumi.Input['ClusterVpcConnectivitySaslArgs']]:
        """
        Details for VpcConnectivity ClientAuthentication using SASL.
        """
        return pulumi.get(self, "sasl")

    @sasl.setter
    def sasl(self, value: Optional[pulumi.Input['ClusterVpcConnectivitySaslArgs']]):
        pulumi.set(self, "sasl", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['ClusterVpcConnectivityTlsArgs']]:
        """
        Details for VpcConnectivity ClientAuthentication using TLS.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['ClusterVpcConnectivityTlsArgs']]):
        pulumi.set(self, "tls", value)


if not MYPY:
    class ClusterVpcConnectivityIamArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        SASL/IAM authentication is enabled or not.
        """
elif False:
    ClusterVpcConnectivityIamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivityIamArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterVpcConnectivitySaslArgsDict(TypedDict):
        iam: NotRequired[pulumi.Input['ClusterVpcConnectivityIamArgsDict']]
        """
        Details for ClientAuthentication using IAM for VpcConnectivity.
        """
        scram: NotRequired[pulumi.Input['ClusterVpcConnectivityScramArgsDict']]
        """
        Details for SASL/SCRAM client authentication for VpcConnectivity.
        """
elif False:
    ClusterVpcConnectivitySaslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivitySaslArgs:
    def __init__(__self__, *,
                 iam: Optional[pulumi.Input['ClusterVpcConnectivityIamArgs']] = None,
                 scram: Optional[pulumi.Input['ClusterVpcConnectivityScramArgs']] = None):
        """
        :param pulumi.Input['ClusterVpcConnectivityIamArgs'] iam: Details for ClientAuthentication using IAM for VpcConnectivity.
        :param pulumi.Input['ClusterVpcConnectivityScramArgs'] scram: Details for SASL/SCRAM client authentication for VpcConnectivity.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input['ClusterVpcConnectivityIamArgs']]:
        """
        Details for ClientAuthentication using IAM for VpcConnectivity.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input['ClusterVpcConnectivityIamArgs']]):
        pulumi.set(self, "iam", value)

    @property
    @pulumi.getter
    def scram(self) -> Optional[pulumi.Input['ClusterVpcConnectivityScramArgs']]:
        """
        Details for SASL/SCRAM client authentication for VpcConnectivity.
        """
        return pulumi.get(self, "scram")

    @scram.setter
    def scram(self, value: Optional[pulumi.Input['ClusterVpcConnectivityScramArgs']]):
        pulumi.set(self, "scram", value)


if not MYPY:
    class ClusterVpcConnectivityScramArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        SASL/SCRAM authentication is enabled or not.
        """
elif False:
    ClusterVpcConnectivityScramArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivityScramArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: SASL/SCRAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        SASL/SCRAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterVpcConnectivityTlsArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        TLS authentication is enabled or not.
        """
elif False:
    ClusterVpcConnectivityTlsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivityTlsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: TLS authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        TLS authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterVpcConnectivityArgsDict(TypedDict):
        client_authentication: NotRequired[pulumi.Input['ClusterVpcConnectivityClientAuthenticationArgsDict']]
        """
        VPC connection control settings for brokers.
        """
elif False:
    ClusterVpcConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConnectivityArgs:
    def __init__(__self__, *,
                 client_authentication: Optional[pulumi.Input['ClusterVpcConnectivityClientAuthenticationArgs']] = None):
        """
        :param pulumi.Input['ClusterVpcConnectivityClientAuthenticationArgs'] client_authentication: VPC connection control settings for brokers.
        """
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)

    @property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional[pulumi.Input['ClusterVpcConnectivityClientAuthenticationArgs']]:
        """
        VPC connection control settings for brokers.
        """
        return pulumi.get(self, "client_authentication")

    @client_authentication.setter
    def client_authentication(self, value: Optional[pulumi.Input['ClusterVpcConnectivityClientAuthenticationArgs']]):
        pulumi.set(self, "client_authentication", value)


if not MYPY:
    class ConfigurationLatestRevisionArgsDict(TypedDict):
        creation_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The time when the configuration revision was created.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        The description of the configuration revision.
        """
        revision: NotRequired[pulumi.Input[builtins.int]]
        """
        The revision number.
        """
elif False:
    ConfigurationLatestRevisionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationLatestRevisionArgs:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 revision: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] creation_time: The time when the configuration revision was created.
        :param pulumi.Input[builtins.str] description: The description of the configuration revision.
        :param pulumi.Input[builtins.int] revision: The revision number.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the configuration revision was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the configuration revision.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The revision number.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision", value)


if not MYPY:
    class ReplicatorAmazonMskClusterArgsDict(TypedDict):
        """
        Details of an Amazon MSK cluster.
        """
        msk_cluster_arn: pulumi.Input[builtins.str]
        """
        The ARN of an Amazon MSK cluster.
        """
elif False:
    ReplicatorAmazonMskClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorAmazonMskClusterArgs:
    def __init__(__self__, *,
                 msk_cluster_arn: pulumi.Input[builtins.str]):
        """
        Details of an Amazon MSK cluster.
        :param pulumi.Input[builtins.str] msk_cluster_arn: The ARN of an Amazon MSK cluster.
        """
        pulumi.set(__self__, "msk_cluster_arn", msk_cluster_arn)

    @property
    @pulumi.getter(name="mskClusterArn")
    def msk_cluster_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of an Amazon MSK cluster.
        """
        return pulumi.get(self, "msk_cluster_arn")

    @msk_cluster_arn.setter
    def msk_cluster_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "msk_cluster_arn", value)


if not MYPY:
    class ReplicatorConsumerGroupReplicationArgsDict(TypedDict):
        """
        Configuration relating to consumer group replication.
        """
        consumer_groups_to_replicate: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of regular expression patterns indicating the consumer groups to copy.
        """
        consumer_groups_to_exclude: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of regular expression patterns indicating the consumer groups that should not be replicated.
        """
        detect_and_copy_new_consumer_groups: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to periodically check for new consumer groups.
        """
        synchronise_consumer_group_offsets: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
elif False:
    ReplicatorConsumerGroupReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorConsumerGroupReplicationArgs:
    def __init__(__self__, *,
                 consumer_groups_to_replicate: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 consumer_groups_to_exclude: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 detect_and_copy_new_consumer_groups: Optional[pulumi.Input[builtins.bool]] = None,
                 synchronise_consumer_group_offsets: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Configuration relating to consumer group replication.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_groups_to_replicate: List of regular expression patterns indicating the consumer groups to copy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_groups_to_exclude: List of regular expression patterns indicating the consumer groups that should not be replicated.
        :param pulumi.Input[builtins.bool] detect_and_copy_new_consumer_groups: Whether to periodically check for new consumer groups.
        :param pulumi.Input[builtins.bool] synchronise_consumer_group_offsets: Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        pulumi.set(__self__, "consumer_groups_to_replicate", consumer_groups_to_replicate)
        if consumer_groups_to_exclude is not None:
            pulumi.set(__self__, "consumer_groups_to_exclude", consumer_groups_to_exclude)
        if detect_and_copy_new_consumer_groups is not None:
            pulumi.set(__self__, "detect_and_copy_new_consumer_groups", detect_and_copy_new_consumer_groups)
        if synchronise_consumer_group_offsets is not None:
            pulumi.set(__self__, "synchronise_consumer_group_offsets", synchronise_consumer_group_offsets)

    @property
    @pulumi.getter(name="consumerGroupsToReplicate")
    def consumer_groups_to_replicate(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of regular expression patterns indicating the consumer groups to copy.
        """
        return pulumi.get(self, "consumer_groups_to_replicate")

    @consumer_groups_to_replicate.setter
    def consumer_groups_to_replicate(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "consumer_groups_to_replicate", value)

    @property
    @pulumi.getter(name="consumerGroupsToExclude")
    def consumer_groups_to_exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of regular expression patterns indicating the consumer groups that should not be replicated.
        """
        return pulumi.get(self, "consumer_groups_to_exclude")

    @consumer_groups_to_exclude.setter
    def consumer_groups_to_exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "consumer_groups_to_exclude", value)

    @property
    @pulumi.getter(name="detectAndCopyNewConsumerGroups")
    def detect_and_copy_new_consumer_groups(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to periodically check for new consumer groups.
        """
        return pulumi.get(self, "detect_and_copy_new_consumer_groups")

    @detect_and_copy_new_consumer_groups.setter
    def detect_and_copy_new_consumer_groups(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "detect_and_copy_new_consumer_groups", value)

    @property
    @pulumi.getter(name="synchroniseConsumerGroupOffsets")
    def synchronise_consumer_group_offsets(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        return pulumi.get(self, "synchronise_consumer_group_offsets")

    @synchronise_consumer_group_offsets.setter
    def synchronise_consumer_group_offsets(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "synchronise_consumer_group_offsets", value)


if not MYPY:
    class ReplicatorKafkaClusterClientVpcConfigArgsDict(TypedDict):
        """
        Details of an Amazon VPC which has network connectivity to the Kafka cluster.
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
elif False:
    ReplicatorKafkaClusterClientVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorKafkaClusterClientVpcConfigArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Details of an Amazon VPC which has network connectivity to the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The AWS security groups to associate with the elastic network interfaces in order to specify what the replicator has access to. If a security group is not specified, the default security group associated with the VPC is used.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)


if not MYPY:
    class ReplicatorKafkaClusterArgsDict(TypedDict):
        """
        Details of a Kafka cluster for replication.
        """
        amazon_msk_cluster: pulumi.Input['ReplicatorAmazonMskClusterArgsDict']
        """
        Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        """
        vpc_config: pulumi.Input['ReplicatorKafkaClusterClientVpcConfigArgsDict']
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
elif False:
    ReplicatorKafkaClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorKafkaClusterArgs:
    def __init__(__self__, *,
                 amazon_msk_cluster: pulumi.Input['ReplicatorAmazonMskClusterArgs'],
                 vpc_config: pulumi.Input['ReplicatorKafkaClusterClientVpcConfigArgs']):
        """
        Details of a Kafka cluster for replication.
        :param pulumi.Input['ReplicatorAmazonMskClusterArgs'] amazon_msk_cluster: Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        :param pulumi.Input['ReplicatorKafkaClusterClientVpcConfigArgs'] vpc_config: Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        pulumi.set(__self__, "amazon_msk_cluster", amazon_msk_cluster)
        pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="amazonMskCluster")
    def amazon_msk_cluster(self) -> pulumi.Input['ReplicatorAmazonMskClusterArgs']:
        """
        Details of an Amazon MSK cluster. Exactly one of AmazonMskCluster is required.
        """
        return pulumi.get(self, "amazon_msk_cluster")

    @amazon_msk_cluster.setter
    def amazon_msk_cluster(self, value: pulumi.Input['ReplicatorAmazonMskClusterArgs']):
        pulumi.set(self, "amazon_msk_cluster", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Input['ReplicatorKafkaClusterClientVpcConfigArgs']:
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: pulumi.Input['ReplicatorKafkaClusterClientVpcConfigArgs']):
        pulumi.set(self, "vpc_config", value)


if not MYPY:
    class ReplicatorReplicationInfoArgsDict(TypedDict):
        """
        Specifies configuration for replication between a source and target Kafka cluster.
        """
        consumer_group_replication: pulumi.Input['ReplicatorConsumerGroupReplicationArgsDict']
        """
        Configuration relating to consumer group replication.
        """
        source_kafka_cluster_arn: pulumi.Input[builtins.str]
        """
        Amazon Resource Name of the source Kafka cluster.
        """
        target_compression_type: pulumi.Input['ReplicatorReplicationInfoTargetCompressionType']
        """
        The type of compression to use writing records to target Kafka cluster.
        """
        target_kafka_cluster_arn: pulumi.Input[builtins.str]
        """
        Amazon Resource Name of the target Kafka cluster.
        """
        topic_replication: pulumi.Input['ReplicatorTopicReplicationArgsDict']
        """
        Configuration relating to topic replication.
        """
elif False:
    ReplicatorReplicationInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorReplicationInfoArgs:
    def __init__(__self__, *,
                 consumer_group_replication: pulumi.Input['ReplicatorConsumerGroupReplicationArgs'],
                 source_kafka_cluster_arn: pulumi.Input[builtins.str],
                 target_compression_type: pulumi.Input['ReplicatorReplicationInfoTargetCompressionType'],
                 target_kafka_cluster_arn: pulumi.Input[builtins.str],
                 topic_replication: pulumi.Input['ReplicatorTopicReplicationArgs']):
        """
        Specifies configuration for replication between a source and target Kafka cluster.
        :param pulumi.Input['ReplicatorConsumerGroupReplicationArgs'] consumer_group_replication: Configuration relating to consumer group replication.
        :param pulumi.Input[builtins.str] source_kafka_cluster_arn: Amazon Resource Name of the source Kafka cluster.
        :param pulumi.Input['ReplicatorReplicationInfoTargetCompressionType'] target_compression_type: The type of compression to use writing records to target Kafka cluster.
        :param pulumi.Input[builtins.str] target_kafka_cluster_arn: Amazon Resource Name of the target Kafka cluster.
        :param pulumi.Input['ReplicatorTopicReplicationArgs'] topic_replication: Configuration relating to topic replication.
        """
        pulumi.set(__self__, "consumer_group_replication", consumer_group_replication)
        pulumi.set(__self__, "source_kafka_cluster_arn", source_kafka_cluster_arn)
        pulumi.set(__self__, "target_compression_type", target_compression_type)
        pulumi.set(__self__, "target_kafka_cluster_arn", target_kafka_cluster_arn)
        pulumi.set(__self__, "topic_replication", topic_replication)

    @property
    @pulumi.getter(name="consumerGroupReplication")
    def consumer_group_replication(self) -> pulumi.Input['ReplicatorConsumerGroupReplicationArgs']:
        """
        Configuration relating to consumer group replication.
        """
        return pulumi.get(self, "consumer_group_replication")

    @consumer_group_replication.setter
    def consumer_group_replication(self, value: pulumi.Input['ReplicatorConsumerGroupReplicationArgs']):
        pulumi.set(self, "consumer_group_replication", value)

    @property
    @pulumi.getter(name="sourceKafkaClusterArn")
    def source_kafka_cluster_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name of the source Kafka cluster.
        """
        return pulumi.get(self, "source_kafka_cluster_arn")

    @source_kafka_cluster_arn.setter
    def source_kafka_cluster_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_kafka_cluster_arn", value)

    @property
    @pulumi.getter(name="targetCompressionType")
    def target_compression_type(self) -> pulumi.Input['ReplicatorReplicationInfoTargetCompressionType']:
        """
        The type of compression to use writing records to target Kafka cluster.
        """
        return pulumi.get(self, "target_compression_type")

    @target_compression_type.setter
    def target_compression_type(self, value: pulumi.Input['ReplicatorReplicationInfoTargetCompressionType']):
        pulumi.set(self, "target_compression_type", value)

    @property
    @pulumi.getter(name="targetKafkaClusterArn")
    def target_kafka_cluster_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name of the target Kafka cluster.
        """
        return pulumi.get(self, "target_kafka_cluster_arn")

    @target_kafka_cluster_arn.setter
    def target_kafka_cluster_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_kafka_cluster_arn", value)

    @property
    @pulumi.getter(name="topicReplication")
    def topic_replication(self) -> pulumi.Input['ReplicatorTopicReplicationArgs']:
        """
        Configuration relating to topic replication.
        """
        return pulumi.get(self, "topic_replication")

    @topic_replication.setter
    def topic_replication(self, value: pulumi.Input['ReplicatorTopicReplicationArgs']):
        pulumi.set(self, "topic_replication", value)


if not MYPY:
    class ReplicatorReplicationStartingPositionArgsDict(TypedDict):
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        type: NotRequired[pulumi.Input['ReplicatorReplicationStartingPositionType']]
        """
        The type of replication starting position.
        """
elif False:
    ReplicatorReplicationStartingPositionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorReplicationStartingPositionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ReplicatorReplicationStartingPositionType']] = None):
        """
        Configuration for specifying the position in the topics to start replicating from.
        :param pulumi.Input['ReplicatorReplicationStartingPositionType'] type: The type of replication starting position.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ReplicatorReplicationStartingPositionType']]:
        """
        The type of replication starting position.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ReplicatorReplicationStartingPositionType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ReplicatorReplicationTopicNameConfigurationArgsDict(TypedDict):
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        """
        type: NotRequired[pulumi.Input['ReplicatorReplicationTopicNameConfigurationType']]
        """
        The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
        """
elif False:
    ReplicatorReplicationTopicNameConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorReplicationTopicNameConfigurationArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationType']] = None):
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        :param pulumi.Input['ReplicatorReplicationTopicNameConfigurationType'] type: The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationType']]:
        """
        The type of replication topic name configuration, identical to upstream topic name or prefixed with source cluster alias.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ReplicatorTopicReplicationArgsDict(TypedDict):
        topics_to_replicate: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of regular expression patterns indicating the topics to copy.
        """
        copy_access_control_lists_for_topics: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        """
        copy_topic_configurations: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to periodically configure remote topics to match their corresponding upstream topics.
        """
        detect_and_copy_new_topics: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to periodically check for new topics and partitions.
        """
        starting_position: NotRequired[pulumi.Input['ReplicatorReplicationStartingPositionArgsDict']]
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        topic_name_configuration: NotRequired[pulumi.Input['ReplicatorReplicationTopicNameConfigurationArgsDict']]
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        """
        topics_to_exclude: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of regular expression patterns indicating the topics that should not be replicated.
        """
elif False:
    ReplicatorTopicReplicationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatorTopicReplicationArgs:
    def __init__(__self__, *,
                 topics_to_replicate: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 copy_access_control_lists_for_topics: Optional[pulumi.Input[builtins.bool]] = None,
                 copy_topic_configurations: Optional[pulumi.Input[builtins.bool]] = None,
                 detect_and_copy_new_topics: Optional[pulumi.Input[builtins.bool]] = None,
                 starting_position: Optional[pulumi.Input['ReplicatorReplicationStartingPositionArgs']] = None,
                 topic_name_configuration: Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationArgs']] = None,
                 topics_to_exclude: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics_to_replicate: List of regular expression patterns indicating the topics to copy.
        :param pulumi.Input[builtins.bool] copy_access_control_lists_for_topics: Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        :param pulumi.Input[builtins.bool] copy_topic_configurations: Whether to periodically configure remote topics to match their corresponding upstream topics.
        :param pulumi.Input[builtins.bool] detect_and_copy_new_topics: Whether to periodically check for new topics and partitions.
        :param pulumi.Input['ReplicatorReplicationStartingPositionArgs'] starting_position: Configuration for specifying the position in the topics to start replicating from.
        :param pulumi.Input['ReplicatorReplicationTopicNameConfigurationArgs'] topic_name_configuration: Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics_to_exclude: List of regular expression patterns indicating the topics that should not be replicated.
        """
        pulumi.set(__self__, "topics_to_replicate", topics_to_replicate)
        if copy_access_control_lists_for_topics is not None:
            pulumi.set(__self__, "copy_access_control_lists_for_topics", copy_access_control_lists_for_topics)
        if copy_topic_configurations is not None:
            pulumi.set(__self__, "copy_topic_configurations", copy_topic_configurations)
        if detect_and_copy_new_topics is not None:
            pulumi.set(__self__, "detect_and_copy_new_topics", detect_and_copy_new_topics)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if topic_name_configuration is not None:
            pulumi.set(__self__, "topic_name_configuration", topic_name_configuration)
        if topics_to_exclude is not None:
            pulumi.set(__self__, "topics_to_exclude", topics_to_exclude)

    @property
    @pulumi.getter(name="topicsToReplicate")
    def topics_to_replicate(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of regular expression patterns indicating the topics to copy.
        """
        return pulumi.get(self, "topics_to_replicate")

    @topics_to_replicate.setter
    def topics_to_replicate(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "topics_to_replicate", value)

    @property
    @pulumi.getter(name="copyAccessControlListsForTopics")
    def copy_access_control_lists_for_topics(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_access_control_lists_for_topics")

    @copy_access_control_lists_for_topics.setter
    def copy_access_control_lists_for_topics(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_access_control_lists_for_topics", value)

    @property
    @pulumi.getter(name="copyTopicConfigurations")
    def copy_topic_configurations(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to periodically configure remote topics to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_topic_configurations")

    @copy_topic_configurations.setter
    def copy_topic_configurations(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_topic_configurations", value)

    @property
    @pulumi.getter(name="detectAndCopyNewTopics")
    def detect_and_copy_new_topics(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to periodically check for new topics and partitions.
        """
        return pulumi.get(self, "detect_and_copy_new_topics")

    @detect_and_copy_new_topics.setter
    def detect_and_copy_new_topics(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "detect_and_copy_new_topics", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[pulumi.Input['ReplicatorReplicationStartingPositionArgs']]:
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: Optional[pulumi.Input['ReplicatorReplicationStartingPositionArgs']]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="topicNameConfiguration")
    def topic_name_configuration(self) -> Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationArgs']]:
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        """
        return pulumi.get(self, "topic_name_configuration")

    @topic_name_configuration.setter
    def topic_name_configuration(self, value: Optional[pulumi.Input['ReplicatorReplicationTopicNameConfigurationArgs']]):
        pulumi.set(self, "topic_name_configuration", value)

    @property
    @pulumi.getter(name="topicsToExclude")
    def topics_to_exclude(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of regular expression patterns indicating the topics that should not be replicated.
        """
        return pulumi.get(self, "topics_to_exclude")

    @topics_to_exclude.setter
    def topics_to_exclude(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics_to_exclude", value)


if not MYPY:
    class ServerlessClusterClientAuthenticationArgsDict(TypedDict):
        sasl: pulumi.Input['ServerlessClusterSaslArgsDict']
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
elif False:
    ServerlessClusterClientAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessClusterClientAuthenticationArgs:
    def __init__(__self__, *,
                 sasl: pulumi.Input['ServerlessClusterSaslArgs']):
        """
        :param pulumi.Input['ServerlessClusterSaslArgs'] sasl: Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        pulumi.set(__self__, "sasl", sasl)

    @property
    @pulumi.getter
    def sasl(self) -> pulumi.Input['ServerlessClusterSaslArgs']:
        """
        Details for client authentication using SASL. To turn on SASL, you must also turn on `EncryptionInTransit` by setting `inCluster` to true. You must set `clientBroker` to either `TLS` or `TLS_PLAINTEXT` . If you choose `TLS_PLAINTEXT` , then you must also set `unauthenticated` to true.
        """
        return pulumi.get(self, "sasl")

    @sasl.setter
    def sasl(self, value: pulumi.Input['ServerlessClusterSaslArgs']):
        pulumi.set(self, "sasl", value)


if not MYPY:
    class ServerlessClusterIamArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        SASL/IAM authentication is enabled or not.
        """
elif False:
    ServerlessClusterIamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessClusterIamArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ServerlessClusterSaslArgsDict(TypedDict):
        iam: pulumi.Input['ServerlessClusterIamArgsDict']
        """
        Details for ClientAuthentication using IAM.
        """
elif False:
    ServerlessClusterSaslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessClusterSaslArgs:
    def __init__(__self__, *,
                 iam: pulumi.Input['ServerlessClusterIamArgs']):
        """
        :param pulumi.Input['ServerlessClusterIamArgs'] iam: Details for ClientAuthentication using IAM.
        """
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter
    def iam(self) -> pulumi.Input['ServerlessClusterIamArgs']:
        """
        Details for ClientAuthentication using IAM.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: pulumi.Input['ServerlessClusterIamArgs']):
        pulumi.set(self, "iam", value)


if not MYPY:
    class ServerlessClusterVpcConfigArgsDict(TypedDict):
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
elif False:
    ServerlessClusterVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessClusterVpcConfigArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)


